/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.text.MessageFormat;
import java.util.ArrayList;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.plsql.PlSqlDeclarator;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.util.ModelUtil;

public class TriggerDeclarator
extends PlSqlDeclarator {
    public TriggerDeclarator(DBObjectProvider pr) {
        super(pr);
    }

    public void loadDeclarativeInfo(SourceObject obj) {
        super.loadDeclarativeInfo(obj);
        Trigger trigger = (Trigger)obj;
        String code = null;
        ArrayList<String> events = new ArrayList<String>();
        String[] refNames = new String[]{null, null};
        Trigger.Timing timing = null;
        String whenClause = null;
        boolean statementLevel = true;
        PlSqlInterrogator pi = trigger.getSourceInterrogator();
        if (pi == null) {
            DBLog.getLogger().log(DBLog.getTraceLogLevel(), "BUG6189001 TriggerDeclarator.loadDeclarativeInfo pi == null");
        }
        String name = pi.getName();
        String schemaName = this.m_prv.getInternalName(pi.getSchemaName());
        if (schemaName != null) {
            Schema schema = null;
            try {
                schema = this.m_prv.getSchema(schemaName);
            }
            catch (DBException e) {
                // empty catch block
            }
            trigger.setSchema(schema);
        }
        trigger.setName(this.m_prv.getInternalName(name));
        try {
            this.extractReferences(trigger, extractMode.DECLARATOR);
        }
        catch (ValidationException e) {
            // empty catch block
        }
        ArrayList frags = this.getFragList(pi.getRoot());
        int i = 0;
        while (i < frags.size()) {
            PlSqlFragment frag = (PlSqlFragment)frags.get(i);
            switch (1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[frag.getFramentType().ordinal()]) {
                case 1: {
                    if (frag.getFirstToken().matches("BEFORE")) {
                        timing = Trigger.Timing.BEFORE;
                        break;
                    }
                    if (frag.getFirstToken().matches("AFTER")) {
                        timing = Trigger.Timing.AFTER;
                        break;
                    }
                    if (!frag.getFirstToken().matches("INSTEAD")) break;
                    timing = Trigger.Timing.INSTEAD_OF;
                    break;
                }
                case 2: {
                    PlSqlToken tk = frag.getFirstToken();
                    String eventName = "";
                    while (tk.getStart() <= frag.getLastToken().getStart()) {
                        if (tk.matches("UPDATE") && tk.getNextCodeToken().matches("OF")) {
                            eventName = tk.getSource().toUpperCase();
                            events.add(eventName);
                            eventName = "";
                            while (tk != frag.getLastToken() && !tk.getNextCodeToken().matches("OR")) {
                                tk = tk.getNextCodeToken();
                            }
                        } else if (tk == frag.getLastToken() || tk.getNextCodeToken().matches("OR")) {
                            eventName = eventName + tk.getSource().toUpperCase();
                            events.add(eventName);
                            eventName = "";
                        } else if (!tk.matches("OR")) {
                            eventName = eventName + tk.getSource().toUpperCase() + " ";
                        }
                        tk = tk.getNextCodeToken();
                    }
                    break;
                }
                case 3: {
                    PlSqlToken tk = frag.getFirstToken();
                    while (tk.getStart() <= frag.getLastToken().getStart()) {
                        if (tk.matches("OLD") && tk.getNextCodeToken().matches("AS")) {
                            tk = tk.getNextCodeToken().getNextCodeToken();
                            refNames[0] = tk.getSource();
                        } else if (tk.matches("NEW") && tk.getNextCodeToken().matches("AS")) {
                            tk = tk.getNextCodeToken().getNextCodeToken();
                            refNames[1] = tk.getSource();
                        }
                        tk = tk.getNextCodeToken();
                    }
                    break;
                }
                case 4: {
                    statementLevel = false;
                    break;
                }
                case 5: {
                    PlSqlFragment whenFrag = new PlSqlFragment(pi);
                    whenFrag.setFirstToken(frag.getFirstToken().getNextToken());
                    whenFrag.setLastToken(frag.getLastToken().getPrevToken());
                    whenClause = whenFrag.getSource();
                    break;
                }
                case 6: {
                    code = trigger.getSource().substring(frag.getFirstToken().getStart());
                    break;
                }
            }
            ++i;
        }
        trigger.setCode(code);
        trigger.setEvents(events.toArray(new String[events.size()]));
        trigger.setReferenceNames(refNames);
        trigger.setStatementLevel(statementLevel);
        trigger.setTiming(timing);
        trigger.setWhenClause(whenClause);
    }

    private void extractReferences(Trigger trigger, extractMode mode) throws ValidationException {
        PlSqlInterrogator pi = trigger.getSourceInterrogator();
        Trigger.BaseType baseType = null;
        Schema tableOwner = null;
        DBObjectID tableID = null;
        ArrayList<DBObjectID> columnIDs = new ArrayList<DBObjectID>();
        String errors = "";
        ArrayList frags = this.getFragList(pi.getRoot());
        String tableName = null;
        Relation rel = null;
        int i = 0;
        while (i < frags.size()) {
            PlSqlFragment frag = (PlSqlFragment)frags.get(i);
            if (frag.getFramentType() == PlSqlFragment.Type.TRIGGER_TABLE) {
                String nestedTableToCheck = null;
                baseType = null;
                PlSqlToken tk = frag.getFirstToken();
                if (tk.matches("NESTED")) {
                    tk = tk.getNextCodeToken(2);
                    nestedTableToCheck = this.m_prv.getInternalName(tk.getSource());
                    tk = tk.getNextCodeToken(2);
                }
                if (tk.getNextCodeToken().matches(".")) {
                    try {
                        tableOwner = this.m_prv.getSchema(this.m_prv.getInternalName(tk.getSource()));
                    }
                    catch (DBException e) {
                        tableOwner = trigger.getSchema();
                    }
                    tk = tk.getNextCodeToken(2);
                } else {
                    tableOwner = trigger.getSchema();
                }
                if (tk.matches("SCHEMA")) {
                    baseType = Trigger.BaseType.SCHEMA;
                } else if (tk.matches("DATABASE")) {
                    baseType = Trigger.BaseType.DATABASE;
                } else {
                    Column c;
                    tableName = this.m_prv.getInternalName(tk.getSource());
                    try {
                        rel = (Relation)this.m_prv.getObject("TABLE", tableOwner, tableName);
                        if (rel != null) {
                            baseType = Trigger.BaseType.TABLE;
                            tableID = rel.getID();
                        } else {
                            rel = (Relation)this.m_prv.getObject("VIEW", tableOwner, tableName);
                            if (rel != null) {
                                baseType = Trigger.BaseType.VIEW;
                                tableID = rel.getID();
                            } else {
                                tableID = null;
                            }
                        }
                    }
                    catch (DBException e) {
                        try {
                            rel = (Relation)this.m_prv.getObject("VIEW", tableOwner, tableName);
                            baseType = Trigger.BaseType.VIEW;
                            tableID = rel.getID();
                        }
                        catch (DBException e2) {
                            tableID = null;
                        }
                    }
                    if (tableID == null && trigger.getTableID() instanceof TemporaryObjectID) {
                        tableID = trigger.getTableID();
                        DBObject obj = null;
                        try {
                            obj = tableID.resolveID();
                        }
                        catch (DBException e) {
                            obj = null;
                        }
                        if (obj != null && obj.getName().equals(tableName) && ("TABLE".equals(obj.getType()) || "VIEW".equals(obj.getType()))) {
                            rel = (Relation)obj;
                        } else {
                            tableID = null;
                        }
                    }
                    if (tableID == null) {
                        errors = errors + "\n" + MessageFormat.format(DBArb.getString(224), tableName);
                    } else if (nestedTableToCheck != null && (c = rel.getColumn(nestedTableToCheck)) == null) {
                        errors = errors + "\n" + MessageFormat.format(DBArb.getString(188), nestedTableToCheck, tableName);
                    }
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < frags.size()) {
            PlSqlFragment frag = (PlSqlFragment)frags.get(i2);
            if (frag.getFramentType() == PlSqlFragment.Type.TRIGGER_COLUMNS && tableID != null) {
                String lastColToken = ",";
                PlSqlToken tk = frag.getFirstToken();
                while (tk.getStart() <= frag.getLastToken().getStart()) {
                    String tkStr = tk.getSource();
                    if (lastColToken.equals(",")) {
                        Column col = rel.getColumn(this.m_prv.getInternalName(tk.getSource()));
                        if (col != null) {
                            columnIDs.add(col.getID());
                        } else {
                            errors = errors + "\n" + MessageFormat.format(DBArb.getString(188), tkStr, tableName);
                        }
                    }
                    lastColToken = tk.getSource();
                    tk = tk.getNextCodeToken();
                }
            }
            ++i2;
        }
        if (mode == extractMode.VALIDATOR && !errors.equals("")) {
            throw new ValidationException((DBObject)trigger, errors.substring("\n".length()));
        }
        if (mode == extractMode.DECLARATOR) {
            trigger.setBaseType(baseType);
            trigger.setTableOwner(tableOwner);
            trigger.setTableID(tableID);
            trigger.setColumnIDs(columnIDs.toArray(new DBObjectID[columnIDs.size()]));
        }
    }

    public void validateReferences(Trigger trg) throws ValidationException {
        this.extractReferences(trg, extractMode.VALIDATOR);
    }

    private ArrayList getFragList(PlSqlFragment frg) {
        ArrayList<PlSqlFragment> retVal = new ArrayList<PlSqlFragment>();
        retVal.add(frg);
        if (frg.getFramentType() != PlSqlFragment.Type.PLSQL_BLOCK) {
            int i = 0;
            while (i < frg.getSubFragments().size()) {
                ArrayList children = this.getFragList((PlSqlFragment)frg.getSubFragments().get(i));
                int j = 0;
                while (j < children.size()) {
                    retVal.add((PlSqlFragment)children.get(j));
                    ++j;
                }
                ++i;
            }
        }
        return retVal;
    }

    public static void updateSourceFromRefs(Trigger trig, DBObjectProvider pro) {
        PlSqlInterrogator pi = null;
        StringBuilder builder = new StringBuilder();
        Schema storedTableOwner = trig.getTableOwner();
        DBObjectID storedTableID = trig.getTableID();
        DBObjectID[] storedColumnIDs = trig.getColumnIDs();
        Trigger copy = DBUtil.makeTemporaryCopy(trig);
        new TriggerDeclarator(pro).loadDeclarativeInfo(copy);
        Schema derivedTableOwner = copy.getTableOwner();
        DBObjectID derivedTableID = copy.getTableID();
        DBObjectID[] derivedColumnIDs = copy.getColumnIDs();
        if (ModelUtil.areDifferent((Object)storedTableOwner, (Object)derivedTableOwner) || ModelUtil.areDifferent((Object)storedTableID, (Object)derivedTableID) || ModelUtil.areDifferent((Object)storedColumnIDs, (Object)derivedColumnIDs)) {
            pi = trig.getSourceInterrogator();
            PlSqlFragment baseItemFrag = TriggerDeclarator.getFragment(pi.getRoot(), PlSqlFragment.Type.TRIGGER_TABLE);
            Trigger.BaseType baseType = trig.getBaseType();
            if (baseType == Trigger.BaseType.SCHEMA && ModelUtil.areDifferent((Object)storedTableOwner, (Object)derivedTableOwner)) {
                builder.append(trig.getSource().substring(0, baseItemFrag.getStartOffset()));
                builder.append(pro.getExternalName(storedTableOwner.getName()));
                builder.append(".SCHEMA");
                builder.append(trig.getSource().substring(baseItemFrag.getEndOffset() + 1));
                trig.setSource(builder.toString());
            } else if (baseType == Trigger.BaseType.TABLE || baseType == Trigger.BaseType.VIEW) {
                PlSqlFragment columnListFrag = null;
                Relation storedTable = null;
                if (baseType == Trigger.BaseType.TABLE && ModelUtil.areDifferent((Object)storedColumnIDs, (Object)derivedColumnIDs)) {
                    columnListFrag = TriggerDeclarator.getFragment(pi.getRoot(), PlSqlFragment.Type.TRIGGER_COLUMNS);
                }
                if (columnListFrag != null) {
                    builder.append(trig.getSource().substring(0, columnListFrag.getStartOffset()));
                    int colNum = 0;
                    DBObjectID[] dBObjectIDArray = storedColumnIDs;
                    int n = 0;
                    while (n < dBObjectIDArray.length) {
                        DBObjectID colID = dBObjectIDArray[n];
                        if (colNum++ > 0) {
                            builder.append(",");
                        }
                        builder.append(pro.getExternalName(DBUtil.getDBObjectName(colID)));
                        ++n;
                    }
                    builder.append(trig.getSource().substring(columnListFrag.getEndOffset() + 1, baseItemFrag.getStartOffset()));
                } else {
                    builder.append(trig.getSource().substring(0, baseItemFrag.getStartOffset()));
                }
                String tableName = null;
                if (storedTableID != null) {
                    try {
                        storedTable = (Relation)storedTableID.resolveID();
                    }
                    catch (DBException e) {
                        storedTable = null;
                    }
                    if (storedTable != null) {
                        tableName = storedTable.getName();
                        storedTableOwner = storedTable.getSchema();
                    }
                }
                if (tableName != null && (ModelUtil.areDifferent((Object)storedTableOwner, (Object)derivedTableOwner) || ModelUtil.areDifferent((Object)storedTableID, (Object)derivedTableID))) {
                    if (!storedTableOwner.equals(trig.getSchema())) {
                        builder.append(pro.getExternalName(storedTableOwner.getName()));
                        builder.append(".");
                    }
                    builder.append(pro.getExternalName(tableName));
                    builder.append(trig.getSource().substring(baseItemFrag.getEndOffset() + 1));
                } else {
                    builder.append(trig.getSource().substring(baseItemFrag.getStartOffset()));
                }
                trig.setSource(builder.toString());
            }
        }
    }

    private static PlSqlFragment getFragment(PlSqlFragment root, PlSqlFragment.Type fragType) {
        for (Object o : root.getSubFragments()) {
            PlSqlFragment frag = (PlSqlFragment)o;
            if (frag.getFramentType() != fragType) continue;
            return frag;
        }
        for (Object o : root.getSubFragments()) {
            PlSqlFragment childFrag = TriggerDeclarator.getFragment((PlSqlFragment)o, fragType);
            if (childFrag == null) continue;
            return childFrag;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class extractMode
    extends Enum<extractMode> {
        private static final /* synthetic */ extractMode[] $v;
        public static final /* enum */ extractMode DECLARATOR;
        public static final /* enum */ extractMode VALIDATOR;

        public static extractMode valueOf(String string) {
            return Enum.valueOf(extractMode.class, string);
        }

        public static final extractMode[] values() {
            return (extractMode[])$v.clone();
        }

        static {
            extractMode[] extractModeArray = new extractMode[2];
            extractModeArray[1] = VALIDATOR = new extractMode("VALIDATOR", 1);
            extractModeArray[0] = DECLARATOR = new extractMode("DECLARATOR", 0);
            $v = extractModeArray;
        }

        private extractMode(String string2, int n2) {
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$javatools$db$plsql$PlSqlFragment$Type;

        static {
            int[] nArray = new int[PlSqlFragment.Type.values().length];
            $sm$oracle$javatools$db$plsql$PlSqlFragment$Type = nArray;
            try {
                nArray[PlSqlFragment.Type.TRIGGER_TIMING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.TRIGGER_EVENTS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.TRIGGER_REFERENCING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.TRIGGER_ROW_LEVEL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.TRIGGER_WHEN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$plsql$PlSqlFragment$Type[PlSqlFragment.Type.PLSQL_BLOCK.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

