/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.StringTokenizer;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.db.DBLog;

public class PlSqlCompilerOptions
extends HashStructureAdapter {
    public static final String KEY = "PlSqlCompilerOptions";
    private static final String GENERATE_DEBUG = "generateDebugPlsql";

    public PlSqlCompilerOptions(HashStructure hash) {
        super(hash);
    }

    public WarningValue getWarningValue(WarningCategory category) {
        String val;
        if (category != null && (val = this._hash.getString(category.toString())) != null) {
            try {
                WarningValue warningValue = WarningValue.valueOf(val);
                return warningValue;
            }
            catch (IllegalArgumentException ex) {
                DBLog.logStackTrace(ex);
            }
        }
        return null;
    }

    public void setWarningValue(WarningCategory category, WarningValue value) {
        if (category != null) {
            this._hash.putString(category.toString(), value == null ? null : value.toString());
        }
    }

    public void setWarningFlags(String flags) {
        this._hash.clear();
        StringTokenizer t = new StringTokenizer(flags, "|");
        while (t.hasMoreTokens()) {
            String pair = t.nextToken();
            int idx = pair.indexOf(58);
            if (idx <= 0) continue;
            try {
                WarningValue val = WarningValue.valueOf(pair.substring(0, idx));
                WarningCategory cat = WarningCategory.valueOf(pair.substring(idx + 1));
                this.setWarningValue(cat, val);
            }
            catch (IllegalArgumentException ex) {
                DBLog.logStackTrace(ex);
            }
        }
    }

    public String getWarningFlags() {
        StringBuffer buf = new StringBuffer();
        WarningCategory[] warningCategoryArray = WarningCategory.values();
        int n = 0;
        while (n < warningCategoryArray.length) {
            WarningCategory category = warningCategoryArray[n];
            WarningValue value = this.getWarningValue(category);
            if (value != null) {
                buf.append((Object)value).append(':').append((Object)category).append('|');
            }
            ++n;
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public boolean isGeneratePlSqlDebugInfo() {
        return this._hash.getBoolean(GENERATE_DEBUG, true);
    }

    public void setGeneratePlSqlDebugInfo(boolean boo) {
        this._hash.putBoolean(GENERATE_DEBUG, boo);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WarningCategory
    extends Enum<WarningCategory> {
        private static final /* synthetic */ WarningCategory[] $v;
        public static final /* enum */ WarningCategory ALL;
        public static final /* enum */ WarningCategory INFORMATIONAL;
        public static final /* enum */ WarningCategory SEVERE;
        public static final /* enum */ WarningCategory PERFORMANCE;

        public static WarningCategory valueOf(String string) {
            return Enum.valueOf(WarningCategory.class, string);
        }

        public static final WarningCategory[] values() {
            return (WarningCategory[])$v.clone();
        }

        static {
            WarningCategory[] warningCategoryArray = new WarningCategory[4];
            warningCategoryArray[3] = PERFORMANCE = new WarningCategory("PERFORMANCE", 3);
            warningCategoryArray[2] = SEVERE = new WarningCategory("SEVERE", 2);
            warningCategoryArray[1] = INFORMATIONAL = new WarningCategory("INFORMATIONAL", 1);
            warningCategoryArray[0] = ALL = new WarningCategory("ALL", 0);
            $v = warningCategoryArray;
        }

        private WarningCategory(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WarningValue
    extends Enum<WarningValue> {
        private static final /* synthetic */ WarningValue[] $v;
        public static final /* enum */ WarningValue ENABLE;
        public static final /* enum */ WarningValue DISABLE;
        public static final /* enum */ WarningValue ERROR;

        public static WarningValue valueOf(String string) {
            return Enum.valueOf(WarningValue.class, string);
        }

        public static final WarningValue[] values() {
            return (WarningValue[])$v.clone();
        }

        static {
            WarningValue[] warningValueArray = new WarningValue[3];
            warningValueArray[2] = ERROR = new WarningValue("ERROR", 2);
            warningValueArray[1] = DISABLE = new WarningValue("DISABLE", 1);
            warningValueArray[0] = ENABLE = new WarningValue("ENABLE", 0);
            $v = warningValueArray;
        }

        private WarningValue(String string2, int n2) {
        }
    }
}

