/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleTablePartitions
extends AbstractChildDBObject {
    @PropertyKey(value=OracleTablePartitions.class, childOf={Table.class}, provider=OracleDatabase.class)
    public static final String KEY = "OracleTablePartitions";
    public static final String TYPE = "PARTITION MODEL";
    private PartitionType m_partitionType;
    private ObjectType m_objectType;
    private List<DBObjectID> m_partitionColumns;
    private Integer m_hashQuantity;
    private List<String> m_hashQuantityTablespaces;
    private OracleTablePartitions m_subpartitionModel;

    private void $init$() {
        this.m_partitionColumns = new ArrayList<DBObjectID>();
        this.m_hashQuantityTablespaces = new ArrayList<String>();
    }

    public OracleTablePartitions() {
        this.$init$();
    }

    public OracleTablePartitions(PartitionType partitionType, ObjectType objectType) {
        this.$init$();
        this.m_partitionType = partitionType;
        this.m_objectType = objectType;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    @Transient
    public String getName() {
        return this.m_objectType == null ? null : this.m_objectType.name();
    }

    @Override
    @Transient
    public void setName(String name) {
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        refs.addAll(this.m_partitionColumns);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        super.getOwnedObjectsImpl(objs, types);
        this.includeOwnedObject(objs, this.m_subpartitionModel, types);
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        int i = 0;
        while (i < this.m_partitionColumns.size()) {
            DBObjectID next = this.m_partitionColumns.get(i);
            if (idMap.containsKey(next)) {
                this.m_partitionColumns.set(i, idMap.get(next));
                replaced = true;
            }
            ++i;
        }
        return replaced;
    }

    public void setPartitionType(PartitionType partitionType) {
        this.m_partitionType = partitionType;
    }

    public PartitionType getPartitionType() {
        return this.m_partitionType;
    }

    public void setObjectType(ObjectType objectType) {
        this.m_objectType = objectType;
    }

    public ObjectType getObjectType() {
        return this.m_objectType;
    }

    public void setSubpartitionModel(OracleTablePartitions subpartitions) {
        this.changeParent(this.m_subpartitionModel, subpartitions);
        this.m_subpartitionModel = subpartitions;
    }

    public OracleTablePartitions getSubpartitionModel() {
        return this.m_subpartitionModel;
    }

    public void setPartitionColumns(DBObjectID[] partitionColumns) {
        this.m_partitionColumns.removeAll(this.m_partitionColumns);
        if (partitionColumns != null) {
            int i = 0;
            while (i < partitionColumns.length) {
                this.addPartitionColumn(partitionColumns[i]);
                ++i;
            }
        }
    }

    public DBObjectID[] getPartitionColumns() {
        return this.m_partitionColumns.toArray(new DBObjectID[this.m_partitionColumns.size()]);
    }

    public void addPartitionColumn(DBObjectID partitionColumn) {
        if (partitionColumn != null) {
            this.m_partitionColumns.add(partitionColumn);
        }
    }

    public void addPartitionColumn(DBObjectID partitionColumn, int atIndex) {
        if (partitionColumn != null) {
            this.m_partitionColumns.add(atIndex, partitionColumn);
        }
    }

    public void removePartitionColumn(DBObjectID partitionColumn) {
        this.m_partitionColumns.remove(partitionColumn);
    }

    public void removePartitionColumnAt(int index) {
        this.m_partitionColumns.remove(index);
    }

    public void setHashQuantity(Integer hashQuantity) {
        this.m_hashQuantity = hashQuantity;
    }

    public Integer getHashQuantity() {
        return this.m_hashQuantity;
    }

    public void setHashQuantityTablespaces(String[] tablespaceNames) {
        this.m_hashQuantityTablespaces.removeAll(this.m_hashQuantityTablespaces);
        if (tablespaceNames != null) {
            int i = 0;
            while (i < tablespaceNames.length) {
                this.addHashQuantityTablespace(tablespaceNames[i]);
                ++i;
            }
        }
    }

    public void addHashQuantityTablespace(String tablespaceName) {
        if (tablespaceName != null) {
            this.m_hashQuantityTablespaces.add(tablespaceName);
        }
    }

    public void removeHashQuantityTablespace(String tablespaceName) {
        this.m_hashQuantityTablespaces.remove(tablespaceName);
    }

    public String[] getHashQuantityTablespaces() {
        return this.m_hashQuantityTablespaces.toArray(new String[this.m_hashQuantityTablespaces.size()]);
    }

    public void setPartitions(TablePartition[] partitions) {
        this.getChildSupport().setChildArray(TablePartition.class, partitions);
    }

    public TablePartition[] getPartitions() {
        return (TablePartition[])this.getChildSupport().getChildArray(TablePartition.class);
    }

    public void addPartition(TablePartition partition) {
        this.getChildSupport().addChild(partition);
    }

    public void removePartition(TablePartition partition) {
        this.getChildSupport().removeChild(partition);
    }

    public TablePartition createPartition(String name) {
        TablePartition partition = new TablePartition(name, this.m_partitionType, this.m_objectType);
        this.addPartition(partition);
        return partition;
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        OracleTablePartitions copy = target != null ? (OracleTablePartitions)target : new OracleTablePartitions();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    public boolean equals(Object target) {
        return target instanceof OracleTablePartitions && this.equalsImpl((OracleTablePartitions)target);
    }

    protected void copyToImpl(OracleTablePartitions target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_partitionType = this.m_partitionType;
        target.m_objectType = this.m_objectType;
        target.m_hashQuantity = this.m_hashQuantity;
        target.setSubpartitionModel(this.copyObject(this.m_subpartitionModel, target, idPolicy));
        ModelUtil.deepCopy(this.m_hashQuantityTablespaces, target.m_hashQuantityTablespaces);
        target.m_partitionColumns.clear();
        target.m_partitionColumns.addAll(this.m_partitionColumns);
    }

    protected boolean equalsImpl(OracleTablePartitions target) {
        return super.equalsImpl(target) && ModelUtil.areEqual((Object)((Object)this.m_partitionType), (Object)((Object)target.m_partitionType)) && ModelUtil.areEqual((Object)((Object)this.m_objectType), (Object)((Object)target.m_objectType)) && ModelUtil.areEqual((Object)this.m_hashQuantity, (Object)target.m_hashQuantity) && ModelUtil.areEqual(this.m_hashQuantityTablespaces, target.m_hashQuantityTablespaces) && ModelUtil.areEqual(this.m_partitionColumns, target.m_partitionColumns) && ModelUtil.areEqual((Object)this.m_subpartitionModel, (Object)target.m_subpartitionModel);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PartitionType
    extends Enum<PartitionType> {
        private static final /* synthetic */ PartitionType[] $v;
        public static final /* enum */ PartitionType RANGE;
        public static final /* enum */ PartitionType HASH;
        public static final /* enum */ PartitionType LIST;

        public static PartitionType valueOf(String string) {
            return Enum.valueOf(PartitionType.class, string);
        }

        public static final PartitionType[] values() {
            return (PartitionType[])$v.clone();
        }

        static {
            PartitionType[] partitionTypeArray = new PartitionType[3];
            partitionTypeArray[2] = LIST = new PartitionType("LIST", 2);
            partitionTypeArray[1] = HASH = new PartitionType("HASH", 1);
            partitionTypeArray[0] = RANGE = new PartitionType("RANGE", 0);
            $v = partitionTypeArray;
        }

        private PartitionType(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ObjectType
    extends Enum<ObjectType> {
        private static final /* synthetic */ ObjectType[] $v;
        public static final /* enum */ ObjectType PARTITION;
        public static final /* enum */ ObjectType SUBPARTITION;
        public static final /* enum */ ObjectType SUBPARTITION_TEMPLATE;
        public static final /* enum */ ObjectType PARTITION_LEVEL_SUBPARTITION;

        public static ObjectType valueOf(String string) {
            return Enum.valueOf(ObjectType.class, string);
        }

        public static final ObjectType[] values() {
            return (ObjectType[])$v.clone();
        }

        static {
            ObjectType[] objectTypeArray = new ObjectType[4];
            objectTypeArray[3] = PARTITION_LEVEL_SUBPARTITION = new ObjectType("PARTITION_LEVEL_SUBPARTITION", 3);
            objectTypeArray[2] = SUBPARTITION_TEMPLATE = new ObjectType("SUBPARTITION_TEMPLATE", 2);
            objectTypeArray[1] = SUBPARTITION = new ObjectType("SUBPARTITION", 1);
            objectTypeArray[0] = PARTITION = new ObjectType("PARTITION", 0);
            $v = objectTypeArray;
        }

        private ObjectType(String string2, int n2) {
        }
    }
}

