/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

public class OracleStorageProperties
implements Copyable {
    @PropertyKey(value=OracleStorageProperties.class, childOf={Table.class, MaterializedViewLog.class, Index.class}, provider=OracleDatabase.class)
    public static final String KEY = "OracleStorageProperties";
    @PropertyKey(value=OracleStorageProperties.class, childOf={MaterializedView.class}, provider=OracleDatabase.class)
    public static final String MV_INDEX_KEY = "MatViewIndexStorageProperties";
    private String m_tablespace;
    private Integer m_pctFree;
    private Integer m_pctUsed;
    private Integer m_initrans;
    private Integer m_maxtrans;
    private Integer m_initialExtent;
    private Integer m_nextExtent;
    private Integer m_minExtent;
    private Integer m_maxExtent;
    private Integer m_pctIncrease;
    private Boolean m_logging;
    private Integer m_freelists;
    private Integer m_freelistGroups;
    private BufferModes m_bufferMode;
    private static Integer n0 = new Integer(0);
    private static Integer n1 = new Integer(1);
    private static Integer n99 = new Integer(99);
    private static Integer n255 = new Integer(255);

    private void $init$() {
        this.m_bufferMode = BufferModes.DEFAULT;
    }

    public OracleStorageProperties() {
        this.$init$();
    }

    public Object copyTo(Object target) {
        OracleStorageProperties copy = target != null ? (OracleStorageProperties)target : new OracleStorageProperties();
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(OracleStorageProperties copy) {
        copy.m_tablespace = this.m_tablespace;
        copy.m_pctFree = this.m_pctFree;
        copy.m_pctUsed = this.m_pctUsed;
        copy.m_initrans = this.m_initrans;
        copy.m_maxtrans = this.m_maxtrans;
        copy.m_initialExtent = this.m_initialExtent;
        copy.m_nextExtent = this.m_nextExtent;
        copy.m_minExtent = this.m_minExtent;
        copy.m_maxExtent = this.m_maxExtent;
        copy.m_pctIncrease = this.m_pctIncrease;
        copy.m_logging = this.m_logging;
        copy.m_freelists = this.m_freelists;
        copy.m_freelistGroups = this.m_freelistGroups;
        copy.m_bufferMode = this.m_bufferMode;
    }

    public boolean equals(Object target) {
        return target instanceof OracleStorageProperties && this.equalsImpl((OracleStorageProperties)target);
    }

    protected boolean equalsImpl(OracleStorageProperties target) {
        return ModelUtil.areEqual((Object)this.m_tablespace, (Object)target.m_tablespace) && ModelUtil.areEqual((Object)this.m_pctFree, (Object)target.m_pctFree) && ModelUtil.areEqual((Object)this.m_pctUsed, (Object)target.m_pctUsed) && ModelUtil.areEqual((Object)this.m_initrans, (Object)target.m_initrans) && ModelUtil.areEqual((Object)this.m_maxtrans, (Object)target.m_maxtrans) && ModelUtil.areEqual((Object)this.m_initialExtent, (Object)target.m_initialExtent) && ModelUtil.areEqual((Object)this.m_nextExtent, (Object)target.m_nextExtent) && ModelUtil.areEqual((Object)this.m_minExtent, (Object)target.m_minExtent) && ModelUtil.areEqual((Object)this.m_maxExtent, (Object)target.m_maxExtent) && ModelUtil.areEqual((Object)this.m_pctIncrease, (Object)target.m_pctIncrease) && ModelUtil.areEqual((Object)this.m_logging, (Object)target.m_logging) && ModelUtil.areEqual((Object)this.m_freelists, (Object)target.m_freelists) && ModelUtil.areEqual((Object)this.m_freelistGroups, (Object)target.m_freelistGroups) && this.m_bufferMode == target.m_bufferMode;
    }

    public void setTablespace(String tablespace) {
        this.m_tablespace = tablespace;
    }

    public String getTablespace() {
        return this.m_tablespace;
    }

    public void setPercentFree(Integer pctFree) {
        this.m_pctFree = pctFree;
    }

    public Integer getPercentFree() {
        return this.m_pctFree;
    }

    public void setPercentUsed(Integer pctUsed) {
        this.m_pctUsed = pctUsed;
    }

    public Integer getPercentUsed() {
        return this.m_pctUsed;
    }

    public void setInitrans(Integer initrans) {
        this.m_initrans = initrans;
    }

    public Integer getInitrans() {
        return this.m_initrans;
    }

    public void setMaxtrans(Integer maxtrans) {
        this.m_maxtrans = maxtrans;
    }

    public Integer getMaxtrans() {
        return this.m_maxtrans;
    }

    public void setInitialExtent(Integer initialExtent) {
        this.m_initialExtent = initialExtent;
    }

    public Integer getInitialExtent() {
        return this.m_initialExtent;
    }

    public void setNextExtent(Integer nextExtent) {
        this.m_nextExtent = nextExtent;
    }

    public Integer getNextExtent() {
        return this.m_nextExtent;
    }

    public void setMinExtent(Integer minExtent) {
        this.m_minExtent = minExtent;
    }

    public Integer getMinExtent() {
        return this.m_minExtent;
    }

    public void setMaxExtent(Integer maxExtent) {
        this.m_maxExtent = maxExtent;
    }

    public Integer getMaxExtent() {
        return this.m_maxExtent;
    }

    public void setPercentIncrease(Integer pctIncrease) {
        this.m_pctIncrease = pctIncrease;
    }

    public Integer getPercentIncrease() {
        return this.m_pctIncrease;
    }

    public void setLogging(Boolean logging) {
        this.m_logging = logging;
    }

    public Boolean getLogging() {
        return this.m_logging;
    }

    public void setFreelists(Integer freelists) {
        this.m_freelists = freelists;
    }

    public Integer getFreelists() {
        return this.m_freelists;
    }

    public void setFreelistGroups(Integer freelistGroups) {
        this.m_freelistGroups = freelistGroups;
    }

    public Integer getFreelistGroups() {
        return this.m_freelistGroups;
    }

    public void setBufferMode(BufferModes bufferMode) {
        this.m_bufferMode = bufferMode;
    }

    public BufferModes getBufferMode() {
        return this.m_bufferMode;
    }

    public void validatePercentFree(DBObject contextObject) throws ValidationException {
        if (this.m_pctFree != null && (this.m_pctFree < 0 || this.m_pctFree > 99)) {
            throw new ValidationException(contextObject, DBArb.format(368, "PCTFREE", n0, n99));
        }
        this.validateSumOfPctFreeAndPctUsed(contextObject);
    }

    public void validatePercentUsed(DBObject contextObject) throws ValidationException {
        if (this.m_pctUsed != null && (this.m_pctUsed < 0 || this.m_pctUsed > 99)) {
            throw new ValidationException(contextObject, DBArb.format(368, "PCTUSED", n0, n99));
        }
        this.validateSumOfPctFreeAndPctUsed(contextObject);
    }

    public void validateInitrans(DBObject contextObject) throws ValidationException {
        if (this.m_initrans != null && (this.m_initrans < 1 || this.m_initrans > 255)) {
            throw new ValidationException(contextObject, DBArb.format(368, "INITRANS", n1, n255));
        }
    }

    public void validateMaxtrans(DBObject contextObject) throws ValidationException {
        if (this.m_maxtrans != null && (this.m_maxtrans < 1 || this.m_maxtrans > 255)) {
            throw new ValidationException(contextObject, DBArb.format(368, "MAXTRANS", n1, n255));
        }
    }

    public void validateInitialExtent(DBObject contextObject) throws ValidationException {
        if (this.m_initialExtent != null && this.m_initialExtent < 1) {
            throw new ValidationException(contextObject, DBArb.format(158, "INITIAL", n1));
        }
    }

    public void validateNextExtent(DBObject contextObject) throws ValidationException {
        if (this.m_nextExtent != null && this.m_nextExtent < 1) {
            throw new ValidationException(contextObject, DBArb.format(158, "NEXT", n1));
        }
    }

    public void validateMinExtent(DBObject contextObject) throws ValidationException {
        if (this.m_minExtent != null && this.m_minExtent < 1) {
            throw new ValidationException(contextObject, DBArb.format(158, "MINEXTENT", n1));
        }
    }

    public void validateMaxExtent(DBObject contextObject) throws ValidationException {
        if (this.m_maxExtent != null && this.m_maxExtent < 1) {
            throw new ValidationException(contextObject, DBArb.format(158, "MAXEXTENT", n1));
        }
    }

    public void validatePercentIncrease(DBObject contextObject) throws ValidationException {
        if (this.m_pctIncrease != null && this.m_pctIncrease < 0) {
            throw new ValidationException(contextObject, DBArb.format(158, "PCTINCREASE", n0));
        }
    }

    public void validateFreelistGroups(DBObject contextObject) throws ValidationException {
        if (this.m_freelistGroups != null && this.m_freelistGroups < 1) {
            throw new ValidationException(contextObject, DBArb.format(158, "FREELIST_GROUPS", n1));
        }
    }

    public void validateFreelists(DBObject contextObject) throws ValidationException {
        if (this.m_freelists != null && this.m_freelists < 1) {
            throw new ValidationException(contextObject, DBArb.format(158, "FREELISTS", n1));
        }
    }

    public void validateBufferMode(DBObject contextObject) throws ValidationException {
    }

    public void validate(DBObject contextObject) throws ValidationException {
        this.validatePercentFree(contextObject);
        this.validatePercentUsed(contextObject);
        this.validateInitrans(contextObject);
        this.validateMaxtrans(contextObject);
        this.validateInitialExtent(contextObject);
        this.validateNextExtent(contextObject);
        this.validateMinExtent(contextObject);
        this.validateMaxExtent(contextObject);
        this.validatePercentIncrease(contextObject);
        this.validateFreelistGroups(contextObject);
        this.validateFreelists(contextObject);
        this.validateBufferMode(contextObject);
    }

    private void validateSumOfPctFreeAndPctUsed(DBObject contextObject) throws ValidationException {
        if (this.m_pctFree != null && this.m_pctUsed != null && this.m_pctFree + this.m_pctUsed > 100) {
            throw new ValidationException(contextObject, DBArb.getString(242));
        }
    }

    private static int min(int a, int b) {
        return a < b ? a : b;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BufferModes
    extends Enum<BufferModes> {
        private static final /* synthetic */ BufferModes[] $v;
        public static final /* enum */ BufferModes DEFAULT;
        public static final /* enum */ BufferModes KEEP;
        public static final /* enum */ BufferModes RECYCLE;

        public static BufferModes valueOf(String string) {
            return Enum.valueOf(BufferModes.class, string);
        }

        public static final BufferModes[] values() {
            return (BufferModes[])$v.clone();
        }

        static {
            BufferModes[] bufferModesArray = new BufferModes[3];
            bufferModesArray[2] = RECYCLE = new BufferModes("RECYCLE", 2);
            bufferModesArray[1] = KEEP = new BufferModes("KEEP", 1);
            bufferModesArray[0] = DEFAULT = new BufferModes("DEFAULT", 0);
            $v = bufferModesArray;
        }

        private BufferModes(String string2, int n2) {
        }
    }
}

