/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.ora.OracleFunctions;
import oracle.javatools.db.ora.OracleSQLQuery;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.AbstractSchemaObjectUsage;
import oracle.javatools.db.sql.ArithmeticOperation;
import oracle.javatools.db.sql.CaseStatement;
import oracle.javatools.db.sql.ColumnKeywordUsage;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.Comparison;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.DataMiningFunction;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.ExpressionList;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.FunctionDefinition;
import oracle.javatools.db.sql.GroupByExpression;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.InvalidAliasException;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.OnJoinCondition;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryClauseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SelectObjectUsage;
import oracle.javatools.db.sql.SetOperation;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.db.sql.SynonymUsage;
import oracle.javatools.db.sql.UsingJoinCondition;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.db.sql.WindowFunction;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.parser.plsql.data.PlsqlError;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.SqlExpression;
import oracle.javatools.parser.plsql.data.SqlOperators;
import oracle.javatools.parser.plsql.symtab.SqlAjndef;
import oracle.javatools.parser.plsql.symtab.SqlColdef;
import oracle.javatools.parser.plsql.symtab.SqlFrodef;
import oracle.javatools.parser.plsql.symtab.SqlGbydef;
import oracle.javatools.parser.plsql.symtab.SqlOdmCost;
import oracle.javatools.parser.plsql.symtab.SqlOdmModel;
import oracle.javatools.parser.plsql.symtab.SqlOdmdef;
import oracle.javatools.parser.plsql.symtab.SqlOpndef;
import oracle.javatools.parser.plsql.symtab.SqlOptdef;
import oracle.javatools.parser.plsql.symtab.SqlOrddef;
import oracle.javatools.parser.plsql.symtab.SqlQbcdef;
import oracle.javatools.parser.plsql.symtab.SqlSeldef;
import oracle.javatools.parser.plsql.symtab.SqlStrdef;
import oracle.javatools.parser.plsql.symtab.SqlTypdef;
import oracle.javatools.parser.plsql.syntax.SqlDriver;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OracleSQLQueryBuilder
extends AbstractSQLQueryBuilder
implements SQLQueryBuilder {
    private static OracleFunctions s_funcs;
    private OracleSQLQueryBuilder m_parentBuilder;
    private static String m_originalSQL;

    public OracleSQLQueryBuilder(DBObjectProvider pro, Schema defaultSchema) {
        super(pro, defaultSchema);
    }

    @Override
    public void buildQuery(SQLQuery query) throws SQLQueryException {
        if (query instanceof DeclarativeSQLQuery) {
            this.m_query = (AbstractSQLQuery)query;
            this.validateQuery();
            this.loadQuery();
        } else {
            DBObject parent;
            String queryText;
            String string = queryText = query == null ? "" : query.getSQLText();
            if (queryText.equals("SELECT \n    \nFROM \n    ")) {
                queryText = "";
            }
            this.buildQuery(queryText, (parent = query.getParent()) instanceof SQLQueryOwner ? (SQLQueryOwner)parent : null);
        }
    }

    @Override
    protected void buildQueryImpl(String sql, SQLQueryOwner parent) throws SQLQueryException {
        this.m_query = new OracleSQLQuery();
        if (ModelUtil.hasLength((String)sql)) {
            PlsqlRoot root = OracleSQLQueryBuilder.parseQueryString(sql, 0);
            OracleSQLQueryBuilder.checkErrors(root, sql);
            PlsqlNode[] units = root.getUnits();
            SqlQbcdef query = null;
            int i = 0;
            while (i < units.length) {
                byte type = ((SqlExpression)units[i]).getOperandType();
                if (type == 5) {
                    query = (SqlQbcdef)units[i];
                }
                ++i;
            }
            try {
                this.buildQuery(query, (DBObject)parent);
                this.m_query.setQueryString(sql);
            }
            catch (SQLQueryException sqe) {
                AbstractSQLQuery oldQuery = this.m_query;
                this.m_query = new NonDeclarativeSQLQuery();
                this.m_query.setFromObjects(oldQuery.getFromObjects());
                this.m_query.setSelectObjects(oldQuery.getSelectObjects());
                this.m_query.setQueryString(sql);
                throw sqe;
            }
        }
    }

    private OracleSQLQueryBuilder(DBObjectProvider pro, Schema defaultSchema, SqlQbcdef query, OracleSQLQueryBuilder parent) throws SQLQueryException {
        super(pro, defaultSchema);
        this.m_parentBuilder = parent;
        this.buildQuery(query, this.m_parentBuilder.getSQLQuery());
    }

    private void buildQuery(SqlQbcdef query, DBObject parent) throws SQLQueryException {
        this.m_query = new OracleSQLQuery();
        if (parent != null && !(parent instanceof SQLQueryOwner) && !(parent instanceof SQLQuery)) {
            throw new IllegalArgumentException("parent of a SQLQuery must be a SQLQuery or SQLQueryOwner");
        }
        this.m_query.setParent(parent == null ? (DBObject)this.m_defaultSchema : parent);
        SQLQueryException oops = null;
        SqlQbcdef query2 = query;
        if (query2 != null) {
            SqlOrddef[] orderby;
            SqlGbydef groupby;
            this.m_query.setDistinct(query2.isDistinct());
            this.m_query.setDistinctSource(query2.getDistinctQualifierSource());
            SqlFrodef[] from = query2.qbcfro;
            if (from == null) {
                SqlOpndef[] ops = (SqlOpndef[])query2.getOperands();
                short type = query2.getOperatorType();
                oops = new SQLQueryException(DBArb.getString(128));
                while (query2.optopv != null) {
                    query2 = (SqlQbcdef)query2.optopv[0];
                }
                from = query2.qbcfro;
                if (from == null) {
                    throw oops;
                }
            }
            int i = 0;
            while (i < from.length) {
                try {
                    FromObject newFrom = this.createFrom(from[i]);
                    this.addFromObject(newFrom);
                }
                catch (SQLQueryException sqe) {
                    if (oops == null) {
                        oops = sqe;
                    }
                    oops.setNextException(sqe);
                }
                ++i;
            }
            SqlSeldef[] select = query2.qbcsel;
            int i2 = 0;
            while (i2 < select.length) {
                try {
                    SelectObject obj = new SelectObject();
                    String alias = select[i2].getSelnam();
                    obj.setAlias(alias);
                    obj.setUseAs(select[i2].hasAs());
                    SqlOpndef thing = select[i2].getSelopn();
                    SQLFragment exp = this.createFragment(thing, obj, null);
                    obj.setExpression(exp);
                    if (ModelUtil.hasLength((String)alias) && !this.m_provider.isValidName("COLUMN", alias)) {
                        this.throwException(new InvalidAliasException(obj));
                    }
                    this.addSelectObject(obj);
                }
                catch (SQLQueryException sqe) {
                    if (parent instanceof Relation) {
                        SelectObject obj = new SelectObject();
                        String name = select[i2].getSelnam();
                        if (!ModelUtil.hasLength((String)name)) {
                            SqlOpndef thing = select[i2].getSelopn();
                            name = thing.getColumnBaseName();
                        }
                        if (!ModelUtil.hasLength((String)name)) {
                            int j = i2 + 1;
                            name = "\"<column " + j + ">\"";
                        }
                        if (!name.startsWith("\"")) {
                            name = name.toUpperCase();
                        }
                        obj.setAlias(name);
                        SimpleSQLFragment exp = new SimpleSQLFragment("null");
                        obj.setExpression(exp);
                        this.addSelectObject(obj);
                    }
                    if (oops == null) {
                        oops = sqe;
                    }
                    oops.setNextException(sqe);
                }
                ++i2;
            }
            if (oops != null) {
                throw oops;
            }
            SqlOptdef where = query2.qbcwhr;
            if (where != null) {
                WhereObject whereObj = this.createWhere(where);
                this.setWhereObject(whereObj);
            }
            if ((groupby = query2.qbcgbh) != null) {
                GroupByObject gbc = this.createGroupBy(groupby, (SqlOpndef)query2.qbchav);
                this.setGroupByObject(gbc);
            }
            if ((orderby = query2.qbcord) != null) {
                int i3 = 0;
                while (i3 < orderby.length) {
                    this.addOrderByObject(this.createOrderByObject(orderby[i3]));
                    ++i3;
                }
            }
            this.validateAggregatesAndGroupBy();
        }
    }

    private void checkLength(String expression) throws SQLQueryException {
        if (!ModelUtil.hasLength((String)expression)) {
            this.throwException(new SQLQueryException(DBArb.getString(371)));
        }
    }

    private OrderByObject createOrderByObject(SqlOrddef orderby) throws SQLQueryException {
        String asc = orderby.getOrderByAscSource();
        String nullsLast = orderby.getOrderByNullsLastSource();
        SqlOpndef term = orderby.getOrderByTerm();
        OrderByObject obo = new OrderByObject();
        SQLFragment frag = this.createFragment(term, obo, null);
        obo.setExpression(frag);
        obo.setOrder(asc);
        obo.setNullOrdering(nullsLast);
        return obo;
    }

    private FromObject createFrom(SqlFrodef sql) throws SQLQueryException {
        FromObject retval = null;
        SqlOpndef subquery = sql.getSubQuery();
        if (subquery == null) {
            retval = new FromObject();
            this.ensureID(retval);
            SqlAjndef join = sql.getAnsiJoin();
            if (join == null) {
                String alias = sql.getTableAlias();
                retval.setAlias(alias);
                if (ModelUtil.hasLength((String)alias) && !this.m_provider.isValidName("COLUMN", alias)) {
                    this.throwException(new InvalidAliasException(retval));
                }
                String schema = sql.getSchemaName();
                String table = sql.getTableName();
                if (ModelUtil.hasLength((String)table) && table.equalsIgnoreCase("DUAL")) {
                    retval.setExpression(new SimpleSQLFragment(table));
                } else {
                    DBObjectUsage exp;
                    if (ModelUtil.hasLength((String)sql.networkAccess)) {
                        this.throwException(new SQLQueryException(DBArb.format(365, table, sql.networkAccess)));
                    }
                    if ((exp = this.createRelationUsage(schema, table)) == null) {
                        this.throwException(new SQLQueryException(DBArb.format(112, table)));
                    }
                    retval.setExpression(exp);
                }
            } else {
                JoinObject exp = new JoinObject();
                retval.setExpression(exp);
                int type = join.getJoinType();
                String joinType = null;
                switch (type) {
                    case 4: {
                        joinType = "FULL";
                        break;
                    }
                    case 2: {
                        joinType = "LEFT";
                        break;
                    }
                    case 3: {
                        joinType = "RIGHT";
                        break;
                    }
                    case 5: {
                        joinType = "CROSS";
                        break;
                    }
                    case 1: {
                        joinType = "INNER";
                        break;
                    }
                }
                exp.setJoinType(joinType);
                boolean natural = join.getNaturalJoin();
                exp.setNatural(natural);
                SqlFrodef left = join.getJoinLeftTable();
                FromObject leftFrom = this.createFrom(left);
                exp.setLeftExpression(leftFrom);
                SqlFrodef right = join.getJoinRightTable();
                FromObject rightFrom = this.createFrom(right);
                exp.setRightExpression(rightFrom);
                if (m_originalSQL != null) {
                    if (joinType.equals("INNER")) {
                        int startOffset = join.getStartOffset();
                        exp.setIncludeJoinKeyword(this.hasToken(startOffset, joinType, "JOIN"));
                    } else if (exp.isOuterJoin()) {
                        int startOffset = join.getStartOffset();
                        exp.setIncludeJoinKeyword(this.hasToken(startOffset, "OUTER", "JOIN"));
                    }
                }
                if (!joinType.equals("CROSS") && !natural) {
                    SqlOpndef onClause = join.getJoinOnClause();
                    if (onClause != null && onClause instanceof SqlOptdef) {
                        WhereObject w = this.createWhere((SqlOptdef)onClause, retval);
                        if (w != null) {
                            OnJoinCondition on = (OnJoinCondition)w.copyTo(new OnJoinCondition());
                            exp.setCondition(on);
                        }
                    } else {
                        SqlColdef[] joinCols = join.getJoinColumns();
                        if (joinCols != null) {
                            UsingJoinCondition using = new UsingJoinCondition();
                            exp.setCondition(using);
                            int i = 0;
                            while (i < joinCols.length) {
                                String col = joinCols[i].getColumnBaseName();
                                FromObjectUsage cu = this.findColumnInFromObjects(col, new FromObject[]{leftFrom, rightFrom}, true, true, (SQLFragment)retval);
                                if (cu != null) {
                                    using.addColumn(cu);
                                }
                                ++i;
                            }
                        }
                    }
                }
            }
        } else if (subquery instanceof SqlQbcdef) {
            OracleSQLQueryBuilder builder = new OracleSQLQueryBuilder(this.m_provider, this.m_defaultSchema, (SqlQbcdef)subquery, this);
            AbstractSQLQuery sub = builder.getSQLQuery();
            if (sub == null) {
                this.throwException(new SQLQueryException(DBArb.getString(348)));
            } else {
                String alias = sql.getTableAlias();
                retval = new FromObject(sub, alias);
                if (ModelUtil.hasLength((String)alias) && !this.m_provider.isValidName("COLUMN", alias)) {
                    this.throwException(new InvalidAliasException(retval));
                }
            }
        } else if (subquery instanceof SqlOptdef || subquery instanceof SqlColdef) {
            SQLFragment[] arg = new SQLFragment[]{this.createFragment(subquery, retval, null)};
            Function tc = this.getOracleFunctions().createFunction("TABLE", arg, "TABLE");
            String alias = sql.getTableAlias();
            retval = new FromObject(tc, alias);
            if (ModelUtil.hasLength((String)alias) && !this.m_provider.isValidName("COLUMN", alias)) {
                this.throwException(new InvalidAliasException(retval));
            }
        } else {
            this.throwException(new SQLQueryException(DBArb.getString(348)));
        }
        return retval;
    }

    @Override
    protected FromObjectUsage findColumnInFromExpression(String colName, SQLFragment exp, boolean allowDuplicates, FromObject from, SQLFragment creating) throws SQLQueryException {
        SQLFragment[] args;
        FromObjectUsage found = super.findColumnInFromExpression(colName, exp, allowDuplicates, from, creating);
        if (found == null && exp instanceof Function && "TABLE".equals(((Function)exp).getFunction()) && (args = ((Function)exp).getArguments()) != null && args.length > 0) {
            found = this.findColumnInFromExpression(colName, args[0], allowDuplicates, from, creating);
        }
        return found;
    }

    private boolean hasToken(int offset, String token, String before) {
        if (offset > 0 && m_originalSQL != null) {
            before = before.toUpperCase();
            token = token.toUpperCase();
            String test = m_originalSQL.substring(offset).toUpperCase();
            if (ModelUtil.hasLength((String)before) && test.contains(before)) {
                test = test.substring(0, test.indexOf(before));
                return test.contains(token);
            }
            return test.trim().startsWith(token);
        }
        return false;
    }

    private WhereObject createWhere(SqlOptdef sql) throws SQLQueryException {
        return this.createWhere(sql, null);
    }

    private WhereObject createWhere(SqlOptdef sql, SQLFragment creating) throws SQLQueryException {
        WhereObject retval = null;
        short type = sql.getOperatorType();
        if (WhereObject.isWhereOperator(type)) {
            SqlExpression[] operands = sql.getOperands();
            SQLFragment[] frags = new SQLFragment[operands.length];
            int i = 0;
            while (i < operands.length) {
                frags[i] = this.createFragment((SqlOpndef)operands[i], creating, null);
                ++i;
            }
            retval = new WhereObject(frags, type);
        } else {
            retval = new WhereObject(this.createFragment((SqlOpndef)sql, creating, null));
        }
        return retval;
    }

    private GroupByObject createGroupBy(SqlGbydef sql, SqlOpndef having) throws SQLQueryException {
        GroupByObject retval = null;
        int type = sql.getGroupByListType();
        if (type == 0) {
            retval = new GroupByObject();
            SqlOpndef[] gbs = sql.getGroupBySetTerms();
            SQLFragment[] frags = new SQLFragment[gbs.length];
            int i = 0;
            while (i < gbs.length) {
                SQLFragment f = this.createFragment(gbs[i], retval, null);
                if (f != null) {
                    frags[i] = f;
                } else {
                    this.throwException(new SQLQueryException(DBArb.getString(82)));
                }
                ++i;
            }
            retval.setExpressions(frags);
            if (having != null && having instanceof SqlOptdef) {
                WhereObject hv = this.createWhere((SqlOptdef)having);
                retval.setHaving(hv);
            }
        }
        return retval;
    }

    private FromObjectUsage createColumnUsage(SqlColdef columnDef) throws SQLQueryException {
        return this.createColumnUsage(columnDef, null);
    }

    private FromObjectUsage createColumnUsage(SqlColdef columnDef, SQLFragment creating) throws SQLQueryException {
        String colName;
        String col;
        String table;
        FromObjectUsage retval = null;
        ArrayList<String> bits = new ArrayList<String>();
        String user = columnDef.getColumnUserName();
        if (ModelUtil.hasLength((String)user)) {
            bits.add(user);
        }
        if (ModelUtil.hasLength((String)(table = columnDef.getColumnTableName()))) {
            bits.add(table);
        }
        if ((col = columnDef.getColumnBaseName()) == null) {
            String[] ca = columnDef.getColumnAndAttributes();
            if (ca != null) {
                bits.addAll(Arrays.asList(ca));
            }
        } else if (ModelUtil.hasLength((String)col)) {
            bits.add(col);
        }
        ArrayList bitsCopy = new ArrayList(bits);
        int colindex = 0;
        FromObject extraFrom = creating instanceof FromObject ? (FromObject)creating : null;
        FromObject from = null;
        String parentName = null;
        if (bits.size() > 1) {
            ++colindex;
            parentName = (String)bits.remove(0);
            from = this.findFromObject(parentName, extraFrom);
            if (from == null && bits.size() > 0 && (from = this.findFromObject(parentName = parentName + "." + (String)bits.get(0), extraFrom)) != null) {
                ++colindex;
                bits.remove(0);
            }
            if (from == null) {
                this.throwException(new SQLQueryException(DBArb.format(293, parentName)));
            }
        }
        if ((colName = (String)bits.remove(0)).charAt(0) != '\"') {
            colName = colName.toUpperCase();
        }
        if (colName.equals("*")) {
            retval = new ColumnKeywordUsage(colName, from);
        } else if (from == null) {
            retval = this.findColumnInFromObjects(colName, creating, extraFrom);
            if (retval == null) {
                if (creating instanceof OrderByObject) {
                    SelectObject[] selectObjectArray = this.m_query.getSelectObjects();
                    int n = 0;
                    while (n < selectObjectArray.length) {
                        SelectObject select = selectObjectArray[n];
                        if (colName.equals(select.getName())) {
                            this.ensureID(select);
                            retval = new SelectObjectUsage(select, null);
                            break;
                        }
                        ++n;
                    }
                }
                if (retval == null) {
                    this.throwException(new SQLQueryException(DBArb.format(249, colName)));
                }
            }
        } else {
            this.ensureID(from);
            SQLFragment exp = from.getExpression();
            if (exp instanceof RelationUsage) {
                retval = this.findColumnInRelation(colName, (RelationUsage)exp);
                if (retval == null) {
                    this.throwException(new SQLQueryException(DBArb.format(130, colName, parentName)));
                }
            } else if (exp instanceof SQLQuery) {
                retval = this.findColumnInSubQuery(colName, (SQLQuery)exp);
                if (retval == null) {
                    this.throwException(new SQLQueryException(DBArb.format(332, colName)));
                }
            } else if (exp instanceof SynonymUsage) {
                SchemaObject obj = ((SynonymUsage)exp).getReferencedObject();
                if (obj instanceof Relation) {
                    retval = this.findColumnInRelation(colName, (Relation)obj);
                }
                if (retval == null) {
                    this.throwException(new SQLQueryException(DBArb.format(104, colName, parentName)));
                } else {
                    retval.setFromObjectID(from.getID());
                }
            } else {
                retval = this.findColumnInFromExpression(colName, exp, false, from, creating);
                if (retval == null) {
                    this.throwException(new SQLQueryException(DBArb.format(152, parentName)));
                }
            }
        }
        retval.setQualified(colindex > 0);
        if (retval instanceof ColumnUsage) {
            if (bits.size() > 0) {
                ((ColumnUsage)retval).setAttributes(bits.toArray(new String[bits.size()]));
            }
            if (columnDef.colOuterJoin) {
                ((ColumnUsage)retval).setOuterJoin(true);
            }
        }
        return retval;
    }

    private FromObject findFromObject(String alias, FromObject creating) {
        FromObject from = this.getFromObject(alias, creating);
        if (from == null) {
            OracleSQLQueryBuilder parent = this.m_parentBuilder;
            while (parent != null && from == null) {
                from = parent.getFromObject(alias);
                parent = parent.m_parentBuilder;
            }
        }
        return from;
    }

    private SQLFragment[] createFragments(SqlExpression[] sql, SQLFragment creating, Object context) throws SQLQueryException {
        ArrayList<SQLFragment> retval = new ArrayList<SQLFragment>();
        int i = 0;
        while (i < sql.length) {
            if (sql[i] != null) {
                retval.add(this.createFragment((SqlOpndef)sql[i], creating, context));
            }
            ++i;
        }
        return retval.toArray(new SQLFragment[retval.size()]);
    }

    private SQLFragment createFragment(SqlOpndef sql, SQLFragment creating, Object context) throws SQLQueryException {
        SQLFragment retval = null;
        byte operandType = sql.getOperandType();
        switch (operandType) {
            case 10: {
                retval = this.createGroupByExpression((SqlGbydef)sql, creating, context);
                break;
            }
            case 13: {
                retval = this.createDataMiningFunction((SqlOdmdef)sql, creating, context);
                break;
            }
            case 12: {
                retval = this.createFragment(((SqlSeldef)sql).getSelopn(), creating, context);
                break;
            }
            case 1: {
                if (context != null && context.equals("MAKE_REF")) {
                    try {
                        retval = this.createColumnUsage((SqlColdef)sql, creating);
                    }
                    catch (SQLQueryException e) {
                        String tab = ((SqlColdef)sql).getColumnBaseName();
                        String schema = ((SqlColdef)sql).getColumnTableName();
                        retval = this.createRelationUsage(schema, tab);
                        if (retval != null) break;
                        String simple = tab;
                        if (ModelUtil.hasLength((String)schema)) {
                            simple = schema + "." + simple;
                        }
                        retval = new SimpleSQLFragment(simple);
                    }
                    break;
                }
                retval = this.createColumnUsage((SqlColdef)sql, creating);
                break;
            }
            case 2: {
                SqlOptdef operatorDef = (SqlOptdef)sql;
                short type = operatorDef.getOperatorType();
                if (WhereObject.isWhereOperator(type)) {
                    retval = this.createWhere((SqlOptdef)sql, creating);
                    break;
                }
                if (ArithmeticOperation.isArithmeticOperation(type)) {
                    retval = new ArithmeticOperation(type, this.createFragments(operatorDef.getOperands(), creating, context));
                    break;
                }
                if (Comparison.isComparator(type)) {
                    SQLFragment[] args = this.createFragments(operatorDef.getOperands(), creating, context);
                    retval = new Comparison(args[0], type, args.length > 1 ? args[1] : null);
                    break;
                }
                if (SetOperation.isSetOperator(type)) {
                    SQLFragment[] args = this.createFragments(operatorDef.getOperands(), creating, context);
                    retval = new SetOperation(type, args);
                    break;
                }
                if (type == 371 || type == 385) {
                    SQLFragment[] args = this.createFragments(operatorDef.getOperands(), creating, context);
                    int i = 0;
                    SQLFragment exp = null;
                    if (type == 385) {
                        exp = args[i++];
                    }
                    SQLFragment elseExp = null;
                    if ((args.length - i) % 2 != 0) {
                        elseExp = args[args.length - 1];
                    }
                    int end = args.length - (elseExp == null ? 0 : 1);
                    CaseStatement.WhenThen[] whenThens = new CaseStatement.WhenThen[(end - i) / 2];
                    int j = 0;
                    while (j < whenThens.length) {
                        whenThens[j] = new CaseStatement.WhenThen(args[i++], args[i++]);
                        ++j;
                    }
                    retval = new CaseStatement(exp, whenThens, elseExp);
                    break;
                }
                if (type == 74) {
                    SqlExpression[] opds = sql.getOperands();
                    if (opds.length != 1 || !(opds[0] instanceof SqlQbcdef)) break;
                    retval = this.buildSubquery((SqlQbcdef)opds[0]);
                    break;
                }
                if (type == 708) {
                    SqlExpression[] opnds;
                    SqlExpression[] sqlExpressionArray = opnds = sql.getOperands();
                    int n = 0;
                    while (n < sqlExpressionArray.length) {
                        short type2;
                        SqlExpression sqle = sqlExpressionArray[n];
                        if (sqle instanceof SqlOptdef && (type2 = ((SqlOptdef)sqle).getOperatorType()) == 708) {
                            opnds = sqle.getOperands();
                            break;
                        }
                        ++n;
                    }
                    SQLFragment[] args = this.createFragments(opnds, creating, context);
                    retval = new ExpressionList(args);
                    break;
                }
                if (type == 333) {
                    if (context instanceof WindowFunction) {
                        SqlExpression[] os = operatorDef.getOperands();
                        if (os.length <= 0) break;
                        OrderByObject[] args = new OrderByObject[os.length];
                        int i = 0;
                        while (i < os.length) {
                            args[i] = this.createOrderByObject((SqlOrddef)os[i]);
                            ++i;
                        }
                        ((WindowFunction)context).setOrderBy(args);
                        break;
                    }
                    this.throwException(new SQLQueryException(DBArb.getString(377)));
                    break;
                }
                if (type == 334) {
                    if (context instanceof WindowFunction) {
                        SqlExpression[] os = operatorDef.getOperands();
                        SQLFragment[] argsL = this.getArgList(creating, context, os, 0);
                        ((WindowFunction)context).setPartitionBy(argsL);
                        break;
                    }
                    this.throwException(new SQLQueryException(DBArb.getString(105)));
                    break;
                }
                String func = SqlOperators.OPT_words[type - 1];
                if (func == null) {
                    this.throwException(new SQLQueryException(DBArb.format(243, func)));
                }
                SqlExpression[] os = operatorDef.getOperands();
                int start = 0;
                if (func.equals("plsfun") && os.length > 0) {
                    func = os[0].getColumnBaseName();
                    start = 1;
                }
                func = func.toUpperCase();
                if (operatorDef.isWindowFuntion()) {
                    retval = new WindowFunction(func);
                    SQLFragment[] argsL = this.getArgList(creating, retval, os, start);
                    if (argsL.length > 0 && argsL[0] != null) {
                        ((Function)retval).setArguments(new SQLFragment[]{argsL[0]});
                    }
                } else {
                    SQLFragment[] argsL = this.getArgList(creating, func, os, start);
                    retval = this.getOracleFunctions().createFunction(func, argsL, operatorDef.getSource());
                    if (retval == null) {
                        this.throwException(new SQLQueryException(DBArb.format(243, func)));
                    }
                }
                ((Function)retval).setDistinct(operatorDef.isDistinct());
                ((Function)retval).setDistinctSource(operatorDef.getDistinctQualifierSource());
                break;
            }
            case 3: {
                SqlStrdef stringDef = (SqlStrdef)sql;
                byte type = stringDef.getStringType();
                String text = stringDef.getStringText();
                retval = new SimpleSQLFragment(text);
                break;
            }
            case 11: {
                SqlTypdef typeDef = (SqlTypdef)sql;
                String typName = typeDef.getTypName();
                retval = new SimpleSQLFragment(typName);
                break;
            }
            case 5: {
                retval = this.buildSubquery((SqlQbcdef)sql);
            }
        }
        return retval;
    }

    private SQLQuery buildSubquery(SqlQbcdef sql) throws SQLQueryException {
        OracleSQLQueryBuilder builder = new OracleSQLQueryBuilder(this.m_provider, this.m_defaultSchema, sql, this);
        AbstractSQLQuery sub = builder.getSQLQuery();
        if (sub == null) {
            this.throwException(new SQLQueryException(DBArb.getString(348)));
            return null;
        }
        return sub;
    }

    private SQLFragment[] getArgList(SQLFragment creating, Object func, SqlExpression[] os, int start) throws SQLQueryException {
        ArrayList<SQLFragment> args = new ArrayList<SQLFragment>();
        int i = start;
        while (i < os.length) {
            if (os[i] != null) {
                SQLFragment arg = this.createFragment((SqlOpndef)os[i], creating, func);
                args.add(arg);
            }
            ++i;
        }
        SQLFragment[] argsL = args.toArray(new SQLFragment[args.size()]);
        return argsL;
    }

    public DBObjectProvider getProvider() {
        return this.m_provider;
    }

    public void setProvider(DBObjectProvider provider) {
        this.m_provider = provider;
    }

    @Override
    protected SQLFragment parseFromExpression(String expression, FromObject creating) throws SQLQueryException {
        this.checkLength(expression);
        int dot = expression.indexOf(".");
        String schema = null;
        String relation = null;
        if (dot > 0) {
            schema = expression.substring(0, dot);
            relation = expression.substring(dot + 1);
        } else {
            DBObject queryParent = this.m_query.getParent();
            if (queryParent instanceof SchemaObject) {
                schema = ((SchemaObject)queryParent).getSchema().getName();
            }
            relation = expression;
        }
        DBObjectUsage ru = this.createRelationUsage(schema, relation);
        if (ru == null) {
            this.throwException(new SQLQueryException(DBArb.format(112, expression)));
        }
        return ru;
    }

    @Override
    protected SQLFragment parseSelectExpression(String expression, SelectObject creating) throws SQLQueryException {
        this.checkLength(expression);
        PlsqlRoot root = OracleSQLQueryBuilder.parseQueryString(expression, 3);
        OracleSQLQueryBuilder.checkErrors(root, expression);
        PlsqlNode[] units = root.getUnits();
        if (units != null && units.length > 0) {
            return this.createFragment((SqlOpndef)units[0], creating, null);
        }
        throw new SQLQueryException(DBArb.getString(58));
    }

    @Override
    public SQLFragment parseWhereExpression(String expression, WhereObject creating) throws SQLQueryException {
        this.checkLength(expression);
        PlsqlRoot root = OracleSQLQueryBuilder.parseQueryString(expression, 1);
        OracleSQLQueryBuilder.checkErrors(root, expression);
        PlsqlNode[] units = root.getUnits();
        if (units != null && units.length > 0) {
            return this.createFragment((SqlOpndef)units[0], creating, null);
        }
        throw new SQLQueryException(DBArb.getString(58));
    }

    @Override
    public OnJoinCondition parseOnExpression(String expression, JoinObject join) throws SQLQueryException {
        this.checkLength(expression);
        PlsqlRoot root = OracleSQLQueryBuilder.parseQueryString(expression, 1);
        OracleSQLQueryBuilder.checkErrors(root, expression);
        PlsqlNode[] units = root.getUnits();
        if (units != null && units.length > 0) {
            SQLFragment frag = this.createFragment((SqlOpndef)units[0], join, null);
            if (frag instanceof WhereObject) {
                return (OnJoinCondition)frag.copyTo(new OnJoinCondition());
            }
            return new OnJoinCondition(frag);
        }
        throw new SQLQueryException(DBArb.getString(58));
    }

    private SQLFragment createGroupByExpression(SqlGbydef gby, SQLFragment creating, Object context) throws SQLQueryException {
        Operation retval;
        int type = gby.getGroupByListType();
        if (type == 0) {
            retval = new ExpressionList();
        } else {
            GroupByExpression groupByE = new GroupByExpression();
            retval = groupByE;
            switch (type) {
                case 1: {
                    groupByE.setGroupByType(GroupByExpression.GroupingType.ROLLUP);
                    break;
                }
                case 2: {
                    groupByE.setGroupByType(GroupByExpression.GroupingType.CUBE);
                    break;
                }
                case 3: {
                    groupByE.setGroupByType(GroupByExpression.GroupingType.GROUPING_SETS);
                    break;
                }
                case 4: {
                    groupByE.setGroupByType(null);
                    break;
                }
            }
        }
        SqlOpndef[] ops = gby.getGroupBySetTerms();
        SQLFragment[] args = new SQLFragment[ops == null ? 0 : ops.length];
        int i = 0;
        while (i < args.length) {
            args[i] = this.createFragment(ops[i], retval, context);
            ++i;
        }
        if (retval instanceof GroupByExpression) {
            ((GroupByExpression)retval).setArguments(args);
        } else {
            retval.setArguments(args);
        }
        return retval;
    }

    private SQLFragment createDataMiningFunction(SqlOdmdef odm, SQLFragment creating, Object context) throws SQLQueryException {
        DataMiningFunction retval = null;
        short type = odm.getOperatorType();
        String fname = SqlOperators.OPT_words[type - 1];
        if (fname == null) {
            this.throwException(new SQLQueryException(DBArb.format(243, fname)));
        }
        fname = fname.toUpperCase();
        SqlExpression[] os = odm.getOperands();
        SqlOdmdef internalOp = (SqlOdmdef)os[0];
        SqlOdmModel model = internalOp.getModel();
        String msn = model.getSchemaName();
        String modelName = (ModelUtil.hasLength((String)msn) ? msn + "." : "") + model.getModelName();
        SqlOdmCost cost = odm.getCost();
        SQLFragment[] dmSpecificArgs = this.getArgList(creating, fname, os, 1);
        SQLFragment[] usingArgs = this.getArgList(creating, fname, internalOp.getOperands(), 0);
        retval = new DataMiningFunction(fname, new SimpleSQLFragment(modelName), cost != null, dmSpecificArgs, usingArgs);
        return retval;
    }

    private DBObjectUsage createRelationUsage(String schema, String relation) {
        if (!ModelUtil.hasLength((String)relation)) {
            return null;
        }
        AbstractSchemaObjectUsage retval = null;
        if (this.m_provider != null) {
            schema = schema == null ? null : this.m_provider.getInternalName(schema);
            relation = this.m_provider.getInternalName(relation);
            try {
                Schema sch = null;
                sch = ModelUtil.hasLength((String)schema) ? this.m_provider.getSchema(schema) : this.m_defaultSchema;
                if (sch != null) {
                    SchemaObject obj = this.getObject("TABLE", sch, relation);
                    if (obj == null) {
                        obj = this.getObject("VIEW", sch, relation);
                    }
                    if (obj == null) {
                        DBObjectID id;
                        obj = this.getObject("SYNONYM", sch, relation);
                        if (obj != null && (id = obj.getID()) != null) {
                            retval = new SynonymUsage(id);
                            retval.setProvider(this.m_provider);
                        }
                    } else {
                        DBObjectID id = obj.getID();
                        if (id != null) {
                            retval = new RelationUsage(id);
                            retval.setProvider(this.m_provider);
                        }
                    }
                }
            }
            catch (DBException e) {
                DBLog.logStackTrace(e);
            }
        }
        return retval;
    }

    @Override
    public boolean supportsGroupBy() {
        return true;
    }

    @Override
    public boolean supportsOrderBy() {
        return true;
    }

    @Override
    public FunctionDefinition[] getBuiltInFunctions() {
        Collection funcs = this.getOracleFunctions().getAllFunctions();
        return funcs.toArray(new FunctionDefinition[funcs.size()]);
    }

    private OracleFunctions getOracleFunctions() {
        if (s_funcs == null) {
            s_funcs = new OracleFunctions();
        }
        return s_funcs;
    }

    private static PlsqlRoot parseQueryString(String expression, int type) throws SQLQueryException {
        m_originalSQL = expression;
        try {
            ReadTextBuffer textBuffer = TextBufferFactory.createReadTextBuffer((String)expression);
            PlsqlParser.ParsingOptions options = new PlsqlParser.ParsingOptions();
            options.inputType = 16;
            SqlDriver sql = new SqlDriver();
            sql.setTextBuffer(textBuffer);
            PlsqlRoot plsqlRoot = sql.qcpidrv(type);
            return plsqlRoot;
        }
        catch (Exception e) {
            DBLog.logStackTrace(e);
            throw new SQLQueryException(DBArb.format(94, e.getMessage()));
        }
    }

    private static void checkErrors(PlsqlRoot root, String sql) throws SQLQueryException {
        PlsqlError[] errors = root.getErrors();
        if (errors != null && errors.length > 0) {
            throw new SQLParseException(errors, sql);
        }
    }

    @Override
    protected final void setViewColDataType(ViewColumn col) {
        super.setViewColDataType(col);
        if (col.getDataTypeUsage() == null) {
            DataType dt;
            DBObjectID id = col.getSelectObjectID();
            SelectObject so = null;
            try {
                so = (SelectObject)id.resolveID();
            }
            catch (DBException e) {
                // empty catch block
            }
            if (so != null && so.getExpression() instanceof Function && (dt = this.getOracleFunctions().getDataType(((Function)so.getExpression()).getFunction(), this.m_provider)) != null) {
                col.setDataTypeUsage(dt.createDefaultUsage());
            }
        }
    }

    public static void checkSQLForErrors(String sql) throws SQLQueryException {
        PlsqlRoot root = OracleSQLQueryBuilder.parseQueryString(sql, 0);
        OracleSQLQueryBuilder.checkErrors(root, sql);
    }

    @Override
    protected FromObjectUsage findColumnInRelation(String colName, Relation rel) throws SQLQueryException {
        if (colName.equalsIgnoreCase(this.getOracleFunctions().ROWID)) {
            ColumnKeywordUsage c = new ColumnKeywordUsage();
            c.setColumnName(colName);
            return c;
        }
        return super.findColumnInRelation(colName, rel);
    }

    private void validateAggregatesAndGroupBy() throws SQLQueryException {
        ArrayList<GroupByValidationObject> gbvo = this.getGroupByValidationObjects(this.m_query.getSelectObjects());
        boolean aggregatesInSelect = false;
        boolean nonAggregatesInSelect = false;
        ChildDBObject firstNonAggregate = null;
        for (GroupByValidationObject val : gbvo) {
            if (GroupByValidationObject.ra$m_frag(val) instanceof Function && ((Function)GroupByValidationObject.ra$m_frag(val)).isGrouping()) {
                aggregatesInSelect = true;
                continue;
            }
            nonAggregatesInSelect = true;
            if (firstNonAggregate != null) continue;
            firstNonAggregate = GroupByValidationObject.ra$m_frag(val);
        }
        if (aggregatesInSelect && nonAggregatesInSelect && this.m_query.getGroupByObject() == null) {
            SQLQueryClauseException ex = new SQLQueryClauseException((SQLFragment)firstNonAggregate.getParent(), DBArb.format(245, firstNonAggregate.getSQLText()));
            ex.addType("GROUP BY");
            this.throwException(ex);
        } else if (this.m_query.getGroupByObject() != null && nonAggregatesInSelect) {
            GroupByObject gbo = this.m_query.getGroupByObject();
            for (GroupByValidationObject val : gbvo) {
                if (!GroupByValidationObject.ra$m_ok(val)) {
                    for (SQLFragment gbFrag : this.getChildrenDeep(gbo, null)) {
                        if (!gbFrag.equals(GroupByValidationObject.ra$m_frag(val))) continue;
                        GroupByValidationObject.wa$m_ok(val, true);
                        break;
                    }
                    if (!GroupByValidationObject.ra$m_ok(val) && GroupByValidationObject.ra$m_frag(val) instanceof ColumnUsage) {
                        for (SQLFragment gbFrag : this.getChildrenDeep(gbo, null)) {
                            if (!(gbFrag instanceof ColumnUsage)) continue;
                            ColumnUsage cu = new ColumnUsage();
                            ((ColumnUsage)gbFrag).copyTo(cu);
                            cu.setQualified(((ColumnUsage)GroupByValidationObject.ra$m_frag(val)).isQualified());
                            if (!cu.equals(GroupByValidationObject.ra$m_frag(val))) continue;
                            GroupByValidationObject.wa$m_ok(val, true);
                            break;
                        }
                    }
                }
                if (GroupByValidationObject.ra$m_ok(val)) continue;
                SQLQueryClauseException ex = new SQLQueryClauseException((SQLFragment)GroupByValidationObject.ra$m_frag(val).getParent(), DBArb.format(169, GroupByValidationObject.ra$m_frag(val).getSQLText()));
                ex.addType("GROUP BY");
                this.throwException(ex);
            }
        }
    }

    private Collection<SQLFragment> getChildrenDeep(SQLFragment parent, Collection<SQLFragment> kids) {
        if (kids == null) {
            kids = new ArrayList<SQLFragment>();
        }
        DBObject[] dBObjectArray = parent.getOwnedObjects();
        int n = 0;
        while (n < dBObjectArray.length) {
            DBObject obj = dBObjectArray[n];
            if (obj instanceof SQLFragment) {
                kids.add((SQLFragment)obj);
                this.getChildrenDeep((SQLFragment)obj, kids);
            }
            ++n;
        }
        return kids;
    }

    private ArrayList<GroupByValidationObject> getGroupByValidationObjects(SQLFragment[] fragList) {
        ArrayList<GroupByValidationObject> retval = new ArrayList<GroupByValidationObject>();
        SQLFragment[] sQLFragmentArray = fragList;
        int n = 0;
        while (n < sQLFragmentArray.length) {
            GroupByObject gbo;
            SQLFragment sqlFrag = sQLFragmentArray[n];
            boolean groupByExpression = false;
            SQLFragment sqlFrag2 = sqlFrag;
            if (sqlFrag2 instanceof SelectObject) {
                sqlFrag2 = ((SelectObject)sqlFrag).getExpression();
            }
            if ((gbo = this.m_query.getGroupByObject()) != null) {
                for (SQLFragment gbFrag : this.getChildrenDeep(gbo, null)) {
                    if (!gbFrag.equals(sqlFrag2)) continue;
                    retval.add(new GroupByValidationObject(sqlFrag2, true));
                    groupByExpression = true;
                    break;
                }
            }
            if (!groupByExpression) {
                if (sqlFrag2 instanceof ArithmeticOperation) {
                    retval.addAll(this.getGroupByValidationObjects(((ArithmeticOperation)sqlFrag2).getArguments()));
                } else if (sqlFrag2 instanceof Function) {
                    if (((Function)sqlFrag2).isGrouping()) {
                        retval.add(new GroupByValidationObject(sqlFrag2, true));
                    } else {
                        retval.addAll(this.getGroupByValidationObjects(((Function)sqlFrag2).getArguments()));
                    }
                } else if (sqlFrag2 instanceof ColumnUsage) {
                    retval.add(new GroupByValidationObject(sqlFrag2, false));
                }
            }
            ++n;
        }
        return retval;
    }

    private static class GroupByValidationObject {
        private SQLFragment m_frag;
        private boolean m_ok;

        GroupByValidationObject(SQLFragment frag, boolean ok) {
            this.m_frag = frag;
            this.m_ok = ok;
        }

        static SQLFragment ra$m_frag(GroupByValidationObject groupByValidationObject) {
            return groupByValidationObject.m_frag;
        }

        static boolean ra$m_ok(GroupByValidationObject groupByValidationObject) {
            return groupByValidationObject.m_ok;
        }

        static void wa$m_ok(GroupByValidationObject groupByValidationObject, boolean bl) {
            groupByValidationObject.m_ok = bl;
        }
    }
}

