/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleIndexPartitions
extends AbstractChildDBObject {
    @PropertyKey(value=OracleIndexPartitions.class, childOf={Index.class}, provider=OracleDatabase.class)
    public static final String KEY = "OracleIndexPartitions";
    public static final String TYPE = "INDEX PARTITION MODEL";
    private PartitionType m_partitionType;
    private List<DBObjectID> m_globalPartitionColumns;
    private Integer m_globalHashQuantity;
    private List<String> m_tablespaces;

    private void $init$() {
        this.m_globalPartitionColumns = new ArrayList<DBObjectID>();
        this.m_tablespaces = new ArrayList<String>();
    }

    public OracleIndexPartitions() {
        this.$init$();
    }

    public OracleIndexPartitions(PartitionType partitionType) {
        this.$init$();
        this.m_partitionType = partitionType;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    @Transient
    public String getName() {
        return KEY;
    }

    @Override
    @Transient
    public void setName(String name) {
    }

    public PartitionType getPartitionType() {
        return this.m_partitionType;
    }

    public IndexPartition[] getPartitions() {
        return (IndexPartition[])this.getChildSupport().getChildArray(IndexPartition.class);
    }

    public DBObjectID[] getGlobalPartitionColumns() {
        return this.m_globalPartitionColumns.toArray(new DBObjectID[this.m_globalPartitionColumns.size()]);
    }

    public String[] getTablespaces() {
        return this.m_tablespaces.toArray(new String[this.m_tablespaces.size()]);
    }

    public Integer getGlobalHashQuantity() {
        return this.m_globalHashQuantity;
    }

    public void setPartitionType(PartitionType partitionType) {
        this.m_partitionType = partitionType;
    }

    public void setGlobalPartitionColumns(DBObjectID[] partitionColumns) {
        this.m_globalPartitionColumns.removeAll(this.m_globalPartitionColumns);
        if (partitionColumns != null) {
            int i = 0;
            while (i < partitionColumns.length) {
                this.addGlobalPartitionColumn(partitionColumns[i]);
                ++i;
            }
        }
    }

    public void addGlobalPartitionColumn(DBObjectID partitionColumn) {
        if (partitionColumn != null) {
            this.m_globalPartitionColumns.add(partitionColumn);
        }
    }

    public void removeGlobalPartitionColumn(DBObjectID partitionColumn) {
        this.m_globalPartitionColumns.remove(partitionColumn);
    }

    public void setPartitions(IndexPartition[] partitions) {
        this.getChildSupport().setChildArray(IndexPartition.class, partitions);
    }

    public void addPartition(IndexPartition partition) {
        this.getChildSupport().addChild(partition);
    }

    public void removePartition(IndexPartition partition) {
        this.getChildSupport().removeChild(partition);
    }

    public void setTablespaces(String[] tablespaces) {
        this.m_tablespaces.removeAll(this.m_tablespaces);
        if (tablespaces != null) {
            int i = 0;
            while (i < tablespaces.length) {
                this.m_tablespaces.add(tablespaces[i]);
                ++i;
            }
        }
    }

    public void addTablespace(String tablespace) {
        if (tablespace != null) {
            this.m_tablespaces.add(tablespace);
        }
    }

    public void setGlobalHashQuantity(Integer hashQuantity) {
        this.m_globalHashQuantity = hashQuantity;
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        OracleIndexPartitions copy = target != null ? (OracleIndexPartitions)target : new OracleIndexPartitions();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    public boolean equals(Object target) {
        return target instanceof OracleIndexPartitions && this.equalsImpl((OracleIndexPartitions)target);
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        int i = 0;
        while (i < this.m_globalPartitionColumns.size()) {
            DBObjectID next = this.m_globalPartitionColumns.get(i);
            if (idMap.containsKey(next)) {
                this.m_globalPartitionColumns.set(i, idMap.get(next));
                replaced = true;
            }
            ++i;
        }
        return replaced;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        refs.addAll(this.m_globalPartitionColumns);
    }

    protected void copyToImpl(OracleIndexPartitions target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_partitionType = this.m_partitionType;
        target.m_globalHashQuantity = this.m_globalHashQuantity;
        target.m_globalPartitionColumns.clear();
        target.m_globalPartitionColumns.addAll(this.m_globalPartitionColumns);
        ModelUtil.deepCopy(this.m_tablespaces, target.m_tablespaces);
    }

    protected boolean equalsImpl(OracleIndexPartitions target) {
        return super.equalsImpl(target) && ModelUtil.areEqual((Object)((Object)this.m_partitionType), (Object)((Object)target.m_partitionType)) && ModelUtil.areEqual(this.m_globalPartitionColumns, target.m_globalPartitionColumns) && ModelUtil.areEqual((Object)this.m_globalHashQuantity, (Object)target.m_globalHashQuantity) && ModelUtil.areEqual(this.m_tablespaces, target.m_tablespaces);
    }

    public static Column[] getValidGlobalPartitionColumns(Index index) {
        ArrayList<Column> columns = new ArrayList<Column>();
        Table table = index.getTable();
        IndexObject[] indexObjectArray = index.getColumnExpressions();
        int n = 0;
        while (n < indexObjectArray.length) {
            IndexObject colExpr = indexObjectArray[n];
            String expr = colExpr.getExpression().getSQLText();
            if (table.getColumn(expr) == null || "DESC".equals(colExpr.getOrder())) break;
            columns.add(table.getColumn(expr));
            ++n;
        }
        return columns.toArray(new Column[columns.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PartitionType
    extends Enum<PartitionType> {
        private static final /* synthetic */ PartitionType[] $v;
        public static final /* enum */ PartitionType GLOBAL_RANGE;
        public static final /* enum */ PartitionType GLOBAL_HASH;
        public static final /* enum */ PartitionType LOCAL_HASH;
        public static final /* enum */ PartitionType LOCAL_COMP;
        public static final /* enum */ PartitionType LOCAL_OTHER;
        public static final /* enum */ PartitionType DOMAIN;
        public static final /* enum */ PartitionType SUBPARTITION;

        public static PartitionType valueOf(String string) {
            return Enum.valueOf(PartitionType.class, string);
        }

        public static final PartitionType[] values() {
            return (PartitionType[])$v.clone();
        }

        static {
            PartitionType[] partitionTypeArray = new PartitionType[7];
            partitionTypeArray[6] = SUBPARTITION = new PartitionType("SUBPARTITION", 6);
            partitionTypeArray[5] = DOMAIN = new PartitionType("DOMAIN", 5);
            partitionTypeArray[4] = LOCAL_OTHER = new PartitionType("LOCAL_OTHER", 4);
            partitionTypeArray[3] = LOCAL_COMP = new PartitionType("LOCAL_COMP", 3);
            partitionTypeArray[2] = LOCAL_HASH = new PartitionType("LOCAL_HASH", 2);
            partitionTypeArray[1] = GLOBAL_HASH = new PartitionType("GLOBAL_HASH", 1);
            partitionTypeArray[0] = GLOBAL_RANGE = new PartitionType("GLOBAL_RANGE", 0);
            $v = partitionTypeArray;
        }

        private PartitionType(String string2, int n2) {
        }
    }
}

