/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleExternalTableProperties
extends AbstractChildDBObject {
    @PropertyKey(value=OracleExternalTableProperties.class, childOf={Table.class}, provider=OracleDatabase.class)
    public static final String KEY = "OracleExternalTableProperties";
    public static final String TYPE = "EXTERNAL TABLE PROPERTIES";
    public static final String ACCESS_DRIVER_TYPE_ORACLE_LOADER = "ORACLE_LOADER";
    public static final String ACCESS_DRIVER_TYPE_ORACLE_DATAPUMP = "ORACLE_DATAPUMP";
    public static final String REJECT_LIMIT_UNLIMITED = "UNLIMITED";
    private DBObjectID m_defaultDirectory;
    private String m_accessDriverType;
    private boolean m_accessUsingClob;
    private Object m_accessParameters;
    private String m_rejectLimit;
    private ProjectColumn m_projectColumn;
    private List<LocationSpecifier> m_locationSpecifiers;

    private void $init$() {
        this.m_accessUsingClob = false;
        this.m_projectColumn = ProjectColumn.ALL;
        this.m_locationSpecifiers = new ArrayList<LocationSpecifier>();
    }

    public OracleExternalTableProperties() {
        this.$init$();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        OracleExternalTableProperties copy = target != null ? (OracleExternalTableProperties)target : new OracleExternalTableProperties();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    public boolean equals(Object target) {
        return target instanceof OracleExternalTableProperties && this.equalsImpl((OracleExternalTableProperties)target);
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        if (this.m_defaultDirectory != null && idMap.containsKey(this.m_defaultDirectory)) {
            this.m_defaultDirectory = idMap.get(this.m_defaultDirectory);
            replaced = true;
        }
        for (LocationSpecifier locSpec : this.m_locationSpecifiers) {
            DBObjectID dirID = locSpec.getDirectory();
            if (dirID == null || !idMap.containsKey(dirID)) continue;
            locSpec.setDirectory(idMap.get(dirID));
        }
        return replaced;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        if (this.m_defaultDirectory != null) {
            refs.add(this.m_defaultDirectory);
        }
        for (LocationSpecifier locSpec : this.m_locationSpecifiers) {
            DBObjectID dirID = locSpec.getDirectory();
            if (dirID == null) continue;
            refs.add(dirID);
        }
    }

    public void setDefaultDirectory(DBObjectID directory) {
        this.m_defaultDirectory = directory;
    }

    public DBObjectID getDefaultDirectory() {
        return this.m_defaultDirectory;
    }

    public void setLocationSpecifiers(LocationSpecifier[] locationSpecifiers) {
        this.m_locationSpecifiers.clear();
        if (locationSpecifiers != null) {
            int i = 0;
            while (i < locationSpecifiers.length) {
                this.m_locationSpecifiers.add(locationSpecifiers[i]);
                ++i;
            }
        }
    }

    public LocationSpecifier[] getLocationSpecifiers() {
        return this.m_locationSpecifiers.toArray(new LocationSpecifier[this.m_locationSpecifiers.size()]);
    }

    public void addLocationSpecifier(LocationSpecifier locationSpecifier) {
        this.m_locationSpecifiers.add(locationSpecifier);
    }

    public void addLocationSpecifier(DBObjectID directory, String specifier) {
        this.m_locationSpecifiers.add(new LocationSpecifier(directory, specifier));
    }

    public void addLocationSpecifier(String specifier) {
        this.m_locationSpecifiers.add(new LocationSpecifier(specifier));
    }

    public void removeLocationSpecifier(LocationSpecifier locationSpecifier) {
        this.m_locationSpecifiers.remove(locationSpecifier);
    }

    public void removeAllLocationSpecifiers() {
        this.m_locationSpecifiers.clear();
    }

    public void setAccessDriverType(String accessDriverType) {
        this.m_accessDriverType = accessDriverType;
    }

    public String getAccessDriverType() {
        return this.m_accessDriverType;
    }

    public void setAccessParameters(Object accessParameters) {
        this.m_accessParameters = accessParameters;
    }

    public Object getAccessParameters() {
        return this.m_accessParameters;
    }

    public void setAccessUsingClob(boolean usingClob) {
        this.m_accessUsingClob = usingClob;
    }

    public boolean isAccessUsingClob() {
        return this.m_accessUsingClob;
    }

    public void setRejectLimit(String rejectLimit) {
        this.m_rejectLimit = rejectLimit;
    }

    public String getRejectLimit() {
        return this.m_rejectLimit;
    }

    public void setProjectColumn(ProjectColumn projectColumn) {
        this.m_projectColumn = projectColumn;
    }

    public ProjectColumn getProjectColumn() {
        return this.m_projectColumn;
    }

    protected void copyToImpl(OracleExternalTableProperties copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        copy.m_accessDriverType = this.m_accessDriverType;
        copy.m_accessUsingClob = this.m_accessUsingClob;
        copy.m_accessParameters = this.m_accessParameters;
        copy.m_rejectLimit = this.m_rejectLimit;
        copy.m_defaultDirectory = this.m_defaultDirectory;
        copy.m_projectColumn = this.m_projectColumn;
        ModelUtil.deepCopy(this.m_locationSpecifiers, copy.m_locationSpecifiers);
    }

    protected boolean equalsImpl(OracleExternalTableProperties target) {
        return super.equalsImpl(target) && this.m_accessUsingClob == target.m_accessUsingClob && ModelUtil.areEqual((Object)this.m_accessDriverType, (Object)target.m_accessDriverType) && ModelUtil.areEqual((Object)this.m_accessParameters, (Object)target.m_accessParameters) && ModelUtil.areEqual((Object)this.m_rejectLimit, (Object)target.m_rejectLimit) && ModelUtil.areEqual((Object)((Object)this.m_projectColumn), (Object)((Object)target.m_projectColumn)) && ModelUtil.areEqual((Object)this.m_defaultDirectory, (Object)target.m_defaultDirectory) && ModelUtil.areEqual(this.m_locationSpecifiers, target.m_locationSpecifiers);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AccessType
    extends Enum<AccessType> {
        private static final /* synthetic */ AccessType[] $v;
        public static final /* enum */ AccessType BLOB;
        public static final /* enum */ AccessType CLOB;

        public static AccessType valueOf(String string) {
            return Enum.valueOf(AccessType.class, string);
        }

        public static final AccessType[] values() {
            return (AccessType[])$v.clone();
        }

        static {
            AccessType[] accessTypeArray = new AccessType[2];
            accessTypeArray[1] = CLOB = new AccessType("CLOB", 1);
            accessTypeArray[0] = BLOB = new AccessType("BLOB", 0);
            $v = accessTypeArray;
        }

        private AccessType(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ProjectColumn
    extends Enum<ProjectColumn> {
        private static final /* synthetic */ ProjectColumn[] $v;
        public static final /* enum */ ProjectColumn ALL;
        public static final /* enum */ ProjectColumn REFERENCED;

        public static ProjectColumn valueOf(String string) {
            return Enum.valueOf(ProjectColumn.class, string);
        }

        public static final ProjectColumn[] values() {
            return (ProjectColumn[])$v.clone();
        }

        static {
            ProjectColumn[] projectColumnArray = new ProjectColumn[2];
            projectColumnArray[1] = REFERENCED = new ProjectColumn("REFERENCED", 1);
            projectColumnArray[0] = ALL = new ProjectColumn("ALL", 0);
            $v = projectColumnArray;
        }

        private ProjectColumn(String string2, int n2) {
        }
    }

    public static class LocationSpecifier
    implements Copyable {
        private DBObjectID _directory;
        private String _specifier;

        public LocationSpecifier() {
        }

        public LocationSpecifier(String specifier) {
            this._directory = null;
            this._specifier = specifier;
        }

        public LocationSpecifier(DBObjectID directory, String specifier) {
            this._directory = directory;
            this._specifier = specifier;
        }

        public Object copyTo(Object target) {
            LocationSpecifier copy = target != null ? (LocationSpecifier)target : new LocationSpecifier();
            this.copyToImpl(copy);
            return copy;
        }

        protected void copyToImpl(LocationSpecifier copy) {
            copy._specifier = this._specifier;
            copy._directory = this._directory;
        }

        public boolean equals(Object target) {
            return target instanceof LocationSpecifier && this.equalsImpl((LocationSpecifier)target);
        }

        protected boolean equalsImpl(LocationSpecifier target) {
            return ModelUtil.areEqual((Object)this._specifier, (Object)target._specifier) && ModelUtil.areEqual((Object)this._directory, (Object)target._directory);
        }

        public void setDirectory(DBObjectID directory) {
            this._directory = directory;
        }

        public DBObjectID getDirectory() {
            return this._directory;
        }

        public void setSpecifier(String specifier) {
            this._specifier = specifier;
        }

        public String getSpecifier() {
            return this._specifier;
        }
    }
}

