/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.ObjectTypeUsage;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOBDescriptor
extends AbstractChildDBObject {
    public static final String TYPE = "LOB DESCRIPTOR";
    public static final String LOB_PARAMETER_CACHE = "CACHE";
    public static final String LOB_PARAMETER_NOCACHE = "NOCACHE";
    public static final String LOB_PARAMETER_CACHEREADS = "CACHE READS";
    private String m_lobSegName;
    private List<DBObjectID> m_lobColumns;
    private Integer m_chunk;
    private Integer m_pctVersion;
    private Integer m_freepools;
    private boolean m_storageEnabledInRow;
    private boolean m_retention;
    private String m_cache;
    private OracleStorageProperties m_storage;

    private void $init$() {
        this.m_lobColumns = new ArrayList<DBObjectID>();
        this.m_storageEnabledInRow = true;
        this.m_retention = false;
    }

    public LOBDescriptor() {
        this.$init$();
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        LOBDescriptor copy = target != null ? (LOBDescriptor)target : new LOBDescriptor();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (!ModelUtil.hasLength((String)name)) {
            name = "";
            for (DBObjectID colID : this.m_lobColumns) {
                try {
                    DBObject col = colID.resolveID();
                    if (col == null) continue;
                    if (name.length() > 0) {
                        name = name + ", ";
                    }
                    name = name + col.getName();
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
            this.setName(name);
        }
        return name;
    }

    public boolean equals(Object target) {
        return target instanceof LOBDescriptor && this.equalsImpl((LOBDescriptor)target);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setLOBSegName(String name) {
        this.m_lobSegName = name;
    }

    public String getLOBSegName() {
        return this.m_lobSegName;
    }

    public void setColumns(DBObjectID[] columns) {
        this.m_lobColumns.removeAll(this.m_lobColumns);
        if (columns != null) {
            int i = 0;
            while (i < columns.length) {
                this.addColumn(columns[i]);
                ++i;
            }
        }
    }

    public DBObjectID[] getColumns() {
        return this.m_lobColumns.toArray(new DBObjectID[this.m_lobColumns.size()]);
    }

    public void addColumn(DBObjectID column) {
        if (column != null) {
            this.m_lobColumns.add(column);
        }
    }

    public void removeColumn(DBObjectID column) {
        this.m_lobColumns.remove(column);
    }

    public void setChunk(Integer chunk) {
        this.m_chunk = chunk;
    }

    public Integer getChunk() {
        return this.m_chunk;
    }

    public void setPctVersion(Integer pctVersion) {
        this.m_pctVersion = pctVersion;
    }

    public Integer getPctVersion() {
        return this.m_pctVersion;
    }

    public void setFreepools(Integer freepools) {
        this.m_freepools = freepools;
    }

    public Integer getFreepools() {
        return this.m_freepools;
    }

    public void setStorage(OracleStorageProperties storage) {
        this.m_storage = storage;
    }

    public OracleStorageProperties getStorage() {
        return this.m_storage;
    }

    public void setRetention(boolean retention) {
        this.m_retention = retention;
    }

    public boolean isRetention() {
        return this.m_retention;
    }

    public void setStorageEnabledInRow(boolean storageEnabledInRow) {
        this.m_storageEnabledInRow = storageEnabledInRow;
    }

    public boolean isStorageEnabledInRow() {
        return this.m_storageEnabledInRow;
    }

    public void setCache(String cache) {
        this.m_cache = cache;
    }

    public String getCache() {
        return this.m_cache;
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        int i = 0;
        while (i < this.m_lobColumns.size()) {
            DBObjectID next = this.m_lobColumns.get(i);
            if (idMap.containsKey(next)) {
                this.m_lobColumns.set(i, idMap.get(next));
                replaced = true;
            }
            ++i;
        }
        return replaced;
    }

    public static boolean isLOBColumn(DBObjectID colID) {
        try {
            Column column = (Column)colID.resolveID();
            if (column != null) {
                boolean bl = LOBDescriptor.isLOBColumn(column);
                return bl;
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isLOBColumn(Column column) {
        try {
            DataType dt = DataTypeHelper.getDataType(column.getDataTypeUsage());
            if (dt != null) {
                String name = dt.getName();
                boolean bl = "BLOB".equalsIgnoreCase(name) || "CLOB".equalsIgnoreCase(name) || "NCLOB".equalsIgnoreCase(name);
                return bl;
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isVARRAYColumn(DBObjectID colID) {
        Column column = null;
        Object dt = null;
        try {
            column = (Column)colID.resolveID();
            if (column != null) {
                boolean bl = LOBDescriptor.isVARRAYColumn(column);
                return bl;
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isVARRAYColumn(Column column) {
        block3: {
            try {
                DataTypeUsage dtu = column.getDataTypeUsage();
                if (!(dtu instanceof ObjectTypeUsage)) break block3;
                ComplexType typ = (ComplexType)dtu.getDataTypeID().resolveID();
                if (typ == null) {
                    DBLog.getLogger().log(Level.WARNING, column.getName() + " has invalid data type usage");
                    break block3;
                }
                boolean bl = "VARYING ARRAY".equals(typ.getCollectionType());
                return bl;
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return false;
    }

    protected void copyToImpl(LOBDescriptor target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_lobSegName = this.m_lobSegName;
        target.m_storageEnabledInRow = this.m_storageEnabledInRow;
        target.m_chunk = this.m_chunk;
        target.m_pctVersion = this.m_pctVersion;
        target.m_retention = this.m_retention;
        target.m_freepools = this.m_freepools;
        target.m_cache = this.m_cache;
        target.m_storage = this.m_storage == null ? null : (OracleStorageProperties)this.m_storage.copyTo(null);
        target.m_lobColumns.clear();
        target.m_lobColumns.addAll(this.m_lobColumns);
    }

    protected boolean equalsImpl(LOBDescriptor target) {
        return super.equalsImpl(target) && ModelUtil.areEqual((Object)this.m_lobSegName, (Object)target.m_lobSegName) && ModelUtil.areEqual(this.m_lobColumns, target.m_lobColumns) && target.m_storageEnabledInRow == this.m_storageEnabledInRow && ModelUtil.areEqual((Object)target.m_chunk, (Object)this.m_chunk) && ModelUtil.areEqual((Object)target.m_pctVersion, (Object)this.m_pctVersion) && target.m_retention == this.m_retention && ModelUtil.areEqual((Object)target.m_freepools, (Object)this.m_freepools) && ModelUtil.areEqual((Object)target.m_cache, (Object)this.m_cache) && ModelUtil.areEqual((Object)target.m_storage, (Object)this.m_storage);
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        refs.addAll(this.m_lobColumns);
    }

    public static LOBDescriptor findLOBDescriptorForColumn(Column column) {
        OracleColumnProperties ocp = (OracleColumnProperties)column.getProperty("OracleColumnProperties");
        if (ocp != null) {
            if (LOBDescriptor.isLOBColumn(column.getID())) {
                return ocp.getLOBProperties();
            }
            if (LOBDescriptor.isVARRAYColumn(column.getID())) {
                return ocp.getVAProperties();
            }
        }
        return null;
    }
}

