/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexPartition
extends AbstractChildDBObject {
    public static final String TYPE = "INDEX PARTITION";
    private OracleIndexPartitions m_subpartitions;
    private OracleStorageProperties m_segmentAttributes;
    private Boolean m_keyCompression;
    private ArrayList m_valuesLessThan;
    private String m_domainParameters;

    private void $init$() {
        this.m_valuesLessThan = new ArrayList();
    }

    public IndexPartition() {
        this.$init$();
    }

    public IndexPartition(OracleIndexPartitions parent) {
        super(null, parent);
        this.$init$();
    }

    public IndexPartition(String name, OracleIndexPartitions parent) {
        super(name, parent);
        this.$init$();
    }

    public Boolean getKeyCompression() {
        return this.m_keyCompression;
    }

    public Object[] getValuesLessThan() {
        return this.m_valuesLessThan.toArray(new Object[this.m_valuesLessThan.size()]);
    }

    public OracleStorageProperties getSegmentAttributes() {
        return this.m_segmentAttributes;
    }

    public OracleIndexPartitions getSubpartitions() {
        return this.m_subpartitions;
    }

    public String getDomainParameters() {
        return this.m_domainParameters;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setKeyCompression(Boolean isEnabled) {
        this.m_keyCompression = isEnabled;
    }

    public void setValuesLessThan(Object[] values) {
        this.m_valuesLessThan.removeAll(this.m_valuesLessThan);
        if (values != null) {
            Object[] objectArray = values;
            int n = 0;
            while (n < objectArray.length) {
                Object value = objectArray[n];
                this.addValue(value);
                ++n;
            }
        }
    }

    public void setValuesLessThan(String values) {
        if (ModelUtil.hasLength((String)values)) {
            List<String> list = TablePartition.splitValues(values);
            this.setValuesLessThan(list.toArray(new String[list.size()]));
        }
    }

    public void setSegmentAttributes(OracleStorageProperties segmentAttributes) {
        this.m_segmentAttributes = segmentAttributes;
    }

    public void setSubpartitions(OracleIndexPartitions subpartitions) {
        this.changeParent(this.m_subpartitions, subpartitions);
        this.m_subpartitions = subpartitions;
    }

    public void setDomainParameters(String parameters) {
        this.m_domainParameters = parameters;
    }

    public void addValue(Object value) {
        if (value != null) {
            this.m_valuesLessThan.add(this.normaliseValue(value));
        }
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        IndexPartition copy = target != null ? (IndexPartition)target : new IndexPartition();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    public boolean equals(Object target) {
        return target instanceof IndexPartition && this.equalsImpl((IndexPartition)target);
    }

    protected void copyToImpl(IndexPartition target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_keyCompression = this.m_keyCompression;
        target.m_domainParameters = this.m_domainParameters;
        target.setSegmentAttributes(this.copyObject(this.m_segmentAttributes, target, idPolicy));
        target.setSubpartitions(this.copyObject(this.m_subpartitions, target, idPolicy));
        ModelUtil.deepCopy((List)this.m_valuesLessThan, (List)target.m_valuesLessThan, (boolean)false);
    }

    protected boolean equalsImpl(IndexPartition target) {
        return super.equalsImpl(target) && ModelUtil.areEqual((Object)this.m_keyCompression, (Object)target.m_keyCompression) && ModelUtil.areEqual((Object)this.m_subpartitions, (Object)target.m_subpartitions) && ModelUtil.areEqual((Object)this.m_segmentAttributes, (Object)target.m_segmentAttributes) && ModelUtil.areEqual((Object)this.m_valuesLessThan, (Object)target.m_valuesLessThan) && ModelUtil.areEqual((Object)this.m_domainParameters, (Object)target.m_domainParameters);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        super.getOwnedObjectsImpl(objs, types);
        this.includeOwnedObject(objs, this.m_subpartitions, types);
    }

    private Object normaliseValue(Object value) {
        String s;
        if (value instanceof String && "MAXVALUE".equalsIgnoreCase(s = (String)value)) {
            return TablePartition.RangeValue.valueOf(s.toUpperCase());
        }
        return value;
    }
}

