/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.diff.ResultSetFilter;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.DynamicPropertySet;
import oracle.javatools.util.DynamicPropertySetImpl;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSet
implements Copyable,
DynamicPropertySet {
    private DynamicPropertySet m_props;
    private ResultSet m_parent;
    private boolean m_same;
    private Object m_a;
    private Object m_b;
    private String m_name;
    private String m_propPath;
    private int m_indexOfA;
    private int m_indexOfB;
    private boolean m_listReordered;
    private List<ResultSet> m_list;
    private HashMap<String, ResultSet> m_map;
    public static final String LIST = "LIST";
    public static final String MAP = "MAP";
    public static final String LEAF = "LEAF";
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.m_indexOfA = -1;
        this.m_indexOfB = -1;
    }

    static {
        $assertionsDisabled = ResultSet.class.desiredAssertionStatus() ^ true;
    }

    public ResultSet(ResultSet parent, Object a, Object b, int indexOfA, int indexOfB, String name, String type) {
        this.$init$();
        if (!(indexOfA < 0 && indexOfB < 0 || $assertionsDisabled || parent.getType().equals(LIST))) {
            throw new AssertionError();
        }
        this.m_parent = parent;
        this.m_a = a;
        this.m_b = b;
        this.m_name = name;
        if (name == null) {
            if (parent != null) {
                this.m_name = parent.m_name;
                this.m_propPath = parent.getType().equals(LIST) ? parent.m_propPath + "/<" + parent.m_list.size() + ">" : parent.m_propPath;
            }
        } else {
            this.m_propPath = parent != null && parent.m_propPath != null ? parent.m_propPath + "/" + name : name;
        }
        this.setType(type);
        if (parent != null) {
            if (LIST.equals(parent.getType())) {
                parent.addToList(this);
                this.m_indexOfA = indexOfA;
                this.m_indexOfB = indexOfB;
            }
            if (MAP.equals(parent.getType())) {
                parent.addToMap(name, this);
            }
        }
    }

    protected void setType(String type) {
        this.m_list = type.equals(LIST) ? new ArrayList() : null;
        this.m_map = type.equals(MAP) ? new HashMap() : null;
    }

    public ResultSet(ResultSet parent, Object a, Object b, String name, String type) {
        this(parent, a, b, -1, -1, name, type);
    }

    @Deprecated
    public ResultSet(ResultSet parent, boolean same, Object a, Object b, String propertyName, String aVal, String bVal) {
        this(parent, a, b, propertyName, LEAF);
        this.m_same = same;
    }

    public ResultSet(ResultSet parent, boolean same, Object a, Object b, String propertyName) {
        this(parent, a, b, propertyName, LEAF);
        this.m_same = same;
    }

    public String getType() {
        String type = LEAF;
        if (this.m_list != null) {
            type = LIST;
        } else if (this.m_map != null) {
            type = MAP;
        }
        return type;
    }

    public void addToList(ResultSet rs) {
        this.m_list.add(rs);
    }

    public void addToMap(String name, ResultSet rs) {
        this.m_map.put(name, rs);
    }

    public boolean isModified() {
        return !this.isSame() && !this.inBbutNotA() && !this.inAbutNotB();
    }

    public boolean isSame() {
        return this.m_same;
    }

    public void setSame(boolean val) {
        this.m_same = val;
    }

    public Object a() {
        return this.m_a;
    }

    public void setA(Object a) {
        this.m_a = a;
    }

    public Object b() {
        return this.m_b;
    }

    public void setB(Object b) {
        this.m_b = b;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getPropertyName() {
        return this.m_name;
    }

    public String getName() {
        String name = this.m_name;
        if (MAP.equals(this.getType())) {
            if (this.m_b == null && this.m_a instanceof DBObject) {
                name = ((DBObject)this.m_a).getName();
            } else if (this.m_b != null && this.m_b instanceof DBObject) {
                name = ((DBObject)this.m_b).getName();
            }
        }
        return ModelUtil.hasLength((String)name) ? name : this.m_name;
    }

    public boolean isChildListReorder() {
        return this.m_listReordered;
    }

    public void setListReordered(boolean listReordered) {
        this.m_listReordered = listReordered;
    }

    public List<ResultSet> getModifiedObjectList() {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (ResultSet rs : this.m_list) {
                if (rs.a() == null || rs.b() == null || rs.isSame()) continue;
                result.add(rs);
            }
        }
        return result;
    }

    public List<ResultSet> getNotSameObjectList() {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (ResultSet rs : this.m_list) {
                if (rs.isSame()) continue;
                result.add(rs);
            }
        }
        return result;
    }

    public boolean inBbutNotA() {
        return !this.m_same && this.m_a == null && this.m_b != null;
    }

    public int getIndexOfA() {
        return this.m_indexOfA;
    }

    public int getIndexOfB() {
        return this.m_indexOfB;
    }

    public List<ResultSet> getAList() {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (ResultSet rs : this.m_list) {
                if (!rs.inA()) continue;
                result.add(rs);
            }
        }
        return result;
    }

    public List<ResultSet> getBList() {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (ResultSet rs : this.m_list) {
                if (!rs.inB()) continue;
                result.add(rs);
            }
        }
        return result;
    }

    public List<ResultSet> getBonlyList() {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (ResultSet rs : this.m_list) {
                if (!rs.inBbutNotA()) continue;
                result.add(rs);
            }
        }
        return result;
    }

    public boolean inA() {
        return this.m_a != null;
    }

    public boolean inB() {
        return this.m_b != null;
    }

    public boolean inAbutNotB() {
        return !this.m_same && this.m_a != null && this.m_b == null;
    }

    public List<ResultSet> getAonlyList() {
        ArrayList<ResultSet> result = new ArrayList<ResultSet>();
        if (this.m_list != null) {
            for (ResultSet rs : this.m_list) {
                if (!rs.inAbutNotB()) continue;
                result.add(rs);
            }
        }
        return result;
    }

    public List<ResultSet> getAllObjectsList() {
        return this.m_list == null ? null : new ArrayList<ResultSet>(this.m_list);
    }

    public Map<String, ResultSet> getModifiedObjectMap() {
        HashMap<String, ResultSet> result = new HashMap<String, ResultSet>();
        if (this.m_map != null) {
            for (String key : this.m_map.keySet()) {
                ResultSet r = this.m_map.get(key);
                if (r.a() == null || r.b() == null || r.isSame()) continue;
                result.put(key, r);
            }
        }
        return result;
    }

    public Map<String, ResultSet> getNotSameObjectMap() {
        HashMap<String, ResultSet> result = new HashMap<String, ResultSet>();
        if (this.m_map != null) {
            for (String key : this.m_map.keySet()) {
                ResultSet r = this.m_map.get(key);
                if (r.isSame()) continue;
                result.put(key, r);
            }
        }
        return result;
    }

    public Map<String, ResultSet> getBonlyMap() {
        HashMap<String, ResultSet> result = new HashMap<String, ResultSet>();
        if (this.m_map != null) {
            for (String key : this.m_map.keySet()) {
                ResultSet r = this.m_map.get(key);
                if (r.a() != null || r.b() == null) continue;
                result.put(key, r);
            }
        }
        return result;
    }

    public Map getAonlyMap() {
        HashMap<String, ResultSet> result = new HashMap<String, ResultSet>();
        if (this.m_map != null) {
            for (String key : this.m_map.keySet()) {
                ResultSet r = this.m_map.get(key);
                if (r.a() == null || r.b() != null) continue;
                result.put(key, r);
            }
        }
        return result;
    }

    public Map<String, ResultSet> getAllObjectsMap() {
        return this.m_map == null ? null : new HashMap<String, ResultSet>(this.m_map);
    }

    public Class getResultSetClass() {
        Object rso = this.getResultSetObject();
        return rso == null ? null : rso.getClass();
    }

    public Object getResultSetObject() {
        return this.m_a == null ? this.m_b : this.m_a;
    }

    public Iterator<ResultSet> getChildIterator() {
        Iterator<ResultSet> result = this.m_map != null ? this.m_map.values().iterator() : (this.m_list != null ? this.m_list.iterator() : Collections.emptyList().iterator());
        return result;
    }

    public void print() {
        this.print("", -1);
    }

    public void printOne() {
        this.print("", 1);
    }

    private void print(String indent, int printChildren) {
        StringWriter sw = new StringWriter();
        this.print(indent, printChildren, new PrintWriter(sw));
        DBLog.log(sw.getBuffer().toString(), new Object[0]);
    }

    public void print(PrintWriter pw) {
        this.print("", -1, pw);
    }

    private void print(String indent, int printChildren, PrintWriter writer) {
        String type = this.getType() + " ";
        String same = this.m_same ? "SAME " : "XXXX ";
        String name = this.getName();
        if (name == null) {
            name = "";
        }
        if (this.m_map != null) {
            writer.println(indent + same + type + name + " " + this.m_indexOfA + " " + this.m_indexOfB);
            if (printChildren-- != 0) {
                Iterator<String> i = this.m_map.keySet().iterator();
                while (i.hasNext()) {
                    ResultSet r = this.m_map.get(i.next());
                    r.print(indent + "  ", printChildren, writer);
                }
            }
        } else if (this.m_list != null) {
            String reordered = this.isChildListReorder() ? " reordered" : "";
            writer.println(indent + same + type + name + " list" + reordered);
            if (printChildren-- != 0) {
                for (ResultSet r : this.m_list) {
                    r.print(indent + "  ", printChildren, writer);
                }
            }
        } else {
            writer.println(indent + same + type + name);
        }
    }

    String getPropertyPath() {
        return this.m_propPath;
    }

    public Map getProperties() {
        return this.m_props == null ? null : this.m_props.getProperties();
    }

    public Object getProperty(String key) {
        return this.m_props == null ? null : this.m_props.getProperty(key);
    }

    public Object getProperty(String key, Object defaultValue) {
        return this.m_props == null ? defaultValue : this.m_props.getProperty(key, defaultValue);
    }

    public void setProperties(Map properties) {
        if (this.m_props == null) {
            this.m_props = new DynamicPropertySetImpl();
        }
        this.m_props.setProperties(properties);
    }

    public void setProperty(String key, Object value) {
        if (this.m_props == null) {
            this.m_props = new DynamicPropertySetImpl();
        }
        this.m_props.setProperty(key, value);
    }

    public Object copyTo(Object target) {
        if (!$assertionsDisabled && target != null && !(target instanceof ResultSet)) {
            throw new AssertionError();
        }
        ResultSet copy = target != null ? (ResultSet)target : new ResultSet();
        copy.m_props = this.m_props == null ? null : (DynamicPropertySet)this.m_props.copyTo(null);
        copy.m_same = this.m_same;
        copy.m_a = this.m_a;
        copy.m_b = this.m_b;
        copy.m_name = this.m_name;
        copy.m_propPath = this.m_propPath;
        copy.m_indexOfA = this.m_indexOfA;
        copy.m_indexOfB = this.m_indexOfB;
        copy.m_listReordered = this.m_listReordered;
        if (this.m_list != null) {
            copy.m_list = new ArrayList<ResultSet>();
            for (ResultSet rs : this.m_list) {
                ResultSet child = (ResultSet)rs.copyTo(null);
                child.m_parent = copy;
                copy.m_list.add(child);
            }
        }
        if (this.m_map != null) {
            copy.m_map = new HashMap();
            for (String key : this.m_map.keySet()) {
                ResultSet child = (ResultSet)this.m_map.get(key).copyTo(null);
                child.m_parent = copy;
                copy.m_map.put(key, child);
            }
        }
        return copy;
    }

    private ResultSet() {
        this.$init$();
    }

    public ResultSet getFilteredResultSet(ResultSetFilter rsf) {
        ResultSet retval = (ResultSet)this.copyTo(null);
        retval.applyFilter(rsf);
        return retval;
    }

    private void applyFilter(ResultSetFilter rsf) {
        if (!this.m_same) {
            if (this.m_list != null) {
                for (ResultSet rs : this.m_list) {
                    rs.applyFilter(rsf);
                }
                this.m_same = true;
                for (ResultSet rs : this.m_list) {
                    if (rs.isSame()) continue;
                    this.m_same = false;
                    break;
                }
            } else if (this.m_map != null && this.m_map.size() > 0) {
                for (String key : this.m_map.keySet()) {
                    ResultSet rs = this.m_map.get(key);
                    rs.applyFilter(rsf);
                }
                this.m_same = true;
                for (String key : this.m_map.keySet()) {
                    ResultSet rs = this.m_map.get(key);
                    if (rs.isSame()) continue;
                    this.m_same = false;
                    break;
                }
            } else if (rsf.isFilteredProperty(this, this.m_propPath)) {
                this.m_same = true;
            }
        }
    }

    public ResultSet getParent() {
        return this.m_parent;
    }
}

