/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngineCancelledException;
import oracle.javatools.db.diff.Differ;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DiffEngine {
    private boolean m_cancelled;
    private boolean m_allowMultipleDiffers;
    private Map<Class, List<Differ>> m_registeredDiffers;
    private Map<Class, Differ> m_registeredListDiffers;
    private Map<Class, Comparator> m_registeredComparators;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DiffEngine() {
        this(false);
    }

    public DiffEngine(boolean allowMultipleDiffers) {
        this.m_allowMultipleDiffers = allowMultipleDiffers;
        this.m_registeredDiffers = new HashMap<Class, List<Differ>>();
        this.m_registeredListDiffers = new HashMap<Class, Differ>();
        this.m_registeredComparators = new HashMap<Class, Comparator>();
    }

    public DiffEngine(DiffEngine existing) {
        this.m_allowMultipleDiffers = existing.m_allowMultipleDiffers;
        this.m_registeredDiffers = new HashMap<Class, List<Differ>>(existing.m_registeredDiffers);
        this.m_registeredListDiffers = new HashMap<Class, Differ>(existing.m_registeredListDiffers);
        this.m_registeredComparators = new HashMap<Class, Comparator>(existing.m_registeredComparators);
    }

    public DiffContext diff(Object a, Object b) {
        this.checkProgress();
        ResultSet rs = new ResultSet(null, a, b, null, "MAP");
        DiffContext dc = new DiffContext(this, rs);
        return this.diff(a, b, rs, dc);
    }

    public DiffContext diff(Object[] a, Object[] b) {
        this.checkProgress();
        ResultSet rs = new ResultSet(null, a, (Object)b, null, "LIST");
        DiffContext dc = new DiffContext(this, rs);
        return this.diff(a, b, rs, dc);
    }

    static {
        $assertionsDisabled = DiffEngine.class.desiredAssertionStatus() ^ true;
    }

    public DiffContext diff(Object a, Object b, ResultSet r, DiffContext dc) {
        this.checkProgress();
        if (!$assertionsDisabled && a == null && b == null) {
            throw new AssertionError();
        }
        Class<?> searchClass = a == null ? b.getClass() : a.getClass();
        List<Differ> differs = this.getDiffers(searchClass);
        if (!$assertionsDisabled && differs == null) {
            throw new AssertionError((Object)("no differ for class " + searchClass.getName()));
        }
        if (differs != null) {
            for (Differ differ : differs) {
                if (differ.diff(a, b, r, dc)) break;
            }
        }
        return dc;
    }

    public DiffContext diff(Object[] a, Object[] b, ResultSet r) {
        this.checkProgress();
        DiffContext dc = new DiffContext(this, r);
        return this.diff(a, b, r, dc);
    }

    public DiffContext diff(Object[] a, Object[] b, ResultSet r, DiffContext dc) {
        this.checkProgress();
        Class<?> searchClass = a == null ? b.getClass() : a.getClass();
        Differ listDiffer = this.getListDiffer(searchClass);
        listDiffer.diff(a == null ? null : Arrays.asList(a), b == null ? null : Arrays.asList(b), r, dc);
        return dc;
    }

    public DiffContext diff(List a, List b, ResultSet r, DiffContext dc) {
        this.checkProgress();
        r.setA(a);
        r.setB(b);
        Differ listDiffer = null;
        if (a != null && a.size() > 0 && a.get(0) != null) {
            listDiffer = this.getListDiffer(a.get(0).getClass());
        } else if (b != null && b.size() > 0 && b.get(0) != null) {
            listDiffer = this.getListDiffer(b.get(0).getClass());
        } else {
            r.setSame(true);
        }
        if (listDiffer != null) {
            boolean didWeDiff = listDiffer.diff(a, b, r, dc);
        }
        return dc;
    }

    public void registerDiffer(Differ d, Class c) {
        List<Differ> differs = this.m_registeredDiffers.get(c);
        if (differs == null) {
            differs = new ArrayList<Differ>();
            this.m_registeredDiffers.put(c, differs);
        }
        if (!this.m_allowMultipleDiffers) {
            differs.clear();
        }
        differs.add(0, d);
    }

    public void registerListDiffer(Differ d, Class c) {
        this.m_registeredListDiffers.put(this.toNonArrayClass(c), d);
    }

    public void registerComparator(Comparator cmp, Class c) {
        this.m_registeredComparators.put(c, cmp);
    }

    public static <T> T searchMap(Map<Class, T> map, Class type) {
        T result = null;
        block0: while (type != null) {
            if (map.containsKey(type)) {
                result = map.get(type);
                break;
            }
            if (type == Object.class) break;
            Class<?>[] interfaces = type.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (map.containsKey(interfaces[i])) {
                    result = map.get(interfaces[i]);
                    break block0;
                }
                ++i;
            }
            Class old = type;
            if ((type = type.getSuperclass()) != null || type == Object.class) continue;
            type = Object.class;
        }
        return result;
    }

    private List<Differ> getDiffers(Class type) {
        return DiffEngine.searchMap(this.m_registeredDiffers, type);
    }

    private Differ getListDiffer(Class type) {
        return DiffEngine.searchMap(this.m_registeredListDiffers, this.toNonArrayClass(type));
    }

    private Class toNonArrayClass(Class type) {
        if (type != null && type.isArray()) {
            type = type.getComponentType();
        }
        return type;
    }

    public Comparator getComparator(Class type) {
        return DiffEngine.searchMap(this.m_registeredComparators, type);
    }

    public synchronized void checkProgress() {
        if (this.m_cancelled) {
            throw new DiffEngineCancelledException();
        }
    }

    public synchronized void cancelDiff() {
        this.m_cancelled = true;
    }

    public DiffEngine copy() {
        DiffEngine copy = new DiffEngine(this.m_allowMultipleDiffers);
        ModelUtil.deepCopy(this.m_registeredDiffers, copy.m_registeredDiffers);
        ModelUtil.deepCopy(this.m_registeredListDiffers, copy.m_registeredListDiffers);
        ModelUtil.deepCopy(this.m_registeredComparators, copy.m_registeredComparators);
        return copy;
    }
}

