/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TokenGenerator {
    private TokenProcessor m_processor;

    public abstract void generateToken(TokenContext var1);

    public abstract Object evaluateToken(TokenContext var1);

    public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
        return Collections.emptyList();
    }

    protected final TokenProcessor getProcessor() {
        return this.m_processor;
    }

    void setProcessor(TokenProcessor processor) {
        this.m_processor = processor;
    }

    public static final class ReplaceGenerator
    extends TokenGenerator {
        public static final String TOKEN = "replace";

        public void generateToken(TokenContext context) {
            if (context.getOptions().isReplace()) {
                context.append("OR REPLACE");
            }
        }

        public Object evaluateToken(TokenContext context) {
            return context.getOptions().isReplace();
        }
    }

    public static final class CascadeGenerator
    extends TokenGenerator {
        public static final String TOKEN = "cascade";

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            return context.getOptions().isCascade();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NameGenerator
    extends TokenGenerator {
        public static final String TOKEN = "schema.name";

        @Override
        public void generateToken(TokenContext context) {
            context.append(context.getObject());
        }

        @Override
        public Object evaluateToken(TokenContext context) {
            return null;
        }

        @Override
        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("name", "schema");
        }
    }
}

