/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ddl.AlterDDLGenerator;
import oracle.javatools.db.ddl.CreateDDLGenerator;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGeneratorImpl;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.DropDDLGenerator;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.ddl.TokenProcessor;
import oracle.javatools.db.ddl.UndeleteDDLGenerator;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenDDLGenerator<T extends DDLType>
extends DDLGeneratorImpl<T> {
    private TokenProcessor m_processor;

    private void $init$() {
        this.m_processor = new TokenProcessor();
    }

    public TokenDDLGenerator(DBObjectProvider pro) {
        super(pro);
        this.$init$();
    }

    public void registerTokenGenerator(String tokenName, TokenGenerator gen) {
        this.m_processor.registerGenerator(tokenName, gen);
    }

    public final void registerCreateDDL(String type, String code, DDLType ddlType) {
        this.registerCreateGenerator(type, new 1(this, code, ddlType, type));
    }

    public final void registerDropDDL(String type, String code, DDLType ddlType) {
        this.registerDropGenerator(type, new 2(this, code, ddlType));
    }

    public final void registerUndeleteDDL(String type, String code, DDLType ddlType) {
        this.registerUndeleteGenerator(type, new 3(this, code, ddlType));
    }

    public final void registerAlterDDL(String type, String code, DDLType ddlType) {
        this.registerAlterGenerator(type, new 4(this, code, ddlType, type));
    }

    protected DDL createDDL(DDLOptions options, String code, DBObject obj, DDLType ddlType) {
        TokenContext context = new TokenContext(this.getProvider(), options, obj);
        return this.doCreateDDL(options, code, context, ddlType);
    }

    protected DDL createUpdateDDL(DDLOptions options, String code, ResultSet rs, DDLType ddlType) {
        TokenContext context = new TokenContext(this.getProvider(), options, rs);
        return this.doCreateDDL(options, code, context, ddlType);
    }

    private DDL doCreateDDL(DDLOptions options, String code, TokenContext context, DDLType ddlType) {
        this.m_processor.process(code, context);
        DDL<DDLType> ddl = null;
        for (String ddlString : context.getStatements()) {
            if (!ModelUtil.hasLength((String)ddlString)) continue;
            if (ddl == null) {
                ddl = new DDL<DDLType>((DBObject)context.getObject());
            }
            ddl.append(ddlType, ddlString);
        }
        return ddl;
    }

    static TokenProcessor ra$m_processor(TokenDDLGenerator tokenDDLGenerator) {
        return tokenDDLGenerator.m_processor;
    }

    static DBObjectProvider mav$getProvider(TokenDDLGenerator tokenDDLGenerator) {
        return tokenDDLGenerator.getProvider();
    }

    final class 1
    implements CreateDDLGenerator {
        private Collection<String> m_allProps;
        private final /* synthetic */ String v$code;
        private final /* synthetic */ DDLType v$ddlType;
        private final /* synthetic */ String v$type;
        final /* synthetic */ TokenDDLGenerator this$0;

        public DDL getCreateDDL(DDLOptions options, DBObject obj) {
            return this.this$0.createDDL(options, this.v$code, obj, this.v$ddlType);
        }

        public boolean canCreate(String propPath) {
            if (this.m_allProps == null) {
                this.m_allProps = TokenDDLGenerator.ra$m_processor(this.this$0).getCreatePropertyPaths(this.v$code, this.v$type, TokenDDLGenerator.mav$getProvider(this.this$0));
            }
            return this.m_allProps.contains(propPath);
        }

        public boolean canReplace() {
            boolean retval = this.v$code.contains("{replace}");
            return retval;
        }

        public 1(TokenDDLGenerator tokenDDLGenerator, String string, DDLType dDLType, String string2) {
            this.v$type = string2;
            this.v$ddlType = dDLType;
            this.v$code = string;
            this.this$0 = tokenDDLGenerator;
        }
    }

    final class 2
    implements DropDDLGenerator {
        private final /* synthetic */ String v$code;
        private final /* synthetic */ DDLType v$ddlType;
        final /* synthetic */ TokenDDLGenerator this$0;

        public DDL getDropDDL(DDLOptions options, DBObject obj) {
            return this.this$0.createDDL(options, this.v$code, obj, this.v$ddlType);
        }

        public 2(TokenDDLGenerator tokenDDLGenerator, String string, DDLType dDLType) {
            this.v$ddlType = dDLType;
            this.v$code = string;
            this.this$0 = tokenDDLGenerator;
        }
    }

    final class 3
    implements UndeleteDDLGenerator {
        private final /* synthetic */ String v$code;
        private final /* synthetic */ DDLType v$ddlType;
        final /* synthetic */ TokenDDLGenerator this$0;

        public DDL getUndeleteDDL(DDLOptions options, DBObject obj) {
            return this.this$0.createDDL(options, this.v$code, obj, this.v$ddlType);
        }

        public 3(TokenDDLGenerator tokenDDLGenerator, String string, DDLType dDLType) {
            this.v$ddlType = dDLType;
            this.v$code = string;
            this.this$0 = tokenDDLGenerator;
        }
    }

    final class 4
    implements AlterDDLGenerator {
        private Collection<String> m_allProps;
        private final /* synthetic */ String v$code;
        private final /* synthetic */ DDLType v$ddlType;
        private final /* synthetic */ String v$type;
        final /* synthetic */ TokenDDLGenerator this$0;

        public DDL getAlterDDL(DDLOptions options, ResultSet rs) {
            return this.this$0.createUpdateDDL(options, this.v$code, rs, this.v$ddlType);
        }

        public boolean canAlter(String prop) {
            if (this.m_allProps == null) {
                this.m_allProps = TokenDDLGenerator.ra$m_processor(this.this$0).getAlterPropertyPaths(this.v$code, this.v$type, TokenDDLGenerator.mav$getProvider(this.this$0));
            }
            return this.m_allProps.contains(prop);
        }

        public 4(TokenDDLGenerator tokenDDLGenerator, String string, DDLType dDLType, String string2) {
            this.v$type = string2;
            this.v$ddlType = dDLType;
            this.v$code = string;
            this.this$0 = tokenDDLGenerator;
        }
    }
}

