/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.TokenProcessor;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TokenContext {
    private StringBuilder m_buff;
    private List<String> m_stmts;
    private DBObjectProvider m_provider;
    private DDLOptions m_options;
    private TokenProcessor m_processor;
    private Object m_obj;
    private ResultSet m_resultSet;
    private Object m_loop;
    private boolean m_statementLoop;

    private void $init$() {
        this.m_buff = new StringBuilder();
        this.m_stmts = new ArrayList<String>();
    }

    TokenContext(DBObjectProvider pro, DDLOptions options, Object obj) {
        this.$init$();
        this.m_provider = pro;
        DDLOptions dDLOptions = this.m_options = options == null ? new DDLOptions() : options;
        if (obj instanceof ResultSet) {
            this.m_resultSet = (ResultSet)obj;
            this.m_obj = this.m_resultSet.b();
        } else {
            this.m_obj = obj;
        }
    }

    public DBObjectProvider getProvider() {
        return this.m_provider;
    }

    public Object getObject() {
        return this.m_obj;
    }

    public ResultSet getResultSet() {
        return this.m_resultSet;
    }

    public boolean isUpdate() {
        return this.m_resultSet != null;
    }

    public DDLOptions getOptions() {
        return this.m_options;
    }

    TokenProcessor getProcessor() {
        return this.m_processor;
    }

    void setProcessor(TokenProcessor processor) {
        this.m_processor = processor;
    }

    void setLoopObject(Object loop) {
        this.m_loop = loop;
        if (this.m_buff.length() == 0) {
            this.m_statementLoop = true;
        } else if (this.m_statementLoop) {
            this.endCurrentStatement();
        }
    }

    public Object getLoopObject() {
        return this.m_loop;
    }

    public void endCurrentStatement() {
        if (this.m_buff.length() > 0) {
            String stmt = this.m_buff.toString().trim();
            if (stmt.length() > 0) {
                this.m_stmts.add(stmt);
            }
            this.m_buff = new StringBuilder();
        }
    }

    public String toString() {
        return this.m_buff.toString().trim();
    }

    public List<String> getStatements() {
        this.endCurrentStatement();
        return this.m_stmts;
    }

    public int length() {
        return this.m_buff.length();
    }

    public void removeIfEndsWith(String str) {
        int newEnd = this.m_buff.length() - str.length();
        if (newEnd >= 0 && this.m_buff.lastIndexOf(str) == newEnd) {
            this.m_buff.delete(newEnd, this.m_buff.length());
        }
    }

    boolean endsWithWhitespace() {
        char[] lastChar = new char[1];
        int length = this.m_buff.length();
        if (length > 0) {
            this.m_buff.getChars(length - 1, length, lastChar, 0);
            return Character.isWhitespace(lastChar[0]);
        }
        return false;
    }

    void appendName(String name) {
        if (this.m_provider != null) {
            name = this.m_provider.getExternalName(name);
        }
        this.appendString(name);
    }

    private void appendString(String string) {
        this.m_buff.append(string);
    }

    private void appendSchemaName(String sname) {
        if (ModelUtil.hasLength((String)sname)) {
            Object obj = this.getObject();
            Schema contextSchema = null;
            if (this.m_provider != null) {
                try {
                    contextSchema = this.m_provider.getDefaultSchema();
                }
                catch (DBException e) {
                    DBLog.getLogger().log(Level.WARNING, "Unable to determine the default schema", e);
                }
            }
            if (contextSchema == null) {
                Schema schema = contextSchema = obj instanceof DBObject ? DBUtil.getSchema((DBObject)obj) : null;
            }
            if (contextSchema == null || !sname.equals(contextSchema.getName()) || this.m_options.isPrefixSchemaName()) {
                this.appendName(sname);
                this.appendString(".");
            }
        }
    }

    public void append(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof ResultSet) {
            this.append(((ResultSet)value).b());
        } else if (value instanceof DBObject) {
            if (this.m_processor.canProcess(value)) {
                TokenContext tc = this.newChildContext((DBObject)value);
                this.m_processor.process(value, tc);
            } else if (value instanceof SQLFragment) {
                this.appendString(((SQLFragment)value).getSQLText());
            } else if (value instanceof DataTypeUsage) {
                this.appendString(DataTypeHelper.getDDL((DataTypeUsage)value));
            } else {
                Schema valueSchema;
                if (value instanceof SchemaObject && (valueSchema = ((SchemaObject)value).getSchema()) != null) {
                    this.appendSchemaName(valueSchema.getName());
                }
                this.appendName(((DBObject)value).getName());
            }
        } else if (value instanceof DBObjectID) {
            boolean resolved = false;
            try {
                DBObject obj = ((DBObjectID)value).resolveID();
                if (obj != null) {
                    resolved = true;
                    this.append(obj);
                }
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, "couldn't resolve id for ddl gen", dbe);
            }
            if (!resolved && value instanceof BaseObjectID) {
                this.appendSchemaName(((BaseObjectID)value).getSchemaName());
                this.appendName(((BaseObjectID)value).getName());
            }
        } else if (value instanceof Object[]) {
            Object[] arr = (Object[])value;
            int i = 0;
            while (i < arr.length) {
                if (i > 0) {
                    this.appendString(", ");
                }
                this.append(arr[i]);
                ++i;
            }
        } else {
            this.appendString(value.toString());
        }
    }

    public TokenContext newChildContext(Object newObj) {
        TokenContext child = new TokenContext(this.m_provider, this.m_options, newObj == null ? this.m_obj : newObj);
        child.m_buff = this.m_buff;
        child.m_processor = this.m_processor;
        child.m_loop = this.m_loop;
        return child;
    }
}

