/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GeneratorCache {
    private Map<Class, Subcache> m_cache;

    private void $init$() {
        this.m_cache = new HashMap<Class, Subcache>();
    }

    GeneratorCache() {
        this.$init$();
    }

    synchronized <T> void registerGenerator(Class<T> clz, String type, T g) {
        Subcache sc = this.m_cache.get(clz);
        if (sc == null) {
            sc = new Subcache(null);
            this.m_cache.put(clz, sc);
        }
        Subcache.mav$registerGenerator(sc, type, g);
    }

    synchronized <T> boolean unregisterGenerator(Class<T> clz, String type, T g) {
        Subcache sc = this.m_cache.get(clz);
        if (sc != null) {
            return Subcache.mav$unregisterGenerator(sc, type, g);
        }
        return false;
    }

    <T> List<T> getGenerators(Class<T> clz, String type) {
        Subcache sc = this.m_cache.get(clz);
        if (sc != null) {
            return Subcache.mav$getGenerators(sc, type);
        }
        return Collections.emptyList();
    }

    boolean containsType(Class clz, String type) {
        Subcache sc = this.m_cache.get(clz);
        if (sc != null) {
            return Subcache.mav$containsType(sc, type);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Subcache<G> {
        private Map<String, List<G>> m_subcache;

        private void $init$() {
            this.m_subcache = new HashMap<String, List<G>>();
        }

        private void registerGenerator(String type, G g) {
            List<G> list = this.m_subcache.get(type);
            if (list == null) {
                list = new ArrayList<G>();
                this.m_subcache.put(type, list);
            }
            list.add(0, g);
        }

        private boolean unregisterGenerator(String type, G g) {
            List<G> list = this.m_subcache.get(type);
            if (list != null) {
                return list.remove(g);
            }
            return false;
        }

        private List<G> getGenerators(String type) {
            List<G> retval = this.m_subcache.get(type);
            if (retval != null) {
                return retval;
            }
            return Collections.emptyList();
        }

        private boolean containsType(String type) {
            return this.m_subcache.containsKey(type);
        }

        private Subcache() {
            this.$init$();
        }

        static boolean mav$containsType(Subcache subcache, String string) {
            return subcache.containsType(string);
        }

        static List mav$getGenerators(Subcache subcache, String string) {
            return subcache.getGenerators(string);
        }

        static boolean mav$unregisterGenerator(Subcache subcache, String string, Object object) {
            return subcache.unregisterGenerator(string, object);
        }

        Subcache(1 var2_2) {
            this();
        }

        static void mav$registerGenerator(Subcache subcache, String string, Object object) {
            subcache.registerGenerator(string, object);
        }

        public final class 1 {
        }
    }
}

