/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Database;
import oracle.javatools.db.StatementWrapper;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DDLStatementWrapper
extends StatementWrapper {
    private DDL m_ddl;

    public DDLStatementWrapper(Database db, DDL<? extends DDLType> ddl) {
        super(db, (String[])null);
        Collection<String> ddls = ddl.getStatements();
        this.setStatement(ddls.toArray(new String[ddl.size()]));
        this.m_ddl = ddl;
    }

    @Override
    public boolean execute() throws DBException {
        if (this.m_ddl == null || this.m_ddl.size() == 0) {
            return false;
        }
        return (Boolean)this.doExecute(new 1(this));
    }

    static Connection mav$getConnection(DDLStatementWrapper dDLStatementWrapper) {
        return dDLStatementWrapper.getConnection();
    }

    static void mav$setExecuting(DDLStatementWrapper dDLStatementWrapper, boolean bl) {
        dDLStatementWrapper.setExecuting(bl);
    }

    static DDL ra$m_ddl(DDLStatementWrapper dDLStatementWrapper) {
        return dDLStatementWrapper.m_ddl;
    }

    static boolean mav$executeImpl(DDLStatementWrapper dDLStatementWrapper, String string) {
        return dDLStatementWrapper.executeImpl(string);
    }

    static boolean mav$isIgnoreErrors(DDLStatementWrapper dDLStatementWrapper) {
        return dDLStatementWrapper.isIgnoreErrors();
    }

    static void mav$throwDBException(DDLStatementWrapper dDLStatementWrapper, DBObject dBObject, String string, SQLException sQLException) {
        dDLStatementWrapper.throwDBException(dBObject, string, sQLException);
    }

    final class 1
    extends StatementWrapper.ExecutionRunnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean runImpl() throws DBException {
            boolean retval = false;
            Connection connection = DDLStatementWrapper.mav$getConnection(DDLStatementWrapper.this);
            synchronized (connection) {
                DDLStatementWrapper.mav$setExecuting(DDLStatementWrapper.this, true);
                try {
                    retval = true;
                    Map stmts = DDLStatementWrapper.ra$m_ddl(DDLStatementWrapper.this).getStatementsForExecution();
                    for (Collection<DDL.StatementWithObject> swos : stmts.values()) {
                        if (swos == null) continue;
                        for (DDL.StatementWithObject swo : swos) {
                            String s = swo.getStatement();
                            if (!ModelUtil.hasLength((String)s)) continue;
                            try {
                                retval = DDLStatementWrapper.mav$executeImpl(DDLStatementWrapper.this, s) || retval;
                            }
                            catch (SQLException sqe) {
                                if (DDLStatementWrapper.mav$isIgnoreErrors(DDLStatementWrapper.this)) continue;
                                DDLStatementWrapper.mav$throwDBException(DDLStatementWrapper.this, swo.getObject(), s, sqe);
                            }
                        }
                    }
                }
                finally {
                    DDLStatementWrapper.this.close();
                    DDLStatementWrapper.mav$setExecuting(DDLStatementWrapper.this, false);
                }
            }
            return retval;
        }

        public 1(StatementWrapper statementWrapper) {
        }
    }
}

