/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectExpander;
import oracle.javatools.db.StatementWrapper;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.ddl.AbstractDDLGenerator;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLStatementWrapper;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DDLDatabase
extends AbstractDatabase {
    private oracle.javatools.db.ddl.DDLGenerator m_generator;
    private DDLGenerator m_oldGenerator;
    private Map<String, Schema> m_schemas;
    private Map<String, Schema> m_pinnedSchemas;
    private boolean m_schemasLoaded;

    private void $init$() {
        this.m_schemas = new TreeMap<String, Schema>();
        this.m_pinnedSchemas = new TreeMap<String, Schema>();
    }

    protected DDLDatabase(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
        this.$init$();
        this.reconnected(conn);
    }

    @Override
    @Deprecated
    protected final void setDDLGenerator(DDLGenerator gen) {
        this.m_oldGenerator = gen;
        if (this.m_generator != null) {
            this.m_generator = null;
        }
    }

    @Override
    public PropertyManager getPropertyManager() {
        return this.getDDLGenerator2();
    }

    @Override
    public DDLGenerator getDDLGenerator() {
        return (DDLGenerator)((Object)this.getDDLGenerator2());
    }

    public final oracle.javatools.db.ddl.DDLGenerator getDDLGenerator2() {
        if (this.m_generator == null) {
            DatabaseDescriptor dd = this.getDescriptor();
            this.m_generator = dd.getDDLGenerator(this);
        }
        if (this.m_generator instanceof AbstractDDLGenerator && this.m_oldGenerator != null) {
            ((AbstractDDLGenerator)this.m_generator).setOldGenerator((oracle.javatools.db.AbstractDDLGenerator)this.m_oldGenerator);
        }
        return this.m_generator;
    }

    @Override
    public DiffEngine getDiffEngine() {
        return GenericDiffEngine.getDiffEngine(true);
    }

    protected final boolean executeDDL(DDL ddl, boolean ignoreErrors) throws DBException {
        if (ddl.size() >= 1) {
            DDLStatementWrapper wrap = new DDLStatementWrapper((Database)this, ddl);
            wrap.setIgnoreErrors(ignoreErrors);
            return ((StatementWrapper)wrap).execute();
        }
        return false;
    }

    protected void throwUnsupportedOperation(String msg, SchemaObject ... objs) throws DBException {
        throw new DBException(objs != null && objs.length > 0 ? objs[0] : null, (Throwable)new UnsupportedOperationException(msg));
    }

    @Override
    public final boolean canCreate(SchemaObject object, boolean replace) {
        oracle.javatools.db.ddl.DDLGenerator gen = this.getDDLGenerator2();
        if (gen != null) {
            String type;
            boolean exists = this.exists(object);
            if ((replace || !exists) && this.m_generator.supportsAction(type = object.getType(), exists ? PropertyAction.REPLACE : PropertyAction.CREATE)) {
                return this.hasPriviledge(type, object.getSchema(), "CREATE");
            }
        }
        return false;
    }

    @Override
    public final boolean canCreate(Schema schema, boolean replace) {
        oracle.javatools.db.ddl.DDLGenerator gen = this.getDDLGenerator2();
        if (gen != null) {
            try {
                boolean exists;
                boolean bl = exists = this.getSchema(schema.getName()) != null;
                if ((replace || !exists) && this.m_generator.supportsAction("SCHEMA", exists ? PropertyAction.REPLACE : PropertyAction.CREATE)) {
                    boolean bl2 = this.hasPriviledge("SCHEMA", null, "CREATE");
                    return bl2;
                }
            }
            catch (DBException ex) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public final boolean canDelete(Schema schema, boolean cascade) {
        oracle.javatools.db.ddl.DDLGenerator gen = this.getDDLGenerator2();
        if (gen != null) {
            try {
                if (this.getSchema(schema.getName()) != null && gen.supportsAction("SCHEMA", PropertyAction.DELETE)) {
                    boolean bl = this.hasPriviledge("SCHEMA", schema, "DELETE");
                    return bl;
                }
            }
            catch (DBException ex) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public final boolean canDelete(SchemaObject obj, boolean cascade) {
        String type;
        oracle.javatools.db.ddl.DDLGenerator gen = this.getDDLGenerator2();
        if (gen != null && this.exists(obj) && gen.supportsAction(type = obj.getType(), PropertyAction.DELETE)) {
            return this.hasPriviledge(type, obj.getSchema(), "DELETE");
        }
        return false;
    }

    @Override
    public final void createSchema(Schema schema, boolean replace) throws DBException {
        Schema oldSchema;
        if (schema == null) {
            throw new IllegalArgumentException("null Schema in createSchema");
        }
        DDL ddl = null;
        oracle.javatools.db.ddl.DDLGenerator gen = this.getDDLGenerator2();
        if (gen != null) {
            ddl = gen.getCreateDDL(new DDLOptions(replace, false), schema);
        }
        if (ddl == null || ddl.size() == 0) {
            this.throwUnsupportedOperation("Create Schema", new SchemaObject[0]);
        }
        if (replace && (oldSchema = this.getSchema(schema.getName())) != null) {
            if (oldSchema == schema) {
                throw new IllegalArgumentException("Cannot replace schema with itself");
            }
            if (!this.canDelete(oldSchema, true)) {
                throw new DBException((DBObject)schema, "Cannot drop existing schema " + oldSchema.getName());
            }
            this.deleteSchema(oldSchema, true);
        }
        this.executeDDL(ddl, false);
        this.loadAllSchemas(true);
        String name = schema.getName();
        Schema newSchema = this.createSchema(name);
        this.cacheSchema(name, newSchema);
        this.fireSchemaAdded(newSchema);
    }

    @Override
    public final void deleteSchema(Schema schema, boolean cascade) throws DBException {
        oracle.javatools.db.ddl.DDLGenerator gen = this.getDDLGenerator2();
        DDL ddl = null;
        if (gen != null) {
            ddl = gen.getDeleteDDL(new DDLOptions(false, cascade), schema);
        }
        if (ddl == null || ddl.size() == 0) {
            this.throwUnsupportedOperation("Schema Deletion", new SchemaObject[0]);
        }
        this.executeDDL(ddl, false);
        this.loadAllSchemas(false);
        if (this.uncacheSchema(schema.getName())) {
            this.fireSchemaRemoved(schema);
        }
    }

    @Override
    public final void updateSchema(Schema oldSchema, Schema newSchema) throws DBException {
        this.throwUnsupportedOperation("Schema Update", new SchemaObject[0]);
    }

    @Override
    public final void createObject(SchemaObject object, boolean replace) throws DBException {
        this.createObjects(new SchemaObject[]{object}, replace);
    }

    @Override
    public final void createObjects(SchemaObject[] objects, boolean replace) throws DBException {
        Object[] existing = new SchemaObject[objects.length];
        DiffEngine de = this.getDiffEngine();
        ResultSet rs = de.diff(objects, existing).getResult();
        SchemaObjectExpander[] schemaObjectExpanderArray = this.getSchemaObjectExpanders();
        int n = 0;
        while (n < schemaObjectExpanderArray.length) {
            SchemaObjectExpander soe = schemaObjectExpanderArray[n];
            soe.expand(rs);
            ++n;
        }
        objects = (SchemaObject[])rs.a();
        existing = new SchemaObject[objects.length];
        oracle.javatools.db.ddl.DDLGenerator ddlgen = this.getDDLGenerator2();
        if (ddlgen == null) {
            this.throwUnsupportedOperation("CREATE not supported.", new SchemaObject[0]);
        }
        DDL ddl = new DDL();
        NameInUseException dbe = null;
        int i = 0;
        while (i < objects.length) {
            DBException newdbe = null;
            existing[i] = DBUtil.getProviderDefinition(objects[i], (DBObjectProvider)this);
            if (existing[i] == objects[i]) {
                throw new IllegalStateException("Cannot create an object that already exists in the provider");
            }
            if (existing[i] == null) {
                DDLOptions options = new DDLOptions(false, false);
                ddl.append(ddlgen.getCreateDDL(options, objects[i]));
            } else if (replace) {
                if (this.canDelete((SchemaObject)existing[i], false)) {
                    DDLOptions options = new DDLOptions(true, false);
                    ddl.append(ddlgen.getCreateDDL(options, objects[i]));
                } else {
                    newdbe = new DBException((DBObject)existing[i], DBArb.format(298, objects[i].getType(), objects[i].getName()));
                }
            } else {
                newdbe = new NameInUseException((DBObject)existing[i]);
            }
            if (newdbe != null) {
                if (dbe == null) {
                    dbe = newdbe;
                } else {
                    dbe.setNextException(newdbe);
                }
            }
            ++i;
        }
        if (dbe != null) {
            throw dbe;
        }
        try {
            this.executeDDL(ddl, false);
        }
        catch (DBException dbex) {
            this.processCreateException(dbex, null);
        }
        this.finishCreate(objects, (SchemaObject[])existing);
    }

    protected void processCreateException(DBException dbe, SchemaObject object) throws DBException {
        if (object == null) {
            DBObject dbo = dbe.getObject();
            while (dbo != null) {
                if (dbo instanceof SchemaObject) {
                    object = (SchemaObject)dbo;
                    break;
                }
                dbo = dbo.getParent();
            }
        }
        if (this.isCauseNameInUse(dbe)) {
            throw new NameInUseException(object);
        }
        if (object != null && this.exists(object)) {
            try {
                this.deleteObject(object, true);
            }
            catch (DBException dbe2) {
                DBLog.getLogger().log(Level.FINE, DBArb.getString(364), dbe2);
            }
        }
        throw dbe;
    }

    protected boolean isCauseNameInUse(DBException dbe) {
        return false;
    }

    @Override
    public final void deleteObject(SchemaObject object, boolean cascade) throws DBException {
        this.deleteObjects(new SchemaObject[]{object}, cascade);
    }

    @Override
    public void deleteObjects(SchemaObject[] objects, boolean cascade) throws DBException {
        if ((objects = DBUtil.stripNulls(DBUtil.getProviderDefinitions(objects, this))).length > 0) {
            ArrayList ddlList = new ArrayList();
            oracle.javatools.db.ddl.DDLGenerator ddlgen = this.getDDLGenerator2();
            if (ddlgen != null) {
                DDLOptions options = new DDLOptions(false, cascade);
                int i = 0;
                while (i < objects.length) {
                    ddlList.add(ddlgen.getDeleteDDL(options, objects[i]));
                    ++i;
                }
            }
            if (ddlList.size() == 0) {
                this.throwUnsupportedOperation("DELETE not supported.", new SchemaObject[0]);
            } else if (ddlList.size() != objects.length) {
                throw new IllegalStateException("Object list and DDL list don't match.");
            }
            int i = 0;
            while (i < objects.length) {
                DDL dropDDL = (DDL)ddlList.get(i);
                if (dropDDL == null) {
                    DBLog.getLogger().log(Level.WARNING, "Could not drop " + objects[i].getType() + objects[i].getName());
                } else {
                    try {
                        this.executeDDL(dropDDL, false);
                    }
                    catch (DBException dbe) {
                        this.processDeleteException(dbe, objects[i]);
                    }
                }
                ++i;
            }
            this.finishDelete(objects);
        }
    }

    protected void processDeleteException(DBException dbe, SchemaObject object) throws DBException {
        throw dbe;
    }

    @Override
    public final void undeleteObject(SchemaObject object) throws DBException {
        this.undeleteObjects(new SchemaObject[]{object});
    }

    @Override
    public final void undeleteObjects(SchemaObject[] objects) throws DBException {
        if (objects != null && objects.length > 0) {
            DDL ddl = null;
            oracle.javatools.db.ddl.DDLGenerator ddlgen = this.getDDLGenerator2();
            if (ddlgen != null) {
                DDLOptions options = new DDLOptions(false, false);
                ddl = ddlgen.getUndeleteDDL(options, objects);
            }
            if (ddl == null) {
                this.throwUnsupportedOperation("Undelete (FLASHBACK) not supported.", new SchemaObject[0]);
            }
            if (this.executeDDL(ddl, false)) {
                this.finishDelete(objects);
            }
        }
    }

    @Override
    public final void updateObject(SchemaObject oldObject, SchemaObject newObject) throws DBException {
        this.updateObjects(new SchemaObject[]{oldObject}, new SchemaObject[]{newObject});
    }

    @Override
    public final void updateObjects(SchemaObject[] oldObjects, SchemaObject[] newObjects) throws DBException {
        if (oldObjects == null || newObjects == null || oldObjects.length == 0) {
            return;
        }
        if (oldObjects.length != newObjects.length) {
            throw new IllegalArgumentException("Number of old and new objects don't match");
        }
        DiffEngine de = this.getDiffEngine();
        ResultSet rs = de.diff(oldObjects, newObjects).getResult();
        if (!rs.isSame()) {
            this.updateObjects(rs, false, false);
        }
    }

    @Override
    public final void updateObjects(ResultSet rs, boolean replace, boolean cascade) throws DBException {
        SchemaObject[] newObjects;
        SchemaObject[] oldObjects;
        DDL ddl = null;
        oracle.javatools.db.ddl.DDLGenerator ddlgen = this.getDDLGenerator2();
        if (ddlgen != null) {
            DDLOptions options = new DDLOptions(replace, cascade);
            ddl = ddlgen.getUpdateDDL(options, rs);
        }
        if (ddl == null || ddl.size() == 0) {
            this.throwUnsupportedOperation("UPDATE not supported.", new SchemaObject[0]);
        }
        if ("LIST".equals(rs.getType())) {
            List<ResultSet> l = rs.getAllObjectsList();
            oldObjects = new SchemaObject[l.size()];
            newObjects = new SchemaObject[l.size()];
            int i = 0;
            while (i < l.size()) {
                ResultSet r = l.get(i);
                oldObjects[i] = (SchemaObject)r.a();
                newObjects[i] = (SchemaObject)r.b();
                ++i;
            }
        } else if ("MAP".equals(rs.getType()) && rs.a() instanceof SchemaObject) {
            oldObjects = new SchemaObject[]{(SchemaObject)rs.a()};
            newObjects = new SchemaObject[]{(SchemaObject)rs.b()};
        } else {
            newObjects = null;
            oldObjects = null;
            this.throwUnsupportedOperation("ResultSet is not appropriate for updateObjects", new SchemaObject[0]);
        }
        if (!replace) {
            int i = 0;
            while (i < oldObjects.length) {
                if (oldObjects[i] == null && newObjects[i] != null && this.exists(newObjects[i])) {
                    new NameInUseException(newObjects[i]);
                }
                ++i;
            }
        }
        if (this.executeDDL(ddl, false)) {
            this.finishCreate(newObjects, oldObjects);
        }
    }

    @Override
    protected void registerExpanders() {
        this.registerSchemaObjectExpander(new TemplateExpander(this));
    }

    @Override
    public Schema getSchema(String name) throws DBException {
        if (name != null) {
            boolean checked = this.loadAllSchemas(false);
            Schema s = this.getCachedSchema(name);
            if (s == null && !checked) {
                this.loadAllSchemas(true);
                s = this.getCachedSchema(name);
            }
            return s;
        }
        return null;
    }

    @Override
    public final Schema[] listSchemas() throws DBException {
        this.loadAllSchemas(true);
        Collection<Schema> list = this.m_schemas.values();
        return list.toArray(new Schema[list.size()]);
    }

    @Override
    public Schema[] listSchemas(boolean restrictVisible) throws DBException {
        return this.listSchemas();
    }

    protected final synchronized boolean loadAllSchemas(boolean force) throws DBException {
        if (this.m_schemasLoaded && !force) {
            return false;
        }
        Map<String, Schema> schemas = this.loadSchemasImpl();
        this.m_schemas.clear();
        this.m_schemas.putAll(this.m_pinnedSchemas);
        this.m_schemas.putAll(schemas);
        this.m_schemasLoaded = true;
        return true;
    }

    protected abstract Map<String, Schema> loadSchemasImpl() throws DBException;

    protected final void cacheSchema(String name, Schema schema) {
        this.cacheSchema(name, schema, false);
    }

    protected final void cacheSchema(String name, Schema schema, boolean pin) {
        this.m_schemas.put(name, schema);
        if (pin) {
            this.m_pinnedSchemas.put(name, schema);
        }
    }

    protected final boolean uncacheSchema(String name) {
        if (this.m_pinnedSchemas.containsKey(name)) {
            this.m_pinnedSchemas.remove(name);
        }
        return this.m_schemas.remove(name) != null;
    }

    protected final Schema getCachedSchema(String name) {
        return this.m_schemas.get(name);
    }

    @Override
    public void close() {
        super.close();
        this.m_schemasLoaded = false;
        this.m_schemas.clear();
        this.m_pinnedSchemas.clear();
    }
}

