/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.ArrayList;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.ddl.OracleDDLType;
import oracle.javatools.db.property.AbstractPropertyManager;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractDDLGenerator<T extends DDLType>
extends AbstractPropertyManager
implements oracle.javatools.db.ddl.DDLGenerator<T>,
DDLGenerator {
    private oracle.javatools.db.AbstractDDLGenerator m_oldGenerator;

    protected AbstractDDLGenerator(DBObjectProvider pro) {
        super(pro);
    }

    @Deprecated
    public final void setOldGenerator(oracle.javatools.db.AbstractDDLGenerator oldGen) {
        this.m_oldGenerator = oldGen;
    }

    @Override
    public boolean supportsAction(String type, PropertyAction action) {
        if (this.m_oldGenerator != null) {
            if (this.m_oldGenerator instanceof PropertyManager) {
                return ((PropertyManager)this.m_oldGenerator).supportsAction(type, action);
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean canCreate(String type, String prop) {
        return this.m_oldGenerator != null;
    }

    @Override
    public final DDL<T> getCreateDDL(DDLOptions options, DBObject ... objects) {
        ArrayList<DDL<T>> ddls = new ArrayList<DDL<T>>();
        DBObject[] dBObjectArray = objects;
        int n = 0;
        while (n < dBObjectArray.length) {
            DBObject obj = dBObjectArray[n];
            try {
                DDL<T> ddl = this.getCreateDDLImpl(options, obj);
                if (ddl != null && ddl.size() > 0) {
                    ddls.add(ddl);
                }
            }
            catch (UnsupportedOperationException use) {
                if (this.m_oldGenerator != null) {
                    this.m_oldGenerator.setNewOptions(options);
                    if (obj instanceof Schema) {
                        DDL<OracleDDLType> ddl = this.m_oldGenerator.getCreateDDL((Schema)obj).convertToNew(obj);
                        ddls.add(ddl);
                    } else if (obj instanceof SchemaObject) {
                        DDL<OracleDDLType> ddl = this.m_oldGenerator.getCreateDDL((SchemaObject)obj, options.isReplace(), options.isCascade()).convertToNew(obj);
                        ddls.add(ddl);
                    }
                }
                throw use;
            }
            ++n;
        }
        if (ddls.size() > 0) {
            DDL ddl = new DDL();
            for (DDL dDL : ddls) {
                ddl.append(dDL);
            }
            return ddl;
        }
        return null;
    }

    protected abstract DDL<T> getCreateDDLImpl(DDLOptions var1, DBObject ... var2);

    @Override
    public final DDL<T> getDeleteDDL(DDLOptions options, DBObject ... objects) {
        ArrayList<DDL<T>> ddls = new ArrayList<DDL<T>>();
        DBObject[] dBObjectArray = objects;
        int n = 0;
        while (n < dBObjectArray.length) {
            DBObject obj = dBObjectArray[n];
            try {
                DDL<T> ddl = this.getDeleteDDLImpl(options, obj);
                if (ddl != null && ddl.size() > 0) {
                    ddls.add(ddl);
                }
            }
            catch (UnsupportedOperationException use) {
                if (this.m_oldGenerator != null) {
                    this.m_oldGenerator.setNewOptions(options);
                    if (obj instanceof Schema) {
                        DDL<OracleDDLType> ddl = this.m_oldGenerator.getDeleteDDL((Schema)obj, options.isCascade()).convertToNew(obj);
                        ddls.add(ddl);
                    } else if (obj instanceof SchemaObject) {
                        DDL<OracleDDLType> ddl = this.m_oldGenerator.getDeleteDDL((SchemaObject)obj, options.isCascade()).convertToNew(obj);
                        ddls.add(ddl);
                    }
                }
                throw use;
            }
            ++n;
        }
        if (ddls.size() > 0) {
            DDL ddl = new DDL();
            for (DDL dDL : ddls) {
                ddl.append(dDL);
            }
            return ddl;
        }
        return null;
    }

    protected abstract DDL<T> getDeleteDDLImpl(DDLOptions var1, DBObject ... var2);

    @Override
    public final DDL<T> getUpdateDDL(DDLOptions options, ResultSet resultSet) {
        DDL ddl = new DDL();
        if (resultSet.getType() == "MAP") {
            this.processResultSet(options, resultSet, ddl);
        } else if (resultSet.getType() == "LIST") {
            for (ResultSet objRS : resultSet.getAllObjectsList()) {
                this.processResultSet(options, objRS, ddl);
            }
        } else {
            DBLog.getLogger().warning("unexpected ResultSet type for DDL");
        }
        return ddl;
    }

    /*
     * Unable to fully structure code
     */
    protected final void processResultSet(DDLOptions options, ResultSet rs, DDL<T> ddl) {
        if (!rs.isSame()) {
            if (rs.a() == null) {
                ddl.append(this.getCreateDDL(options, new DBObject[]{(SchemaObject)rs.b()}));
            } else if (rs.b() == null) {
                ddl.append(this.getDeleteDDL(options, new DBObject[]{(SchemaObject)rs.a()}));
            } else {
                block10: {
                    updateDDL = null;
                    try {
                        updateDDL = this.getUpdateDDLImpl(options, rs);
                        break block10;
                    }
                    catch (UnsupportedOperationException uoe) {
                        if (this.m_oldGenerator == null) break block10;
                        this.m_oldGenerator.setNewOptions(options);
                        updateDDL = new DDL<T>();
                        old = this.m_oldGenerator.getUpdateDDL(rs, options.isReplace(), options.isCascade());
                        i = 0;
                        ** while (i < old.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (old[i] != null) {
                            updateDDL.append(old[i].convertToNew((DBObject)rs.a()));
                        }
                        ++i;
                        continue;
                    }
                }
                if (updateDDL == null) {
                    throw new UnsupportedOperationException("UPDATE not supported");
                }
                ddl.append(updateDDL);
            }
        }
    }

    protected abstract DDL<T> getUpdateDDLImpl(DDLOptions var1, ResultSet var2);

    @Override
    public final Ddl getCreateDDL(SchemaObject obj, boolean replace, boolean cascade) {
        return this.getCreateDDL(new DDLOptions(replace, cascade), obj).convertToLegacy();
    }

    @Override
    public final Ddl getCreateDDL(SchemaObject[] objects, boolean replace, boolean cascade) {
        return this.getCreateDDL(new DDLOptions(replace, cascade), objects).convertToLegacy();
    }

    @Override
    public final Ddl getDeleteDDL(SchemaObject object, boolean cascade) {
        return this.getDeleteDDL(new DDLOptions(true, cascade), object).convertToLegacy();
    }

    @Override
    public final Ddl getDeleteDDL(SchemaObject[] objects, boolean cascade) {
        return this.getDeleteDDL(new DDLOptions(true, cascade), objects).convertToLegacy();
    }

    @Override
    public final Ddl[] getUpdateDDL(SchemaObject oldObject, SchemaObject newObject) {
        return this.getUpdateDDL(new SchemaObject[]{oldObject}, new SchemaObject[]{newObject});
    }

    @Override
    public final Ddl[] getUpdateDDL(SchemaObject[] oldObjects, SchemaObject[] newObjects) {
        ResultSet rs = this.getProvider().getDiffEngine().diff(oldObjects, newObjects).getResult();
        return this.getUpdateDDL(rs, false, false);
    }

    @Override
    public final Ddl[] getUpdateDDL(ResultSet resultSet, boolean replace, boolean cascade) {
        return this.getUpdateDDL(new DDLOptions(replace, cascade), resultSet).convertToLegacyArray();
    }

    @Override
    public final Ddl getCreateDDL(Schema schema) {
        return this.getCreateDDL(new DDLOptions(), schema).convertToLegacy();
    }

    @Override
    public final Ddl getDeleteDDL(Schema schema, boolean cascade) {
        return this.getDeleteDDL(new DDLOptions(false, cascade), schema).convertToLegacy();
    }
}

