/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.PredefinedDataTypeUsage;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredefinedDataType
extends AbstractDBObject
implements DataType {
    private int m_domain;
    private String m_definition;
    private String[] m_tokenizedDefinition;
    private int w_index;
    private int w_valueIndex;
    private String w_dataType;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PredefinedDataType() {
    }

    public PredefinedDataType(int domain, String name) {
        super(name);
        this.m_domain = domain;
        this.m_definition = name;
    }

    public PredefinedDataType(int domain, String name, String definition, DataTypeAttribute[] attributes) {
        super(name);
        this.m_domain = domain;
        this.m_definition = definition;
        if (attributes != null) {
            int i = 0;
            while (i < attributes.length) {
                this.addAttribute(attributes[i]);
                ++i;
            }
        }
    }

    public PredefinedDataType(int domain, String name, String definition, long minSize, long maxSize, long defaultSize, boolean isSizeMandatory, DataTypeAttribute[] attributes) {
        super(name);
        this.m_domain = domain;
        this.m_definition = definition;
        this.addAttribute(new DataTypeAttribute("size", 312, minSize, new Long(maxSize), new Long(defaultSize), isSizeMandatory));
        if (attributes != null) {
            int i = 0;
            while (i < attributes.length) {
                this.addAttribute(attributes[i]);
                ++i;
            }
        }
    }

    public final void addAttribute(DataTypeAttribute attribute) {
        this.getChildSupport().addChild(attribute);
    }

    public final void addAttribute(DataTypeAttribute attribute, int atIndex) {
        this.getChildSupport().addChild(atIndex, attribute);
    }

    public final void removeAttribute(DataTypeAttribute attribute) {
        this.getChildSupport().removeChild(attribute);
    }

    @Override
    public DataTypeUsage createDefaultUsage() {
        PredefinedDataTypeUsage usage = new PredefinedDataTypeUsage(this);
        HashMap<String, Object> attributeValues = new HashMap<String, Object>();
        DataTypeAttribute[] dataTypeAttributeArray = this.getDataTypeAttributes();
        int n = 0;
        while (n < dataTypeAttributeArray.length) {
            DataTypeAttribute attribute = dataTypeAttributeArray[n];
            if (attribute.isMandatory()) {
                attributeValues.put(attribute.getName(), attribute.getDefaultValue());
            }
            ++n;
        }
        if (attributeValues.size() > 0) {
            usage.setAttributeValues(attributeValues);
        }
        return usage;
    }

    static {
        $assertionsDisabled = PredefinedDataType.class.desiredAssertionStatus() ^ true;
    }

    @Override
    public DataTypeUsage createUsage(Map<String, Object> attributeValues) {
        if (!$assertionsDisabled && attributeValues == null) {
            throw new AssertionError();
        }
        PredefinedDataTypeUsage usage = new PredefinedDataTypeUsage(this);
        HashMap<String, Object> declarableAttributeValues = new HashMap<String, Object>();
        for (String name : attributeValues.keySet()) {
            DataTypeAttribute attribute = this.getDataTypeAttribute(name);
            if (attribute == null || !attribute.isDeclarable() || attributeValues.get(name) == null) continue;
            declarableAttributeValues.put(name, attributeValues.get(name));
        }
        String nameAttr = (String)attributeValues.get("name");
        if (nameAttr != null) {
            this.addAttributeValues(declarableAttributeValues, nameAttr);
        }
        usage.setAttributeValues(declarableAttributeValues);
        return usage;
    }

    @Override
    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dbObject) throws DataTypeValidationException {
        Map<String, Object> attributeValues = dataTypeUsage.getAttributeValues();
        DataTypeAttribute[] dataTypeAttributeArray = this.getDataTypeAttributes();
        int n = 0;
        while (n < dataTypeAttributeArray.length) {
            DataTypeAttribute attribute = dataTypeAttributeArray[n];
            Object attributeValue = attributeValues.get(attribute.getName());
            if (attribute.isMandatory() && (attributeValue == null || "".equals(attributeValue))) {
                throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format(211, DataTypeHelper.getNameFromLabel(attribute.getLabel())));
            }
            if (attribute.isDeclarable()) {
                if (attribute.getValueType() == 0) {
                    String usageValue = DataTypeHelper.toString(attributeValue);
                    String[] allowableValues = attribute.getValues();
                    if (usageValue != null && allowableValues != null && !attribute.isExtensible()) {
                        boolean isValidValue = false;
                        int j = 0;
                        while (j < allowableValues.length) {
                            if (allowableValues[j].compareToIgnoreCase(usageValue) == 0) {
                                isValidValue = true;
                                break;
                            }
                            ++j;
                        }
                        if (!isValidValue) {
                            throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format(54, usageValue, DataTypeHelper.getNameFromLabel(attribute.getLabel())));
                        }
                    }
                } else {
                    Long usageValue = DataTypeHelper.toLong(attributeValue);
                    Long minValue = attribute.getMinValue();
                    Long maxValue = attribute.getMaxValue();
                    if (usageValue != null) {
                        if (usageValue.compareTo(minValue) < 0) {
                            throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format(330, DataTypeHelper.getNameFromLabel(attribute.getLabel()), minValue));
                        }
                        if (maxValue != null && usageValue.compareTo(maxValue) > 0) {
                            throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format(329, DataTypeHelper.getNameFromLabel(attribute.getLabel()), maxValue));
                        }
                    }
                }
            }
            ++n;
        }
    }

    @Override
    public void validateDefaultValue(Object defaultValue, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
        String strDefaultValue;
        if (dataTypeUsage != null && defaultValue instanceof String && ModelUtil.hasLength((String)(strDefaultValue = defaultValue.toString().trim()))) {
            try {
                Collection<String[]> colrefs = ParserUtils.getColumnNames(strDefaultValue, ParserUtils.ExpressionType.ARITHMETIC);
                if (colrefs.size() > 0) {
                    String colNames = null;
                    for (String[] nameComponents : colrefs) {
                        String name = null;
                        String[] stringArray = nameComponents;
                        int n = 0;
                        while (n < stringArray.length) {
                            String component = stringArray[n];
                            name = name == null ? component : name + '.' + component;
                            ++n;
                        }
                        colNames = colNames == null ? name : colNames + ", " + name;
                    }
                    throw new DefaultValueValidationException(dbObject, this.getName(), DBArb.format(266, colNames));
                }
            }
            catch (SQLQueryException x) {
                // empty catch block
            }
        }
    }

    @Override
    public String getDDL(DataTypeUsage dataTypeUsage) {
        Map<String, Object> attributeValues = dataTypeUsage.getAttributeValues();
        String ddl = "";
        this.w_index = 0;
        while (this.w_index < this.m_definition.length()) {
            ddl = ddl + this.getDDL(attributeValues, false);
            ++this.w_index;
        }
        return ddl;
    }

    @Override
    public final boolean hasDataTypeAttribute(String name) {
        return this.getDataTypeAttribute(name) != null;
    }

    @Override
    public final DataTypeAttribute getDataTypeAttribute(String name) {
        return this.getChildSupport().findChild(DataTypeAttribute.class, name);
    }

    @Override
    public final DataTypeAttribute[] getDataTypeAttributes() {
        return (DataTypeAttribute[])this.getChildSupport().getChildArray(DataTypeAttribute.class);
    }

    @Override
    public final DBObject getParent() {
        return null;
    }

    @Override
    public final String getType() {
        return "DATATYPE";
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        PredefinedDataType copy = target != null ? (PredefinedDataType)target : new PredefinedDataType();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(PredefinedDataType target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_definition = this.m_definition;
        target.m_domain = this.m_domain;
    }

    public boolean equals(Object obj) {
        return obj instanceof PredefinedDataType && this.equalsImpl((PredefinedDataType)obj);
    }

    protected boolean equalsImpl(PredefinedDataType other) {
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)this.m_definition, (Object)other.m_definition) && this.m_domain == other.m_domain;
    }

    private String getDDL(Map attributeValues, boolean optional) {
        String ddl = "";
        while (this.w_index < this.m_definition.length() && this.m_definition.charAt(this.w_index) != ']') {
            char c = this.m_definition.charAt(this.w_index);
            if (c == '[') {
                ddl = ddl + this.getOptionalDDL(attributeValues);
            } else if (c == '<') {
                String attributeName = "";
                while (++this.w_index < this.m_definition.length() && this.m_definition.charAt(this.w_index) != '>') {
                    attributeName = attributeName + this.m_definition.charAt(this.w_index);
                }
                Object attributeValue = attributeValues.get(attributeName);
                if (optional && attributeValue == null) {
                    return "";
                }
                if (attributeValue != null) {
                    ddl = ddl + attributeValue.toString();
                }
            } else {
                ddl = ddl + c;
            }
            ++this.w_index;
        }
        return ddl;
    }

    private String getOptionalDDL(Map attributeValues) {
        ++this.w_index;
        String ddl = this.getDDL(attributeValues, true);
        if (ddl.length() == 0) {
            while (this.w_index < this.m_definition.length() && this.m_definition.charAt(this.w_index) != ']') {
                if (this.m_definition.charAt(this.w_index) == '[') {
                    this.getOptionalDDL(attributeValues);
                }
                ++this.w_index;
            }
        }
        return ddl;
    }

    public void validateDefinition() throws DataTypeValidationException {
        int index = 0;
        while (index < this.m_definition.length()) {
            char c = this.m_definition.charAt(index);
            if (c == '[') {
                index = this.findChar(']', index + 1);
            } else if (c == '<') {
                index = this.validateAttributeName(index);
            }
            ++index;
        }
    }

    private int findChar(char target, int index) throws DataTypeValidationException {
        while (index < this.m_definition.length()) {
            char c = this.m_definition.charAt(index);
            if (target == '>' && c == '<') {
                throw new DataTypeValidationException(null, this.m_definition, "Invalid nested attributes");
            }
            if (c == '[') {
                index = this.findChar(']', index + 1);
            } else if (c == '<') {
                index = this.validateAttributeName(index);
            } else if (c == target) {
                return index;
            }
            ++index;
        }
        throw new DataTypeValidationException(null, this.m_definition, "Matching " + target + " not found");
    }

    private int validateAttributeName(int index) throws DataTypeValidationException {
        int startOfAttributeName = index + 1;
        String attributeName = this.m_definition.substring(startOfAttributeName, index = this.findChar('>', startOfAttributeName));
        if (this.getDataTypeAttribute(attributeName) == null) {
            throw new DataTypeValidationException(null, this.m_definition, "Attribute <" + attributeName + "> not defined for data type" + this.m_definition);
        }
        return index;
    }

    private void addAttributeValues(Map attributeValues, String dataType) {
        if (this.m_tokenizedDefinition == null) {
            this.m_tokenizedDefinition = PredefinedDataType.tokenize(this.m_definition, "[]( ),");
        }
        this.w_dataType = dataType;
        String[] tokenizedDataType = PredefinedDataType.tokenize(dataType, "( ),");
        this.w_index = 0;
        this.w_valueIndex = 0;
        while (this.w_index < this.m_tokenizedDefinition.length && this.w_valueIndex < tokenizedDataType.length) {
            this.addAttributeValues(attributeValues, tokenizedDataType, false);
            ++this.w_index;
        }
    }

    private void addOptionalAttributeValue(Map attributeValues, String[] dataType) {
        ++this.w_index;
        if (!this.addAttributeValues(attributeValues, dataType, true)) {
            int optionalClauses = 1;
            do {
                if (this.m_tokenizedDefinition[this.w_index].equals("[")) {
                    ++optionalClauses;
                    continue;
                }
                if (!this.m_tokenizedDefinition[this.w_index].equals("]")) continue;
                --optionalClauses;
            } while (optionalClauses > 0 && ++this.w_index < this.m_tokenizedDefinition.length);
        }
    }

    private boolean addAttributeValues(Map attributeValues, String[] dataType, boolean optional) {
        while (this.w_valueIndex < dataType.length && this.w_index < this.m_tokenizedDefinition.length && !this.m_tokenizedDefinition[this.w_index].equals("]")) {
            if (this.m_tokenizedDefinition[this.w_index].equals("[")) {
                this.addOptionalAttributeValue(attributeValues, dataType);
            } else if (this.m_tokenizedDefinition[this.w_index].charAt(0) == '<') {
                String attributeName = this.m_tokenizedDefinition[this.w_index].substring(1, this.m_tokenizedDefinition[this.w_index].length() - 1);
                int valueType = this.getDataTypeAttribute(attributeName).getValueType();
                if (valueType == 1) {
                    try {
                        attributeValues.put(attributeName, Long.valueOf(dataType[this.w_valueIndex]));
                    }
                    catch (NumberFormatException ex) {
                        DBLog.log("Can't match \"" + dataType[this.w_valueIndex] + "\" in \"" + this.w_dataType + "\" with definition : " + this.m_definition, new Object[0]);
                    }
                } else {
                    String value = dataType[this.w_valueIndex];
                    if (this.getDataTypeAttribute(attributeName).getValues() != null) {
                        int validValueIdx;
                        String[] validValues = this.getDataTypeAttribute(attributeName).getValues();
                        while ((validValueIdx = this.isValidValue(value, validValues)) == -1 && ++this.w_valueIndex < dataType.length) {
                            value = value + dataType[this.w_valueIndex];
                        }
                        if (this.w_valueIndex < dataType.length) {
                            attributeValues.put(attributeName, validValues[validValueIdx]);
                        } else {
                            DBLog.log("Data type \"" + this.w_dataType + "\" doesn't match its definition : " + this.m_definition, new Object[0]);
                        }
                    }
                }
                ++this.w_valueIndex;
            } else {
                if (optional) {
                    if (this.m_tokenizedDefinition[this.w_index].compareToIgnoreCase(dataType[this.w_valueIndex]) != 0) {
                        return false;
                    }
                } else if (!$assertionsDisabled && this.m_tokenizedDefinition[this.w_index].compareToIgnoreCase(dataType[this.w_valueIndex]) != 0) {
                    throw new AssertionError((Object)("Data type \"" + this.w_dataType + "\" doesn't match its definition : " + this.m_definition));
                }
                ++this.w_valueIndex;
            }
            ++this.w_index;
        }
        return true;
    }

    private int isValidValue(String targetValue, String[] values) {
        int i = 0;
        while (i < values.length) {
            if (values[i].replaceAll("\\s", "").compareToIgnoreCase(targetValue) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected static String[] tokenize(String string, String delimiters) {
        StringTokenizer tok = new StringTokenizer(string.replaceAll("\\s", " "), delimiters, true);
        ArrayList<String> tokens = new ArrayList<String>();
        int tokenCount = 0;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.charAt(0) == ' ') continue;
            tokens.add(token);
            ++tokenCount;
        }
        return tokens.toArray(new String[tokenCount]);
    }

    protected static PlsqlNode parseDefaultValue(String strDefaultValue, DataType dataType, DBObject dbObject) throws DefaultValueValidationException {
        PlsqlNode node = null;
        try {
            PlsqlRoot parseTree = ParserUtils.parseQueryString(strDefaultValue, 2);
            ParserUtils.checkErrors(parseTree, strDefaultValue);
            if (parseTree.getUnits().length != 1) {
                DBLog.log("Expecting 1 parse unit but got " + parseTree.getUnits().length, new Object[0]);
                PlsqlNode plsqlNode = null;
                return plsqlNode;
            }
            node = parseTree.getUnits()[0];
        }
        catch (SQLQueryException x) {
            if (node != null && ParserUtils.isConstant(node)) {
                throw new DefaultValueValidationException(dbObject, dataType.getName(), DBArb.getString(91));
            }
            throw new DefaultValueValidationException(dbObject, dataType.getName(), DBArb.format(114, x.getMessage()));
        }
        return node;
    }
}

