/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.text.SimpleDateFormat;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.BaseDateTimeDataType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DefaultValueValidationException;

public class DateDataType
extends BaseDateTimeDataType {
    private static final String DATE_FORMAT = "ddMMMyy";
    private static final String ORACLE_FORMAT = "DD-MON-RR";
    private static SimpleDateFormat s_date;

    public DateDataType() {
    }

    public DateDataType(int domain, String name) {
        super(domain, name);
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        DateDataType copy = target != null ? (DateDataType)target : new DateDataType();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(DateDataType target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
    }

    public boolean equals(Object obj) {
        return obj instanceof DateDataType && this.equalsImpl((DateDataType)obj);
    }

    protected boolean equalsImpl(DateDataType other) {
        return super.equalsImpl(other);
    }

    public void validateDefaultValue(Object defaultValue, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
        String err;
        super.validateDefaultValue(defaultValue, dataTypeUsage, dbObject);
        if (s_date == null) {
            s_date = new SimpleDateFormat(DATE_FORMAT);
        }
        if ((err = this.validateDateTime(defaultValue, s_date, ORACLE_FORMAT, dbObject)) != null) {
            throw new DefaultValueValidationException(dbObject, this.getName(), err);
        }
    }
}

