/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataTypeUsage
extends AbstractChildDBObject {
    public static final String TYPE = "DataTypeUsage";
    private DBObjectID m_dataTypeID;
    private Map<String, Object> m_attributeValues;

    private void $init$() {
        this.m_attributeValues = new HashMap<String, Object>();
    }

    protected DataTypeUsage() {
        this.$init$();
    }

    protected DataTypeUsage(DataType dt) {
        this.$init$();
        if (dt != null) {
            this.m_dataTypeID = dt.getID();
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean changed = super.replaceReferenceIDs(idMap);
        if (idMap.containsKey(this.m_dataTypeID)) {
            this.m_dataTypeID = idMap.get(this.m_dataTypeID);
            changed = true;
        }
        return changed;
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        refs.add(this.m_dataTypeID);
    }

    protected boolean equalsImpl(DataTypeUsage target) {
        return super.equalsImpl(target) && ModelUtil.areEqual((Object)this.m_dataTypeID, (Object)target.m_dataTypeID) && DBUtil.areEqualIgnoreNullValues(this.m_attributeValues, target.m_attributeValues);
    }

    protected void copyToImpl(DataTypeUsage target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_attributeValues.clear();
        ModelUtil.deepCopy(this.m_attributeValues, target.m_attributeValues);
        target.m_dataTypeID = this.m_dataTypeID;
    }

    public final void setDataTypeID(DBObjectID id) {
        this.m_dataTypeID = id;
    }

    public final DBObjectID getDataTypeID() {
        return this.m_dataTypeID;
    }

    public final void setAttributeValues(Map<String, Object> attributeValues) {
        if (attributeValues == null) {
            this.m_attributeValues.clear();
        } else {
            this.m_attributeValues = attributeValues;
        }
    }

    public final Map<String, Object> getAttributeValues() {
        return this.m_attributeValues;
    }

    public final Object getAttributeValue(String name) {
        return this.m_attributeValues.get(name);
    }

    public final void putAttributeValue(String name, Object value) {
        this.m_attributeValues.put(name, value);
    }

    public final void deleteAttributeValue(String name) {
        this.m_attributeValues.remove(name);
    }

    public final boolean hasAttributeValue(String name) {
        return this.m_attributeValues.containsKey(name);
    }
}

