/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.logging.Level;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.util.ModelUtil;

public class DataTypeHelper {
    public static DataType getDataType(DataTypeUsage usage) throws DBException {
        if (usage != null) {
            DBObjectID dataTypeID = usage.getDataTypeID();
            if (dataTypeID == null) {
                throw new DBException((DBObject)usage, "Column's DataTypeUsage has no DataTypeID to resolve.");
            }
            return (DataType)dataTypeID.resolveID();
        }
        return null;
    }

    public static Long getLongAttributeValue(DataTypeUsage usage, String name) {
        return DataTypeHelper.toLong(usage.getAttributeValue(name));
    }

    public static String getStringAttributeValue(DataTypeUsage usage, String name) {
        return DataTypeHelper.toString(usage.getAttributeValue(name));
    }

    public static String getStringAttributeDefaultValue(DataTypeUsage usage, String attributeName) {
        String result = null;
        try {
            Object defaultValue;
            DataType dataType = DataTypeHelper.getDataType(usage);
            DataTypeAttribute attribute = dataType.getDataTypeAttribute(attributeName);
            if (attribute != null && (defaultValue = attribute.getDefaultValue()) != null) {
                result = defaultValue.toString();
            }
        }
        catch (DBException dbe) {
            // empty catch block
        }
        return result;
    }

    public static Long toLong(Object usageValue) {
        try {
            String convert = usageValue == null ? null : ModelUtil.nullifyIfEmpty((String)usageValue.toString());
            Long l = convert == null ? null : Long.valueOf(convert);
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Long toLongOrError(Object usageValue) throws NumberFormatException {
        String convert = usageValue == null ? null : ModelUtil.nullifyIfEmpty((String)usageValue.toString());
        return convert == null ? null : Long.valueOf(convert);
    }

    public static String toString(Object usageValue) {
        return usageValue == null ? null : usageValue.toString();
    }

    public static String getNameFromLabel(int resourceLabelID) {
        return DBArb.getString(resourceLabelID).replaceAll("&", "");
    }

    public static String getNameFromLabel(String resourceLabel) {
        return resourceLabel.replaceAll("&", "");
    }

    public static Object getAttributeValue(Object value, DataType dataType, String attributeName) {
        DataTypeAttribute attribute;
        if (value instanceof String && !ModelUtil.hasLength((String)((String)value))) {
            value = null;
        }
        if (value != null && (attribute = dataType.getDataTypeAttribute(attributeName)) != null) {
            if (attribute.getValueType() == 0) {
                return DataTypeHelper.toString(value);
            }
            return DataTypeHelper.toLong(value);
        }
        return value;
    }

    public static String getDDL(DataTypeUsage dtu) {
        if (dtu != null) {
            try {
                DataType dt = DataTypeHelper.getDataType(dtu);
                if (dt != null) {
                    String string = dt.getDDL(dtu);
                    return string;
                }
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, "couldn't resolve datatype ID for DDL", dbe);
            }
        }
        return null;
    }
}

