/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View
extends Relation
implements SQLQueryOwner {
    private SQLQuery m_query;
    private String m_restriction;
    private boolean m_force;
    public static final String TYPE = "VIEW";
    public static final String READ_ONLY = "WITH READ ONLY";
    public static final String CHECK_OPTION = "WITH CHECK OPTION";

    public View() {
    }

    public View(String name, Schema schema) {
        super(name, schema);
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        View copy = target != null ? (View)target : new View();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(View copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        copy.setSQLQuery(this.copyObject(this.m_query, copy, idPolicy));
        copy.setQueryRestriction(this.m_restriction);
        copy.setForceOnCreate(this.m_force);
    }

    public boolean equals(Object target) {
        return target instanceof View && this.equalsImpl((View)target);
    }

    protected boolean equalsImpl(View target) {
        return super.equalsImpl(target) && this.m_force == target.m_force && ModelUtil.areEqual((Object)this.m_query, (Object)target.m_query) && ModelUtil.areEqual((Object)this.m_restriction, (Object)target.m_restriction);
    }

    @Transient
    public String getViewText() {
        this.checkInit("SQLQuery");
        if (this.m_query == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        buff.append(this.m_query.getSQLText().trim());
        if (this.m_restriction != null) {
            buff.append("\n");
            buff.append(this.m_restriction);
        }
        return buff.toString();
    }

    @Transient
    public void setViewText(String text) {
        this.checkInit("SQLQuery");
        StringBuffer sb = new StringBuffer(text);
        if (text == null) {
            this.m_query = null;
            this.m_restriction = null;
        } else if (text.trim().endsWith(READ_ONLY)) {
            this.m_query = new NonDeclarativeSQLQuery(text.substring(0, text.lastIndexOf(READ_ONLY)).trim());
            this.m_restriction = READ_ONLY;
        } else if (text.trim().endsWith(CHECK_OPTION)) {
            this.m_query = new NonDeclarativeSQLQuery(text.substring(0, text.lastIndexOf(CHECK_OPTION)).trim());
            this.m_restriction = CHECK_OPTION;
        } else {
            this.m_query = new NonDeclarativeSQLQuery(text);
            this.m_restriction = null;
        }
    }

    @Override
    public SQLQuery getSQLQuery() {
        this.checkInit("SQLQuery");
        return this.m_query;
    }

    @Override
    public void setSQLQuery(SQLQuery query) {
        this.checkInit("SQLQuery");
        this.changeParent(this.m_query, query);
        this.m_query = query;
    }

    @Override
    public boolean isDeclarative() {
        this.checkInit("SQLQuery");
        return this.m_query != null && this.m_query instanceof DeclarativeSQLQuery;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        super.getOwnedObjectsImpl(objs, types);
        this.includeOwnedObject(objs, this.m_query, types);
    }

    public String getQueryRestriction() {
        return this.m_restriction;
    }

    public void setQueryRestriction(String restriction) {
        this.m_restriction = restriction;
    }

    public boolean isForceOnCreate() {
        return this.m_force;
    }

    public void setForceOnCreate(boolean force) {
        this.m_force = force;
    }
}

