/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Schema;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trigger
extends PlSql {
    public static final String TYPE = "TRIGGER";
    public static final String INSERT_EVENT = "INSERT";
    public static final String DELETE_EVENT = "DELETE";
    public static final String UPDATE_EVENT = "UPDATE";
    public static final String ALTER_EVENT = "ALTER";
    public static final String ANALYZE_EVENT = "ANALYZE";
    public static final String ASSOCIATE_STATISTICS_EVENT = "ASSOCIATE STATISTICS";
    public static final String AUDIT_EVENT = "AUDIT";
    public static final String COMMENT_EVENT = "COMMENT";
    public static final String CREATE_EVENT = "CREATE";
    public static final String DISASSOCIATE_STATISTICS_EVENT = "DISASSOCIATE STATISTICS";
    public static final String DB_ROLE_CHANGE_EVENT = "DB_ROLE_CHANGE";
    public static final String DROP_EVENT = "DROP";
    public static final String GRANT_EVENT = "GRANT";
    public static final String NOAUDIT_EVENT = "NOAUDIT";
    public static final String RENAME_EVENT = "RENAME";
    public static final String REVOKE_EVENT = "REVOKE";
    public static final String TRUNCATE_EVENT = "TRUNCATE";
    public static final String DDL_EVENT = "DDL";
    public static final String SERVERERROR_EVENT = "SERVERERROR";
    public static final String LOGON_EVENT = "LOGON";
    public static final String LOGOFF_EVENT = "LOGOFF";
    public static final String STARTUP_EVENT = "STARTUP";
    public static final String SHUTDOWN_EVENT = "SHUTDOWN";
    public static final String SUSPEND_EVENT = "SUSPEND";
    private static final List TABLE_EVENTS = Collections.unmodifiableList(Arrays.asList("INSERT", "DELETE", "UPDATE"));
    private static final List BEFORE_SCHEMA_EVENTS = Collections.unmodifiableList(Arrays.asList("LOGOFF", "ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "NOAUDIT", "RENAME", "REVOKE", "TRUNCATE", "DDL"));
    private static final List AFTER_SCHEMA_EVENTS = Collections.unmodifiableList(Arrays.asList("LOGON", "SERVERERROR", "SUSPEND", "ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "NOAUDIT", "RENAME", "REVOKE", "TRUNCATE", "DDL"));
    private static final List BEFORE_DB_EVENTS = Collections.unmodifiableList(Arrays.asList("LOGOFF", "SHUTDOWN", "ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "NOAUDIT", "RENAME", "REVOKE", "TRUNCATE", "DDL"));
    private static final List AFTER_DB_EVENTS = Collections.unmodifiableList(Arrays.asList("LOGON", "SERVERERROR", "STARTUP", "SUSPEND", "ALTER", "ANALYZE", "ASSOCIATE STATISTICS", "AUDIT", "COMMENT", "CREATE", "DISASSOCIATE STATISTICS", "DROP", "GRANT", "NOAUDIT", "RENAME", "REVOKE", "TRUNCATE", "DDL", "DB_ROLE_CHANGE"));
    private static final List DATABASE_ONLY_EVENTS = Collections.unmodifiableList(Arrays.asList("SERVERERROR", "LOGON", "LOGOFF", "STARTUP", "SHUTDOWN", "SUSPEND"));
    private Timing m_timing;
    private boolean m_statementLevel;
    private List<String> m_events;
    private Schema m_tableOwner;
    private DBObjectID m_tableID;
    private BaseType m_baseType;
    private String[] m_refNames;
    private String m_whenClause;
    private ArrayList<DBObjectID> m_columnIDs;
    private boolean m_enabled;
    private String m_code;

    public static boolean isDatabaseOnlyEvent(String event) {
        return DATABASE_ONLY_EVENTS.contains(event);
    }

    public static List getEvents(BaseType type, Timing timing) {
        List list;
        if (timing == Timing.INSTEAD_OF && type != BaseType.VIEW) {
            list = Collections.EMPTY_LIST;
        } else {
            switch (1.$sm$oracle$javatools$db$Trigger$BaseType[type.ordinal()]) {
                case 1: 
                case 2: {
                    list = TABLE_EVENTS;
                    break;
                }
                case 3: {
                    list = timing == Timing.BEFORE ? BEFORE_SCHEMA_EVENTS : AFTER_SCHEMA_EVENTS;
                    break;
                }
                case 4: {
                    list = timing == Timing.BEFORE ? BEFORE_DB_EVENTS : AFTER_DB_EVENTS;
                    break;
                }
                default: {
                    list = Collections.EMPTY_LIST;
                    break;
                }
            }
        }
        return list;
    }

    private void $init$() {
        this.m_statementLevel = true;
        this.m_events = new ArrayList<String>();
        this.m_refNames = new String[2];
        this.m_columnIDs = new ArrayList();
        this.m_enabled = true;
    }

    public Trigger() {
        this.$init$();
    }

    public Trigger(Schema schema, String name) {
        this.$init$();
        this.setSchema(schema);
        this.setName(name);
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        Trigger copy = target != null ? (Trigger)target : new Trigger();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(Trigger copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        copy.m_timing = this.m_timing;
        copy.m_statementLevel = this.m_statementLevel;
        copy.m_events.clear();
        copy.m_events.addAll(this.m_events);
        copy.m_tableOwner = this.m_tableOwner;
        copy.m_tableID = this.m_tableID;
        copy.m_baseType = this.m_baseType;
        int i = 0;
        while (i < this.m_refNames.length) {
            copy.m_refNames[i] = this.m_refNames[i];
            ++i;
        }
        copy.m_whenClause = this.m_whenClause;
        copy.m_columnIDs.clear();
        copy.m_columnIDs.addAll(this.m_columnIDs);
        copy.m_code = this.m_code;
        copy.m_enabled = this.m_enabled;
    }

    public boolean equals(Object target) {
        return target instanceof Trigger && this.equalsImpl((Trigger)target);
    }

    protected boolean equalsImpl(Trigger target) {
        return super.equalsImpl(target) && this.m_timing == target.m_timing && this.m_statementLevel == target.m_statementLevel && ModelUtil.areEqual(this.m_events, target.m_events) && ModelUtil.areEqual((Object)this.m_tableOwner, (Object)target.m_tableOwner) && ModelUtil.areEqual((Object)this.m_tableID, (Object)target.m_tableID) && this.m_baseType == target.m_baseType && Arrays.equals(this.m_refNames, target.m_refNames) && ModelUtil.areEqual((Object)this.m_whenClause, (Object)target.m_whenClause) && ModelUtil.areEqual(this.m_columnIDs, target.m_columnIDs) && ModelUtil.areEqual((Object)this.m_code, (Object)target.m_code) && this.m_enabled == target.m_enabled;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public Timing getTiming() {
        this.checkInit();
        return this.m_timing;
    }

    public void setTiming(Timing timing) {
        this.checkInit();
        this.m_timing = timing;
    }

    public boolean isStatementLevel() {
        this.checkInit();
        return this.m_statementLevel;
    }

    public void setStatementLevel(boolean stmtLevel) {
        this.checkInit();
        this.m_statementLevel = stmtLevel;
    }

    public String[] getEvents() {
        this.checkInit();
        return this.m_events.toArray(new String[this.m_events.size()]);
    }

    public void setEvents(String[] events) {
        this.checkInit();
        ArrayList<String> newEvents = new ArrayList<String>();
        if (events != null) {
            String[] stringArray = events;
            int n = 0;
            while (n < stringArray.length) {
                String event = stringArray[n];
                newEvents.add(event);
                ++n;
            }
        }
        if (ModelUtil.areDifferent(this.m_events, newEvents)) {
            this.m_events = newEvents;
        }
    }

    public Schema getTableOwner() {
        this.checkInit();
        return this.m_tableOwner;
    }

    public void setTableOwner(Schema owner) {
        this.checkInit();
        this.m_tableOwner = owner;
    }

    public DBObjectID getTableID() {
        this.checkInit();
        return this.m_tableID;
    }

    public void setTableID(DBObjectID tableID) {
        this.checkInit();
        this.m_tableID = tableID;
    }

    public BaseType getBaseType() {
        this.checkInit();
        return this.m_baseType;
    }

    public void setBaseType(BaseType type) {
        this.checkInit();
        this.m_baseType = type;
    }

    public String[] getReferenceNames() {
        this.checkInit();
        String[] names = new String[this.m_refNames.length];
        int i = 0;
        while (i < this.m_refNames.length) {
            names[i] = this.m_refNames[i];
            ++i;
        }
        return names;
    }

    public void setReferenceNames(String[] names) {
        this.checkInit();
        if (names == null || names.length != 2) {
            throw new IllegalArgumentException("trigger reference names property must contain two names.");
        }
        if (!Arrays.equals(this.m_refNames, names)) {
            int i = 0;
            while (i < this.m_refNames.length) {
                this.m_refNames[i] = null;
                ++i;
            }
            int i2 = 0;
            while (i2 < names.length) {
                this.m_refNames[i2] = names[i2];
                ++i2;
            }
        }
    }

    public String getWhenClause() {
        this.checkInit();
        return this.m_whenClause;
    }

    public void setWhenClause(String clause) {
        this.checkInit();
        this.m_whenClause = clause;
    }

    public DBObjectID[] getColumnIDs() {
        return this.m_columnIDs.toArray(new DBObjectID[this.m_columnIDs.size()]);
    }

    public void setColumnIDs(DBObjectID[] ids) {
        this.m_columnIDs.clear();
        if (ids != null) {
            int i = 0;
            while (i < ids.length) {
                if (ids[i] != null) {
                    this.m_columnIDs.add(ids[i]);
                }
                ++i;
            }
        }
    }

    public String getCode() {
        this.checkInit();
        return this.m_code == null ? null : this.m_code.trim();
    }

    public void setCode(String code) {
        this.checkInit();
        this.m_code = code;
    }

    @Override
    public String getSource() {
        return super.getSource();
    }

    @Override
    public void setSource(String source) {
        super.setSource(source);
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        if (this.m_tableID != null) {
            refs.add(this.m_tableID);
        }
        refs.addAll(this.m_columnIDs);
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        if (this.m_tableID != null && idMap.containsKey(this.m_tableID)) {
            this.m_tableID = idMap.get(this.m_tableID);
            replaced = true;
        }
        int i = 0;
        while (i < this.m_columnIDs.size()) {
            DBObjectID id = this.m_columnIDs.get(i);
            if (idMap.containsKey(id)) {
                this.m_columnIDs.set(i, idMap.get(id));
                replaced = true;
            }
            ++i;
        }
        return replaced;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Timing
    extends Enum<Timing> {
        private static final /* synthetic */ Timing[] $v;
        public static final /* enum */ Timing BEFORE;
        public static final /* enum */ Timing AFTER;
        public static final /* enum */ Timing INSTEAD_OF;

        public static Timing valueOf(String string) {
            return Enum.valueOf(Timing.class, string);
        }

        public static final Timing[] values() {
            return (Timing[])$v.clone();
        }

        static {
            Timing[] timingArray = new Timing[3];
            timingArray[2] = INSTEAD_OF = new Timing("INSTEAD_OF", 2);
            timingArray[1] = AFTER = new Timing("AFTER", 1);
            timingArray[0] = BEFORE = new Timing("BEFORE", 0);
            $v = timingArray;
        }

        public String toString() {
            return super.toString().replaceAll("_", " ");
        }

        private Timing(String string2, int n2) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BaseType
    extends Enum<BaseType> {
        private static final /* synthetic */ BaseType[] $v;
        public static final /* enum */ BaseType TABLE;
        public static final /* enum */ BaseType VIEW;
        public static final /* enum */ BaseType SCHEMA;
        public static final /* enum */ BaseType DATABASE;

        public static BaseType valueOf(String string) {
            return Enum.valueOf(BaseType.class, string);
        }

        public static final BaseType[] values() {
            return (BaseType[])$v.clone();
        }

        static {
            BaseType[] baseTypeArray = new BaseType[4];
            baseTypeArray[3] = DATABASE = new BaseType("DATABASE", 3);
            baseTypeArray[2] = SCHEMA = new BaseType("SCHEMA", 2);
            baseTypeArray[1] = VIEW = new BaseType("VIEW", 1);
            baseTypeArray[0] = TABLE = new BaseType("TABLE", 0);
            $v = baseTypeArray;
        }

        private BaseType(String string2, int n2) {
        }
    }

    static class 1 {
        static final /* synthetic */ int[] $sm$oracle$javatools$db$Trigger$BaseType;

        static {
            int[] nArray = new int[BaseType.values().length];
            $sm$oracle$javatools$db$Trigger$BaseType = nArray;
            try {
                nArray[BaseType.TABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Trigger$BaseType[BaseType.VIEW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Trigger$BaseType[BaseType.SCHEMA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                1.$sm$oracle$javatools$db$Trigger$BaseType[BaseType.DATABASE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
        }
    }
}

