/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.List;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Function;
import oracle.javatools.db.Index;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Procedure;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectExpander;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlToken;

public class TemplateExpander
implements SchemaObjectExpander {
    private static final String TEMPLATE_OBJECT = "TemplateObject";
    DBObjectProvider m_pro;
    DatabaseDescriptor m_descriptor;

    public TemplateExpander(DBObjectProvider pro) {
        this.m_pro = pro;
        this.m_descriptor = pro.getDescriptor();
    }

    public static final SchemaObject initialiseObject(SchemaObject template) {
        SchemaObject object = (SchemaObject)template.copyTo(null);
        object.setName(null);
        object.setProperty(TEMPLATE_OBJECT, template);
        if (object instanceof PlSql) {
            ((PlSql)object).setSource(null);
            if (object instanceof SpecPlSql) {
                ((SpecPlSql)object).setBodySource(null);
            }
        }
        return object;
    }

    public static final void copyTemplateProperty(SchemaObject so1, SchemaObject so2) {
        so2.setProperty(TEMPLATE_OBJECT, so1.getProperty(TEMPLATE_OBJECT));
    }

    public static final boolean isPendingObject(SchemaObject object) {
        return object.getProperty(TEMPLATE_OBJECT) != null;
    }

    public void expand(ResultSet rs) {
        List<ResultSet> newRSs = rs.getAonlyList();
        for (ResultSet newRS : newRSs) {
            SchemaObject so;
            if (!(newRS.a() instanceof SchemaObject) || !TemplateExpander.isPendingObject(so = (SchemaObject)newRS.a())) continue;
            this.completePendingObject(so);
        }
    }

    private void completePendingObject(SchemaObject object) {
        SchemaObject template = (SchemaObject)object.getProperty(TEMPLATE_OBJECT);
        if (template != null) {
            object.getProperties().remove(TEMPLATE_OBJECT);
            if (object instanceof Table) {
                Table tab = (Table)object;
                Index[] indexArray = tab.getIndexes();
                int n = 0;
                while (n < indexArray.length) {
                    Index i = indexArray[n];
                    i.setName(this.replaceNameFragment(i.getName(), template.getName(), tab.getName()));
                    try {
                        this.m_descriptor.makeNameValidAndUnique(i, this.m_pro);
                    }
                    catch (InvalidNameException e) {
                        // empty catch block
                    }
                    ++n;
                }
                Constraint[] constraintArray = tab.getConstraints();
                int n2 = 0;
                while (n2 < constraintArray.length) {
                    Constraint c = constraintArray[n2];
                    c.setName(this.replaceNameFragment(c.getName(), template.getName(), tab.getName()));
                    try {
                        this.m_descriptor.makeNameValidAndUnique(c, this.m_pro);
                    }
                    catch (InvalidNameException e) {
                        // empty catch block
                    }
                    ++n2;
                }
                Column[] columnArray = tab.getColumns();
                int n3 = 0;
                while (n3 < columnArray.length) {
                    DBObjectID trgID;
                    Column column;
                    block35: {
                        column = columnArray[n3];
                        DBObjectID seqID = (DBObjectID)column.getProperty("AUTO_GENERATED_SEQUENCE");
                        if (seqID != null) {
                            try {
                                String seqName;
                                DBObject thisSeq = seqID.resolveID();
                                String string = seqName = thisSeq != null ? thisSeq.getName() : "";
                                if (!seqName.equals(template.getName() + "_SEQ")) break block35;
                                seqName = this.replaceNameFragment(seqName, template.getName(), tab.getName());
                                thisSeq = (Sequence)thisSeq.copyTo(null);
                                thisSeq.setName(seqName);
                                try {
                                    this.m_descriptor.makeNameValidAndUnique(thisSeq, this.m_pro);
                                }
                                catch (InvalidNameException e) {
                                    // empty catch block
                                }
                                seqID = TemporaryObjectID.createID(thisSeq);
                                thisSeq.setID(seqID);
                                column.setProperty("AUTO_GENERATED_SEQUENCE", seqID);
                            }
                            catch (DBException e) {
                                // empty catch block
                            }
                        }
                    }
                    if ((trgID = (DBObjectID)column.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER")) != null) {
                        try {
                            DBObject trg = trgID.resolveID();
                            String trigName = this.replaceNameFragment(trg.getName(), template.getName(), tab.getName());
                            trg = new Trigger(tab.getSchema(), trigName);
                            try {
                                this.m_descriptor.makeNameValidAndUnique(trg, this.m_pro);
                            }
                            catch (InvalidNameException e) {
                                // empty catch block
                            }
                            trgID = TemporaryObjectID.createID(trg);
                            trg.setID(trgID);
                            column.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", trgID);
                        }
                        catch (DBException e) {
                            // empty catch block
                        }
                    }
                    ++n3;
                }
            } else if (object instanceof SpecPlSql) {
                PlSqlInterrogator piTemplate = ((PlSql)template).getSourceInterrogator();
                ((PlSql)object).setSource(piTemplate.getRenamedSource(object.getName()));
                PlSqlInterrogator piTemplateBody = ((SpecPlSql)template).getBodySourceInterrogator();
                if (piTemplateBody != null) {
                    ((SpecPlSql)object).setBodySource(piTemplateBody.getRenamedSource(object.getName()));
                }
            } else if (object instanceof Trigger) {
                PlSqlInterrogator piObject = ((PlSql)object).getSourceInterrogator();
                PlSqlFragment objectProcFrag = this.findFragment(piObject.getRoot(), PlSqlFragment.Type.TRIGGER, true);
                PlSqlFragment objectPLSQLFrag = this.findFragment(objectProcFrag, PlSqlFragment.Type.PLSQL_BLOCK, false);
                PlSqlInterrogator piTemplate = ((PlSql)template).getSourceInterrogator();
                PlSqlFragment templateProcFrag = this.findFragment(piTemplate.getRoot(), PlSqlFragment.Type.TRIGGER, true);
                PlSqlFragment templatePLSQLFrag = this.findFragment(templateProcFrag, PlSqlFragment.Type.PLSQL_BLOCK, false);
                int objectParamsStart = objectProcFrag.getFirstToken().getEnd();
                int objectParamsEnd = objectPLSQLFrag.getFirstToken().getStart();
                int templateParamsStart = templateProcFrag.getFirstToken().getEnd();
                int templateParamsEnd = templatePLSQLFrag.getFirstToken().getStart();
                StringBuilder sb = new StringBuilder();
                String objectSource = ((PlSql)object).getSource();
                String templateSource = ((PlSql)template).getSource();
                sb.append(templateSource.substring(0, templateParamsStart));
                sb.append(objectSource.substring(objectParamsStart, objectParamsEnd));
                sb.append(templateSource.substring(templateParamsEnd));
                ((PlSql)object).setSource(sb.toString());
            } else if (object instanceof Procedure || object instanceof Function) {
                PlSqlFragment.Type type = PlSqlFragment.Type.PROCEDURE;
                if (object instanceof Function) {
                    type = PlSqlFragment.Type.FUNCTION;
                }
                PlSqlInterrogator piObject = ((PlSql)object).getSourceInterrogator();
                PlSqlFragment objectProcFrag = this.findFragment(piObject.getRoot(), type, true);
                PlSqlFragment objectParamsFrag = this.findFragment(objectProcFrag, PlSqlFragment.Type.PARAMETER_LIST, false);
                PlSqlInterrogator piTemplate = ((PlSql)template).getSourceInterrogator();
                PlSqlFragment templateProcFrag = this.findFragment(piTemplate.getRoot(), type, true);
                PlSqlFragment templateParamsFrag = this.findFragment(templateProcFrag, PlSqlFragment.Type.PARAMETER_LIST, false);
                int templateParamsStart = -1;
                int templateParamsEnd = -1;
                if (templateParamsFrag == null) {
                    PlSqlToken name = templateProcFrag.getFirstToken().getNextCodeToken();
                    templateParamsStart = name.getNextCodeToken().getStart();
                    templateParamsEnd = name.getNextToken().getStart();
                } else {
                    templateParamsStart = templateParamsFrag.getFirstToken().getStart();
                    templateParamsEnd = templateParamsFrag.getLastToken().getEnd() + 1;
                }
                StringBuilder sb = new StringBuilder();
                String templateSource = ((PlSql)template).getSource();
                sb.append(templateSource.substring(0, templateParamsStart));
                if (objectParamsFrag != null) {
                    sb.append(objectParamsFrag.getSource());
                }
                boolean done = false;
                if (object instanceof Function) {
                    PlSqlToken tok = templateProcFrag.getFirstToken();
                    int startOfReturnType = -1;
                    int endOfReturnType = -1;
                    while (!tok.matches("return") && tok.getType() != PlSqlToken.Type.END_MARKER) {
                        tok = tok.getNextToken();
                    }
                    if (tok.matches("return")) {
                        tok = tok.getNextCodeToken();
                        startOfReturnType = tok.getStart();
                        while (tok.isCode()) {
                            tok = tok.getNextToken();
                        }
                        endOfReturnType = tok.getStart();
                        sb.append(templateSource.substring(templateParamsEnd, startOfReturnType));
                        sb.append(DBUtil.getDBObjectName(((Function)object).getReturnTypeID()));
                        sb.append(templateSource.substring(endOfReturnType));
                        done = true;
                    }
                }
                if (!done) {
                    sb.append(templateSource.substring(templateParamsEnd));
                }
                ((PlSql)object).setSource(sb.toString());
                piObject = ((PlSql)object).getSourceInterrogator();
                ((PlSql)object).setSource(piObject.getRenamedSource(object.getName()));
            }
        }
    }

    private String replaceNameFragment(String fullname, String origFrag, String newFrag) {
        String retval = "_" + fullname + "_";
        String _s1_ = "_" + origFrag + "_";
        String _s2_ = "_" + newFrag + "_";
        int i = 0;
        String tempFrag = "_" + i + "_";
        String s = _s1_ + _s2_;
        while (s.contains(tempFrag)) {
            tempFrag = "_" + ++i + "_";
        }
        while (retval.indexOf(_s1_) >= 0) {
            retval = retval.replace(_s1_, tempFrag);
        }
        while (retval.indexOf(tempFrag) >= 0) {
            retval = retval.replace(tempFrag, _s2_);
        }
        return retval.substring(1, retval.length() - 1);
    }

    private PlSqlFragment findFragment(PlSqlFragment root, PlSqlFragment.Type type, boolean deep) {
        if (root.getFramentType() == type) {
            return root;
        }
        for (Object o : root.getSubFragments()) {
            PlSqlFragment frag2;
            PlSqlFragment frag = (PlSqlFragment)o;
            if (frag.getFramentType() == type) {
                return frag;
            }
            if (!deep || (frag2 = this.findFragment(frag, type, true)) == null) continue;
            return frag2;
        }
        return null;
    }
}

