/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.util.ModelUtil;

public class Table
extends Relation {
    public static final String TYPE = "TABLE";
    @PropertyKey(value=TableType.class, childOf={Table.class})
    public static final String TABLE_TYPE_KEY = "TableType";

    public Table() {
        this.setProperty(TABLE_TYPE_KEY, (Object)TableType.NORMAL);
    }

    public Table(String name, Schema schema) {
        super(name, schema);
        this.setProperty(TABLE_TYPE_KEY, (Object)TableType.NORMAL);
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        Table copy = target != null ? (Table)target : new Table();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    public boolean equals(Object target) {
        return target instanceof Table && this.equalsImpl((Table)target);
    }

    public String getType() {
        return TYPE;
    }

    public Index[] getIndexes() {
        this.checkInit("INDEX");
        return (Index[])this.getChildSupport().getChildArray(Index.class);
    }

    public void setIndexes(Index[] indexes) {
        this.checkInit("INDEX");
        this.getChildSupport().setChildArray(Index.class, indexes);
    }

    public void addIndex(Index index) {
        this.checkInit("INDEX");
        this.getChildSupport().addChild(index);
    }

    public void removeIndex(Index index) {
        this.checkInit("INDEX");
        this.getChildSupport().removeChild(index);
    }

    public Index getIndex(String idxName) {
        this.checkInit("INDEX");
        return this.getChildSupport().findChild(Index.class, idxName);
    }

    public void setSchema(Schema schema) {
        Schema oldSchema = this.getSchema();
        super.setSchema(schema);
        if (schema != oldSchema) {
            Index[] indexArray = this.getIndexes();
            int n = 0;
            while (n < indexArray.length) {
                Index i = indexArray[n];
                Schema iSchema = i.getSchema();
                if (iSchema != null) {
                    String iSchemaName = iSchema.getName();
                    if (oldSchema != null && ModelUtil.areEqual((Object)iSchemaName, (Object)oldSchema.getName()) || schema != null && ModelUtil.areEqual((Object)iSchemaName, (Object)schema.getName())) {
                        i.setSchema(null);
                    }
                }
                ++n;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TableType
    extends Enum<TableType> {
        private static final /* synthetic */ TableType[] $v;
        public static final /* enum */ TableType NORMAL;
        public static final /* enum */ TableType TRANSACTION_TEMP;
        public static final /* enum */ TableType SESSION_TEMP;
        public static final /* enum */ TableType INDEX_ORGANIZED;
        public static final /* enum */ TableType EXTERNAL;

        public static TableType valueOf(String string) {
            return Enum.valueOf(TableType.class, string);
        }

        public static final TableType[] values() {
            return (TableType[])$v.clone();
        }

        static {
            TableType[] tableTypeArray = new TableType[5];
            tableTypeArray[4] = EXTERNAL = new TableType("EXTERNAL", 4);
            tableTypeArray[3] = INDEX_ORGANIZED = new TableType("INDEX_ORGANIZED", 3);
            tableTypeArray[2] = SESSION_TEMP = new TableType("SESSION_TEMP", 2);
            tableTypeArray[1] = TRANSACTION_TEMP = new TableType("TRANSACTION_TEMP", 1);
            tableTypeArray[0] = NORMAL = new TableType("NORMAL", 0);
            $v = tableTypeArray;
        }

        private TableType(String string2, int n2) {
        }
    }
}

