/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.Database;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementWrapper {
    private static List<Connection> s_locks = new ArrayList<Connection>();
    private static ExecutionProxy s_proxy;
    private Database m_db;
    private boolean m_locked;
    private Connection m_conn;
    private String m_name;
    private String m_identifier;
    private Statement m_stmt;
    private String[] m_statement;
    private boolean m_ignoreErrors;
    private boolean m_noThreads;
    private long m_millis;
    private static Collection<Listener> s_listeners;

    private StatementWrapper() {
    }

    public StatementWrapper(String connName, Connection connection, String ... statements) {
        this.m_name = connName;
        this.m_conn = connection;
        this.setStatement(statements);
    }

    public StatementWrapper(Database db, String ... statements) {
        this.m_db = db;
        this.setStatement(statements);
    }

    public void setStatement(String ... statements) {
        this.m_statement = statements;
    }

    protected final String[] getStatementStrings() {
        return this.m_statement;
    }

    protected String getStatementTextForLog() {
        StringBuilder buff = new StringBuilder();
        if (this.m_statement != null) {
            String[] stringArray = this.m_statement;
            int n = 0;
            while (n < stringArray.length) {
                String s = stringArray[n];
                if (buff.length() > 0) {
                    buff.append("\n");
                }
                buff.append(s);
                ++n;
            }
        }
        return buff.toString();
    }

    protected final Statement getStatement() throws SQLException {
        if (this.m_stmt == null) {
            if (!this.m_locked) {
                throw new IllegalStateException("not executing, statement cannot be retrieved");
            }
            this.m_stmt = this.createStatment();
        }
        return this.m_stmt;
    }

    protected Statement createStatment() throws SQLException {
        return this.getConnection().createStatement();
    }

    void setBypassExecutionProxy(boolean doNotThread) {
        this.m_noThreads = doNotThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setExecuting(boolean executing) {
        List<Connection> list = s_locks;
        synchronized (list) {
            this.m_locked = executing;
        }
    }

    public boolean execute() throws DBException {
        return (Boolean)this.doExecute(new 1(this));
    }

    protected boolean executeImpl(String stmt) throws SQLException {
        StatementWrapper.sqlTrace(this.getConnectionName(), stmt, new Object[0]);
        this.queryStarted();
        boolean result = false;
        try {
            if (this.m_db != null && this.m_db instanceof AbstractDatabase) {
                ((AbstractDatabase)this.m_db).setStatement(this.getStatement());
            }
            result = this.getStatement().execute(stmt);
        }
        finally {
            if (this.m_db != null && this.m_db instanceof AbstractDatabase) {
                ((AbstractDatabase)this.m_db).setStatement(null);
            }
        }
        return result;
    }

    protected final <T> T doExecute(ExecutionRunnable<T> r) throws DBException {
        ExecutionProxy ep = StatementWrapper.getExecutionProxy();
        if (ep == null || this.m_noThreads) {
            r.run();
            return r.getResult();
        }
        return (T)ExecutionProxy.mav$doExecute(ep, r);
    }

    public void close() {
        if (this.m_stmt != null) {
            try {
                this.m_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.queryFinished();
    }

    public final String getIdentifier() {
        return this.m_identifier;
    }

    public final void setIdentifier(String i) {
        this.m_identifier = i;
    }

    protected final Database getDatabase() {
        return this.m_db;
    }

    protected final void setDatabase(Database db) {
        this.m_db = db;
    }

    protected final String getConnectionName() {
        if (this.m_db == null) {
            return this.m_name;
        }
        return this.m_db.getConnectionName();
    }

    protected final Connection getConnection() {
        if (this.m_db == null) {
            return this.m_conn;
        }
        return this.m_db.getConnection();
    }

    protected boolean isIgnoreErrors() {
        return this.m_ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignore) {
        this.m_ignoreErrors = ignore;
    }

    protected final void throwDBException(DBObject obj, String text, SQLException sqe) throws DBException {
        throw new DBSQLException(obj, text, sqe);
    }

    public final void throwDBException(SQLException sqe) throws DBException {
        this.throwDBException(null, sqe);
    }

    public final void throwDBException(DBObject obj, SQLException sqe) throws DBException {
        if (this.hasCancelled(sqe)) {
            throw new CancelledException();
        }
        this.throwDBException(obj, this.getStatementTextForLog(), sqe);
    }

    protected boolean hasCancelled(SQLException sqe) {
        return false;
    }

    protected final void queryStarted() {
        this.m_millis = System.currentTimeMillis();
        if (s_listeners != null) {
            for (Listener list : s_listeners) {
                try {
                    list.queryStarted(this);
                }
                catch (Exception e) {
                    DBLog.logStackTrace(e);
                }
            }
        }
    }

    protected final void queryFinished() {
        if (s_listeners != null) {
            for (Listener list : s_listeners) {
                try {
                    list.queryFinished(this);
                }
                catch (Exception e) {
                    DBLog.logStackTrace(e);
                }
            }
        }
        long millis = System.currentTimeMillis() - this.m_millis;
        this.m_millis = 0L;
        DBLog.getLogger().log(DBLog.getTimingLogLevel(), "Executing query, and processing results took {0}ms", Long.toString(millis));
        DBLog.getSQLLog().trace("Query took {0}ms", (Object)Long.toString(millis));
    }

    public static final void addListener(Listener l) {
        if (l != null) {
            if (s_listeners == null) {
                s_listeners = new ArrayList<Listener>();
            }
            s_listeners.add(l);
        }
    }

    public static final boolean removeListener(Listener l) {
        return s_listeners != null && s_listeners.remove(l);
    }

    public static final void sqlTrace(String dbName, String query, Object ... params) {
        StringBuilder paramList = null;
        if (params != null) {
            paramList = new StringBuilder();
            int i = 0;
            while (i < params.length) {
                int index = query.indexOf(63);
                if (index >= 0) {
                    String param = params[i] == null ? "<null>" : "'" + params[i] + "'";
                    query = query.substring(0, index) + param + query.substring(index + 1);
                    paramList.append(param).append(", ");
                }
                ++i;
            }
        }
        DBLog.getSQLLog().trace("{0}:\n{1}", new Object[]{dbName, query});
        DBLog.log("{0}:\n{1}\nBinds used: {2}", dbName, query, paramList == null ? "none" : paramList);
    }

    public static void setExecutionProxy(ExecutionProxy ep) {
        if (ep != null) {
            if (s_proxy != null) {
                DBLog.getLogger().warning("changing execution proxy for db queries from " + s_proxy.getClass().getName() + " to " + ep.getClass().getName());
            }
            s_proxy = ep;
        }
    }

    public static ExecutionProxy getExecutionProxy() {
        return s_proxy;
    }

    static Statement ra$m_stmt(StatementWrapper statementWrapper) {
        return statementWrapper.m_stmt;
    }

    static Database ra$m_db(StatementWrapper statementWrapper) {
        return statementWrapper.m_db;
    }

    static String[] ra$m_statement(StatementWrapper statementWrapper) {
        return statementWrapper.m_statement;
    }

    static boolean ra$m_ignoreErrors(StatementWrapper statementWrapper) {
        return statementWrapper.m_ignoreErrors;
    }

    final class 1
    extends ExecutionRunnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Boolean runImpl() throws DBException {
            boolean retval = false;
            if (StatementWrapper.ra$m_statement(StatementWrapper.this) != null) {
                Connection connection = StatementWrapper.this.getConnection();
                synchronized (connection) {
                    StatementWrapper.this.setExecuting(true);
                    try {
                        retval = true;
                        String[] stringArray = StatementWrapper.ra$m_statement(StatementWrapper.this);
                        int n = 0;
                        while (n < stringArray.length) {
                            block11: {
                                String s = stringArray[n];
                                if (s != null) {
                                    try {
                                        retval = StatementWrapper.this.executeImpl(s) || retval;
                                    }
                                    catch (SQLException sqe) {
                                        if (StatementWrapper.ra$m_ignoreErrors(StatementWrapper.this)) break block11;
                                        StatementWrapper.this.throwDBException(null, s, sqe);
                                    }
                                }
                            }
                            ++n;
                        }
                    }
                    finally {
                        StatementWrapper.this.close();
                        StatementWrapper.this.setExecuting(false);
                    }
                }
            }
            return retval;
        }

        public 1(StatementWrapper statementWrapper2) {
        }
    }

    public static interface Listener {
        public void queryStarted(StatementWrapper var1);

        public void queryFinished(StatementWrapper var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ExecutionProxy {
        private boolean m_cancelling;
        private List<ExecutionRunnable> m_running;

        private void $init$() {
            this.m_running = new ArrayList<ExecutionRunnable>();
        }

        public final synchronized void setCancelling(boolean cancel) {
            this.m_cancelling = cancel;
            for (ExecutionRunnable run : this.m_running) {
                try {
                    run.cancel();
                }
                catch (SQLException sqe) {
                    DBLog.getLogger().log(Level.WARNING, "error cancelling execution", sqe);
                }
            }
            this.m_running.clear();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private <T> T doExecute(ExecutionRunnable<T> r) throws DBException {
            if (this.m_cancelling) {
                throw new CancelledException();
            }
            this.m_running.add(r);
            try {
                T t = this.execute(r);
                return t;
            }
            catch (DBException dbe) {
                if (!this.m_cancelling) throw dbe;
                if (dbe instanceof CancelledException) throw dbe;
                throw new CancelledException();
            }
            finally {
                this.m_running.remove(r);
            }
        }

        public abstract <T> T execute(ExecutionRunnable<T> var1) throws DBException;

        public ExecutionProxy() {
            this.$init$();
        }

        static Object mav$doExecute(ExecutionProxy executionProxy, ExecutionRunnable executionRunnable) {
            return executionProxy.doExecute(executionRunnable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ExecutionRunnable<T>
    implements Runnable {
        private T m_result;
        private DBException m_dbe;

        @Override
        public synchronized void run() {
            try {
                this.m_result = null;
                this.m_dbe = null;
                this.m_result = this.runImpl();
            }
            catch (DBException dbe) {
                this.m_dbe = dbe;
            }
            catch (Throwable t) {
                this.m_dbe = new DBException(t);
            }
        }

        public abstract T runImpl() throws DBException;

        public T getResult() throws DBException {
            if (this.m_dbe != null) {
                throw this.m_dbe;
            }
            return this.m_result;
        }

        public String getName() {
            return StatementWrapper.ra$m_db(StatementWrapper.this) == null ? "" : StatementWrapper.ra$m_db(StatementWrapper.this).getConnectionName();
        }

        public String getStatement() {
            return StatementWrapper.this.getStatementTextForLog();
        }

        public void cancel() throws SQLException {
            if (StatementWrapper.ra$m_stmt(StatementWrapper.this) != null) {
                StatementWrapper.ra$m_stmt(StatementWrapper.this).cancel();
            }
        }
    }
}

