/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.PlSqlAttribute;
import oracle.javatools.db.PlSqlMethod;
import oracle.javatools.db.Schema;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.util.ModelUtil;

public abstract class SpecPlSql
extends PlSql {
    private String m_body;
    private PlSqlInterrogator m_bodyInterrogator;

    protected SpecPlSql() {
    }

    protected SpecPlSql(String name, Schema schema) {
        super(name, schema);
    }

    protected void copyToImpl(SpecPlSql copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        copy.m_body = this.m_body;
    }

    protected boolean equalsImpl(SpecPlSql target) {
        boolean equals = super.equalsImpl(target) && ModelUtil.areEqual((Object)this.m_body, (Object)target.m_body);
        return equals;
    }

    public void setAttributes(PlSqlAttribute[] newAttribs) {
        this.checkInit("TypeAttribute");
        this.getChildSupport().setChildArray(PlSqlAttribute.class, newAttribs);
    }

    public PlSqlAttribute[] getAttributes() {
        this.checkInit("TypeAttribute");
        return (PlSqlAttribute[])this.getChildSupport().getChildArray(PlSqlAttribute.class);
    }

    public void addAttribute(PlSqlAttribute att) {
        this.checkInit("TypeAttribute");
        this.getChildSupport().addChild(att);
    }

    public void addAttribute(int index, PlSqlAttribute att) {
        this.checkInit("TypeAttribute");
        this.getChildSupport().addChild(index, att);
    }

    public PlSqlAttribute getAttribute(String name) {
        this.checkInit("TypeAttribute");
        return this.getChildSupport().findChild(PlSqlAttribute.class, name);
    }

    public void removeAttribute(PlSqlAttribute att) {
        this.checkInit("TypeAttribute");
        this.getChildSupport().removeChild(att);
    }

    public void setMethods(PlSqlMethod[] newMethods) {
        this.checkInit("TypeMethod");
        this.getChildSupport().setChildArray(PlSqlMethod.class, newMethods);
    }

    public PlSqlMethod[] getMethods() {
        this.checkInit("TypeMethod");
        return (PlSqlMethod[])this.getChildSupport().getChildArray(PlSqlMethod.class);
    }

    public void addMethod(PlSqlMethod method) {
        this.checkInit("TypeMethod");
        this.getChildSupport().addChild(method);
    }

    public void addMethod(int index, PlSqlMethod method) {
        this.checkInit("TypeMethod");
        this.getChildSupport().addChild(index, method);
    }

    public PlSqlMethod getMethod(String name) {
        this.checkInit("TypeMethod");
        return this.getChildSupport().findChild(PlSqlMethod.class, name);
    }

    public void removeMethod(PlSqlMethod method) {
        this.checkInit("TypeMethod");
        this.getChildSupport().removeChild(method);
    }

    public String getBodySource() {
        this.checkInit();
        return this.m_body;
    }

    public void setBodySource(String body) {
        this.checkInit();
        this.m_body = body;
        this.m_bodyInterrogator = null;
    }

    public PlSqlInterrogator getBodySourceInterrogator() {
        this.checkInit();
        if (this.m_bodyInterrogator == null) {
            this.m_bodyInterrogator = PlSqlInterrogator.findOrCreate(this.m_body);
        }
        return this.m_bodyInterrogator;
    }
}

