/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.View;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaObjectManager {
    private static final DBObjectID[] EMPTY_ID;
    private DBObjectProvider m_provider;
    private boolean m_registeredAll;
    private final Map m_deps;
    private final Map m_soDeps;
    private final Map m_danglers;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.m_deps = new HashMap();
        this.m_soDeps = new HashMap();
        this.m_danglers = new HashMap();
    }

    static {
        $assertionsDisabled = SchemaObjectManager.class.desiredAssertionStatus() ^ true;
        EMPTY_ID = new DBObjectID[0];
    }

    public SchemaObjectManager(DBObjectProvider provider) {
        this.$init$();
        if (!$assertionsDisabled && provider == null) {
            throw new AssertionError();
        }
        this.m_provider = provider;
    }

    protected final DBObjectProvider getProvider() {
        return this.m_provider;
    }

    protected final boolean haveRegisteredAll() {
        return this.m_registeredAll;
    }

    protected void clearAllCaches() {
        this.m_registeredAll = false;
        this.m_deps.clear();
        this.m_soDeps.clear();
        this.m_danglers.clear();
    }

    protected boolean supportsUnresolvedReferences() {
        return false;
    }

    protected boolean couldFixUnresolvedReferences(DBObject obj) {
        return false;
    }

    public boolean isUnresolvedReference(DBObjectID id) {
        return false;
    }

    protected boolean resolvesUnresolvedReference(DBObjectID id, DBObjectID unresolved) {
        return false;
    }

    public void registerObject(SchemaObject obj) {
        this.registerObject(obj, false);
    }

    public void registerObject(SchemaObject obj, boolean loadOnly) {
        if (this.supportsUnresolvedReferences() && this.couldFixUnresolvedReferences(obj)) {
            this.checkInit();
        }
        if (this.shouldRegister(obj, loadOnly)) {
            this.registerObject(obj, obj);
            if (this.supportsUnresolvedReferences()) {
                this.checkUnresolvedReferences(obj);
            }
        }
    }

    protected boolean shouldRegister(SchemaObject obj, boolean loadOnly) {
        boolean register = this.m_registeredAll;
        if (!register) {
            register = !this.needsInitialization(obj) && (obj instanceof View || obj instanceof Synonym || obj instanceof Table || obj instanceof Trigger);
        }
        return register;
    }

    protected final boolean needsInitialization(SchemaObject obj) {
        return obj instanceof AbstractSchemaObject && ((AbstractSchemaObject)obj).needsInitialization();
    }

    public void unregisterObject(SchemaObject obj) {
        if (this.m_registeredAll) {
            DBObjectID id = obj.getID();
            if (id != null && this.supportsUnresolvedReferences()) {
                for (Map sos : this.m_danglers.values()) {
                    if (!sos.containsKey(id)) continue;
                    Map kids = (Map)sos.remove(id);
                }
            }
            this.unregisterImpl(obj);
        }
    }

    public DBObjectID[] getSchemaObjectReferers(SchemaObject obj, boolean deep) {
        this.checkInit();
        DBObjectID id = obj.getID();
        Collection refs = this.getSchemaObjectReferersImpl(id, deep ? new HashSet() : null);
        if (refs != null && refs.size() > 0) {
            return refs.toArray(new DBObjectID[refs.size()]);
        }
        return EMPTY_ID;
    }

    public DBObjectID[] getReferers(DBObject obj) {
        Collection refs;
        this.checkInit();
        DBObjectID id = obj.getID();
        if (id != null && (refs = (Collection)this.m_deps.get(id)) != null && refs.size() > 0) {
            return refs.toArray(new DBObjectID[refs.size()]);
        }
        return EMPTY_ID;
    }

    public boolean hasUnresolvedReference(SchemaObject obj, String refType) {
        DBObjectID id;
        this.checkInit();
        Map danglersForType = (Map)this.m_danglers.get(refType);
        if (danglersForType != null && (id = obj.getID()) != null) {
            return danglersForType.containsKey(id);
        }
        return false;
    }

    private void checkUnresolvedReferences(SchemaObject obj) {
        ArrayList<SchemaObject> originals = new ArrayList<SchemaObject>();
        ArrayList<SchemaObject> updates = new ArrayList<SchemaObject>();
        Map typeMap = this.createDanglersTypeMap(obj, null);
        for (String refType : typeMap.keySet()) {
            Map danglersForType = (Map)this.m_danglers.get(refType);
            if (danglersForType == null) continue;
            for (Map.Entry soToChildren : danglersForType.entrySet()) {
                DBObjectID key = (DBObjectID)soToChildren.getKey();
                Map kiddies = (Map)soToChildren.getValue();
                for (Map.Entry childEntry : kiddies.entrySet()) {
                    DBObjectID refererId = (DBObjectID)childEntry.getKey();
                    try {
                        DBObject referer = refererId.resolveID();
                        if (referer == null) {
                            DBLog.log("SchemaObjectManager contains unresolvable ID " + refererId, new Object[0]);
                            continue;
                        }
                        HashMap<DBObjectID, DBObjectID> replacements = null;
                        Collection refs = (Collection)childEntry.getValue();
                        if (refs != null) {
                            for (DBObjectID unresolved : refs) {
                                Collection objs = (Collection)typeMap.get(refType);
                                Iterator couldResolveIter = objs.iterator();
                                while (couldResolveIter.hasNext()) {
                                    boolean skip = false;
                                    if (referer instanceof FKConstraint && unresolved instanceof ReferenceID) {
                                        Relation rel = ((FKConstraint)referer).getRelation();
                                        ReferenceID refTabID = (ReferenceID)unresolved.getParent();
                                        if (rel.getName().equals(refTabID.getName()) && rel.getSchema().getName().equals(refTabID.getSchemaName())) {
                                            skip = true;
                                        }
                                    }
                                    DBObject couldResolve = (DBObject)couldResolveIter.next();
                                    DBObjectID id = couldResolve.getID();
                                    if (skip || !this.resolvesUnresolvedReference(id, unresolved)) continue;
                                    if (replacements == null) {
                                        replacements = new HashMap<DBObjectID, DBObjectID>();
                                    }
                                    replacements.put(unresolved, id);
                                    this.registerDependency((SchemaObject)key.resolveID(), referer, id);
                                }
                            }
                        }
                        if (replacements == null || replacements.size() <= 0) continue;
                        this.replaceReferences(originals, updates, referer, (Map<DBObjectID, DBObjectID>)replacements);
                    }
                    catch (DBException e) {
                        // empty catch block
                    }
                }
            }
        }
        if (originals.size() > 0) {
            try {
                this.updateObjects(originals, updates, false);
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.SEVERE, "Failed to update dangligngreference");
            }
        }
    }

    private Map createDanglersTypeMap(DBObject obj, Map map) {
        Map map2 = map = map != null ? map : new HashMap();
        if (this.m_danglers.containsKey(obj.getType())) {
            this.mapKeyToCollection(obj.getType(), obj, map);
        }
        DBObject[] kids = obj.getOwnedObjects();
        int i = 0;
        while (i < kids.length) {
            this.createDanglersTypeMap(kids[i], map);
            ++i;
        }
        return map;
    }

    private void replaceReferences(List<SchemaObject> originals, List<SchemaObject> updates, DBObject referer, Map<DBObjectID, DBObjectID> replacements) {
        SchemaObject soUpdateMe = null;
        SchemaObject so = null;
        ArrayList<DBObject> trail = new ArrayList<DBObject>();
        if (referer instanceof SchemaObject) {
            so = (SchemaObject)referer;
        } else {
            DBObject parent = referer;
            while (!(parent instanceof SchemaObject)) {
                trail.add(0, parent);
                parent = parent.getParent();
            }
            so = (SchemaObject)parent;
        }
        int index = originals.indexOf(so);
        if (index == -1) {
            soUpdateMe = (SchemaObject)so.copyTo(null);
            originals.add(so);
            updates.add(soUpdateMe);
        } else {
            soUpdateMe = updates.get(index);
        }
        DBObject updateReferer = this.findMatchingChild(soUpdateMe, trail);
        updateReferer.replaceReferenceIDs(replacements);
    }

    private DBObject findMatchingChild(SchemaObject copy, List<DBObject> trailToChild) {
        DBObject result = copy;
        for (DBObject child : trailToChild) {
            String childType = child.getType();
            String childName = child.getName();
            result = ModelUtil.hasLength((String)childName) ? result.findOwnedObject(childType, childName) : result.getOwnedObjects(childType)[0];
        }
        return result;
    }

    private void unregisterImpl(DBObject obj) {
        DBObjectID id = obj.getID();
        if (id != null) {
            DBObjectID[] refs = obj.getReferenceIDs();
            int i = 0;
            while (i < refs.length) {
                Collection referers;
                if (this.m_deps.containsKey(refs[i]) && (referers = (Collection)this.m_deps.get(refs[i])) != null) {
                    referers.remove(id);
                    if (referers.size() < 1) {
                        this.m_deps.remove(refs[i]);
                    }
                }
                ++i;
            }
            DBObject[] kids = obj.getOwnedObjects();
            int i2 = 0;
            while (i2 < kids.length) {
                this.unregisterImpl(kids[i2]);
                ++i2;
            }
            if (obj instanceof SchemaObject) {
                Iterator iter = this.m_soDeps.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry e = iter.next();
                    Collection referers = (Collection)e.getValue();
                    if (referers == null) continue;
                    referers.remove(id);
                    if (referers.size() >= 1) continue;
                    iter.remove();
                }
            }
        }
    }

    private void unregisterChildren(DBObject obj) {
        DBObjectID id = obj.getID();
        if (id != null) {
            if (this.m_deps.containsKey(id)) {
                Collection collection = (Collection)this.m_deps.remove(id);
            }
            DBObject[] kids = obj.getOwnedObjects();
            int i = 0;
            while (i < kids.length) {
                this.unregisterChildren(kids[i]);
                ++i;
            }
        }
    }

    private Collection getSchemaObjectReferersImpl(DBObjectID id, Collection refs) {
        Collection newRefs;
        if (id != null && (newRefs = (Collection)this.m_soDeps.get(id)) != null && newRefs.size() > 0) {
            if (refs == null) {
                refs = newRefs;
            } else {
                for (DBObjectID deepID : newRefs) {
                    if (deepID == null || refs.contains(deepID)) continue;
                    refs.add(deepID);
                    this.getSchemaObjectReferersImpl(deepID, refs);
                }
            }
        }
        return refs;
    }

    private void registerObject(SchemaObject key, DBObject obj) {
        DBObjectID[] ids = obj.getReferenceIDs();
        int i = 0;
        while (i < ids.length) {
            if (ids[i] instanceof TemporaryObjectID) {
                DBLog.getLogger().warning("WARNING: attempt to cache temporary ID with the dependency manager");
            } else if (this.supportsUnresolvedReferences() && this.isUnresolvedReference(ids[i])) {
                this.registerUnresolvedReference(key, obj, ids[i]);
            } else {
                this.registerDependency(key, obj, ids[i]);
            }
            ++i;
        }
        DBObject[] kids = obj.getOwnedObjects();
        int i2 = 0;
        while (i2 < kids.length) {
            this.registerObject(key, kids[i2]);
            ++i2;
        }
    }

    private void registerSchemaObjectDependency(SchemaObject referer, DBObjectID referedTo) {
        DBObjectID id = referer.getID();
        this.addMapping(id, referedTo, this.m_soDeps);
    }

    private void registerDependency(SchemaObject key, DBObject referer, DBObjectID referedTo) {
        DBObjectID id = referer.getID();
        if (!(referedTo instanceof DataTypeID)) {
            this.addMapping(id, referedTo, this.m_deps);
            DBObjectID referedToParent = this.getParent(referedTo);
            if (referedToParent != null && key != null) {
                this.registerSchemaObjectDependency(key, referedToParent);
            }
        }
    }

    private DBObjectID getParent(DBObjectID id) {
        DBObjectID par = id.getParent();
        if (par != null) {
            return this.getParent(par);
        }
        return id;
    }

    private void addMapping(DBObjectID id, DBObjectID refID, Map deps) {
        if (refID != null && id != null && !refID.equals(id)) {
            this.mapKeyToCollection(refID, id, deps);
        }
    }

    private void mapKeyToCollection(Object key, Object itemForCollection, Map map) {
        HashSet<Object> c = (HashSet<Object>)map.get(key);
        if (c == null) {
            c = new HashSet<Object>();
            map.put(key, c);
        }
        c.add(itemForCollection);
    }

    private void registerUnresolvedReference(SchemaObject key, DBObject referer, DBObjectID ref) {
        HashSet<DBObjectID> referers;
        HashMap childObjectRefs;
        DBObjectID soID = key.getID();
        DBObjectID id = referer.getID();
        String refType = ref.getType();
        HashMap danglersForType = (HashMap)this.m_danglers.get(refType);
        if (danglersForType == null) {
            danglersForType = new HashMap();
            this.m_danglers.put(refType, danglersForType);
        }
        if ((childObjectRefs = (HashMap)danglersForType.get(soID)) == null) {
            childObjectRefs = new HashMap();
            danglersForType.put(soID, childObjectRefs);
        }
        if ((referers = (HashSet<DBObjectID>)childObjectRefs.get(id)) == null) {
            referers = new HashSet<DBObjectID>();
            childObjectRefs.put(id, referers);
        }
        if (!referers.contains(ref)) {
            referers.add(ref);
        }
    }

    protected void updateObjects(List<SchemaObject> originals, List<SchemaObject> updates, boolean bulkOperation) throws DBException {
        int i = 0;
        while (i < originals.size()) {
            SchemaObject orig = originals.get(i);
            SchemaObject update = updates.get(i);
            update.copyTo(orig);
            DBObjectChange.fireObjectUpdated(orig);
            ++i;
        }
    }

    public void doCascadeDelete(SchemaObject deleted, SchemaObject referer) throws DBException {
        SchemaObject updated = this.cascadeDelete(deleted, referer);
        if (updated != null) {
            this.updateObjects(Arrays.asList(referer), Arrays.asList(updated), true);
        }
    }

    public SchemaObject cascadeDelete(DBObject deleted, SchemaObject referer) {
        return this.cascadeDelete(deleted, referer, true);
    }

    public SchemaObject cascadeDelete(DBObject deleted, SchemaObject referer, boolean copyIfCascadeRequired) {
        DBObjectID refID;
        SchemaObject schemaObject = DBUtil.getSchemaObject(deleted);
        SchemaObject updated = null;
        if (referer instanceof View || referer instanceof MaterializedView) {
            SQLQuery query = ((SQLQueryOwner)((Object)referer)).getSQLQuery();
            if (query != null && !(query instanceof NonDeclarativeSQLQuery)) {
                updated = this.copyIfRequired(updated, referer, copyIfCascadeRequired);
                SQLQueryOwner updatedOwner = (SQLQueryOwner)((Object)updated);
                String sqlText = query.getSQLText();
                SelectObject[] so = query.getSelectObjects();
                if (so == null || so.length == 0) {
                    StringBuilder sb = new StringBuilder();
                    int pos = sqlText.toUpperCase().indexOf("SELECT");
                    sb.append(sqlText.substring(0, pos + 6)).append(" *").append(sqlText.substring(pos + 6));
                    sqlText = sb.toString();
                }
                NonDeclarativeSQLQuery newQuery = new NonDeclarativeSQLQuery(sqlText);
                updatedOwner.setSQLQuery(newQuery);
                ((Relation)updated).setColumns(null);
            }
        } else if (referer instanceof Table) {
            if (deleted instanceof ComplexType) {
                Column[] cols = ((Relation)referer).getColumns();
                ArrayList<Column> colsGone = new ArrayList<Column>();
                int k = 0;
                while (k < cols.length) {
                    DBObjectID id = cols[k].getDataTypeUsage().getDataTypeID();
                    if (id != null && id.equals(deleted.getID())) {
                        colsGone.add(cols[k]);
                    }
                    ++k;
                }
                if (colsGone.size() > 0) {
                    updated = this.copyIfRequired(updated, referer, copyIfCascadeRequired);
                    Table updatedTable = (Table)updated;
                    for (Column colByeBye : colsGone) {
                        updatedTable.removeColumn(updatedTable.getColumn(colByeBye.getName()));
                    }
                }
            } else if (deleted instanceof Sequence || deleted instanceof Trigger) {
                Column[] columnArray = ((Relation)referer).getColumns();
                int n = 0;
                while (n < columnArray.length) {
                    Column column = columnArray[n];
                    DBObjectID id = (DBObjectID)column.getProperty(deleted instanceof Sequence ? "AUTO_GENERATED_SEQUENCE" : "AUTO_GENERATED_SEQUENCE_TRIGGER");
                    if (id != null && id.equals(deleted.getID())) {
                        updated = this.copyIfRequired(updated, referer, copyIfCascadeRequired);
                        Table updatedTable = (Table)updated;
                        Column updateCol = updatedTable.getColumn(column.getName());
                        updateCol.setProperty("AUTO_GENERATED_SEQUENCE", null);
                        updateCol.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", null);
                    }
                    ++n;
                }
            }
        } else if (referer instanceof Synonym && schemaObject == deleted && (refID = ((Synonym)referer).getReference()) != null && refID.equals(schemaObject.getID())) {
            updated = this.copyIfRequired(updated, referer, copyIfCascadeRequired);
            Synonym updatedSynonym = (Synonym)updated;
            ReferenceID newID = new ReferenceID(schemaObject);
            updatedSynonym.setReference(newID);
        }
        if (referer instanceof Relation && schemaObject instanceof Relation) {
            ArrayList<String> removedCons = new ArrayList<String>();
            ArrayList removedCols = new ArrayList();
            if (deleted == schemaObject) {
                Constraint[] cons = ((Relation)schemaObject).getConstraints();
                int i = 0;
                while (i < cons.length) {
                    if (cons[i] instanceof UniqueConstraint) {
                        this.cascadeConstraintRemove((Relation)referer, (UniqueConstraint)cons[i], removedCons);
                    }
                    ++i;
                }
            } else if (deleted instanceof UniqueConstraint) {
                this.cascadeConstraintRemove((Relation)referer, (UniqueConstraint)deleted, removedCons);
            } else if (deleted instanceof Column && referer instanceof Table) {
                Constraint[] constraintArray = ((Relation)referer).getConstraints();
                int n = 0;
                while (n < constraintArray.length) {
                    Constraint con = constraintArray[n];
                    if (con instanceof ColumnConstraint) {
                        DBObjectID[] ids;
                        DBObjectID[] dBObjectIDArray = ids = ((ColumnConstraint)con).getColumnIDs();
                        int n2 = 0;
                        while (n2 < dBObjectIDArray.length) {
                            DBObjectID refColID = dBObjectIDArray[n2];
                            if (refColID.equals(deleted.getID(), false)) {
                                removedCons.add(con.getName());
                            }
                            ++n2;
                        }
                    }
                    ++n;
                }
            }
            if (removedCons.size() > 0) {
                updated = this.copyIfRequired(updated, referer, copyIfCascadeRequired);
                Relation updatedRelation = (Relation)updated;
                for (String conName : removedCons) {
                    updatedRelation.removeConstraint(updatedRelation.getConstraint(conName));
                }
            }
        }
        return updated;
    }

    private SchemaObject copyIfRequired(SchemaObject updated, SchemaObject referer, boolean copy) {
        if (updated == null) {
            updated = copy ? DBUtil.makeTemporaryCopy(referer) : referer;
        }
        return updated;
    }

    private void cascadeConstraintRemove(Relation referer, UniqueConstraint uniqueCon, List<String> removed) {
        Constraint[] constraintArray = referer.getConstraints();
        int n = 0;
        while (n < constraintArray.length) {
            DBObjectID refID;
            Constraint refCon = constraintArray[n];
            if (refCon instanceof FKConstraint && (refID = ((FKConstraint)refCon).getReferenceID()).equals(uniqueCon.getID(), true)) {
                removed.add(refCon.getName());
            }
            ++n;
        }
    }

    protected void checkInit() {
    }

    protected final synchronized void registerAllObjects() {
        try {
            this.clearAllCaches();
            this.m_registeredAll = true;
            String[] types = this.listObjectTypes();
            Schema[] schemas = this.listSchemas();
            int i = 0;
            while (i < schemas.length) {
                this.setRegisterProgress(0, 1, i, schemas.length, schemas[i].getName());
                SchemaObject[] objects = this.m_provider.listObjects(types, schemas[i]);
                int j = 0;
                while (j < objects.length) {
                    this.setRegisterProgress(j, objects.length, i, schemas.length, schemas[i].getName());
                    this.registerObject(objects[j]);
                    ++j;
                }
                ++i;
            }
        }
        catch (DBException dbe) {
            DBLog.logStackTrace(dbe);
            this.m_registeredAll = false;
        }
    }

    protected String[] listObjectTypes() {
        ArrayList<String> retval = new ArrayList<String>();
        String[] t = this.m_provider.listObjectTypes();
        int i = 0;
        while (i < t.length) {
            retval.add(t[i]);
            ++i;
        }
        retval.remove("SEQUENCE");
        retval.remove("PACKAGE");
        retval.remove("FUNCTION");
        retval.remove("PROCEDURE");
        return retval.toArray(new String[retval.size()]);
    }

    protected Schema[] listSchemas() throws DBException {
        return this.m_provider.listSchemas();
    }

    protected void setRegisterProgress(int objN, int objT, int schemaN, int schemaT, String schemaName) {
    }

    public static final SchemaObject[] getDependencies(SchemaObject obj, DBObjectProvider pro, boolean recurse) {
        HashSet<SchemaObject> deps = new HashSet<SchemaObject>();
        deps.add(obj);
        SchemaObjectManager.addDependencies(deps, obj, pro, recurse);
        deps.remove(obj);
        return deps.toArray(new SchemaObject[deps.size()]);
    }

    private static final void addDependencies(Set deps, DBObject obj, DBObjectProvider pro, boolean recurse) {
        DBObjectID[] refs = obj.getReferenceIDs();
        int i = 0;
        while (i < refs.length) {
            try {
                DBObject refobj = refs[i].resolveID();
                if (refobj == null) {
                    DBLog.getLogger().log(DBLog.getTraceLogLevel(), "SchemaObjectManager: reference type {0} resolved to null on {1}", new Object[]{refs[i].getClass(), DBUtil.getFullyQualifiedName(obj)});
                } else {
                    SchemaObject parent = DBUtil.getSchemaObject(refobj);
                    if (parent != null && !deps.contains(parent)) {
                        deps.add(parent);
                        if (recurse) {
                            SchemaObjectManager.addDependencies(deps, parent, pro, recurse);
                        }
                    }
                }
            }
            catch (DBException e) {
                DBLog.log("SchemaObjectManager: failed to resolve reference on " + DBUtil.getFullyQualifiedName(obj), new Object[0]);
            }
            ++i;
        }
        if (obj instanceof SQLQueryOwner) {
            SQLQuery query = ((SQLQueryOwner)obj).getSQLQuery();
        }
        DBObject[] kids = obj.getOwnedObjects();
        int i2 = 0;
        while (i2 < kids.length) {
            DBObject child;
            block15: {
                child = kids[i2];
                if (child instanceof NonDeclarativeSQLQuery) {
                    try {
                        SQLQueryBuilder b = SQLQueryBuilderFactory.createBuilder(pro, pro.getDefaultSchema());
                        if (b == null) break block15;
                        try {
                            b.buildQuery((NonDeclarativeSQLQuery)child);
                        }
                        catch (SQLQueryException sqe) {
                            // empty catch block
                        }
                        AbstractSQLQuery newQuery = b.getSQLQuery();
                        if (newQuery != null) {
                            child = newQuery;
                        }
                    }
                    catch (DBException dbe) {
                        // empty catch block
                    }
                }
            }
            SchemaObjectManager.addDependencies(deps, child, pro, recurse);
            ++i2;
        }
    }
}

