/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ViewColumn;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Relation
extends AbstractSchemaObject {
    protected Relation() {
    }

    protected Relation(String name, Schema schema) {
        super(name, schema);
    }

    public void setColumns(Column[] newCols) {
        this.checkInit("COLUMN");
        this.getChildSupport().setChildArray(Column.class, newCols);
    }

    public Column[] getColumns() {
        this.checkInit("COLUMN");
        return (Column[])this.getChildSupport().getChildArray(Column.class);
    }

    public void addColumn(Column col) {
        this.checkInit("COLUMN");
        this.getChildSupport().addChild(col);
    }

    public void addColumn(int index, Column col) {
        this.checkInit("COLUMN");
        this.getChildSupport().addChild(index, col);
    }

    public Column getColumn(String name) {
        this.checkInit("COLUMN");
        if (name != null) {
            Column[] columnArray = this.getColumns();
            int n = 0;
            while (n < columnArray.length) {
                Column curr = columnArray[n];
                String colName = curr.getName();
                if (curr instanceof ViewColumn && colName.contains(".")) {
                    colName = colName.substring(colName.indexOf(".") + 1);
                }
                if (ModelUtil.areEqual((Object)colName, (Object)name)) {
                    return curr;
                }
                ++n;
            }
        }
        return null;
    }

    public void removeColumn(Column col) {
        this.checkInit("COLUMN");
        this.getChildSupport().removeChild(col);
    }

    public Constraint[] getConstraints() {
        this.checkInit("CONSTRAINT");
        return (Constraint[])this.getChildSupport().getChildArray(Constraint.class);
    }

    public void setConstraints(Constraint[] constraints) {
        this.checkInit("CONSTRAINT");
        this.getChildSupport().setChildArray(Constraint.class, constraints);
    }

    public Constraint getConstraint(String name) {
        this.checkInit("CONSTRAINT");
        return this.getChildSupport().findChild(Constraint.class, name);
    }

    public void addConstraint(Constraint constraint) {
        this.checkInit("CONSTRAINT");
        this.getChildSupport().addChild(Constraint.class, constraint);
    }

    public void removeConstraint(Constraint constraint) {
        this.checkInit("CONSTRAINT");
        this.getChildSupport().removeChild(Constraint.class, constraint);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> c, String ... types) {
        super.getOwnedObjectsImpl(c, types);
        if (types != null) {
            Constraint[] constraintArray = this.getConstraints();
            int n = 0;
            while (n < constraintArray.length) {
                Constraint con = constraintArray[n];
                if (this.includesType(con.getConstraintType(), types)) {
                    c.add(con);
                }
                ++n;
            }
        }
    }

    static boolean isRelation(String type) {
        return type == null || type.equals("TABLE") || type.equals("VIEW");
    }
}

