/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.ColumnConstraintReferenceID;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.MissingProviderException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.util.ModelUtil;

public class ReferenceID
extends BaseObjectID
implements ColumnConstraintReferenceID {
    private String m_subtype;
    private String m_dbName;
    private Object m_identifier;
    private List<String> m_childObjectNames;

    private void $init$() {
        this.m_childObjectNames = new ArrayList<String>();
    }

    public ReferenceID() {
        this.$init$();
    }

    public ReferenceID(DBObjectID id) {
        this(id, null);
    }

    public ReferenceID(DBObjectID id, DBObjectProvider pro) {
        this.$init$();
        DBObject obj = null;
        try {
            obj = id.resolveID();
        }
        catch (DBException dbe) {
            // empty catch block
        }
        this.initialise(obj, id, pro);
    }

    public ReferenceID(DBObject obj) {
        this.$init$();
        this.initialise(obj, obj.getID(), null);
    }

    public ReferenceID(DBObject obj, DBObjectProvider pro) {
        this.$init$();
        this.initialise(obj, obj.getID(), pro);
    }

    public ReferenceID(String type, String schemaName, String name) {
        this(type, schemaName, null, name, null, null, null);
    }

    public ReferenceID(String type, Schema schema, String name) {
        this(type, schema, name, null);
    }

    public ReferenceID(String type, Schema schema, String name, String dbName) {
        this(type, null, null, name, null, dbName, null);
        this.setSchema(schema);
    }

    public ReferenceID(String type, DBObjectID parent, String name, String subtype, String[] childObjectNames) {
        this(type, null, parent, name, subtype, null, childObjectNames);
    }

    private ReferenceID(String type, String schemaName, DBObjectID parent, String name, String subtype, String dbName, String[] childObjectNames) {
        this.$init$();
        this.setType(type);
        this.setName(name);
        this.setSchemaName(schemaName);
        this.setParent(parent);
        this.setChildObjectNames(childObjectNames);
        this.m_dbName = dbName;
        this.m_subtype = subtype;
    }

    public void construct(String id) {
        String[] items = id.split(":");
        if (items.length > 3) {
            this.setType(" ".equals(items[0]) ? null : items[0]);
            this.setSchemaName(" ".equals(items[1]) ? null : items[1]);
            this.setName(" ".equals(items[2]) ? null : items[2]);
            this.setDatabaseName(" ".equals(items[3]) ? null : items[3]);
        }
        StringBuilder parentIdBuilder = new StringBuilder();
        int index = 4;
        while (index < items.length) {
            parentIdBuilder.append(items[index]);
            if (index < items.length - 1) {
                parentIdBuilder.append(":");
            }
            ++index;
        }
        if (parentIdBuilder.length() > 0) {
            this.setParent(BaseObjectID.createFromString(parentIdBuilder.toString()));
        }
    }

    private void initialise(DBObject obj, DBObjectID id, DBObjectProvider pro) {
        if (obj != null) {
            this.initialise(obj);
        } else if (id instanceof BaseObjectID) {
            id.copyTo(this);
        }
        if (pro instanceof AbstractDBObjectProvider) {
            this.setProviderImpl((AbstractDBObjectProvider)pro);
        }
        if (id instanceof IdentifierBasedID) {
            this.m_identifier = ((IdentifierBasedID)id).getIdentifier();
        }
    }

    private void initialise(DBObject obj) {
        DBObject objPar = obj.getParent();
        if (objPar != null) {
            this.setParent(new ReferenceID(objPar));
        }
        this.setType(obj.getType());
        this.setName(obj.getName());
        if (obj instanceof SchemaObject) {
            this.setSchema(((SchemaObject)obj).getSchema());
        }
        if (obj instanceof Constraint) {
            this.setSubType(((Constraint)obj).getConstraintType());
        } else if (obj instanceof ComplexType) {
            this.setSubType(((ComplexType)obj).getCollectionType());
        }
        if (obj instanceof ColumnConstraint) {
            Column[] columnArray = ((ColumnConstraint)obj).getColumns();
            int n = 0;
            while (n < columnArray.length) {
                Column c = columnArray[n];
                this.addChildObjectName(c);
                ++n;
            }
        }
    }

    public final String[] getChildObjectNames() {
        return this.m_childObjectNames.toArray(new String[this.m_childObjectNames.size()]);
    }

    public final void setChildObjectNames(String[] names) {
        this.m_childObjectNames.clear();
        if (names != null) {
            String[] stringArray = names;
            int n = 0;
            while (n < stringArray.length) {
                String s = stringArray[n];
                this.m_childObjectNames.add(s);
                ++n;
            }
        }
    }

    public final String getSubType() {
        return this.m_subtype;
    }

    public final void setSubType(String subType) {
        this.m_subtype = subType;
    }

    public final String getDatabaseName() {
        return this.m_dbName;
    }

    public final void setDatabaseName(String linkName) {
        this.m_dbName = linkName;
    }

    public final Object getIdentifier() {
        return this.m_identifier;
    }

    public final void setIdentifier(Object obj) {
        this.m_identifier = obj;
    }

    @Deprecated
    public final DBObject resolveReference(Database db) {
        try {
            DBObject dBObject = DBUtil.resolveInOtherProvider(this, db);
            return dBObject;
        }
        catch (DBException dbe) {
            DBObject dBObject = null;
            return dBObject;
        }
    }

    @Deprecated
    public final DBObjectID getNewID() {
        return null;
    }

    @Deprecated
    public final String[] getColumnNames() {
        return this.getChildObjectNames();
    }

    protected boolean equalsImpl(DBObjectID id, boolean strict) {
        Object ident;
        if (strict) {
            return id instanceof ReferenceID && this.equalsImpl((ReferenceID)id);
        }
        if (id instanceof IdentifierBasedID && this.m_identifier != null && (ident = ((IdentifierBasedID)id).getIdentifier()) != null && this.m_identifier != null && ident.getClass() == this.m_identifier.getClass() && ModelUtil.areEqual((Object)this.getType(), (Object)id.getType()) && ident.equals(this.m_identifier)) {
            return true;
        }
        if (id instanceof BaseObjectID && this.hasSameObjectName((BaseObjectID)id)) {
            return true;
        }
        try {
            DBObject obj = id.resolveID();
            if (obj != null && ModelUtil.areEqual((Object)this.getName(), (Object)obj.getName()) && ModelUtil.areEqual((Object)this.getType(), (Object)obj.getType())) {
                if (obj instanceof SchemaObject) {
                    Schema schema = ((SchemaObject)obj).getSchema();
                    boolean bl = schema != null && ModelUtil.areEqual((Object)schema.getName(), (Object)this.getSchemaName());
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (DBException dbe) {
            // empty catch block
        }
        return false;
    }

    protected boolean equalsImpl(ReferenceID id) {
        return super.equalsImpl(id) && ModelUtil.areEqual((Object)id.m_subtype, (Object)this.m_subtype) && ModelUtil.areEqual(id.m_childObjectNames, this.m_childObjectNames) && ModelUtil.areEqual((Object)id.m_dbName, (Object)this.m_dbName) && ModelUtil.areEqual((Object)id.m_identifier, (Object)this.m_identifier);
    }

    public Object copyTo(Object target) {
        if (target instanceof BaseObjectID && !(target instanceof ReferenceID)) {
            this.copyToImpl((BaseObjectID)target);
            return target;
        }
        ReferenceID copy = target == null ? new ReferenceID() : (ReferenceID)target;
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(ReferenceID target) {
        super.copyToImpl(target);
        target.m_identifier = this.m_identifier;
        target.m_dbName = this.m_dbName;
        target.m_subtype = this.m_subtype;
        target.setChildObjectNames(this.getChildObjectNames());
    }

    protected String toStringImpl() {
        StringBuilder builder = new StringBuilder();
        String type = this.getType();
        String sName = this.getSchemaName();
        String name = this.getName();
        String dName = this.getDatabaseName();
        builder.append(ModelUtil.hasLength((String)type) ? type : " ").append(":");
        builder.append(ModelUtil.hasLength((String)sName) ? sName : " ").append(":");
        builder.append(ModelUtil.hasLength((String)name) ? name : " ").append(":");
        builder.append(ModelUtil.hasLength((String)dName) ? dName : " ");
        if (this.getParent() instanceof BaseObjectID) {
            builder.append(":").append(this.getParent().toString());
        }
        return builder.toString();
    }

    public DBObject resolveID() throws DBException {
        if (this.getParent() == null && this.getType() == null) {
            return this.resolveIDWithoutType();
        }
        try {
            DBObject dBObject = super.resolveID();
            return dBObject;
        }
        catch (MissingProviderException mpe) {
            DBObject dBObject = null;
            return dBObject;
        }
    }

    private DBObject resolveIDWithoutType() throws DBException {
        Schema s;
        SchemaObject retval = null;
        String schemaName = this.getSchemaName();
        String name = this.getName();
        DBObjectProvider pro = this.getProvider();
        if (pro != null && ModelUtil.hasLength((String)schemaName) && ModelUtil.hasLength((String)name) && (s = pro.getSchema(schemaName)) != null && (retval = pro.getObject("TABLE", s, name)) == null) {
            String[] types = pro.listObjectTypes();
            int i = 0;
            while (i < types.length && retval == null) {
                if (!types[i].equals("TABLE")) {
                    retval = pro.getObject(types[i], s, name);
                }
                ++i;
            }
        }
        return retval;
    }

    public void addChildObjectName(DBObjectID id) {
        String name;
        if (id instanceof BaseObjectID && ModelUtil.hasLength((String)(name = ((BaseObjectID)id).getName()))) {
            this.addChildObjectName(name);
            return;
        }
        try {
            DBObject obj = id.resolveID();
            if (obj != null) {
                this.addChildObjectName(obj);
                return;
            }
        }
        catch (DBException dbe) {
            // empty catch block
        }
    }

    public void addChildObjectName(DBObject obj) {
        if (obj != null) {
            this.addChildObjectName(obj.getName());
        }
    }

    public void addChildObjectName(String name) {
        this.m_childObjectNames.add(name);
    }
}

