/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.util.ModelUtil;

public abstract class PlSql
extends AbstractSchemaObject
implements SourceObject {
    private String m_source;
    private PlSqlInterrogator m_interrogator;
    public static final String BLOCK_TYPE = "BLOCK";

    public PlSql() {
    }

    public PlSql(String name, Schema schema) {
        super(name, schema);
    }

    protected void copyToImpl(PlSql copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        copy.m_source = this.m_source;
    }

    protected boolean equalsImpl(PlSql target) {
        return super.equalsImpl(target) && ModelUtil.areEqual((Object)this.m_source, (Object)target.m_source);
    }

    public String getSource() {
        this.checkInit();
        return this.m_source;
    }

    public void setSource(String source) {
        this.checkInit();
        this.m_source = source;
        this.m_interrogator = null;
    }

    public static final boolean isPlSql(String objType) {
        return "PACKAGE".equals(objType) || "TYPE".equals(objType) || "FUNCTION".equals(objType) || "PROCEDURE".equals(objType);
    }

    public PlSqlInterrogator getSourceInterrogator() {
        this.checkInit();
        if (this.m_interrogator == null) {
            this.m_interrogator = PlSqlInterrogator.findOrCreate(this.m_source);
        }
        if (this.m_interrogator == null) {
            DBLog.getLogger().log(DBLog.getTraceLogLevel(), "BUG6189001 PlSql.getSourceInterrogator returning null");
        }
        return this.m_interrogator;
    }
}

