/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import oracle.javatools.db.BinaryObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Java;
import oracle.javatools.db.Schema;

public class JavaResource
extends Java
implements BinaryObject {
    public static final String TYPE = "JAVA RESOURCE";
    private byte[] m_bytes;

    public JavaResource() {
    }

    public JavaResource(String name, Schema schema) {
        super(name, schema);
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        JavaResource copy = target != null ? (JavaResource)target : new JavaResource();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    public boolean equals(Object target) {
        return target instanceof JavaResource && this.equalsImpl((JavaResource)target);
    }

    protected void copyToImpl(JavaResource copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        copy.m_bytes = this.m_bytes;
    }

    protected boolean equalsImpl(JavaResource target) {
        return super.equalsImpl(target) && Arrays.equals(this.m_bytes, target.m_bytes);
    }

    public String getType() {
        return TYPE;
    }

    public byte[] getBytes() {
        this.checkInit();
        return this.m_bytes;
    }

    public void setBytes(byte[] bytes) {
        this.checkInit();
        this.m_bytes = bytes;
    }

    public InputStream getInputStream() {
        this.checkInit();
        return new ByteArrayInputStream(this.m_bytes);
    }
}

