/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index
extends AbstractSchemaObject
implements ChildDBObject {
    public static final String TYPE = "INDEX";
    private IndexType m_indexType;
    private transient Table m_table;
    private DBObjectID m_domainIndextype;
    private String m_domainIndextypeParameters;
    private String m_domainIndextypeOpStatus;
    private int m_parallelDegree;
    private Integer m_keyCompression;

    private void $init$() {
        this.m_parallelDegree = 1;
        this.m_keyCompression = null;
    }

    public Index() {
        this.$init$();
    }

    public Index(String name, Table table) {
        super(name, table == null ? null : table.getSchema());
        this.$init$();
        this.m_table = table;
        if (this.m_table != null) {
            this.m_table.addIndex(this);
        }
    }

    public Index(String name, Schema schema) {
        super(name, schema);
        this.$init$();
    }

    public Index(String name, Schema schema, Table table) {
        super(name, schema);
        this.$init$();
        this.m_table = table;
        if (this.m_table != null) {
            this.m_table.addIndex(this);
        }
        this.setSchema(schema);
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        Index copy = target != null ? (Index)target : new Index();
        this.copyToImpl(copy, (Table)copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(Index copy, Table copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, (DBObject)copyParent, idPolicy);
        copy.m_table = copyParent;
        copy.m_indexType = this.m_indexType;
        copy.m_table = this.m_table;
        copy.m_domainIndextype = this.m_domainIndextype;
        copy.m_domainIndextypeOpStatus = this.m_domainIndextypeOpStatus;
        copy.m_domainIndextypeParameters = this.m_domainIndextypeParameters;
        copy.m_parallelDegree = this.m_parallelDegree;
        copy.m_keyCompression = this.m_keyCompression;
    }

    public boolean equals(Object target) {
        return target instanceof Index && this.equalsImpl((Index)target);
    }

    protected boolean equalsImpl(Index target) {
        return super.equalsImpl(target) && this.m_indexType == target.m_indexType && this.m_parallelDegree == target.m_parallelDegree && this.m_keyCompression == target.m_keyCompression && ModelUtil.areEqual((Object)this.m_domainIndextype, (Object)target.m_domainIndextype) && ModelUtil.areEqual((Object)this.m_domainIndextypeOpStatus, (Object)target.m_domainIndextypeOpStatus) && ModelUtil.areEqual((Object)this.m_domainIndextypeParameters, (Object)target.m_domainIndextypeParameters);
    }

    public IndexType getIndexType() {
        this.checkInit();
        return this.m_indexType;
    }

    public DBObjectID getDomainIndextype() {
        this.checkInit();
        return this.m_domainIndextype;
    }

    public String getDomainIndextypeParameters() {
        this.checkInit();
        return this.m_domainIndextypeParameters;
    }

    public String getDomainIndextypeOpStatus() {
        this.checkInit();
        return this.m_domainIndextypeOpStatus;
    }

    public int getParallelDegree() {
        this.checkInit();
        return this.m_parallelDegree;
    }

    public void setIndexType(IndexType indexType) {
        this.checkInit();
        this.m_indexType = indexType;
    }

    public void setDomainIndextype(DBObjectID id) {
        this.checkInit();
        this.m_domainIndextype = id;
    }

    public void setDomainIndextypeParameters(String parameters) {
        this.checkInit();
        this.m_domainIndextypeParameters = parameters;
    }

    public void setDomainIndextypeOpStatus(String status) {
        this.checkInit();
        this.m_domainIndextypeOpStatus = status;
    }

    public void setParallelDegree(int value) {
        this.checkInit();
        this.m_parallelDegree = value;
    }

    public void setKeyCompression(Integer keyCompression) {
        this.checkInit();
        this.m_keyCompression = keyCompression;
    }

    public Integer getKeyCompression() {
        this.checkInit();
        return this.m_keyCompression;
    }

    public void setTable(Table table) {
        Table oldTable = this.m_table;
        if (this.m_table != table) {
            this.m_table = table;
            Schema s = this.getSchema();
            if (s != null && this.m_table != null) {
                Schema tabSchema = this.m_table.getSchema();
                if (tabSchema != null && ModelUtil.areEqual((Object)s.getName(), (Object)tabSchema.getName())) {
                    this.setSchema(null);
                }
            } else if (s == null && table == null && oldTable != null) {
                super.setSchema(oldTable.getSchema());
            }
        }
    }

    @Transient
    public Table getTable() {
        this.checkInit();
        return this.m_table;
    }

    @Override
    @Transient
    public DBObject getParent() {
        return this.getTable();
    }

    @Override
    @Transient
    public void setParent(DBObject par) {
        if (par instanceof Table) {
            this.m_table = (Table)par;
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setColumnExpressions(IndexObject[] colExprs) {
        this.checkInit();
        this.getChildSupport().setChildArray(IndexObject.class, colExprs);
    }

    public IndexObject[] getColumnExpressions() {
        this.checkInit();
        return (IndexObject[])this.getChildSupport().getChildArray(IndexObject.class);
    }

    public void addColumnExpression(IndexObject colExpr) {
        this.checkInit();
        this.getChildSupport().addChild(colExpr);
    }

    public void addColumnExpression(int posn, IndexObject colExpr) {
        this.checkInit();
        this.getChildSupport().addChild(posn, colExpr);
    }

    public void removeColumnExpression(IndexObject colExpr) {
        this.checkInit();
        this.getChildSupport().removeChild(colExpr);
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        if (this.m_domainIndextype != null) {
            refs.add(this.m_domainIndextype);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        if (this.m_domainIndextype != null && idMap.containsKey(this.m_domainIndextype)) {
            this.m_domainIndextype = idMap.get(this.m_domainIndextype);
            replaced = true;
        }
        return replaced;
    }

    @Override
    public Schema getSchema() {
        Schema s = super.getSchema();
        if (s == null && this.m_table != null) {
            return this.m_table.getSchema();
        }
        return s;
    }

    @Override
    public void setSchema(Schema s) {
        if (this.m_table == null || ModelUtil.areDifferent((Object)s, (Object)this.m_table.getSchema())) {
            super.setSchema(s);
        } else {
            super.setSchema(null);
        }
    }

    @Transient
    @Deprecated
    public void setColumns(Column[] cols) {
        Column[] columnArray = cols;
        int n = 0;
        while (n < columnArray.length) {
            Column col = columnArray[n];
            String name = col.getName();
            if (ModelUtil.hasLength((String)name)) {
                IndexObject io = new IndexObject(new SimpleSQLFragment(name));
                this.addColumnExpression(io);
            }
            ++n;
        }
    }

    @Transient
    @Deprecated
    public Column[] getColumns() {
        return null;
    }

    @Deprecated
    public void addColumn(Column col) {
    }

    @Deprecated
    public void removeColumn(Column col) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IndexType
    extends Enum<IndexType> {
        private static final /* synthetic */ IndexType[] $v;
        public static final /* enum */ IndexType NORMAL;
        public static final /* enum */ IndexType UNIQUE;
        public static final /* enum */ IndexType BITMAP;
        public static final /* enum */ IndexType DOMAIN;

        public static IndexType valueOf(String string) {
            return Enum.valueOf(IndexType.class, string);
        }

        public static final IndexType[] values() {
            return (IndexType[])$v.clone();
        }

        static {
            IndexType[] indexTypeArray = new IndexType[4];
            indexTypeArray[3] = DOMAIN = new IndexType("DOMAIN", 3);
            indexTypeArray[2] = BITMAP = new IndexType("BITMAP", 2);
            indexTypeArray[1] = UNIQUE = new IndexType("UNIQUE", 1);
            indexTypeArray[0] = NORMAL = new IndexType("NORMAL", 0);
            $v = indexTypeArray;
        }

        public static IndexType migrate(String old) {
            try {
                int i = Integer.valueOf(old.toString());
                switch (i) {
                    case 2: {
                        IndexType indexType = UNIQUE;
                        return indexType;
                    }
                    case 3: {
                        IndexType indexType = BITMAP;
                        return indexType;
                    }
                    case 4: {
                        IndexType indexType = DOMAIN;
                        return indexType;
                    }
                }
                IndexType indexType = NORMAL;
                return indexType;
            }
            catch (Exception e) {
                IndexType indexType = null;
                return indexType;
            }
        }

        private IndexType(String string2, int n2) {
        }
    }
}

