/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBCore;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderFactory;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatabaseFactory
extends DBObjectProviderFactory.Creator {
    private List<ConnectionCreator> m_connCreators;
    private List<DatabaseCreator> m_dbCreators;
    private DatabaseCreator m_jdbcDatabaseCreator;

    private void $init$() {
        this.m_connCreators = new ArrayList<ConnectionCreator>();
        this.m_dbCreators = new ArrayList<DatabaseCreator>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static DatabaseFactory getInstance() {
        DBCore core = DBCore.getInstance();
        Class<DatabaseFactory> clazz = DatabaseFactory.class;
        synchronized (DatabaseFactory.class) {
            DatabaseFactory df = core.get(DatabaseFactory.class);
            if (df == null) {
                df = new DatabaseFactory();
                core.put(df);
            }
            DatabaseFactory databaseFactory = df;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return databaseFactory;
        }
    }

    private DatabaseFactory() {
        this.$init$();
    }

    @Override
    protected Object getCacheKey(Object identifier, DBObjectProvider pro) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final DBObjectProvider createProviderImpl(Object identifier) throws DBException {
        if (identifier instanceof String) {
            String connName = (String)identifier;
            Iterator<ConnectionCreator> iterator = DatabaseFactory.getConnectionCreators().iterator();
            while (iterator.hasNext()) {
                ConnectionCreator factory;
                ConnectionCreator connectionCreator = factory = iterator.next();
                synchronized (connectionCreator) {
                    Database cached = factory.findDatabase(connName);
                    if (cached != null) {
                        Database database = cached;
                        return database;
                    }
                    Database db = DatabaseFactory.createDatabase(connName, factory);
                    if (db != null) {
                        Database database = db;
                        return database;
                    }
                }
            }
        }
        return null;
    }

    public static Database createDatabase(String connName, ConnectionCreator factory) throws DBException {
        Connection conn = DatabaseFactory.createConnection(connName, factory);
        if (conn != null) {
            String storeName = factory.getStoreName();
            Database db = DatabaseFactory.getInstance().createDatabaseImpl(storeName, connName, conn);
            if (db != null) {
                factory.cacheDatabase(connName, db);
                return db;
            }
        }
        return null;
    }

    private Database createDatabaseImpl(String store, String name, Connection conn) throws DBException {
        for (DatabaseCreator c : DatabaseFactory.getDatabaseCreators()) {
            Database db = c.createDatabaseImpl(store, name, conn);
            if (db == null) continue;
            return db;
        }
        DatabaseCreator jdbc = DatabaseFactory.getInstance().getJdbcCreator();
        if (jdbc != null) {
            return jdbc.createDatabaseImpl(store, name, conn);
        }
        return null;
    }

    @Override
    protected DBObjectProvider findProvider(Object identifier) {
        if (identifier instanceof String) {
            for (ConnectionCreator cc : DatabaseFactory.getConnectionCreators()) {
                Database db = cc.findDatabase((String)identifier);
                if (db == null) continue;
                return db;
            }
        }
        return null;
    }

    @Override
    protected DBObjectProvider uncacheProvider(Object identifier) {
        if (identifier instanceof String) {
            for (ConnectionCreator cc : DatabaseFactory.getConnectionCreators()) {
                Database db = cc.uncacheDatabase((String)identifier);
                if (db == null) continue;
                return db;
            }
        }
        return null;
    }

    public static final Database findOrCreateDatabase(String name, Connection conn) throws DBException {
        Database db = (Database)DBObjectProviderFactory.findOrCreateProvider(name);
        if (db == null && (db = DatabaseFactory.getInstance().createDatabaseImpl(null, name, conn)) != null && ModelUtil.hasLength((String)name)) {
            DBObjectProviderFactory.cacheProvider(name, db);
        }
        return db;
    }

    public static final DatabaseDescriptor getDatabaseDescriptor(Class providerClass) {
        DatabaseCreator dc;
        for (DatabaseCreator factory : DatabaseFactory.getDatabaseCreators()) {
            DatabaseDescriptor desc = factory.getDatabaseDescriptorImpl(providerClass);
            if (desc == null) continue;
            return desc;
        }
        if (JdbcDatabase.class.isAssignableFrom(providerClass) && (dc = DatabaseFactory.getInstance().getJdbcCreator()) != null) {
            return dc.getDatabaseDescriptorImpl(providerClass);
        }
        return null;
    }

    private DatabaseCreator getJdbcCreator() {
        return this.m_jdbcDatabaseCreator;
    }

    void setJdbcDatabaseCreator(DatabaseCreator dc) {
        this.m_jdbcDatabaseCreator = dc;
    }

    public static final DatabaseDescriptor getDatabaseDescriptor(Database db) {
        DatabaseCreator dc;
        for (DatabaseCreator factory : DatabaseFactory.getDatabaseCreators()) {
            DatabaseDescriptor desc = factory.getDatabaseDescriptorImpl(db);
            if (desc == null) continue;
            return desc;
        }
        if (db instanceof JdbcDatabase && (dc = DatabaseFactory.getInstance().getJdbcCreator()) != null) {
            return dc.getDatabaseDescriptorImpl(db);
        }
        return null;
    }

    public static final void registerConnectionCreator(ConnectionCreator cc) {
        if (cc != null) {
            DatabaseFactory.getConnectionCreators().add(0, cc);
        }
    }

    public static final void registerDatabaseCreator(DatabaseCreator dc) {
        if (dc != null) {
            DatabaseFactory.getDatabaseCreators().add(0, dc);
        }
    }

    private static List<DatabaseCreator> getDatabaseCreators() {
        return DatabaseFactory.getInstance().m_dbCreators;
    }

    private static List<ConnectionCreator> getConnectionCreators() {
        return DatabaseFactory.getInstance().m_connCreators;
    }

    public static final <T extends ConnectionCreator> T findConnectionCreator(Class<T> ccc) {
        for (ConnectionCreator cc : DatabaseFactory.getConnectionCreators()) {
            if (!cc.getClass().equals(ccc)) continue;
            return (T)cc;
        }
        return null;
    }

    public static final ConnectionCreator findConnectionCreator(Database db) {
        for (ConnectionCreator cc : DatabaseFactory.getConnectionCreators()) {
            if (cc.findDatabase(db.getConnectionName()) != db) continue;
            return cc;
        }
        return null;
    }

    public static final Connection createConnection(Database db) throws DBException {
        String connName = db.getConnectionName();
        if (connName != null) {
            return DatabaseFactory.createConnection(connName);
        }
        return db.getConnection();
    }

    private static final Connection createConnection(String connName) throws DBException {
        for (ConnectionCreator factory : DatabaseFactory.getConnectionCreators()) {
            Connection conn = DatabaseFactory.createConnection(connName, factory);
            if (conn == null) continue;
            return conn;
        }
        return null;
    }

    private static final Connection createConnection(String connName, ConnectionCreator cc) throws DBException {
        long millis = System.currentTimeMillis();
        Connection conn = cc.createConnectionImpl(connName);
        if (conn != null) {
            DBLog.getLogger().log(DBLog.getTimingLogLevel(), "Opening connection for {0} took {1}ms", new Object[]{connName, Long.toString(System.currentTimeMillis() - millis)});
            return conn;
        }
        return null;
    }

    public static abstract class DatabaseCreator {
        protected abstract Database createDatabaseImpl(String var1, String var2, Connection var3) throws DBException;

        protected abstract DatabaseDescriptor getDatabaseDescriptorImpl(Class var1);

        protected DatabaseDescriptor getDatabaseDescriptorImpl(Database db) {
            return this.getDatabaseDescriptorImpl(db.getClass());
        }
    }

    public static abstract class ConnectionCreator {
        protected Map<String, Database> m_dbs;

        protected abstract Connection createConnectionImpl(String var1) throws DBException;

        protected boolean isActive() {
            return true;
        }

        protected abstract String getStoreName();

        public Database findDatabase(String connName) {
            if (this.isActive() && this.m_dbs != null) {
                return this.m_dbs.get(connName);
            }
            return null;
        }

        public Database uncacheDatabase(String connName) {
            if (this.isActive() && this.m_dbs != null) {
                return this.m_dbs.remove(connName);
            }
            return null;
        }

        protected void cacheDatabase(String connName, Database db) {
            if (this.m_dbs == null) {
                this.m_dbs = new HashMap<String, Database>();
            }
            this.m_dbs.put(connName, db);
        }

        public boolean renameDatabase(String oldName, String newName) {
            Database db = this.uncacheDatabase(oldName);
            if (db != null) {
                ((AbstractDatabase)db).setConnectionName(newName);
                this.cacheDatabase(newName, db);
                return true;
            }
            return false;
        }
    }
}

