/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import oracle.javatools.util.Log;
import oracle.javatools.util.ModelUtil;

public class DBLog {
    private static final String SQL_LOG_NAME = "db_sql";
    private static final Log SQL_LOG = new Log("db_sql");
    private static final String LOG_PROPERTY = "db.log";
    private static Map<String, Logger> s_loggers = new HashMap<String, Logger>();
    private static boolean s_override;

    public static final Logger getLogger() {
        return DBLog.getAndInitialiseLogger("oracle.javatools.db");
    }

    public static final synchronized Logger getAndInitialiseLogger(String name) {
        Logger logger = Logger.getLogger(name);
        if (!s_loggers.containsKey(name)) {
            DBLog.initLogger(logger);
            s_loggers.put(name, logger);
        }
        return logger;
    }

    public static final Level getTimingLogLevel() {
        return Level.FINER;
    }

    public static final Level getTraceLogLevel() {
        return Level.FINER;
    }

    public static final Level getEventLogLevel() {
        return Level.FINE;
    }

    public static final void logStackTrace(Throwable t) {
        DBLog.getLogger().log(DBLog.getTraceLogLevel(), t.getMessage(), t);
    }

    public static final void log(String msg, Object ... params) {
        DBLog.getLogger().log(DBLog.getTraceLogLevel(), msg, params);
    }

    public static final Log getSQLLog() {
        return SQL_LOG;
    }

    private static String getSysLogProperty() {
        String prop = System.getProperty(LOG_PROPERTY);
        return prop;
    }

    public static void initLogger(Logger logger) {
        block7: {
            try {
                String prop = DBLog.getSysLogProperty();
                if (!ModelUtil.hasLength((String)prop)) break block7;
                Level level = null;
                if (Boolean.valueOf(prop).booleanValue()) {
                    level = Level.ALL;
                } else {
                    try {
                        level = Level.parse(prop.toUpperCase());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                if (level != null && !s_override) {
                    ConsoleHandler h = new ConsoleHandler();
                    h.setLevel(level);
                    logger.addHandler(h);
                    logger.setLevel(level);
                    logger.fine("added console handler to logger " + logger.getName());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void overrideConsoleHandler() {
        s_override = true;
    }

    private static class DBLogHandler
    extends StreamHandler {
        public DBLogHandler() {
            this.setOutputStream(new 1());
        }

        public boolean isLoggable(LogRecord record) {
            return super.isLoggable(record) && record.getLevel().intValue() < Level.INFO.intValue();
        }

        final class 1
        extends OutputStream {
            public void write(int b) throws IOException {
                System.err.write(b);
            }

            public void flush() throws IOException {
                System.err.flush();
            }
        }
    }
}

