/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import java.util.Map;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Column
extends AbstractChildDBObject {
    public static final String TYPE = "COLUMN";
    public static final String AUTO_GENERATED_SEQUENCE = "AUTO_GENERATED_SEQUENCE";
    public static final String AUTO_GENERATED_SEQUENCE_TRIGGER = "AUTO_GENERATED_SEQUENCE_TRIGGER";
    private Object m_default;
    private boolean m_notNull;
    private DataTypeUsage m_dataTypeUsage;

    public Column() {
    }

    public Column(String name) {
        super(name);
    }

    public Column(String name, DataTypeUsage usage) {
        super(name);
        this.setDataTypeUsage(usage);
    }

    @Deprecated
    public Column(String name, DataType dataType) {
        super(name);
        if (dataType != null && dataType.getID() != null) {
            try {
                DataType datatype = (DataType)dataType.getID().resolveID();
                this.setDataTypeUsage(datatype.createDefaultUsage());
            }
            catch (DBException x) {
                // empty catch block
            }
        }
    }

    @Deprecated
    public Column(String name, DBObjectID dataTypeID) {
        super(name);
        if (dataTypeID != null) {
            try {
                DataType datatype = (DataType)dataTypeID.resolveID();
                this.setDataTypeUsage(datatype.createDefaultUsage());
            }
            catch (DBException x) {
                // empty catch block
            }
        }
    }

    @Override
    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        Column copy = target != null ? (Column)target : new Column();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    protected void copyToImpl(Column copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        copy.m_default = this.m_default;
        copy.m_notNull = this.m_notNull;
        copy.m_dataTypeUsage = this.copyObject(this.m_dataTypeUsage, copy, idPolicy);
    }

    public boolean equals(Object target) {
        return target instanceof Column && this.equalsImpl((Column)target);
    }

    protected boolean equalsImpl(Column copy) {
        return super.equalsImpl(copy) && ModelUtil.areEqual((Object)this.m_default, (Object)copy.m_default) && this.m_notNull == copy.m_notNull && ModelUtil.areEqual((Object)this.m_dataTypeUsage, (Object)copy.m_dataTypeUsage);
    }

    public void setDefault(Object defaultValue) {
        this.m_default = defaultValue;
    }

    public Object getDefault() {
        return this.m_default;
    }

    public boolean isNotNull() {
        return this.m_notNull;
    }

    public void setNotNull(boolean newNotNull) {
        this.m_notNull = newNotNull;
    }

    public void setDataTypeUsage(DataTypeUsage dataTypeUsage) {
        this.changeParent(this.m_dataTypeUsage, dataTypeUsage);
        this.m_dataTypeUsage = dataTypeUsage;
    }

    public DataTypeUsage getDataTypeUsage() {
        return this.m_dataTypeUsage;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Transient
    public Relation getRelation() {
        return (Relation)this.getParent();
    }

    @Transient
    public void setRelation(Relation relation) {
        this.setParent(relation);
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> objs, String ... types) {
        super.getOwnedObjectsImpl(objs, types);
        this.includeOwnedObject(objs, this.m_dataTypeUsage, types);
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        DBObjectID tid;
        super.getReferenceIDsImpl(refs);
        DBObjectID sid = (DBObjectID)this.getProperty(AUTO_GENERATED_SEQUENCE);
        if (sid != null) {
            refs.add(sid);
        }
        if ((tid = (DBObjectID)this.getProperty(AUTO_GENERATED_SEQUENCE_TRIGGER)) != null) {
            refs.add(tid);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        DBObjectID tid;
        DBObjectID sid;
        DBObjectID dtid;
        boolean replaced = super.replaceReferenceIDs(idMap);
        if (this.m_dataTypeUsage != null && (dtid = this.m_dataTypeUsage.getDataTypeID()) != null && idMap.containsKey(dtid)) {
            this.m_dataTypeUsage.setDataTypeID(idMap.get(dtid));
            replaced = true;
        }
        if ((sid = (DBObjectID)this.getProperty(AUTO_GENERATED_SEQUENCE)) != null && idMap.containsKey(sid)) {
            this.setProperty(AUTO_GENERATED_SEQUENCE, idMap.get(sid));
        }
        if ((tid = (DBObjectID)this.getProperty(AUTO_GENERATED_SEQUENCE_TRIGGER)) != null && idMap.containsKey(tid)) {
            this.setProperty(AUTO_GENERATED_SEQUENCE_TRIGGER, idMap.get(tid));
        }
        return replaced;
    }

    @Deprecated
    @Transient
    public Long getPrecision() {
        if (this.m_dataTypeUsage == null) {
            return null;
        }
        Long precision = DataTypeHelper.getLongAttributeValue(this.m_dataTypeUsage, "precision");
        Long size = DataTypeHelper.getLongAttributeValue(this.m_dataTypeUsage, "size");
        return precision == null ? size : precision;
    }

    @Deprecated
    @Transient
    public void setPrecision(Long precision) {
        if (this.m_dataTypeUsage != null) {
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType(this.m_dataTypeUsage);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (dataType != null) {
                if (dataType.hasDataTypeAttribute("precision")) {
                    this.m_dataTypeUsage.putAttributeValue("precision", precision);
                }
                if (dataType.hasDataTypeAttribute("size")) {
                    this.m_dataTypeUsage.putAttributeValue("size", precision);
                }
            }
        }
    }

    @Deprecated
    @Transient
    public Long getScale() {
        if (this.m_dataTypeUsage == null) {
            return null;
        }
        return DataTypeHelper.getLongAttributeValue(this.m_dataTypeUsage, "scale");
    }

    @Deprecated
    public void setScale(Long scale) {
        if (this.m_dataTypeUsage != null) {
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType(this.m_dataTypeUsage);
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (dataType != null && dataType.hasDataTypeAttribute("scale")) {
                this.m_dataTypeUsage.putAttributeValue("scale", scale);
            }
        }
    }
}

