/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.Index;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.StatementWrapper;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractDatabase
extends AbstractDBObjectProvider
implements Database {
    public static final String SQLSTATE_NOT_IMPLEMENTED = "S1C00";
    private String m_connStore;
    private String m_connName;
    private Connection m_conn;
    private DDLGenerator m_defaultGen;
    private DatabaseDescriptor m_descriptor;
    private boolean m_reconnecting;
    private Statement m_statement;

    protected AbstractDatabase(String connStore, String connName, Connection conn) {
        this.m_connStore = connStore;
        this.m_connName = connName;
        this.m_conn = conn;
        DBLog.getLogger().log(DBLog.getEventLogLevel(), "{0}: new {1}", new Object[]{connName, this.getClass().getName()});
        this.registerBuilders();
        this.registerValidators();
        this.registerExpanders();
    }

    protected void sqlTrace(String query) {
        QueryWrapper.sqlTrace(this.m_connName, query, null);
    }

    protected void sqlTrace(String query, Object[] params) {
        QueryWrapper.sqlTrace(this.m_connName, query, params);
    }

    protected void registerValidators() {
        Map<String, DBObjectValidator> v = this.getDescriptor().getValidators(this);
        for (String type : v.keySet()) {
            this.registerValidator(type, v.get(type));
        }
    }

    @Deprecated
    protected void setDDLGenerator(DDLGenerator gen) {
        this.m_defaultGen = gen;
    }

    public DDLGenerator getDDLGenerator() {
        return this.m_defaultGen;
    }

    protected boolean exists(SchemaObject obj) {
        if (obj != null) {
            String name;
            String type;
            if (obj instanceof MaterializedViewLog) {
                type = "TABLE";
                name = ((MaterializedViewLog)obj).getLogTable();
            } else {
                type = obj.getType();
                name = AbstractDatabase.convertObject(obj);
            }
            return this.exists(type, AbstractDatabase.convertObject(obj.getSchema()), name);
        }
        return false;
    }

    protected abstract void registerBuilders();

    public final Connection getConnection() {
        try {
            Connection connection = this.getConnection(true);
            return connection;
        }
        catch (DBException dBException) {
            return this.m_conn;
        }
    }

    public final Connection getConnection(boolean reconnect) throws DBException {
        if (reconnect && !this.isConnectionAlive()) {
            this.reconnect();
        }
        return this.m_conn;
    }

    public boolean isConnectionAlive() {
        boolean alive = false;
        String stmt = this.getAliveTestStatement();
        if (ModelUtil.hasLength((String)stmt)) {
            StatementWrapper wrap = new StatementWrapper(this.m_connName, this.m_conn, stmt);
            wrap.setBypassExecutionProxy(true);
            try {
                alive = wrap.execute();
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.INFO, "isAlive failed for {0}: {1}", new Object[]{this.m_connName, dbe.getMessage()});
            }
        } else {
            try {
                DatabaseMetaData dmd = this.m_conn.getMetaData();
                alive = true;
            }
            catch (SQLException ex) {
                DBLog.getLogger().log(Level.INFO, "isAlive failed for {0}: {1}", new Object[]{this.m_connName, ex.getMessage()});
            }
        }
        return alive;
    }

    protected String getAliveTestStatement() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasTransaction() {
        if (this.m_statement != null) {
            return true;
        }
        String queryText = this.getTransactionTestQuery();
        if (ModelUtil.hasLength((String)queryText)) {
            Holder retval = new Holder((Object)false);
            Holder done = new Holder((Object)false);
            1 runner = new 1(this, queryText, retval, done);
            Thread t = new Thread((Runnable)runner, "DatabaseHasTransactionThread");
            t.start();
            while (!((Boolean)done.get()).booleanValue()) {
                Holder holder = done;
                synchronized (holder) {
                    try {
                        done.wait(200L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (t.getState() == Thread.State.BLOCKED) {
                        DBLog.getLogger().log(Level.INFO, "Connection for \"{0}\" is busy, cannot perform hasTransaction test.", new Object[]{this.m_connName});
                        break;
                    }
                    if (t.getState() == Thread.State.TERMINATED) {
                        break;
                    }
                }
            }
            return (Boolean)retval.get();
        }
        return false;
    }

    protected String getTransactionTestQuery() {
        return null;
    }

    public final String getName() {
        return this.m_connName;
    }

    final void setConnectionName(String name) {
        this.m_connName = name;
    }

    public final String getConnectionName() {
        return this.m_connName;
    }

    public final String getConnectionStore() {
        return this.m_connStore;
    }

    public final String getQualifiedName() {
        String toEncode = this.m_connStore == null ? this.m_connName : this.m_connStore + "#" + this.m_connName;
        try {
            String string = URLEncoder.encode(toEncode, "utf-8");
            return string;
        }
        catch (UnsupportedEncodingException uee) {
            String string = toEncode;
            return string;
        }
    }

    protected synchronized void reconnect() throws DBException {
        if (this.m_reconnecting) {
            DBLog.getLogger().severe(this.getName() + ": failed to reconnect: cannot create new connection");
            return;
        }
        try {
            this.m_reconnecting = true;
            this.close();
            Connection c = DatabaseFactory.createConnection(this);
            if (c != null && c != this.m_conn) {
                this.m_conn = c;
                this.reconnected(this.m_conn);
            }
        }
        finally {
            this.m_reconnecting = false;
        }
    }

    protected void reconnected(Connection c) {
    }

    public void close() {
        if (this.m_conn != null) {
            try {
                if (!this.m_conn.isClosed()) {
                    DBLog.getLogger().log(Level.FINE, DBArb.format(151, this.m_connName));
                    this.m_conn.close();
                }
            }
            catch (Exception ex) {
                DBLog.getLogger().log(Level.WARNING, DBArb.format(123, this.m_connName), ex);
            }
            this.clearAllCaches();
            this.fireProviderClosed();
        }
    }

    public boolean exists(String type, String schema, String name) {
        boolean exists = false;
        try {
            exists = this.getObject(type, this.getSchema(schema), name) != null;
        }
        catch (DBException ex) {
            // empty catch block
        }
        return exists;
    }

    public boolean isObjectValid(String objectType, String schema, String objectName) {
        return this.exists(objectType, schema, objectName);
    }

    protected final Schema createSchema(String name) {
        Schema s = new Schema(name);
        return s;
    }

    protected void finishCreate(SchemaObject[] objects, SchemaObject[] oldObjects) throws DBException {
        ArrayList<SchemaObject> newObjs = new ArrayList<SchemaObject>();
        DBException dbe = null;
        int i = 0;
        while (i < objects.length) {
            SchemaObject obj;
            SchemaObject object = objects[i];
            SchemaObject old = oldObjects == null ? null : oldObjects[i];
            Schema schema = this.getSchema(object.getSchema().getName());
            if (old != null) {
                this.uncacheObject(old);
            }
            if ((obj = this.getCreatedObject(object.getType(), schema, object.getName())) == null) {
                DBException newE = new DBException((DBObject)object, DBArb.format(251, object.getType(), object.getName()));
                if (dbe == null) {
                    dbe = newE;
                } else {
                    dbe.setNextException(newE);
                }
            } else if (old != null) {
                this.resetSchemaObject(old, obj, null);
            } else {
                newObjs.add(obj);
                this.cacheObject(obj, false);
            }
            ++i;
        }
        if (newObjs.size() > 0) {
            SchemaObject[] sos = newObjs.toArray(new SchemaObject[newObjs.size()]);
            this.fireObjectsAdded(sos[0].getSchema(), sos);
        }
        if (dbe != null) {
            throw dbe;
        }
    }

    protected SchemaObject getCreatedObject(String type, Schema schema, String name) throws DBException {
        return this.getObject(type, schema, name);
    }

    protected void finishDelete(SchemaObject[] objs) {
        Map<Schema, Collection<SchemaObject>> mapped = DBUtil.sortIntoSchemas(objs);
        for (Map.Entry<Schema, Collection<SchemaObject>> entry : mapped.entrySet()) {
            Collection<SchemaObject> col = entry.getValue();
            this.finishDelete(entry.getKey(), col.toArray(new SchemaObject[col.size()]));
        }
    }

    protected void finishDelete(Schema schema, SchemaObject[] objs) {
        this.fireObjectsRemoved(schema, objs);
        int i = 0;
        while (i < objs.length) {
            Table t;
            if (objs[i] instanceof Index && (t = ((Index)objs[i]).getTable()) != null) {
                t.removeIndex((Index)objs[i]);
                DBObjectChange.fireObjectUpdated(t);
            }
            SchemaObjectManager manager = this.getObjectManager();
            DBObjectID[] refs = manager.getSchemaObjectReferers(objs[i], false);
            int j = 0;
            while (j < refs.length) {
                try {
                    SchemaObject referer = (SchemaObject)refs[j].resolveID();
                    manager.doCascadeDelete(objs[i], referer);
                }
                catch (DBException dbe) {
                    // empty catch block
                }
                ++j;
            }
            this.uncacheObject(objs[i]);
            ++i;
        }
    }

    public void createObjects(SchemaObject[] objects, boolean replace) throws DBException {
        int i = 0;
        while (i < objects.length) {
            this.createObject(objects[i], replace);
            ++i;
        }
    }

    protected SchemaObject createByIDImpl(DBObjectID id) throws DBException {
        SchemaObject object = null;
        if (id instanceof BaseObjectID) {
            BaseObjectID dmdID = (BaseObjectID)id;
            Schema s = this.getSchema(dmdID.getSchemaName());
            object = this.createSchemaObjectImpl(dmdID.getType(), s, dmdID.getName());
            if (object != null) {
                object.setID(id);
            }
        }
        return object;
    }

    public void deleteObjects(SchemaObject[] objects, boolean cascade) throws DBException {
        int i = 0;
        while (i < objects.length) {
            this.deleteObject(objects[i], cascade);
            ++i;
        }
    }

    public void updateObjects(SchemaObject[] oldObjects, SchemaObject[] newObjects) throws DBException {
        if (oldObjects.length != newObjects.length) {
            throw new IllegalArgumentException("New and old objects must have a 1:1 correspondance.");
        }
        int i = 0;
        while (i < oldObjects.length) {
            this.updateObject(oldObjects[i], newObjects[i]);
            ++i;
        }
    }

    public String getDatabaseSource(String objectType, Schema schema, String objectName) throws DBException {
        return null;
    }

    public String getDatabaseSource(String objectType, Schema schema, String objectName, String sourceType) throws DBException {
        return null;
    }

    public Schema getDefaultSchema() throws DBException {
        String userName = this.getUserName();
        Schema schema = this.getSchema(userName);
        if (schema == null && this.isUsernameCaseInsensitive() && ModelUtil.hasLength((String)userName)) {
            userName = this.getCasePolicy() == 1 ? userName.toLowerCase() : (this.getCasePolicy() == 2 ? userName.toUpperCase() : userName);
            Schema[] schemaArray = this.listSchemas();
            int n = 0;
            while (n < schemaArray.length) {
                Schema s = schemaArray[n];
                if (userName.equals(s.getName())) {
                    schema = s;
                    break;
                }
                ++n;
            }
        }
        return schema != null ? schema : this.getSchema(null);
    }

    protected boolean isUsernameCaseInsensitive() {
        return true;
    }

    String[] getDatabaseMultiSource(String objectType, Schema schema, String objectName) throws DBException {
        return null;
    }

    public boolean supportsDebugging() {
        return false;
    }

    protected SchemaObject getObjectImpl(String objectType, Schema schema, String name) throws DBException {
        ComplexType type;
        if ("TYPE".equals(objectType) && schema != null && (type = DataTypeRegistry.getInstance().findComplexType(name, schema.getName(), this.getClass())) != null) {
            return type;
        }
        return super.getObjectImpl(objectType, schema, name);
    }

    public DatabaseDescriptor getDescriptor() {
        if (this.m_descriptor == null) {
            this.m_descriptor = DatabaseFactory.getDatabaseDescriptor(this);
        }
        return this.m_descriptor;
    }

    public Schema[] listSchemas(boolean restrictVisible) throws DBException {
        throw new UnsupportedOperationException("listSchemas(boolean)");
    }

    public boolean canRestrictSchemaList() {
        return false;
    }

    void setStatement(Statement statement) {
        if (this.m_statement != null && statement != null) {
            throw new IllegalArgumentException("Cannot set statement when already set");
        }
        this.m_statement = statement;
    }

    public void cancelStatement() {
        if (this.m_statement != null) {
            try {
                this.m_statement.cancel();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    static String ra$m_connName(AbstractDatabase abstractDatabase) {
        return abstractDatabase.m_connName;
    }

    static Connection ra$m_conn(AbstractDatabase abstractDatabase) {
        return abstractDatabase.m_conn;
    }

    final class oracle.javatools.db.AbstractDatabase$1
    implements Runnable {
        private final /* synthetic */ String v$queryText;
        private final /* synthetic */ Holder v$retval;
        private final /* synthetic */ Holder v$done;
        final /* synthetic */ AbstractDatabase this$0;

        public void run() {
            QueryWrapper wrap = new QueryWrapper(AbstractDatabase.ra$m_connName(this.this$0), AbstractDatabase.ra$m_conn(this.this$0), this.v$queryText, new Object[0]);
            1 r = new 1();
            try {
                wrap.executeQuery(r);
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.INFO, "hasTransaction query failed for {0}: {1}", new Object[]{AbstractDatabase.ra$m_connName(this.this$0), dbe.getMessage()});
            }
        }

        public oracle.javatools.db.AbstractDatabase$1(AbstractDatabase abstractDatabase, String string, Holder holder, Holder holder2) {
            this.v$done = holder2;
            this.v$retval = holder;
            this.v$queryText = string;
            this.this$0 = abstractDatabase;
        }

        static Holder ra$v$retval(oracle.javatools.db.AbstractDatabase$1 var0) {
            return var0.v$retval;
        }

        static Holder ra$v$done(oracle.javatools.db.AbstractDatabase$1 var0) {
            return var0.v$done;
        }

        final class 1
        implements QueryWrapper.QueryRunnable {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    try {
                        String id;
                        if (rs.next() && ModelUtil.hasLength((String)(id = rs.getString(1)))) {
                            oracle.javatools.db.AbstractDatabase$1.ra$v$retval(1.this).set((Object)true);
                        }
                    }
                    catch (SQLException sQLException) {}
                }
                catch (Throwable throwable) {
                    Holder holder = oracle.javatools.db.AbstractDatabase$1.ra$v$done(1.this);
                    synchronized (holder) {
                        oracle.javatools.db.AbstractDatabase$1.ra$v$done(1.this).set((Object)true);
                        oracle.javatools.db.AbstractDatabase$1.ra$v$done(1.this).notifyAll();
                    }
                    throw throwable;
                }
                Holder holder = oracle.javatools.db.AbstractDatabase$1.ra$v$done(1.this);
                synchronized (holder) {
                    oracle.javatools.db.AbstractDatabase$1.ra$v$done(1.this).set((Object)true);
                    oracle.javatools.db.AbstractDatabase$1.ra$v$done(1.this).notifyAll();
                }
            }
        }
    }
}

