/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderListener;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.MissingValidatorException;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectExpander;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDBObjectProvider
implements DBObjectProvider {
    public static final int MIXED_CASE_NAME_POLICY = 0;
    public static final int LOWER_CASE_NAME_POLICY = 1;
    public static final int UPPER_CASE_NAME_POLICY = 2;
    public static final int CASE_SENSITIVE_NAME_POLICY = 3;
    public static final String TIMESTAMP_PROPERTY = "Timestamp";
    private SchemaObjectManager m_objManager;
    private Map<String, ObjectTypeEntry> m_typeMap;
    private String[] m_objTypes;
    private List m_listeners;
    private ArrayList<SchemaObjectExpander> m_expanders;
    protected static final String[] EMPTY_LIST = new String[0];

    private void $init$() {
        this.m_typeMap = new HashMap<String, ObjectTypeEntry>();
        this.m_expanders = new ArrayList();
    }

    @Override
    public final void removeProviderListener(DBObjectProviderListener list) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(list);
        }
    }

    @Override
    public final void addProviderListener(DBObjectProviderListener list) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList();
        }
        this.m_listeners.add(list);
    }

    protected final void fireProviderClosed() {
        this.logEvent("fire provider {0} closed", this.getName());
        if (this.m_listeners != null) {
            ArrayList copy = new ArrayList(this.m_listeners);
            for (DBObjectProviderListener next : copy) {
                try {
                    next.providerClosed(this);
                }
                catch (Exception e) {
                    this.processListenerException(next, e);
                }
            }
        }
    }

    public final void fireProviderDeleted() {
        this.logEvent("fire provider {0} deleted", this.getName());
        if (this.m_listeners != null) {
            ArrayList copy = new ArrayList(this.m_listeners);
            for (DBObjectProviderListener next : copy) {
                try {
                    next.providerDeleted(this);
                }
                catch (Exception e) {
                    this.processListenerException(next, e);
                }
            }
        }
    }

    protected final void fireProviderOpened() {
        this.logEvent("fire provider {0} opened", this.getName());
        if (this.m_listeners != null) {
            ArrayList copy = new ArrayList(this.m_listeners);
            for (DBObjectProviderListener next : copy) {
                try {
                    next.providerOpened(this);
                }
                catch (Exception e) {
                    this.processListenerException(next, e);
                }
            }
        }
    }

    protected final void fireProviderReloaded() {
        this.logEvent("fire provider {0} reloaded", this.getName());
        if (this.m_listeners != null) {
            ArrayList copy = new ArrayList(this.m_listeners);
            for (DBObjectProviderListener next : copy) {
                try {
                    next.providerReloaded(this);
                }
                catch (Exception e) {
                    this.processListenerException(next, e);
                }
            }
        }
    }

    protected final void fireSchemaAdded(Schema schema) {
        this.logEvent("fire schema {0} added to {1}", schema.getName(), this.getName());
        if (this.m_listeners != null) {
            ArrayList copy = new ArrayList(this.m_listeners);
            for (DBObjectProviderListener next : copy) {
                try {
                    next.schemaAdded(this, schema);
                }
                catch (Exception e) {
                    this.processListenerException(next, e);
                }
            }
        }
    }

    protected final void fireSchemaUpdated(DBObjectChange change) {
        this.logEvent("fire schema {0} updated in {1}", change.getDBObject().getName(), this.getName());
        this.schemaUpdated(change);
        if (this.m_listeners != null) {
            ArrayList copy = new ArrayList(this.m_listeners);
            for (DBObjectProviderListener next : copy) {
                try {
                    next.schemaUpdated(this, change);
                }
                catch (Exception e) {
                    this.processListenerException(next, e);
                }
            }
        }
    }

    protected final void fireSchemaRemoved(Schema schema) {
        this.logEvent("fire schema {0} removed from {1}", schema.getName(), this.getName());
        if (this.m_listeners != null) {
            ArrayList copy = new ArrayList(this.m_listeners);
            for (DBObjectProviderListener next : copy) {
                try {
                    next.schemaRemoved(this, schema);
                }
                catch (Exception e) {
                    this.processListenerException(next, e);
                }
            }
        }
    }

    public final void fireObjectsAdded(Schema schema, SchemaObject[] objs) {
        if (ModelUtil.hasNonNullElement((Object[])objs)) {
            Level level;
            Logger log = this.getLogger();
            if (log.isLoggable(level = DBLog.getEventLogLevel())) {
                StringBuffer b = new StringBuffer();
                b.append("fire SchemaObjects added to ");
                b.append(this.getName());
                b.append(": ");
                int i = 0;
                while (i < objs.length) {
                    b.append(DBUtil.getFullyQualifiedName(objs[i], true));
                    b.append(" ");
                    ++i;
                }
                this.logEvent(b.toString(), new Object[0]);
            }
            if (this.m_listeners != null) {
                ArrayList copy = new ArrayList(this.m_listeners);
                for (DBObjectProviderListener next : copy) {
                    try {
                        next.schemaObjectsAdded(this, objs[0].getSchema(), objs);
                    }
                    catch (Exception e) {
                        this.processListenerException(next, e);
                    }
                }
            }
        }
    }

    protected final void fireObjectsRemoved(Schema schema, SchemaObject[] objs) {
        if (ModelUtil.hasNonNullElement((Object[])objs)) {
            Level level;
            Logger log = this.getLogger();
            if (log.isLoggable(level = DBLog.getEventLogLevel())) {
                StringBuffer b = new StringBuffer();
                b.append("fire SchemaObjects removed from ");
                b.append(this.getName());
                b.append(": ");
                int i = 0;
                while (i < objs.length) {
                    b.append(DBUtil.getFullyQualifiedName(objs[i], true));
                    b.append(" ");
                    ++i;
                }
                this.logEvent(b.toString(), new Object[0]);
            }
            if (this.m_listeners != null) {
                ArrayList copy = new ArrayList(this.m_listeners);
                for (DBObjectProviderListener next : copy) {
                    try {
                        next.schemaObjectsRemoved(this, schema, objs);
                    }
                    catch (Exception e) {
                        this.processListenerException(next, e);
                    }
                }
            }
        }
    }

    protected void schemaUpdated(DBObjectChange change) {
    }

    private void processListenerException(DBObjectProviderListener l, Exception e) {
        this.getLogger().log(Level.WARNING, MessageFormat.format("listener {0} threw exception:", l.getClass()), e);
    }

    protected final void registerType(String type, DBObjectBuilder builder, DBObjectValidator validator) {
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        if (entry == null) {
            entry = new ObjectTypeEntry(type, builder, validator, null);
            this.m_typeMap.put(type, entry);
            this.m_objTypes = null;
        } else {
            if (builder != null) {
                ObjectTypeEntry.mav$setBuilder(entry, builder);
            }
            if (validator != null) {
                ObjectTypeEntry.mav$setValidator(entry, validator);
            }
        }
    }

    protected final void registerBuilder(String type, DBObjectBuilder builder) {
        this.registerType(type, builder, null);
    }

    protected final void unregisterBuilder(String type) {
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        if (ObjectTypeEntry.mav$getValidator(entry) == null) {
            this.m_typeMap.remove(type);
            this.m_objTypes = null;
        } else {
            ObjectTypeEntry.mav$setBuilder(entry, null);
        }
    }

    protected DBObjectBuilder getBuilderForType(String type) {
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        return entry != null ? ObjectTypeEntry.mav$getBuilder(entry) : null;
    }

    protected final void registerValidator(String type, DBObjectValidator validator) {
        this.registerType(type, null, validator);
    }

    protected final void unregisterValidator(String type) {
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        if (ObjectTypeEntry.mav$getBuilder(entry) == null) {
            this.m_typeMap.remove(type);
            this.m_objTypes = null;
        } else {
            ObjectTypeEntry.mav$setValidator(entry, null);
        }
    }

    protected final DBObjectValidator getValidatorForType(String type) {
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        return entry != null ? ObjectTypeEntry.mav$getValidator(entry) : null;
    }

    protected SchemaObject findObject(String type, Schema schema, String name) {
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        return entry != null ? ObjectTypeEntry.mav$findObject(entry, schema, name) : null;
    }

    protected final SchemaObject findObject(DBObjectID id) {
        ObjectTypeEntry entry;
        SchemaObject object = null;
        if (id != null && (entry = this.m_typeMap.get(id.getType())) != null) {
            object = ObjectTypeEntry.mav$findObject(entry, id);
        }
        return object;
    }

    public void destroyCache() {
        this.m_typeMap.clear();
        this.m_objTypes = null;
    }

    protected final void clearCache(String type) {
        ObjectTypeEntry entry = this.m_typeMap.get(type);
        if (entry != null) {
            ObjectTypeEntry.mav$clearCache(entry);
        }
    }

    protected final void clearAllCaches() {
        Iterator<String> iter = this.m_typeMap.keySet().iterator();
        while (iter.hasNext()) {
            this.clearCache(iter.next());
        }
        if (this.m_objManager != null) {
            this.m_objManager.clearAllCaches();
        }
    }

    @Override
    public SchemaObjectManager getObjectManager() {
        if (this.m_objManager == null) {
            this.m_objManager = this.createObjectManager();
        }
        return this.m_objManager;
    }

    protected SchemaObjectManager createObjectManager() {
        return new SchemaObjectManager(this);
    }

    protected void cacheObject(SchemaObject object, boolean loadOperation) {
        if (object != null) {
            String type = object.getType();
            ObjectTypeEntry entry = this.m_typeMap.get(type);
            if (entry != null) {
                ObjectTypeEntry.mav$addObjectToCache(entry, object);
            }
            this.getObjectManager().registerObject(object, loadOperation);
        }
    }

    protected final void uncacheObject(SchemaObject object) {
        if (object != null) {
            String type = object.getType();
            ObjectTypeEntry entry = this.m_typeMap.get(type);
            if (entry != null) {
                ObjectTypeEntry.mav$removeObjectFromCache(entry, object.getSchema(), object.getName());
            }
            if (this.m_objManager != null) {
                this.m_objManager.unregisterObject(object);
            }
        }
    }

    protected String[] listObjectsImpl(String type, Schema schema, String ref) throws DBException {
        Collection<SchemaObject> objects = this.listObjectsImpl(new String[]{type}, schema, ref);
        String[] names = new String[objects.size()];
        int i = 0;
        for (SchemaObject obj : objects) {
            names[i] = obj.getName();
            ++i;
        }
        return names;
    }

    protected abstract Collection<SchemaObject> listObjectsImpl(String[] var1, Schema var2, String var3) throws DBException;

    protected SchemaObject getObjectImpl(String objectType, Schema schema, String name) throws DBException {
        if (!ModelUtil.hasLength((String)objectType) || schema == null || !ModelUtil.hasLength((String)name)) {
            return null;
        }
        SchemaObject object = null;
        ObjectTypeEntry entry = this.m_typeMap.get(objectType);
        if (entry != null) {
            object = ObjectTypeEntry.mav$findObject(entry, this.getSchema(schema.getName()), name);
            if (object == null) {
                object = this.createSchemaObjectImpl(objectType, schema, name);
                if (object != null) {
                    ObjectTypeEntry.mav$cacheObject(entry, object);
                }
            } else if (this.supportsTimestamps()) {
                boolean needsInit = ((AbstractSchemaObject)object).needsInitialization();
                Long t = (Long)object.getProperty(TIMESTAMP_PROPERTY);
                if (t != null) {
                    Long t2 = this.getExternalTimestamp(object);
                    if (t2 == null || t2.compareTo(t) > 0) {
                        SchemaObject exists = this.createSchemaObjectImpl(objectType, schema, name);
                        if (exists != null) {
                            this.resetSchemaObject(object, exists, t2);
                        } else {
                            this.uncacheObject(object);
                            object = null;
                        }
                    }
                } else if (needsInit) {
                    SchemaObject obj2 = this.createSchemaObjectImpl(objectType, schema, name);
                    if (obj2 == null) {
                        this.uncacheObject(object);
                    }
                    object = obj2;
                }
            }
        }
        return object;
    }

    public boolean supportsTimestamps() {
        return false;
    }

    @Override
    public final Long getTimestamp(String type, Schema schema, String objectName) throws DBException {
        SchemaObject obj;
        Long result = null;
        if (this.supportsTimestamps() && (obj = this.findObject(type, schema, objectName)) != null) {
            result = (Long)obj.getProperty(TIMESTAMP_PROPERTY);
        }
        return result;
    }

    @Override
    public final Long getTimestamp(DBObjectID id) throws DBException {
        if (this.supportsTimestamps()) {
            SchemaObject obj = this.findObject(id);
            return obj != null ? (Long)obj.getProperty(TIMESTAMP_PROPERTY) : null;
        }
        return null;
    }

    protected DBObject findByID(DBObjectID id) throws DBException {
        ObjectTypeEntry entry;
        SchemaObject object = null;
        if (id != null && (entry = this.m_typeMap.get(id.getType())) != null) {
            Long t2;
            Long t;
            object = ObjectTypeEntry.mav$findObject(entry, id);
            if (object == null) {
                object = this.createByIDImpl(id);
                if (object != null) {
                    ObjectTypeEntry.mav$cacheObject(entry, object);
                }
            } else if (this.supportsTimestamps() && (t = (Long)object.getProperty(TIMESTAMP_PROPERTY)) != null && ((t2 = this.getExternalTimestamp(object)) == null || t2.compareTo(t) > 0)) {
                SchemaObject exists = this.createByIDImpl(id);
                if (exists != null) {
                    this.resetSchemaObject(object, exists, t2);
                } else {
                    this.uncacheObject(object);
                    object = null;
                }
            }
        }
        return object;
    }

    protected void resetSchemaObject(SchemaObject object, SchemaObject listed, Long timestamp) {
        this.uncacheObject(object);
        this.uncacheObject(listed);
        try {
            String name = listed.getName();
            Schema schema = listed.getSchema();
            DBObjectID id = listed.getID();
            SchemaObject emptyTemplate = (SchemaObject)object.getClass().newInstance();
            emptyTemplate.copyTo((DBObject)object, false);
            object.setName(name);
            object.setSchema(schema);
            object.setID(id);
            if (timestamp != null) {
                object.setProperty(TIMESTAMP_PROPERTY, timestamp);
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "error wiping object properties - object reset may have failed", e);
        }
        this.markForLazyInit((AbstractSchemaObject)object);
        this.cacheObject(object, true);
        DBObjectChange.fireObjectUpdated(object);
    }

    protected SchemaObject createSchemaObjectImpl(String type, Schema schema, String name) throws DBException {
        for (SchemaObject obj : this.listObjectsImpl(new String[]{type}, schema, name)) {
            if (!this.isRequestedObject(obj, type, schema, name)) continue;
            return obj;
        }
        return null;
    }

    protected boolean isRequestedObject(SchemaObject object, String type, Schema schema, String name) {
        return object != null && type != null && type.equals(object.getType()) && DBUtil.getNameComparator().compare(schema, object.getSchema()) == 0 && ModelUtil.hasLength((String)name) && name.equals(object.getName());
    }

    protected SchemaObject createByIDImpl(DBObjectID id) throws DBException {
        return null;
    }

    protected Long getExternalTimestamp(SchemaObject object) throws DBException {
        return null;
    }

    protected final void markForLazyInit(AbstractSchemaObject object) {
        DBObjectBuilder builder = this.getBuilderForType(object.getType());
        if (builder != null) {
            object.setBuilder(builder);
        }
    }

    public static String convertObject(DBObject obj) {
        String name = obj != null ? obj.getName() : "";
        return ModelUtil.hasLength((String)name) ? name : "";
    }

    @Override
    public String getIdentifierQuoteString() {
        return "\"";
    }

    @Override
    public String[] listObjectTypes() {
        if (this.m_objTypes == null) {
            Set<Map.Entry<String, ObjectTypeEntry>> entries = this.m_typeMap.entrySet();
            ArrayList<String> l = new ArrayList<String>();
            for (Map.Entry<String, ObjectTypeEntry> entry : entries) {
                ObjectTypeEntry typeEntry = entry.getValue();
                if (typeEntry == null || ObjectTypeEntry.mav$getBuilder(typeEntry) == null) continue;
                l.add(entry.getKey());
            }
            this.m_objTypes = l.toArray(new String[l.size()]);
            Arrays.sort(this.m_objTypes);
        }
        return this.m_objTypes;
    }

    @Override
    public boolean supportsObjectType(String type) {
        if (this.isNewFromTemplateType(type)) {
            return true;
        }
        if (this.m_objTypes == null) {
            this.listObjectTypes();
        }
        return Arrays.binarySearch(this.m_objTypes, type) >= 0;
    }

    @Override
    public String[] listObjects(String objectType, Schema schema) throws DBException {
        return this.listObjects(objectType, schema, null);
    }

    @Override
    public final String[] listObjects(String objectType, Schema schema, String ref) throws DBException {
        return this.listObjectsImpl(objectType, schema, ref);
    }

    @Override
    public SchemaObject[] listObjects(String[] objectTypes, Schema schema) throws DBException {
        return this.listObjects(objectTypes, schema, null);
    }

    @Override
    public final SchemaObject[] listObjects(String[] objectTypes, Schema schema, String ref) throws DBException {
        Collection<SchemaObject> retval = this.listObjectsImpl(objectTypes, schema, ref);
        return retval.toArray(new SchemaObject[retval.size()]);
    }

    @Override
    public SchemaObject getObject(String objectType, Schema schema, String name) throws DBException {
        return this.getObjectImpl(objectType, schema, name);
    }

    @Override
    public boolean hasPriviledge(String type, Schema schema, String priv) {
        return true;
    }

    public abstract PropertyManager getPropertyManager();

    private DatabaseDescriptor getDescriptorOrFail() {
        DatabaseDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            throw new IllegalStateException("provider is missing a descriptor");
        }
        return descriptor;
    }

    protected final int getCasePolicy() {
        return this.getDescriptorOrFail().getCasePolicy();
    }

    protected final int getQuotedNameCasePolicy() {
        return this.getDescriptorOrFail().getQuotedNameCasePolicy();
    }

    @Override
    @Deprecated
    public final boolean isValidName(String name) {
        return this.isValidName(null, name);
    }

    @Override
    public final boolean isValidName(String type, String name) {
        return this.getDescriptorOrFail().isValidName(type, name);
    }

    @Override
    @Deprecated
    public final void validateName(String name) throws InvalidNameException {
        this.validateName(null, name);
    }

    @Override
    public final void validateName(String type, String name) throws InvalidNameException {
        this.getDescriptorOrFail().validateName(type, name);
    }

    @Override
    public final String quoteIdentifier(String internalName, boolean force) throws DBException {
        return this.getDescriptorOrFail().quoteIdentifier(internalName, force);
    }

    @Override
    public final String getInternalName(String name, String objectType) {
        return this.getDescriptorOrFail().getInternalName(name, objectType);
    }

    @Override
    public final String getInternalName(String name) {
        return this.getInternalName(name, null);
    }

    @Override
    public final String getExternalName(String name, String objectType) {
        return this.getDescriptorOrFail().getExternalName(name, objectType);
    }

    @Override
    public final String getExternalName(String name) {
        return this.getExternalName(name, null);
    }

    @Override
    public DataType[] listSupportedDataTypes() {
        return DataTypeRegistry.getInstance().listDataTypes(this.getClass());
    }

    @Override
    public DataType getDataType(String typeName) {
        DataType type = null;
        Class<?> clz = this.getClass();
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        type = dtr.findDataType(typeName, clz);
        if (type == null) {
            DBLog.log("DataTypeRegistry had no \"" + typeName + "\" for provider " + clz.getName(), new Object[0]);
            type = dtr.createUserDataType(typeName, clz);
        }
        return type;
    }

    @Override
    public void validateObject(DBObject object) throws ValidationException {
        DBObjectValidator v = this.getValidatorForType(object.getType());
        if (v == null) {
            throw new MissingValidatorException(object);
        }
        v.validateObject(object);
    }

    @Override
    @Deprecated
    public final void validateObject(DBObject object, String property) throws ValidationException {
        this.validateObjectProperty(object, property);
    }

    @Override
    public void validateObjectProperty(DBObject object, Object property) throws ValidationException {
        if (property == null) {
            this.validateObject(object);
        } else {
            DBObjectValidator v = this.getValidatorForType(object.getType());
            if (v == null) {
                throw new MissingValidatorException(object);
            }
            v.validateObjectProperty(object, property);
        }
    }

    @Override
    @Deprecated
    public void validateSchema(Schema schema) throws ValidationException {
        this.validateObject(schema);
    }

    @Override
    public void validateObject(DBObject original, DBObject update) throws ValidationException {
        DBObjectValidator v = this.getValidatorForType(update.getType());
        if (v == null) {
            throw new MissingValidatorException(update);
        }
        v.validateObject(original, update);
    }

    @Override
    @Deprecated
    public final void validateObject(DBObject original, DBObject update, String property) throws ValidationException {
        this.validateObjectProperty(original, update, property);
    }

    @Override
    public void validateObjectProperty(DBObject original, DBObject update, Object property) throws ValidationException {
        if (property == null) {
            this.validateObject(original, update);
        } else {
            DBObjectValidator v = this.getValidatorForType(update.getType());
            if (v == null) {
                throw new MissingValidatorException(update);
            }
            v.validateObjectProperty(original, update, property);
        }
    }

    @Override
    @Deprecated
    public void validateSchema(Schema original, Schema update) throws ValidationException {
        this.validateObject((DBObject)original, update);
    }

    @Override
    public void validateUniqueName(String type, DBObject contextObject, String name) throws NameInUseException {
        if (ModelUtil.hasLength((String)name)) {
            type = this.normaliseType(type);
            if (contextObject instanceof Schema) {
                SchemaObject[] schemaObjects = null;
                try {
                    schemaObjects = this.listObjects(this.listObjectTypes(), (Schema)contextObject);
                }
                catch (DBException x) {
                    // empty catch block
                }
                if (schemaObjects != null) {
                    int i = 0;
                    while (i < schemaObjects.length) {
                        if (type.equals("INDEX") || type.equals("CONSTRAINT")) {
                            this.checkChildrenNames(name, schemaObjects[i].getOwnedObjects(type));
                        } else if (name.equals(schemaObjects[i].getName())) {
                            throw new NameInUseException(name, schemaObjects[i].getName(), schemaObjects[i].getType());
                        }
                        ++i;
                    }
                }
            } else if (contextObject instanceof SchemaObject) {
                this.checkChildrenNames(name, contextObject.getOwnedObjects(type));
            }
        }
    }

    @Override
    public String getUniqueName(String type, DBObject contextObject, String base) {
        ArrayList<String> names = new ArrayList<String>();
        type = this.normaliseType(type);
        if (!ModelUtil.hasLength((String)base)) {
            base = type + 1;
        }
        if (contextObject instanceof Schema) {
            SchemaObject[] schemaObjects = null;
            try {
                schemaObjects = this.listObjects(this.listObjectTypes(), (Schema)contextObject);
            }
            catch (DBException x) {
                // empty catch block
            }
            if (schemaObjects != null) {
                int i = 0;
                while (i < schemaObjects.length) {
                    if (type.equals("INDEX") || type.equals("CONSTRAINT")) {
                        this.addChildrenNames(schemaObjects[i].getOwnedObjects(type), names);
                    } else {
                        names.add(schemaObjects[i].getName());
                    }
                    ++i;
                }
            }
        } else if (contextObject instanceof SchemaObject) {
            this.addChildrenNames(contextObject.getOwnedObjects(type), names);
        }
        int casePolicy = this.getCasePolicy();
        int quotedNameCasePolicy = this.getQuotedNameCasePolicy();
        if (casePolicy != 3 && quotedNameCasePolicy != 3) {
            boolean lowerCase = casePolicy == 1 || quotedNameCasePolicy == 1;
            String normalisedBase = lowerCase ? base.toLowerCase() : base.toUpperCase();
            ArrayList<String> normalisedNames = new ArrayList<String>();
            for (String name : names) {
                normalisedNames.add(lowerCase ? name.toLowerCase() : name.toUpperCase());
            }
            String uniqueName = DBUtil.getUniqueName(normalisedNames, normalisedBase);
            return uniqueName.equals(normalisedBase) ? base : uniqueName;
        }
        return DBUtil.getUniqueName(names, base);
    }

    private void addChildrenNames(DBObject[] children, Collection names) {
        int i = 0;
        while (i < children.length) {
            names.add(children[i].getName());
            ++i;
        }
    }

    private void checkChildrenNames(String name, DBObject[] children) throws NameInUseException {
        int i = 0;
        while (i < children.length) {
            if (name.equals(children[i].getName())) {
                throw new NameInUseException(name, children[i].getParent().getName(), children[i].getParent().getType());
            }
            ++i;
        }
    }

    protected String normaliseType(String type) {
        return type.equals("UniqueConstraint") || type.equals("PKConstraint") || type.equals("FKConstraint") || type.equals("CheckConstraint") ? "CONSTRAINT" : type;
    }

    @Override
    public DiffEngine getDiffEngine() {
        return null;
    }

    protected Logger getLogger() {
        return DBLog.getLogger();
    }

    protected void logEvent(String msg, Object ... params) {
        this.getLogger().log(DBLog.getEventLogLevel(), msg, params);
    }

    protected abstract String getName();

    @Override
    public boolean isEditable(DBObject object) {
        return true;
    }

    @Override
    public SchemaObject getDefaultTemplateForType(String type) {
        return null;
    }

    @Override
    public void setDefaultTemplateForType(String type, SchemaObject template) {
        throw new RuntimeException("Cannot store defaults online");
    }

    @Override
    public boolean isNewFromTemplateType(String type) {
        return "<?>".equals(type);
    }

    protected abstract void registerExpanders();

    protected void registerSchemaObjectExpander(SchemaObjectExpander expander) {
        this.m_expanders.add(expander);
    }

    public SchemaObjectExpander[] getSchemaObjectExpanders() {
        return this.m_expanders.toArray(new SchemaObjectExpander[this.m_expanders.size()]);
    }

    public AbstractDBObjectProvider() {
        this.$init$();
    }

    private class ObjectTypeEntry {
        private Map<String, SchemaObject> m_objectMap;
        private Map<DBObjectID, SchemaObject> m_idToObjectMap;
        private DBObjectBuilder m_builder;
        private DBObjectValidator m_validator;
        static final /* synthetic */ boolean $assertionsDisabled;

        private void $init$() {
            this.m_objectMap = new HashMap<String, SchemaObject>();
            this.m_idToObjectMap = new HashMap<DBObjectID, SchemaObject>();
        }

        private ObjectTypeEntry(String type, DBObjectBuilder builder, DBObjectValidator validator) {
            this.$init$();
            this.m_builder = builder;
            this.m_validator = validator;
        }

        private DBObjectBuilder getBuilder() {
            return this.m_builder;
        }

        static {
            $assertionsDisabled = ObjectTypeEntry.class.desiredAssertionStatus() ^ true;
        }

        private void setBuilder(DBObjectBuilder builder) {
            if (!$assertionsDisabled && builder == null) {
                throw new AssertionError();
            }
            this.m_builder = builder;
        }

        private DBObjectValidator getValidator() {
            return this.m_validator;
        }

        private void setValidator(DBObjectValidator validator) {
            this.m_validator = validator;
        }

        private SchemaObject findObject(Schema schema, String name) {
            String key = this.getKey(schema, name);
            return this.m_objectMap.get(key);
        }

        private SchemaObject findObject(DBObjectID id) {
            return this.m_idToObjectMap.get(id);
        }

        private void cacheObject(SchemaObject object) {
            DBObjectID id;
            String key = this.getKey(object.getSchema(), object.getName());
            SchemaObject oldFromName = this.m_objectMap.put(key, object);
            if (oldFromName != null && oldFromName != object) {
                DBLog.getLogger().log(Level.FINE, "Caching " + object.getType() + " " + object.getName() + " but we already have one!");
            }
            if ((id = object.getID()) == null) {
                DBLog.getLogger().log(Level.FINE, "Caching " + object.getType() + " " + object.getName() + " but it has no ID");
            } else {
                SchemaObject oldFromID = this.m_idToObjectMap.put(id, object);
                if (oldFromID != null && oldFromID != object) {
                    DBLog.getLogger().log(Level.FINE, "Caching " + object.getType() + " " + object.getName() + " but we already have one!");
                }
            }
        }

        private void clearCache() {
            this.m_objectMap.clear();
            this.m_idToObjectMap.clear();
        }

        private void addObjectToCache(SchemaObject object) {
            SchemaObject old = this.findObject(object.getSchema(), object.getName());
            if (old != object) {
                if (old != null) {
                    this.removeObjectFromCache(object.getSchema(), object.getName());
                }
                if (object != null) {
                    this.cacheObject(object);
                }
            }
        }

        private void removeObjectFromCache(Schema schema, String name) {
            DBObjectID id;
            SchemaObject obj = this.m_objectMap.remove(this.getKey(schema, name));
            if (obj != null && this.m_idToObjectMap.get(id = obj.getID()) == obj) {
                this.m_idToObjectMap.remove(id);
            }
        }

        private String getKey(Schema schema, String name) {
            String schemaName;
            StringBuffer buf = new StringBuffer();
            String string = schemaName = schema != null ? schema.getName() : null;
            if (schemaName != null) {
                buf.append(schemaName);
            }
            buf.append('\n');
            buf.append(name);
            return buf.toString();
        }

        static DBObjectBuilder mav$getBuilder(ObjectTypeEntry objectTypeEntry) {
            return objectTypeEntry.getBuilder();
        }

        static SchemaObject mav$findObject(ObjectTypeEntry objectTypeEntry, DBObjectID dBObjectID) {
            return objectTypeEntry.findObject(dBObjectID);
        }

        static void mav$cacheObject(ObjectTypeEntry objectTypeEntry, SchemaObject schemaObject) {
            objectTypeEntry.cacheObject(schemaObject);
        }

        static SchemaObject mav$findObject(ObjectTypeEntry objectTypeEntry, Schema schema, String string) {
            return objectTypeEntry.findObject(schema, string);
        }

        static void mav$removeObjectFromCache(ObjectTypeEntry objectTypeEntry, Schema schema, String string) {
            objectTypeEntry.removeObjectFromCache(schema, string);
        }

        static void mav$addObjectToCache(ObjectTypeEntry objectTypeEntry, SchemaObject schemaObject) {
            objectTypeEntry.addObjectToCache(schemaObject);
        }

        static void mav$clearCache(ObjectTypeEntry objectTypeEntry) {
            objectTypeEntry.clearCache();
        }

        static DBObjectValidator mav$getValidator(ObjectTypeEntry objectTypeEntry) {
            return objectTypeEntry.getValidator();
        }

        static void mav$setValidator(ObjectTypeEntry objectTypeEntry, DBObjectValidator dBObjectValidator) {
            objectTypeEntry.setValidator(dBObjectValidator);
        }

        static void mav$setBuilder(ObjectTypeEntry objectTypeEntry, DBObjectBuilder dBObjectBuilder) {
            objectTypeEntry.setBuilder(dBObjectBuilder);
        }

        ObjectTypeEntry(String string, DBObjectBuilder dBObjectBuilder, DBObjectValidator dBObjectValidator, 1 var5_5) {
            this(string, dBObjectBuilder, dBObjectValidator);
        }

        public final class 1 {
        }
    }
}

