/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.property.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChildDBObject
extends AbstractDBObject
implements ChildDBObject {
    private transient DBObject m_parent;

    protected AbstractChildDBObject() {
    }

    protected AbstractChildDBObject(String name) {
        super(name);
    }

    protected AbstractChildDBObject(String name, DBObject parent) {
        super(name);
        this.m_parent = parent;
    }

    @Override
    @Transient
    public void setParent(DBObject parent) {
        this.m_parent = parent;
    }

    @Override
    @Transient
    public final DBObject getParent() {
        return this.m_parent;
    }

    public final <T extends DBObject> T findParent(Class<T> parentClass) {
        DBObject parent = this.getParent();
        while (parent != null) {
            if (parentClass.isAssignableFrom(parent.getClass())) {
                return (T)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    protected void copyToImpl(AbstractChildDBObject copy, DBObject copyParent, IDPolicy idPolicy) {
        copy.setParent(copyParent);
        super.copyToImpl(copy, copyParent, idPolicy);
    }
}

