/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.images.RaptorImagesArb;
import oracle.dbtools.raptor.utils.UtilsResources;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.dialogs.URLChooserShortcut;
import oracle.ide.dialogs.URLChooserShortcutProvider;
import oracle.ide.layout.URL2String;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class URLChooserShortcuts
implements URLChooserShortcutProvider {
    private static List<URLChooserShortcut> s_shortcuts = null;
    private static URL s_scriptDir;

    private static void addIfExists(URL uRL, String string, Collection<URLChooserShortcut> collection, Icon icon) {
        if (URLChooserShortcuts.isValidURL(uRL)) {
            if (icon == null) {
                collection.add(new URLChooserShortcut(OracleIcons.getIcon((String)"folder.png"), string, uRL));
            } else {
                collection.add(new URLChooserShortcut(icon, string, uRL));
            }
        }
    }

    private static boolean isValidURL(URL uRL) {
        return URLFileSystem.exists((URL)uRL) && URLFileSystem.isDirectory((URL)uRL) && !URLFileSystem.isHidden((URL)uRL);
    }

    private static URL getScriptDir() {
        if (s_scriptDir == null) {
            String string = DBConfig.getInstance().getString("DEFAULTPATH");
            s_scriptDir = ModelUtil.hasLength((String)string) ? URLFactory.newDirURL((String)string) : URLFactory.newDirURL((URL)URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory()), (String)"sql");
        }
        return s_scriptDir;
    }

    public static Collection<URLChooserShortcut> getShortcuts(boolean bl) {
        Serializable serializable;
        ArrayList<URLChooserShortcut> arrayList = new ArrayList<URLChooserShortcut>();
        if (s_shortcuts == null) {
            s_shortcuts = new ArrayList<URLChooserShortcut>();
            serializable = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
            URLChooserShortcuts.addIfExists(URLFactory.newDirURL((URL)serializable, (String)"Desktop"), UtilsResources.get("DESKTOP"), s_shortcuts, RaptorImagesArb.getIcon(74));
            URLChooserShortcuts.addIfExists(URLFactory.newDirURL((URL)serializable, (String)"Documents"), UtilsResources.get("DOCUMENTS"), s_shortcuts, RaptorImagesArb.getIcon(73));
            URLChooserShortcuts.addIfExists(URLFactory.newDirURL((URL)serializable, (String)"My Documents"), UtilsResources.get("MY_DOCUMENTS"), s_shortcuts, RaptorImagesArb.getIcon(73));
        }
        arrayList.addAll(s_shortcuts);
        URLChooserShortcuts.addIfExists(URLChooserShortcuts.getScriptDir(), UtilsResources.get("SQL"), arrayList, null);
        if (bl) {
            serializable = new HashSet();
            String[] stringArray = FileOpenHistory.getInstance().getFileHistory();
            for (int i = stringArray.length - 1; i >= 0; --i) {
                URL uRL;
                URL uRL2 = URL2String.toURL((String)stringArray[i]);
                if (!URLFileSystem.exists((URL)uRL2) || serializable.contains(uRL = URLFileSystem.getParent((URL)uRL2))) continue;
                serializable.add(uRL);
                URLChooserShortcuts.addIfExists(uRL, URLFileSystem.getName((URL)uRL), arrayList, null);
            }
        }
        return arrayList;
    }

    public Collection<URLChooserShortcut> createShortcuts(Context context) {
        return URLChooserShortcuts.getShortcuts(true);
    }

    static {
        DBConfig.getInstance().addStructureChangeListener(new StructureChangeListener(){

            public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
                String string = "";
                for (ChangeInfo changeInfo : structureChangeEvent.getChangeDetails()) {
                    string = changeInfo.getPropertyLocalName();
                    if (!"DEFAULTPATH".equals(string) || changeInfo.getChangeType() != 0) continue;
                    String string2 = changeInfo.getNewValueAsString();
                    s_scriptDir = ModelUtil.hasLength((String)string2) ? URLFactory.newDirURL((String)string2) : URLFactory.newDirURL((URL)URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory()), (String)"sql");
                }
            }
        });
    }
}

