/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpProvider;
import oracle.bali.ewt.help.HelpUnavailableException;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.sqldialog.SQLDialogHelpProvider;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.format.XMLFormatter;
import oracle.dbtools.raptor.format.ui.TableFormatterWrapper;
import oracle.dbtools.raptor.navigator.impl.DatabaseNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditorAddin;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.WaitCursor;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.dialogs.DialogSizeKeeper;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.help.HelpSystem;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.MultiInputMap;
import oracle.ide.keyboard.MultiMapAdapter;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectListener;
import oracle.javatools.editor.EditorProperties;

public class UIUtils {
    public static final String HELP_TEXT = "HELP_TEXT";

    public static void showPanelAsDialog(JPanel jPanel, String string, ActionListener actionListener) {
        UIUtils.showPanelAsDialog(jPanel, string, actionListener, 14, true);
    }

    public static void showPanelAsDialog(JPanel jPanel, String string, ActionListener actionListener, boolean bl) {
        UIUtils.showPanelAsDialog(jPanel, string, actionListener, 14, bl);
    }

    public static void showPanelAsTabbedDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener) {
        UIUtils.showPanelAsTabbedDialog(jPanelArray, stringArray, string, actionListener, null, null);
    }

    public static void showPanelAsTabbedDialog2(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener) {
        UIUtils.showPanelAsTabbedDialog2(jPanelArray, stringArray, string, actionListener, null, null);
    }

    public static void showPanelAsTabbedDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider) {
        UIUtils.showPanelAsTabbedDialog(jPanelArray, stringArray, string, actionListener, helpProvider, null);
    }

    public static void showPanelAsTabbedDialog(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider, ChangeListener changeListener) {
        final CustomTabbedPane customTabbedPane = new CustomTabbedPane();
        for (int i = 0; i < jPanelArray.length; ++i) {
            jPanelArray[i].setBorder(BorderFactory.createEtchedBorder());
            customTabbedPane.addTab(null, stringArray[i], jPanelArray[i]);
        }
        if (helpProvider != null) {
            customTabbedPane.putClientProperty("JEWT.HelpProvider", helpProvider);
        } else {
            HelpProvider helpProvider2 = new HelpProvider(){

                public void showHelp(Component component) throws HelpUnavailableException {
                    HelpSystem.getHelpSystem().showHelp((JComponent)customTabbedPane.getActivePanel());
                }
            };
            customTabbedPane.putClientProperty("JEWT.HelpProvider", helpProvider2);
        }
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)customTabbedPane, null, (String)string, (int)14);
        if (actionListener != null) {
            jEWTDialog.addActionListener(actionListener);
        }
        if (changeListener != null) {
            customTabbedPane.addChangeListener(changeListener);
        }
        jEWTDialog.setSize(600, 300);
        jEWTDialog.pack();
        jEWTDialog.setPreferredSize(customTabbedPane.getPreferredSize());
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }

    public static void showPanelAsTabbedDialog2(JPanel[] jPanelArray, String[] stringArray, String string, ActionListener actionListener, HelpProvider helpProvider, ChangeListener changeListener) {
        final CustomTabbedPane customTabbedPane = new CustomTabbedPane();
        for (int i = 0; i < jPanelArray.length; ++i) {
            jPanelArray[i].setBorder(BorderFactory.createEtchedBorder());
            customTabbedPane.addTab(null, stringArray[i], jPanelArray[i]);
        }
        if (helpProvider != null) {
            customTabbedPane.putClientProperty("JEWT.HelpProvider", helpProvider);
        } else {
            HelpProvider helpProvider2 = new HelpProvider(){

                public void showHelp(Component component) throws HelpUnavailableException {
                    HelpSystem.getHelpSystem().showHelp((JComponent)customTabbedPane.getActivePanel());
                }
            };
            customTabbedPane.putClientProperty("JEWT.HelpProvider", helpProvider2);
        }
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)customTabbedPane, null, (String)string, (int)28);
        if (actionListener != null) {
            jEWTDialog.addActionListener(actionListener);
        }
        if (changeListener != null) {
            customTabbedPane.addChangeListener(changeListener);
        }
        jEWTDialog.setSize(600, 300);
        jEWTDialog.pack();
        jEWTDialog.setPreferredSize(customTabbedPane.getPreferredSize());
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }

    public static void showPanelAsDialog(JPanel jPanel, String string, ActionListener actionListener, int n) {
        UIUtils.showPanelAsDialog(jPanel, string, actionListener, n, true);
    }

    public static void showPanelAsDialog(JPanel jPanel, String string, ActionListener actionListener, int n, boolean bl) {
        Dimension dimension = jPanel.getPreferredSize();
        dimension.setSize(dimension.getWidth() + 150.0, dimension.getHeight() + 100.0);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)n);
        if (actionListener != null) {
            jEWTDialog.addActionListener(actionListener);
        }
        jEWTDialog.setModal(bl);
        if (jPanel.getClientProperty(HELP_TEXT) != null) {
            final JPanel jPanel2 = jPanel;
            String string2 = (String)jPanel.getClientProperty(HELP_TEXT);
            HelpProvider helpProvider = new HelpProvider(){

                public void showHelp(Component component) throws HelpUnavailableException {
                    HelpSystem.getHelpSystem().showHelp((JComponent)jPanel2);
                }
            };
            jPanel.putClientProperty("JEWT.HelpProvider", new SQLDialogHelpProvider(string2));
        }
        jEWTDialog.setSize(dimension);
        DialogSizeKeeper.attachToComponent((Component)jEWTDialog, (String)(string + ".dialogSize"));
        jEWTDialog.setLocationRelativeTo(null);
        jEWTDialog.setVisible(true);
    }

    public static void setClipboard(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
    }

    public static void editNodeWizard(DatabaseNode databaseNode) {
        Context context = Context.newIdeContext((Element)databaseNode);
        final DBObject dBObject = new DBObject((Element)((Node)databaseNode));
        SchemaObject schemaObject = dBObject.getSchemaObject();
        context.setProperty("ParentObject", (Object)schemaObject);
        Database database = dBObject.getDatabase();
        String string = dBObject.getObjectType();
        DBEditorFactory dBEditorFactory = DBEditorFactoryRegistry.getCreateFactory((DBObjectProvider)database, (String)string);
        if (dBEditorFactory != null) {
            URL uRL = dBObject.getNode().getURL();
            if (schemaObject != null) {
                SchemaObjectListener schemaObjectListener = new SchemaObjectListener(){

                    public void schemaObjectUpdated(DBObjectChange dBObjectChange) {
                        DatabaseNode databaseNode = (DatabaseNode)dBObject.getNode();
                        UpdateMessage.fireStructureChanged((Subject)databaseNode);
                    }
                };
                schemaObject.addObjectListener(schemaObjectListener);
                dBEditorFactory.editDBObject((oracle.javatools.db.DBObject)schemaObject, (DBObjectProvider)database);
                schemaObject.removeObjectListener(schemaObjectListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void editNode(DatabaseNode databaseNode) {
        Context context = Context.newIdeContext((Element)databaseNode);
        OpenEditorOptions openEditorOptions = new OpenEditorOptions(context);
        openEditorOptions.setFlags(1);
        WaitCursor waitCursor = Ide.getWaitCursor();
        try {
            waitCursor.show();
            EditorManager.getEditorManager().openEditor(openEditorOptions);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            waitCursor.hide();
            throw throwable;
        }
        waitCursor.hide();
    }

    public static void makeTitledBorder(JComponent jComponent, String string) {
        TitledBorder titledBorder = new TitledBorder(string);
        jComponent.setBorder(titledBorder);
    }

    public static void addFontListener(Component component) {
        final Component component2 = component;
        ClientSetting clientSetting = ClientSetting.findOrCreate((String)AddinManager.getAddinManager().getExtensionIDForAddin(CodeEditorAddin.class));
        FontSizeOptions fontSizeOptions = (FontSizeOptions)clientSetting.getData("FontSizeOptions");
        if (fontSizeOptions != null) {
            Font font = new Font(fontSizeOptions.getFontFamily(), 0, fontSizeOptions.getFontSize());
            component.setFont(font);
        }
        EditorProperties.getProperties().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() != "editor-font-size" && propertyChangeEvent.getPropertyName() != "editor-font-family") {
                    String string = null;
                    Object var3_3 = null;
                    int n = 10;
                    n = propertyChangeEvent.getPropertyName() == "editor-font-size" ? ((Integer)propertyChangeEvent.getNewValue()).intValue() : component2.getFont().getSize();
                    string = propertyChangeEvent.getPropertyName() == "editor-font-family" ? (String)propertyChangeEvent.getNewValue() : component2.getFont().getFamily();
                    Font font = null;
                    font = propertyChangeEvent.getPropertyName() == "editor-font" ? (Font)propertyChangeEvent.getNewValue() : new Font(string, 0, n);
                    component2.setFont(font);
                }
            }
        });
    }

    public static void addIdeKeyBindings(JComponent jComponent, int n, String string) {
        KeyStrokeOptions keyStrokeOptions = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext keyStrokeContext = keyStrokeContextRegistry.getContext(string);
        MultiInputMap multiInputMap = MultiMapAdapter.getLocalMap((KeyStrokeOptions)keyStrokeOptions, (KeyStrokeContext)keyStrokeContext);
        MultiMapAdapter.fillLocalMap((MultiInputMap)multiInputMap, (KeyStrokeOptions)keyStrokeOptions, (KeyStrokeContext)keyStrokeContext);
        for (KeyStroke keyStroke : multiInputMap.allKeys()) {
            Object object = null;
            try {
                object = multiInputMap.get(keyStroke);
            }
            catch (Exception exception) {
                // empty catch block
            }
            jComponent.getInputMap(n).put(keyStroke, object);
        }
        Set set = keyStrokeContext.getAllActions(false);
        ActionMap actionMap = Ide.getIdeActionMap();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            KeyStroke keyStroke;
            keyStroke = (IdeAction)iterator.next();
            if (actionMap.get(keyStroke.getCommandId()) == null) continue;
            jComponent.getActionMap().put(keyStroke.getCommandId(), (Action)((Object)keyStroke));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void tableToXml(JTable jTable, String string, String string2, final boolean bl, final boolean bl2) throws IOException {
        XMLFormatter xMLFormatter = new XMLFormatter(){

            public void printColumn(Object object, int n, int n2) throws IOException {
                if (bl2) {
                    super.printColumn(object, n, n2);
                    return;
                }
                if (n == 0 && !bl) {
                    return;
                }
                String string = this.getColumnName(n2);
                this.write("\t\t<" + string.replace(' ', '_').replace('/', '_') + ">");
                this.write("<![CDATA[");
                if (object != null) {
                    this.write(this.getValue(object).toString());
                }
                this.write("]]>");
                this.write("</" + string.replace(' ', '_') + ">" + this.getLineTerminator());
            }
        };
        File file = new File(string);
        OutputStreamWriter outputStreamWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            outputStreamWriter = new OutputStreamWriter((OutputStream)bufferedOutputStream, string2);
            xMLFormatter.setDataProvider((ResultsFormatterWrapper)new TableFormatterWrapper(jTable));
            xMLFormatter.setOutWriter(outputStreamWriter);
            xMLFormatter.setResult(false);
            xMLFormatter.print();
            Object var11_10 = null;
            if (outputStreamWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (outputStreamWriter == null) throw throwable;
            try {
                outputStreamWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Logger.getLogger(UIUtils.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            throw throwable;
        }
        try {
            outputStreamWriter.close();
            return;
        }
        catch (IOException iOException) {
            Logger.getLogger(UIUtils.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }
}

