/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.awt.Component;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.Translate;
import oracle.ide.Ide;
import oracle.ide.dialogs.OptionSelectionDialog;
import oracle.ide.help.HelpSystem;
import oracle.jdeveloper.db.ConnectionsEvent;
import oracle.jdeveloper.db.DisconnectListener;

public class RaptorDbDisconnectListener
implements DisconnectListener {
    public static final String OPTION_COMMIT = ConnectionArb.getString(103);
    public static final String OPTION_ROLLBACK = ConnectionArb.getString(104);
    public static final String OPTION_CANCEL_DISCONNECT = ConnectionArb.getString(111);
    public static final String[] OPTIONS = new String[]{OPTION_COMMIT, OPTION_ROLLBACK, OPTION_CANCEL_DISCONNECT};

    public boolean canDisconnect(ConnectionsEvent connectionsEvent) {
        String string = connectionsEvent.getName();
        string = Connections.ConnectionKey.createConnectionKey("IdeConnections", string).getQualifiedName();
        try {
            if (RaptorExtensionConstants.isStandAlone() && Connections.getInstance().isOracle(string) && DBUtil.isOracleConnectionAlive((Connection)Connections.getInstance().getConnection(string, false)) && DBUtil.hasTransaction((String)string)) {
                OptionSelectionDialog optionSelectionDialog = new OptionSelectionDialog();
                HelpSystem.getHelpSystem().registerTopic((JComponent)optionSelectionDialog, "f1_connection_has_pending_changes_html");
                boolean bl = optionSelectionDialog.showDialog((Component)Ide.getMainWindow(), MessageFormat.format(ConnectionArb.getString(113), Connections.getDisplayName(string)), ConnectionArb.getString(112), (Object[])OPTIONS, "f1_connection_has_pending_changes_html");
                if (bl) {
                    String string2 = optionSelectionDialog.getSelectedOption().toString();
                    if (string2.equals(OPTION_COMMIT)) {
                        Connections.getInstance().getConnection(string).commit();
                        return true;
                    }
                    if (string2.equals(OPTION_ROLLBACK)) {
                        Connections.getInstance().getConnection(string).rollback();
                        return true;
                    }
                    return false;
                }
                return false;
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Translate.translate((String)"An attempt to determine pending transaction for the just closed connection failed."));
        }
        return true;
    }

    public void connectionDisconnected(ConnectionsEvent connectionsEvent) {
    }
}

