/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.status;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.status.MemoryPanel;
import oracle.dbtools.raptor.status.StatusPanelArb;
import oracle.dbtools.raptor.status.TableSpacePanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.javatools.db.DBException;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;

public class StatusPanel {
    public static final String STATUS_NAME = "raptor.StatusPanel";
    public static final int STATUS_ACTION = Ide.findOrCreateCmdID((String)"raptor.StatusPanel");
    private static StatusPanel INSTANCE;
    private TableSpacePanel tp;
    private MemoryPanel mp;
    private JPanel jp = new JPanel();
    private String dba_sql;
    private String up_sql;
    private String cName;
    private OracleConnection conn = null;
    final IDelayedProgressRunnable stopDb = new IDelayedProgressRunnable(){

        public void cancel() {
        }

        public Object doWork() {
            StatusPanel.this.shutdown();
            StatusPanel.this.refresh(StatusPanel.this.cName);
            return true;
        }

        public void finish(Object object) {
        }

        public void preWork() {
        }
    };
    final IDelayedProgressRunnable startDb = new IDelayedProgressRunnable(){

        public void cancel() {
        }

        public Object doWork() {
            StatusPanel.this.startup();
            StatusPanel.this.refresh(StatusPanel.this.cName);
            return true;
        }

        public void finish(Object object) {
        }

        public void preWork() {
        }
    };

    public static void initMenu() {
        IdeAction ideAction = IdeAction.get((int)STATUS_ACTION, null, (String)"STATUS", (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)new Integer(69), (ResourceBundle)RaptorImage.getInstance(), (String)"db.png", null, (boolean)true);
        ideAction.setEnabled(true);
        ideAction.addController(ExportController.INSTANCE);
        Menubar menubar = Ide.getMenubar();
        JMenuItem jMenuItem = menubar.createMenuItem((ToggleAction)ideAction, 1.0f);
        menubar.add((Component)jMenuItem, MenuManager.getJMenu((String)"Tools"));
    }

    public static StatusPanel getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StatusPanel();
        }
        return INSTANCE;
    }

    private void shutdown() {
        try {
            Properties properties = Connections.getInstance().getConnectionInfo(this.cName);
            String string = properties.getProperty("customUrl");
            String string2 = properties.getProperty("user");
            String string3 = properties.getProperty("password");
            OracleDataSource oracleDataSource = new OracleDataSource();
            Properties properties2 = new Properties();
            properties2.setProperty("user", string2);
            properties2.setProperty("password", string3);
            properties2.setProperty("internal_logon", "sysdba");
            oracleDataSource.setConnectionProperties(properties2);
            oracleDataSource.setURL(string);
            OracleConnection oracleConnection = (OracleConnection)oracleDataSource.getConnection();
            oracleConnection.shutdown(OracleConnection.DatabaseShutdownMode.IMMEDIATE);
            Statement statement = oracleConnection.createStatement();
            statement.executeUpdate("ALTER DATABASE CLOSE NORMAL");
            statement.executeUpdate("ALTER DATABASE DISMOUNT");
            statement.close();
            oracleConnection.shutdown(OracleConnection.DatabaseShutdownMode.FINAL);
            oracleConnection.close();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Exception)exception);
        }
    }

    private void startup() {
        try {
            Properties properties = Connections.getInstance().getConnectionInfo(this.cName);
            String string = properties.getProperty("customUrl");
            String string2 = properties.getProperty("user");
            String string3 = properties.getProperty("password");
            OracleDataSource oracleDataSource = new OracleDataSource();
            Properties properties2 = new Properties();
            properties2.setProperty("user", string2);
            properties2.setProperty("password", string3);
            properties2.setProperty("internal_logon", "sysdba");
            properties2.setProperty("prelim_auth", "true");
            oracleDataSource.setConnectionProperties(properties2);
            oracleDataSource.setURL(string);
            OracleConnection oracleConnection = (OracleConnection)oracleDataSource.getConnection();
            oracleConnection.startup(OracleConnection.DatabaseStartupMode.NO_RESTRICTION);
            oracleConnection.close();
            OracleDataSource oracleDataSource2 = new OracleDataSource();
            Properties properties3 = new Properties();
            properties3.setProperty("user", string2);
            properties3.setProperty("password", string3);
            properties3.setProperty("internal_logon", "sysdba");
            oracleDataSource2.setConnectionProperties(properties3);
            oracleDataSource2.setURL(string);
            OracleConnection oracleConnection2 = (OracleConnection)oracleDataSource2.getConnection();
            Statement statement = oracleConnection2.createStatement();
            statement.executeUpdate("ALTER DATABASE MOUNT");
            statement.executeUpdate("ALTER DATABASE OPEN");
            statement.close();
            oracleConnection2.close();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException((Exception)exception);
        }
    }

    private void setupSql(OracleConnection oracleConnection) {
        if (this.up_sql == null) {
            QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)"/oracle/dbtools/raptor/status/StatusSql.xml");
            Query query = queryXMLSupport.getQuery("reg_dba", (Connection)oracleConnection);
            this.dba_sql = query.getSql();
            query = queryXMLSupport.getQuery("is_up", (Connection)oracleConnection);
            this.up_sql = query.getSql();
        }
    }

    private boolean isSysDba(String string) {
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        if (properties != null) {
            String string2 = properties.getProperty("role");
            return "SYSDBA".equals(string2);
        }
        return false;
    }

    private boolean isOracle(String string) {
        return Connections.getInstance().isOracle(string);
    }

    private boolean isDba(OracleConnection oracleConnection) {
        DBUtil dBUtil = DBUtil.getInstance();
        dBUtil.setRaiseError(false);
        String string = dBUtil.executeReturnOneCol((Connection)oracleConnection, this.dba_sql, new ArrayList());
        dBUtil.setRaiseError(true);
        return "YES".equals(string);
    }

    private boolean isUp(OracleConnection oracleConnection) {
        DBUtil dBUtil = DBUtil.getInstance();
        dBUtil.setRaiseError(false);
        String string = dBUtil.executeReturnOneCol((Connection)oracleConnection, this.up_sql, new ArrayList());
        dBUtil.setRaiseError(true);
        return "YES".equals(string);
    }

    public JPanel getPanel(String string) {
        this.cName = string;
        this.jp.removeAll();
        this.jp.setLayout(new GridBagLayout());
        if (!this.isOracle(this.cName)) {
            this.jp.add((Component)new JLabel(StatusPanelArb.getString(5)), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            return this.jp;
        }
        try {
            ConnectionSelectorUI.SELECTOR_ACTIVE = true;
            this.conn = (OracleConnection)Connections.getInstance().getConnection(this.cName);
            this.setupSql(this.conn);
            if (this.isUp(this.conn)) {
                JButton jButton;
                if (this.isDba(this.conn)) {
                    this.mp = new MemoryPanel((Connection)this.conn);
                    this.jp.add((Component)this.mp.getPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
                    this.tp = new TableSpacePanel((Connection)this.conn);
                    this.jp.add((Component)this.tp.getPanel(), new GridBagConstraints(0, 1, 3, 1, 0.1, 1.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
                    jButton = new JButton("Refresh");
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            StatusPanel.this.tp.refresh();
                            StatusPanel.this.mp.refresh();
                        }
                    });
                    this.jp.add((Component)jButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 20, 0, 0), 0, 0));
                } else {
                    this.jp.add((Component)new JLabel(StatusPanelArb.getString(6)), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                }
                if (this.isSysDba(this.cName)) {
                    jButton = new JButton("Shutdown");
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("Shut Down DB", null, 500, StatusPanel.this.stopDb);
                                    delayedProgressRunnable.setCancellable(false);
                                    delayedProgressRunnable.start();
                                }
                            });
                        }
                    });
                    this.jp.add((Component)jButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 5, 0, 0), 0, 0));
                }
                return this.jp;
            }
            if (this.isSysDba(this.cName)) {
                JButton jButton = new JButton("Startup");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("StartUp DB", null, 500, StatusPanel.this.startDb);
                                delayedProgressRunnable.setCancellable(false);
                                delayedProgressRunnable.start();
                            }
                        });
                    }
                });
                this.jp.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                return this.jp;
            }
            this.jp.add((Component)new JLabel(StatusPanelArb.getString(7)), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            return this.jp;
        }
        catch (Exception exception) {
            if (this.isSysDba(this.cName)) {
                JButton jButton = new JButton("Startup");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("Start DB", null, 500, StatusPanel.this.startDb);
                                delayedProgressRunnable.setCancellable(false);
                                delayedProgressRunnable.start();
                            }
                        });
                    }
                });
                this.jp.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                return this.jp;
            }
            this.jp.add((Component)new JLabel(StatusPanelArb.getString(7)), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            return this.jp;
        }
    }

    public void refresh(String string) {
        this.cName = string;
        this.jp.removeAll();
        this.jp.setLayout(new GridBagLayout());
        if (!this.isOracle(this.cName)) {
            this.jp.add((Component)new JLabel(StatusPanelArb.getString(5)), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jp.validate();
            return;
        }
        try {
            this.conn = (OracleConnection)Connections.getInstance().getConnection(this.cName);
            this.setupSql(this.conn);
            if (this.isUp(this.conn)) {
                JButton jButton;
                if (this.isDba(this.conn)) {
                    this.mp = new MemoryPanel((Connection)this.conn);
                    this.jp.add((Component)this.mp.getPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 20, 0, 0), 0, 0));
                    this.tp = new TableSpacePanel((Connection)this.conn);
                    this.jp.add((Component)this.tp.getPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
                    jButton = new JButton("Refresh");
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            StatusPanel.this.tp.refresh();
                            StatusPanel.this.mp.refresh();
                        }
                    });
                    this.jp.add((Component)jButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
                } else {
                    this.jp.add((Component)new JLabel(StatusPanelArb.getString(6)), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                }
                if (this.isSysDba(this.cName)) {
                    jButton = new JButton("Shutdown");
                    jButton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("Shut Down DB", null, 500, StatusPanel.this.stopDb);
                                    delayedProgressRunnable.setCancellable(false);
                                    delayedProgressRunnable.start();
                                }
                            });
                        }
                    });
                    this.jp.add((Component)jButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
                }
                this.jp.add((Component)new JLabel(" "), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
                this.jp.validate();
                return;
            }
            if (this.isSysDba(this.cName)) {
                JButton jButton = new JButton("Startup");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("Start DB", null, 500, StatusPanel.this.startDb);
                                delayedProgressRunnable.setCancellable(false);
                                delayedProgressRunnable.start();
                            }
                        });
                    }
                });
                this.jp.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.jp.validate();
                return;
            }
            this.jp.add((Component)new JLabel(StatusPanelArb.getString(7)), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jp.validate();
            return;
        }
        catch (DBException dBException) {
            if (this.isSysDba(this.cName)) {
                JButton jButton = new JButton("Startup");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("Start DB", null, 500, StatusPanel.this.startDb);
                                delayedProgressRunnable.setCancellable(false);
                                delayedProgressRunnable.start();
                            }
                        });
                    }
                });
                this.jp.add((Component)jButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.jp.validate();
                return;
            }
            this.jp.add((Component)new JLabel(StatusPanelArb.getString(7)), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jp.validate();
            return;
        }
    }

    public void launch() {
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)Ide.getMainWindow(), (Component)this.getPanel("IdeConnections%23local-sys"), null, (String)"Status Test", (int)16);
        Dimension dimension = new Dimension(600, 480);
        jEWTDialog.setSize(dimension);
        jEWTDialog.setVisible(true);
    }

    private static class ExportController
    implements Controller {
        private static Controller INSTANCE = new ExportController();

        private ExportController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == STATUS_ACTION) {
                StatusPanel.getInstance().launch();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (ideAction.getCommandId() == STATUS_ACTION) {
                ideAction.setEnabled(true);
                return true;
            }
            return false;
        }
    }
}

