/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.scriptrunner.utils;

import java.awt.Component;
import java.awt.Container;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.scriptrunner.OutputRedirector;
import oracle.dbtools.raptor.scriptrunner.ScriptRunner;
import oracle.dbtools.raptor.scriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptMessagePage;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.log.LogPage;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdbc.OracleDriver;

public class ScriptUtils {
    private static final Logger LOGGER = Logger.getLogger(ScriptUtils.class.getName());

    public static String runAsScript(String string, String string2, LogPage logPage) {
        return ScriptUtils.runAsScript(new StringReader(string), string2, logPage);
    }

    public static String runAsScript(String string, String string2) {
        return ScriptUtils.runAsScript(new StringReader(string), string2, null);
    }

    public static String runAsScript(InputStream inputStream, String string, LogPage logPage) {
        return ScriptUtils.runAsScript(new InputStreamReader(inputStream), string, logPage);
    }

    public static String runAsScript(InputStream inputStream, String string) {
        return ScriptUtils.runAsScript(new InputStreamReader(inputStream), string, null);
    }

    public static String runAsScript(Reader reader, String string) {
        return ScriptUtils.runAsScript(reader, string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String runAsScript(Reader reader, String string, LogPage object) {
        block8: {
            if (string == null) {
                string = ConnectionSelectorUI.getConnection(ConnectionArb.getString(32), ConnectionArb.getString(31), string, true);
            }
            if (string != null) {
                try {
                    try {
                        if (object == null) {
                            object = ScriptMessagePage.getScriptMessagePage();
                            object.clearAll();
                        }
                        ScriptRunner scriptRunner = new ScriptRunner(reader, ScriptUtils.resolveConnectionName(string));
                        scriptRunner.setScriptRunnerContext(new ScriptRunnerContext());
                        PipedInputStream pipedInputStream = new PipedInputStream();
                        OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, object);
                        outputRedirector.setName("Report output reader");
                        outputRedirector.start();
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
                        scriptRunner.setOut(bufferedOutputStream);
                        scriptRunner.run();
                        outputRedirector.stopRun();
                    }
                    catch (DBException dBException) {
                        Logger.getLogger(ScriptUtils.class.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                        Object var8_10 = null;
                        break block8;
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(ScriptUtils.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                        Object var8_11 = null;
                    }
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    throw throwable;
                }
            }
        }
        return string;
    }

    public static String runSqlReturnResult(String string, Connection connection) {
        try {
            String string2 = IdeUtil.getIdeEncoding();
            StringReader stringReader = new StringReader(string);
            ScriptRunner scriptRunner = new ScriptRunner((Reader)stringReader, connection);
            ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
            scriptRunnerContext.putProperty("script.runner.using.systemout", (Object)true);
            scriptRunner.setScriptRunnerContext(scriptRunnerContext);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
            scriptRunner.setOut(bufferedOutputStream);
            scriptRunner.run();
            bufferedOutputStream.flush();
            return byteArrayOutputStream.toString(string2);
        }
        catch (Exception exception) {
            return exception.getMessage();
        }
    }

    private static Connection resolveConnectionName(String string) throws DBException {
        return DBUtil.getConnectionResolver().getConnection(string);
    }

    public static void runFileInDialog(File file, Connection connection) {
        final File file2 = file;
        final Connection connection2 = connection;
        final BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        basicEditorPane.setText("");
        final IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){
            private boolean _isCanceled = false;
            ScriptRunner sr = null;

            public void cancel() {
                this.sr.interrupt();
                this._isCanceled = true;
            }

            public Object doWork() {
                Object var1_1 = null;
                this.sr = new ScriptRunner("@" + file2.getAbsolutePath(), connection2);
                basicEditorPane.setEditable(true);
                this.sr.setScriptRunnerContext(new ScriptRunnerContext());
                this.sr.getScriptRunnerContext().setSubstitutionChar('^');
                this.sr.getScriptRunnerContext().setSubstitutionOn(false);
                this.sr.getScriptRunnerContext().setScanOn(false);
                PipedInputStream pipedInputStream = new PipedInputStream();
                BufferedOutputStream bufferedOutputStream = null;
                try {
                    bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
                }
                catch (IOException iOException) {
                    LOGGER.throwing(ScriptUtils.class.getName(), "running", iOException);
                }
                this.sr.setOut(bufferedOutputStream);
                this.sr.start();
                OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, basicEditorPane.getDocument(), basicEditorPane);
                outputRedirector.setName("Script output reader");
                outputRedirector.start();
                basicEditorPane.setEditable(false);
                while (this.sr.isAlive()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return var1_1;
            }

            public void finish(Object object) {
                file2.deleteOnExit();
                if (this._isCanceled) {
                    try {
                        connection2.rollback();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.severe("Could not rollback");
                    }
                }
            }

            public void preWork() {
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable("Installing", null, 500, iDelayedProgressRunnable, (Component)basicEditorPane);
                delayedProgressRunnable.setCancellable(true);
                delayedProgressRunnable.start();
            }
        });
    }

    public static void runInDialog(String string, InputStream inputStream, final Connection connection, final boolean bl) {
        final InputStream inputStream2 = inputStream;
        final Connection connection2 = connection;
        final BasicEditorPane basicEditorPane = EditorFactory.createIdeEditorPane();
        basicEditorPane.setText("");
        IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){
            private boolean _isCanceled = false;
            ScriptRunner sr = null;

            public void cancel() {
                this.sr.interrupt();
                this._isCanceled = true;
            }

            public Object doWork() {
                Object var1_1 = null;
                this.sr = new ScriptRunner(inputStream2, connection2);
                basicEditorPane.setEditable(true);
                this.sr.setScriptRunnerContext(new ScriptRunnerContext());
                this.sr.getScriptRunnerContext().setSubstitutionChar('^');
                this.sr.getScriptRunnerContext().setSubstitutionOn(false);
                this.sr.getScriptRunnerContext().setScanOn(false);
                PipedInputStream pipedInputStream = new PipedInputStream();
                BufferedOutputStream bufferedOutputStream = null;
                try {
                    bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
                }
                catch (IOException iOException) {
                    LOGGER.throwing(ScriptUtils.class.getName(), "running", iOException);
                }
                this.sr.setOut(bufferedOutputStream);
                this.sr.start();
                OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, basicEditorPane.getDocument(), basicEditorPane);
                outputRedirector.setLogPage((LogPage)ScriptMessagePage.getScriptMessagePage());
                outputRedirector.setName("Script output reader");
                outputRedirector.start();
                basicEditorPane.setEditable(false);
                while (this.sr.isAlive()) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return var1_1;
            }

            public void finish(Object object) {
                if (this._isCanceled) {
                    try {
                        connection2.rollback();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.severe("Could not rollback");
                    }
                }
                if (bl) {
                    try {
                        connection.close();
                    }
                    catch (SQLException sQLException) {
                        LOGGER.severe(sQLException.getLocalizedMessage());
                    }
                }
            }

            public void preWork() {
            }
        };
        DelayedProgressRunnable delayedProgressRunnable = new DelayedProgressRunnable(string, null, 500, iDelayedProgressRunnable, (Component)basicEditorPane);
        delayedProgressRunnable.setCancellable(true);
        delayedProgressRunnable.start();
    }

    public static void showError(BasicEditorPane basicEditorPane) {
        JScrollPane jScrollPane = new JScrollPane((Component)basicEditorPane);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jScrollPane, null, (String)"Error", (int)2);
        jEWTDialog.setSize(600, 300);
        jEWTDialog.pack();
        IdeUtil.centerWindow((Container)IdeUtil.getMainWindow(), (Component)jEWTDialog);
        jEWTDialog.setVisible(true);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.err.println("");
            System.err.println("");
            System.err.println("Usage: java oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils username/password@tns @klr.sql define1 define2 define3 ...");
            System.err.println("");
            System.err.println("");
            System.exit(1);
        }
        String string = stringArray[0].substring(0, stringArray[0].indexOf("/"));
        String string2 = stringArray[0].substring(stringArray[0].indexOf("/") + 1, stringArray[0].indexOf("@"));
        String string3 = stringArray[0].substring(stringArray[0].indexOf("@") + 1);
        String string4 = "jdbc:oracle:thin:@" + string3;
        String string5 = null;
        string5 = stringArray[1].indexOf("@") == 0 ? stringArray[1].substring(1) : stringArray[1];
        File file = new File(string5);
        if (!file.exists() && string5.indexOf(".") == -1) {
            string5 = string5 + ".sql";
        }
        if (!file.exists() && string5.indexOf(".") == -1) {
            string5 = string5 + ".sql";
        }
        ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
        for (int i = 2; i < stringArray.length; ++i) {
            scriptRunnerContext.getMap().put("" + (i - 1), stringArray[i]);
        }
        DriverManager.registerDriver((Driver)new OracleDriver());
        Connection connection = DriverManager.getConnection(string4, string, string2);
        connection.setAutoCommit(false);
        ScriptRunner scriptRunner = new ScriptRunner((InputStream)new FileInputStream(string5), connection);
        scriptRunner.setScriptRunnerContext(scriptRunnerContext);
        scriptRunner.run();
    }
}

