/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemacopy;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.schemacopy.CopyAPI;
import oracle.dbtools.raptor.schemacopy.CopyPanel;
import oracle.dbtools.raptor.schemacopy.CopyPanelArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.dialogs.ProgressException;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.javatools.dialogs.MessageDialog;

public class SchemaCopyListener
implements ActionListener {
    Connection _fromConn;
    Connection _toConn;
    String toName = null;
    String fromName = null;
    boolean _cancel = false;

    public void actionPerformed(ActionEvent actionEvent) {
        CopyPanel copyPanel = CopyPanel.getInstance();
        this._fromConn = copyPanel.getFromConn();
        this.fromName = Connections.getInstance().getConnectionName(this._fromConn);
        this._toConn = copyPanel.getToConn();
        this.toName = Connections.getInstance().getConnectionName(this._toConn);
        if (this._fromConn == null) {
            MessageDialog.error((Component)copyPanel, (Object)CopyPanelArb.getString(4), (String)CopyPanelArb.getString(3), (String)"f1_noConnectionFound_html");
            return;
        }
        if (this._toConn == null) {
            MessageDialog.error((Component)copyPanel, (Object)CopyPanelArb.getString(6), (String)CopyPanelArb.getString(5), (String)"f1_noConnectionFound_html");
            return;
        }
        if (this.toName.equals(this.fromName)) {
            MessageDialog.error((Component)copyPanel, (Object)CopyPanelArb.getString(26), (String)CopyPanelArb.getString(5), (String)"f1_noConnectionFound_html");
            return;
        }
        if (actionEvent.getActionCommand().equals("apply")) {
            ExportRun exportRun = new ExportRun();
            exportRun.set_e(actionEvent);
            exportRun.setTitle(CopyPanelArb.getString(7));
            exportRun.setMessage(CopyPanelArb.getString(8));
            try {
                exportRun.start(true);
            }
            catch (ProgressException progressException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, progressException.getStackTrace()[0].toString(), progressException);
            }
        }
    }

    class ExportRun
    extends ProgressRunnable {
        private ActionEvent _e;
        CopyAPI copyApi = null;

        ExportRun() {
        }

        public void set_e(ActionEvent actionEvent) {
            this._e = actionEvent;
        }

        protected Object doWork() throws Exception {
            this.copyApi = new CopyAPI(SchemaCopyListener.this._fromConn, SchemaCopyListener.this._toConn, CopyPanel.getInstance().getAction());
            this.copyApi.doCopy();
            if (this._e.getSource() instanceof JEWTDialog && !SchemaCopyListener.this._cancel) {
                JEWTDialog jEWTDialog = (JEWTDialog)this._e.getSource();
                jEWTDialog.closeDialog(true);
            }
            return true;
        }

        protected void doCancel() {
            this.copyApi.cancel();
            SchemaCopyListener.this._cancel = true;
        }
    }
}

