/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.schemacopy;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.controls.progress.DelayedProgressRunnable;
import oracle.dbtools.raptor.controls.progress.IDelayedProgressRunnable;
import oracle.dbtools.raptor.ddl.DDLGenerator;
import oracle.dbtools.raptor.export.data.DataMover;
import oracle.dbtools.raptor.schemacopy.CopyPanelArb;
import oracle.dbtools.raptor.schemacopy.wizard.CopyWizArb;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.util.IdeUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.db.ConnectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyAPI {
    private String encoding = IdeUtil.getIdeEncoding();
    private Context context;
    private String copyLogName;
    private Connection _fromConn;
    private Connection _toConn;
    private String fromName = null;
    private boolean _cancel = false;
    private String _type = null;
    private File _file;
    private OutputStream fout;
    private BufferedOutputStream bout;
    private OutputStreamWriter _out;
    private String _EOL = null;
    DelayedProgressRunnable dpr;
    int _step = 0;

    public CopyAPI(Connection connection, Connection connection2, String string) {
        this._type = string;
        this._fromConn = connection;
        this.fromName = Connections.getInstance().getConnectionName(this._fromConn);
        this._toConn = connection2;
    }

    private static synchronized LinkedHashMap<String, String> getOrderedTypes() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("DATABASE_LINK", "Oracle#DATABASE_LINK");
        linkedHashMap.put("SEQUENCE", "Oracle#SEQUENCE");
        linkedHashMap.put("TYPE", "Oracle#TYPE");
        linkedHashMap.put("TABLE", "Oracle#TABLE");
        linkedHashMap.put("DATA", "Oracle#DATA");
        linkedHashMap.put("CONSTRAINT", "Oracle#CONSTRAINT");
        linkedHashMap.put("INDEX", "Oracle#INDEX");
        linkedHashMap.put("REFCONSTRAINT", "Oracle#REFCONSTRAINT");
        linkedHashMap.put("TRIGGER", "Oracle#TRIGGER");
        linkedHashMap.put("MATERIALIZED VIEW", "Oracle#MATERIALIZED_VIEW");
        linkedHashMap.put("MATERIALIZED VIEW LOG", "Oracle#MATERIALIZED_VIEW_LOG");
        linkedHashMap.put("VIEW", "Oracle#VIEW");
        linkedHashMap.put("FUNCTION", "Oracle#FUNCTION");
        linkedHashMap.put("PACKAGE", "Oracle#PACKAGE");
        linkedHashMap.put("PACKAGE BODY", "Oracle#PACKAGE_BODY");
        linkedHashMap.put("PROCEDURE", "Oracle#PROCEDURE");
        linkedHashMap.put("SYNONYM", "Oracle#SYNONYM");
        linkedHashMap.put("QUEUE TABLE", "Oracle#QUEUE_TABLE");
        linkedHashMap.put("QUEUE", "Oracle#QUEUE");
        return linkedHashMap;
    }

    private static synchronized LinkedHashMap<String, String> getDropTypes() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("TABLE", "Oracle#TABLE");
        linkedHashMap.put("SYNONYM", "Oracle#SYNONYM");
        linkedHashMap.put("DATABASE_LINK", "Oracle#DATABASE_LINK");
        linkedHashMap.put("SEQUENCE", "Oracle#SEQUENCE");
        linkedHashMap.put("MATERIALIZED VIEW", "Oracle#MATERIALIZED_VIEW");
        linkedHashMap.put("MATERIALIZED VIEW LOG", "Oracle#MATERIALIZED_VIEW_LOG");
        linkedHashMap.put("VIEW", "Oracle#VIEW");
        linkedHashMap.put("FUNCTION", "Oracle#FUNCTION");
        linkedHashMap.put("PACKAGE", "Oracle#PACKAGE");
        linkedHashMap.put("PROCEDURE", "Oracle#PROCEDURE");
        linkedHashMap.put("QUEUE", "Oracle#QUEUE");
        linkedHashMap.put("QUEUE TABLE", "Oracle#QUEUE_TABLE");
        linkedHashMap.put("TYPE", "Oracle#TYPE");
        return linkedHashMap;
    }

    private String getTerm() {
        if (this._EOL == null) {
            IdeSettings ideSettings;
            EnvironOptions environOptions;
            int n;
            this._EOL = Ide.isRunning() ? ((n = (environOptions = (EnvironOptions)(ideSettings = Ide.getSettings()).getData("environment-options")).getLineTerminator()) == 1 ? "\r\n" : (n == 3 ? "\r" : (n == 2 ? "\n" : System.getProperty("line.separator")))) : System.getProperty("line.separator");
        }
        return this._EOL;
    }

    public void copyWithDialog() {
        this.dpr = new DelayedProgressRunnable("Copying...", null, 500, null, new JLabel());
        ((JLabel)this.dpr.getDetailComponent()).setText(CopyPanelArb.getString(27));
        final IDelayedProgressRunnable iDelayedProgressRunnable = new IDelayedProgressRunnable(){

            public void cancel() {
                CopyAPI.this._cancel = true;
            }

            public void finish(Object object) {
                try {
                    TextNode textNode = new TextNode(CopyAPI.this._file.toURL());
                    CopyAPI.this.context = Context.newIdeContext((Node)textNode);
                    OpenEditorOptions openEditorOptions = new OpenEditorOptions(CopyAPI.this.context);
                    openEditorOptions.setFlags(1);
                    EditorManager.getEditorManager().openEditor(openEditorOptions);
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                }
            }

            public void preWork() {
            }

            public Object doWork() {
                CopyAPI.this.doCopy();
                return true;
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                CopyAPI.this.dpr.setRunnable(iDelayedProgressRunnable);
                CopyAPI.this.dpr.setCancellable(true);
                CopyAPI.this.dpr.start();
            }
        });
    }

    private void setProg(String string) {
        if (this.dpr != null) {
            this.dpr.getProgressPanel().setMessage(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void doCopy() {
        ArrayList<String> arrayList;
        Iterator iterator;
        String string;
        this.openLog();
        DDLGenerator dDLGenerator = DDLGenerator.getInstance();
        LinkedHashMap<String, String> linkedHashMap = CopyAPI.getOrderedTypes();
        ArrayList<DBObject> arrayList4 = new ArrayList<DBObject>();
        this.setProg("Generating Copy");
        try {
            string = this._fromConn.getMetaData().getUserName();
            for (String arrayList32 : linkedHashMap.keySet()) {
                iterator = linkedHashMap.get(arrayList32);
                ArrayList<DBObject> arrayList2 = DDLGenerator.getInstance().getSchemaObjects(this._fromConn, string, arrayList32, (String)((Object)iterator));
                if (arrayList2 == null) continue;
                for (DBObject dBObject : arrayList2) {
                    arrayList4.add(dBObject);
                }
            }
        }
        catch (SQLException sQLException) {
            this.lineError();
            this.log(CopyPanelArb.getString(25) + this.getTerm() + sQLException.getMessage() + this.getTerm());
            this.closeLog();
            return;
        }
        string = null;
        if (this._type.equals("DROP")) {
            arrayList = CopyAPI.getDropTypes();
            ArrayList<DBObject> arrayList3 = new ArrayList<DBObject>();
            try {
                iterator = this._fromConn.getMetaData().getUserName();
                for (Object object : ((LinkedHashMap)((Object)arrayList)).keySet()) {
                    String string2 = (String)((LinkedHashMap)((Object)arrayList)).get(object);
                    ArrayList<DBObject> arrayList5 = DDLGenerator.getInstance().getSchemaObjects(this._fromConn, (String)((Object)iterator), (String)object, string2);
                    if (arrayList5 == null) continue;
                    for (DBObject dBObject : arrayList5) {
                        arrayList3.add(dBObject);
                    }
                }
            }
            catch (SQLException sQLException) {
                this.lineError();
                this.log(CopyPanelArb.getString(25) + this.getTerm() + sQLException.getMessage() + this.getTerm());
            }
            for (DBObject dBObject : arrayList3) {
                if (this._cancel) {
                    this.closeLog();
                    return;
                }
                string = dBObject.getObjectType().equals("MATERIALIZED VIEW LOG") ? "  DROP " + dBObject.getObjectType() + " on \"" + dBObject.getObjectName() + "\";" : (dBObject.getObjectType().equals("TABLE") ? "  DROP " + dBObject.getObjectType() + " \"" + dBObject.getObjectName() + "\" cascade constraints;" : (dBObject.getObjectType().equals("QUEUE") ? "begin" + this._EOL + "DBMS_AQADM.DROP_QUEUE(queue_name=>'" + dBObject.getObjectName() + "', auto_commit=>TRUE);" + this._EOL + "end;" : (dBObject.getObjectType().equals("QUEUE TABLE") ? "begin" + this._EOL + "DBMS_AQADM.DROP_QUEUE_TABLE(queue_table=>'" + dBObject.getObjectName() + "', force=>TRUE);" + this._EOL + "end;" : "  DROP " + dBObject.getObjectType() + " \"" + dBObject.getObjectName() + "\";")));
                this.setProg("Dropping " + dBObject.getObjectName());
                this.lineStart();
                this.log(string + this.getTerm());
                this.log(ScriptUtils.runSqlReturnResult(string, this._toConn));
                this.lineEnd();
            }
        }
        arrayList = new ArrayList<String>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        if (this._type.equals("TRUNC")) {
            iterator = "select table_name,constraint_name from user_constraints where constraint_type = 'R'";
            ResultSet resultSet = DBUtil.getInstance().executeQuery(this.fromName, iterator, new ArrayList());
            try {
                while (resultSet.next()) {
                    arrayList.add("alter table \"" + resultSet.getString(1) + "\" disable constraint \"" + resultSet.getString(2) + "\"");
                    arrayList6.add("alter table \"" + resultSet.getString(1) + "\" enable constraint \"" + resultSet.getString(2) + "\"");
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
                this.lineError();
                this.log(CopyPanelArb.getString(25) + this.getTerm() + sQLException.getMessage() + this.getTerm());
                this.closeLog();
                return;
            }
            for (String string3 : arrayList) {
                if (this._cancel) {
                    this.closeLog();
                    break;
                }
                this.setProg("Disabling constraints");
                this.lineStart();
                this.log(string3 + this.getTerm());
                this.log(ScriptUtils.runSqlReturnResult(string3, this._toConn));
                this.lineEnd();
            }
        }
        for (DBObject dBObject : arrayList4) {
            Object object;
            if (this._cancel) {
                if (this._type.equals("TRUNC")) {
                    for (String string4 : arrayList6) {
                        this.setProg("Enabling Constraints");
                        this.log(string4 + this.getTerm());
                        this.log(ScriptUtils.runSqlReturnResult(string4, this._toConn));
                    }
                }
                this.lineError();
                this.log(CopyPanelArb.getString(16) + this.getTerm());
                this.closeLog();
                return;
            }
            if (dBObject.getObjectType().equals("DATA")) {
                try {
                    this.setProg("Moving Data " + dBObject.getObjectName());
                    object = new DataMover(this._fromConn, this._toConn);
                    ((DataMover)((Object)object)).setLogFile(this.bout);
                    this.lineStart();
                    this.log(CopyPanelArb.getString(17) + dBObject.getObjectName() + this.getTerm());
                    this.lineEnd();
                    ((DataMover)((Object)object)).move(dBObject, true);
                }
                catch (ConnectionException connectionException) {
                    this.log(CopyPanelArb.getString(18) + connectionException.getMessage() + this.getTerm());
                }
                continue;
            }
            if (!this._type.equals("TRUNC") || this._type.equals("TRUNC") && !dBObject.getObjectType().equals("TABLE") && !dBObject.getObjectType().equals("REFCONSTRAINT") && !dBObject.getObjectType().equals("CONSTRAINT")) {
                try {
                    void var10_39;
                    this.setProg("Creating " + dBObject.getObjectName());
                    object = dDLGenerator.getCopyDDL(dBObject);
                    String string5 = ((String)object).replaceAll("\"" + dBObject.getSchemaName() + "\".", "");
                    if (dBObject.getObjectType().equals("QUEUE TABLE") || dBObject.getObjectType().equals("QUEUE")) {
                        String string6 = ((String)object).replaceAll("'" + dBObject.getSchemaName() + ".", "'");
                    }
                    if (var10_39.equals("")) continue;
                    this.lineStart();
                    this.log((String)var10_39 + this.getTerm());
                    this.log(ScriptUtils.runSqlReturnResult((String)var10_39, this._toConn));
                    this.lineEnd();
                }
                catch (Exception exception) {
                    this.log(CopyPanelArb.getString(25) + this.getTerm() + dBObject.getObjectName() + this.getTerm() + exception.getMessage() + this.getTerm());
                }
                continue;
            }
            if (!this._type.equals("TRUNC") || !dBObject.getObjectType().equals("TABLE")) continue;
            this.setProg("Truncating " + dBObject.getObjectName());
            string = "  truncate " + dBObject.getObjectType() + " \"" + dBObject.getObjectName() + "\"";
            this.lineStart();
            this.log(string + this.getTerm());
            this.log(ScriptUtils.runSqlReturnResult(string, this._toConn));
            this.lineEnd();
        }
        if (this._type.equals("TRUNC")) {
            for (String string7 : arrayList6) {
                this.setProg("Enabling Constraints");
                this.lineStart();
                this.log(string7 + this.getTerm());
                this.log(ScriptUtils.runSqlReturnResult(string7, this._toConn));
                this.lineEnd();
            }
        }
        this.closeLog();
    }

    private String getStep() {
        ++this._step;
        return Integer.toString(this._step);
    }

    private void clearStep() {
        this._step = 0;
    }

    public LinkedHashMap<String, String> getSummary() {
        LinkedList<Object> linkedList;
        LinkedList<String> linkedList2;
        this.clearStep();
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> linkedHashMap2 = CopyAPI.getOrderedTypes();
        ArrayList<DBObject> arrayList = new ArrayList<DBObject>();
        try {
            linkedList2 = this._fromConn.getMetaData().getUserName();
            for (String iterator2 : linkedHashMap2.keySet()) {
                String string = linkedHashMap2.get(iterator2);
                ArrayList<DBObject> arrayList2 = DDLGenerator.getInstance().getSchemaObjects(this._fromConn, (String)((Object)linkedList2), iterator2, string);
                if (arrayList2 == null) continue;
                for (DBObject dBObject : arrayList2) {
                    arrayList.add(dBObject);
                }
            }
        }
        catch (SQLException sQLException) {
            this.log(CopyPanelArb.getString(25) + this.getTerm() + sQLException.getMessage() + this.getTerm());
        }
        if (this._type.equals("DROP")) {
            linkedList2 = CopyAPI.getDropTypes();
            linkedList = new ArrayList();
            try {
                String sQLException = this._fromConn.getMetaData().getUserName();
                for (ArrayList<DBObject> arrayList2 : ((LinkedHashMap)((Object)linkedList2)).keySet()) {
                    String string = (String)((LinkedHashMap)((Object)linkedList2)).get(arrayList2);
                    ArrayList<DBObject> arrayList3 = DDLGenerator.getInstance().getSchemaObjects(this._fromConn, sQLException, (String)((Object)arrayList2), string);
                    if (arrayList3 == null) continue;
                    for (DBObject dBObject : arrayList3) {
                        ((ArrayList)((Object)linkedList)).add(dBObject);
                    }
                }
            }
            catch (SQLException sQLException) {
                this.log(CopyPanelArb.getString(25) + this.getTerm() + sQLException.getMessage() + this.getTerm());
            }
            for (DBObject dBObject : linkedList) {
                linkedHashMap.put(this.getStep(), " DROP " + dBObject.getObjectType() + " " + dBObject.getObjectName());
            }
        }
        linkedList2 = new LinkedList<String>();
        linkedList = new LinkedList<Object>();
        if (this._type.equals("TRUNC")) {
            String string = "select table_name,constraint_name from user_constraints where constraint_type = 'R'";
            ResultSet resultSet = DBUtil.getInstance().executeQuery(this.fromName, string, new ArrayList());
            try {
                while (resultSet.next()) {
                    linkedList2.add("DISABLE constraint \"" + resultSet.getString(2) + " on Table \"" + resultSet.getString(1));
                    linkedList.add("ENABLE constraint \"" + resultSet.getString(2) + " on Table \"" + resultSet.getString(1));
                }
            }
            catch (SQLException sQLException) {
                this.log(CopyPanelArb.getString(25) + this.getTerm() + sQLException.getMessage() + this.getTerm());
            }
        }
        for (String string : linkedList2) {
            linkedHashMap.put(this.getStep(), string);
        }
        for (DBObject dBObject : arrayList) {
            if (dBObject.getObjectType().equals("DATA")) {
                linkedHashMap.put(this.getStep(), CopyWizArb.getString(10) + dBObject.getObjectName());
                continue;
            }
            if (!this._type.equals("TRUNC") || this._type.equals("TRUNC") && !dBObject.getObjectType().equals("TABLE") && !dBObject.getObjectType().equals("REFCONSTRAINT") && !dBObject.getObjectType().equals("CONSTRAINT")) {
                linkedHashMap.put(this.getStep(), "CREATE " + dBObject.getObjectType() + " " + dBObject.getObjectName());
                continue;
            }
            if (!this._type.equals("TRUNC") || !dBObject.getObjectType().equals("TABLE")) continue;
            linkedHashMap.put(this.getStep(), "TRUNCATE " + dBObject.getObjectName());
        }
        if (this._type.equals("TRUNC")) {
            for (String string : linkedList) {
                linkedHashMap.put(this.getStep(), string);
            }
        }
        return linkedHashMap;
    }

    public void cancel() {
        this._cancel = true;
    }

    private void openLog() {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM.dd.yyyy-HH.mm.ss");
            StringBuilder stringBuilder = new StringBuilder(simpleDateFormat.format(new Date()));
            this.copyLogName = Ide.getProductHomeDirectory() + "SchemaCopy." + stringBuilder + ".log";
            this._file = new File(this.copyLogName);
            this.fout = new FileOutputStream(this._file.getPath());
            this.bout = new BufferedOutputStream(this.fout);
            this._out = new OutputStreamWriter((OutputStream)this.bout, this.encoding);
        }
        catch (IOException iOException) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)"Could Not Create File", (String)(this._file.getPath() + this._file.getName()), null);
        }
    }

    private void lineStart() {
        try {
            if (this._out != null) {
                this._out.write("--- START --------------------------------------------------------------------" + this.getTerm());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void lineEnd() {
        try {
            if (this._out != null) {
                this._out.write("--- END --------------------------------------------------------------------" + this.getTerm());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void lineError() {
        try {
            if (this._out != null) {
                this._out.write("--- ERROR -- ERROR ------------------------------------" + this.getTerm());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void log(String string) {
        try {
            if (this._out != null) {
                this._out.write(string + this.getTerm());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void closeLog() {
        try {
            this._out.flush();
            this._out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

