/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.runner.SmartPlsqlOperator;
import oracle.ide.model.Node;
import oracle.ide.runner.SmartDataProvider;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.old.PlsqlLexer;
import oracle.javatools.parser.plsql.old.PlsqlParser;
import oracle.javatools.parser.plsql.old.PlsqlSyntaxRecognizer;
import oracle.javatools.parser.plsql.old.symbol.ErrorReporter;
import oracle.javatools.parser.plsql.old.symbol.ExpressionList;
import oracle.javatools.parser.plsql.old.symbol.ExpressionSymbol;

public final class SmartPlsql
implements SmartDataProvider {
    public boolean canUnderstand(Node node) {
        return node instanceof PlSqlNode;
    }

    public void getExpressions(ReadTextBuffer readTextBuffer, int n, int n2, List list) {
        try {
            int n3;
            int n4;
            PlsqlLexer plsqlLexer = new PlsqlLexer();
            LexerToken lexerToken = plsqlLexer.createLexerToken();
            plsqlLexer.setTextBuffer(readTextBuffer);
            plsqlLexer.setPosition(n);
            plsqlLexer.setSkipComments(true);
            while ((n4 = plsqlLexer.lex(lexerToken)) != 0 && (n3 = lexerToken.getStartOffset()) <= n2) {
                switch (n4) {
                    case 11: 
                    case 12: {
                        int n5 = SmartPlsql.usePlsqlParser(readTextBuffer, n3, list);
                        if (n5 == -1) break;
                        plsqlLexer.setPosition(n5);
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private static int usePlsqlParser(ReadTextBuffer readTextBuffer, int n, List list) {
        PlsqlParser.ParsingOptions parsingOptions = new PlsqlParser.ParsingOptions();
        parsingOptions.reportErrors = true;
        parsingOptions.inputType = 2;
        parsingOptions.parseDepth = 2;
        parsingOptions.startOffset = n;
        ErrorReporter errorReporter = PlsqlParser.parse((ReadTextBuffer)readTextBuffer, (PlsqlParser.ParsingOptions)parsingOptions);
        if (errorReporter instanceof ExpressionSymbol) {
            ExpressionSymbol expressionSymbol = (ExpressionSymbol)errorReporter;
            SmartPlsql.processExpressionSymbol(expressionSymbol, list);
            return expressionSymbol.getEndOffset();
        }
        return -1;
    }

    private static StringBuffer[] processExpressionSymbol(ExpressionSymbol expressionSymbol, List list) {
        StringBuffer[] stringBufferArray = null;
        if (expressionSymbol != null) {
            ArrayList arrayList = new ArrayList();
            StringBuffer[] stringBufferArray2 = SmartPlsql.processExpressionList(expressionSymbol, arrayList);
            StringBuffer[] stringBufferArray3 = SmartPlsql.processExpressionSymbol(expressionSymbol.getFirstOperand(), arrayList);
            StringBuffer[] stringBufferArray4 = SmartPlsql.processExpressionSymbol(expressionSymbol.getSecondOperand(), arrayList);
            StringBuffer[] stringBufferArray5 = SmartPlsql.processExpressionSymbol(expressionSymbol.getThirdOperand(), arrayList);
            switch (expressionSymbol.getCategory()) {
                case 711: {
                    stringBufferArray = SmartPlsql.processPrefixOperator(expressionSymbol, stringBufferArray3, list);
                    break;
                }
                case 760: {
                    stringBufferArray = SmartPlsql.processArguments(expressionSymbol, stringBufferArray2);
                    break;
                }
                case 750: {
                    stringBufferArray = SmartPlsql.processPrimary(expressionSymbol, stringBufferArray2, list);
                }
            }
            list.addAll(arrayList);
        }
        return stringBufferArray;
    }

    private static boolean isPlsqlIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    private static StringBuffer[] processExpressionList(ExpressionSymbol expressionSymbol, List list) {
        StringBuffer[] stringBufferArray = null;
        if (expressionSymbol instanceof ExpressionList) {
            final int n = expressionSymbol.getCategory();
            ExpressionSymbol[] expressionSymbolArray = ((ExpressionList)expressionSymbol).getExpressions();
            if (expressionSymbolArray != null) {
                int n2 = expressionSymbolArray.length;
                for (int i = 0; i < n2; ++i) {
                    StringBuffer[] stringBufferArray2 = SmartPlsql.processExpressionSymbol(expressionSymbolArray[i], list);
                    stringBufferArray = stringBufferArray == null || stringBufferArray.length == 0 ? stringBufferArray2 : SmartPlsqlOperator.performOperation(stringBufferArray, stringBufferArray2, new SmartPlsqlOperator(){

                        public void operate(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
                            if (n == 750) {
                                if (stringBuffer2.length() > 0 && stringBuffer2.charAt(0) == '(') {
                                    stringBuffer.append(stringBuffer2);
                                } else {
                                    stringBuffer.append(".").append(stringBuffer2);
                                }
                            } else if (n == 760) {
                                stringBuffer.append(",").append(stringBuffer2);
                            }
                        }
                    });
                }
            }
        }
        return stringBufferArray;
    }

    private static StringBuffer[] processPrefixOperator(ExpressionSymbol expressionSymbol, StringBuffer[] stringBufferArray, final List list) {
        StringBuffer[] stringBufferArray2 = null;
        if (stringBufferArray != null) {
            switch (expressionSymbol.getExactCode()) {
                case 1096: {
                    stringBufferArray2 = SmartPlsqlOperator.performOperation(stringBufferArray, new SmartPlsqlOperator(){

                        public void operate(StringBuffer stringBuffer) {
                            boolean bl = SmartPlsql.isPlsqlIdentifierStart(stringBuffer.charAt(0));
                            stringBuffer.insert(0, "NOT ");
                            if (bl) {
                                SmartPlsql.addExpression(stringBuffer, list);
                            }
                        }
                    });
                    break;
                }
                case 100: {
                    stringBufferArray2 = SmartPlsqlOperator.performOperation(stringBufferArray, new SmartPlsqlOperator(){

                        public void operate(StringBuffer stringBuffer) {
                            boolean bl = SmartPlsql.isPlsqlIdentifierStart(stringBuffer.charAt(0));
                            stringBuffer.insert(0, "+");
                            if (bl) {
                                SmartPlsql.addExpression(stringBuffer, list);
                            }
                        }
                    });
                    break;
                }
                case 111: {
                    stringBufferArray2 = SmartPlsqlOperator.performOperation(stringBufferArray, new SmartPlsqlOperator(){

                        public void operate(StringBuffer stringBuffer) {
                            boolean bl = SmartPlsql.isPlsqlIdentifierStart(stringBuffer.charAt(0));
                            stringBuffer.insert(0, "-");
                            if (bl) {
                                SmartPlsql.addExpression(stringBuffer, list);
                            }
                        }
                    });
                }
            }
        }
        return stringBufferArray2;
    }

    private static StringBuffer[] processArguments(ExpressionSymbol expressionSymbol, StringBuffer[] stringBufferArray) {
        StringBuffer[] stringBufferArray2 = SmartPlsqlOperator.performOperation(stringBufferArray, new SmartPlsqlOperator(){

            public void operate(StringBuffer stringBuffer) {
                stringBuffer.insert(0, "(").append(")");
            }
        });
        return stringBufferArray2;
    }

    private static StringBuffer[] processPrimary(ExpressionSymbol expressionSymbol, StringBuffer[] stringBufferArray, List list) {
        StringBuffer[] stringBufferArray2 = null;
        String string = expressionSymbol.getName().getValue();
        if (PlsqlSyntaxRecognizer.isLiteralToken((int)expressionSymbol.getExactCode())) {
            stringBufferArray2 = new StringBuffer[]{new StringBuffer(string)};
        } else if (expressionSymbol instanceof ExpressionList && stringBufferArray != null && stringBufferArray.length > 0) {
            stringBufferArray2 = SmartPlsql.processMethodInvocation(string);
            stringBufferArray2 = SmartPlsqlOperator.performOperation(stringBufferArray2, stringBufferArray, new SmartPlsqlOperator(){

                public void operate(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
                    stringBuffer.append(stringBuffer2);
                }
            });
            SmartPlsql.addPrimaryParts(stringBufferArray2, list);
        } else {
            stringBufferArray2 = new StringBuffer[]{new StringBuffer(string)};
            SmartPlsql.addPrimaryParts(stringBufferArray2, list);
        }
        return stringBufferArray2;
    }

    private static StringBuffer[] processMethodInvocation(String string) {
        int n;
        String string2 = string.toUpperCase();
        if (string2.regionMatches(n = string.lastIndexOf(46) + 1, "GET", 0, 3)) {
            return SmartPlsql.fixGetter(string, n, 3);
        }
        if (string2.regionMatches(n, "SET", 0, 3)) {
            return SmartPlsql.fixGetter(string, n, 3);
        }
        if (string2.regionMatches(n, "IS", 0, 2)) {
            return SmartPlsql.fixGetter(string, n, 2);
        }
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(string)};
        return stringBufferArray;
    }

    private static StringBuffer[] fixGetter(String string, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.delete(n, n + n2);
        char c = stringBuffer.charAt(n);
        if (!Character.isLowerCase(c)) {
            stringBuffer.setCharAt(n, Character.toLowerCase(c));
        }
        String string2 = stringBuffer.toString();
        StringBuffer[] stringBufferArray = new StringBuffer[]{new StringBuffer(string2), new StringBuffer(string2)};
        stringBufferArray[1].insert(n, '_');
        return stringBufferArray;
    }

    private static void addPrimaryParts(StringBuffer[] stringBufferArray, List list) {
        if (stringBufferArray != null) {
            for (int i = stringBufferArray.length - 1; i >= 0; --i) {
                SmartPlsql.addPrimaryParts(stringBufferArray[i].toString(), list);
            }
        }
    }

    private static void addPrimaryParts(String string, List list) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".(", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            stringBuffer.append(string2);
            if (string2.equals(".") || string2.equals("(")) continue;
            SmartPlsql.addExpression(stringBuffer, list);
        }
    }

    private static void addExpression(StringBuffer[] stringBufferArray, List list) {
        if (stringBufferArray != null) {
            for (int i = stringBufferArray.length - 1; i >= 0; --i) {
                SmartPlsql.addExpression(stringBufferArray[i].toString(), list);
            }
        }
    }

    private static void addExpression(StringBuffer stringBuffer, List list) {
        SmartPlsql.addExpression(stringBuffer.toString(), list);
    }

    private static void addExpression(String string, List list) {
        list.add(string);
    }
}

