/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.runner.ParamTableModel;
import oracle.dbtools.raptor.runner.Procedure;
import oracle.dbtools.raptor.runner.RunnerArb;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.Ide;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.db.dialogs.SQLErrorDialog;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.DirOptionsArb;
import oracle.ide.util.FileUtilities;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdeveloper.layout.BoxLayout2;
import oracle.sql.CLOB;

public class PlSqlRunnerPanel
extends JPanel {
    private static final int MAX_LINE_LEN = 128;
    private BorderLayout m_layMain = new BorderLayout();
    private JSplitPane m_splContent = new JSplitPane();
    private JSplitPane m_splTop = new JSplitPane();
    private JPanel m_pnlTarget = new JPanel();
    private JPanel m_pnlParams = new JPanel();
    private JPanel m_pnlBlock = new JPanel();
    private GridBagLayout m_layTarget = new GridBagLayout();
    private JLabel m_lblTarget = new JLabel();
    private JScrollPane m_scrTarget = new JScrollPane();
    private JList m_lstTarget = new JList();
    private GridBagLayout m_layParams = new GridBagLayout();
    private JLabel m_lblParams = new JLabel();
    private JScrollPane m_scrParams = new JScrollPane();
    private GridBagLayout m_layBlock = new GridBagLayout();
    private JScrollPane m_scrBlock = new JScrollPane();
    private JTable m_tblParams = new JTable();
    private TableColumnModel m_colMdl = new DefaultTableColumnModel();
    private BasicEditorPane m_txtBlock = EditorFactory.createIdeEditorPane();
    private JLabel m_lblBlock = new JLabel();
    private ListSelectionModel m_selModel = new DefaultListSelectionModel();
    private LineGutterPlugin m_sqlGutter;
    private LineHighlightPlugin m_sqlHighlite = new LineHighlightPlugin();
    private JButton m_btnReset = new JButton();
    private JButton m_btnFromFile = new JButton();
    private JButton m_btnToFile = new JButton();
    private Component m_glue = Box.createHorizontalGlue();
    private JPanel m_pnlButtons = new JPanel();
    private BoxLayout2 m_layButtons = new BoxLayout2();
    private TableColumn m_colName = new TableColumn();
    private TableColumn m_colType = new TableColumn();
    private TableColumn m_colMode = new TableColumn();
    private RunnableSourceNode m_node;
    private JEWTDialog m_dlg;
    private static final String PACKAGE_QUERY = "SELECT DISTINCT A.OBJECT_NAME, A.OVERLOAD, A.OBJECT_ID FROM SYS.ALL_ARGUMENTS A, SYS.ALL_OBJECTS B WHERE A.OBJECT_ID = B.OBJECT_ID AND B.OWNER = ? AND B.OBJECT_NAME = ? AND B.OBJECT_TYPE = 'PACKAGE'";
    private static final String PROC_QUERY = "SELECT OBJECT_ID FROM SYS.ALL_OBJECTS WHERE OWNER = ? AND OBJECT_NAME = ?";

    public PlSqlRunnerPanel() {
        try {
            this.jbInit();
            HelpSystem.getHelpSystem().registerTopic((JComponent)this, "f1_run_plsql_html");
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TextBuffer runDialog(RunnableSourceNode runnableSourceNode, boolean bl, boolean bl2) {
        String string = (String)runnableSourceNode.getProperty("INVALID");
        if (Boolean.parseBoolean(string)) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)RunnerArb.getString(17), (String)RunnerArb.getString(16), null);
            return null;
        }
        final PlSqlRunnerPanel plSqlRunnerPanel = !bl2 ? new PlSqlRunnerPanel() : new PlSqlProfilerPanel();
        plSqlRunnerPanel.setNode(runnableSourceNode);
        String string2 = RunnerArb.getString(4);
        if (bl) {
            string2 = RunnerArb.getString(5);
        }
        if (bl2) {
            string2 = RunnerArb.getString(6);
        }
        JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)plSqlRunnerPanel, (Component)plSqlRunnerPanel.m_lstTarget, (String)string2);
        jEWTDialog.addVetoableChangeListener(new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
                if ("closed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue()) && !plSqlRunnerPanel._commit()) {
                    throw new PropertyVetoException("no", propertyChangeEvent);
                }
            }
        });
        jEWTDialog.setResizable(true);
        jEWTDialog.addWindowListener((WindowListener)new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                plSqlRunnerPanel.init();
            }
        });
        plSqlRunnerPanel.m_dlg = jEWTDialog;
        TextBuffer textBuffer = null;
        try {
            if (WizardLauncher.runDialog((JDialog)jEWTDialog)) {
                BasicDocument basicDocument = (BasicDocument)plSqlRunnerPanel.m_txtBlock.getDocument();
                textBuffer = basicDocument.getTextBuffer();
                if (bl2) {
                    runnableSourceNode.setProperty("commentReturn", ((PlSqlProfilerPanel)plSqlRunnerPanel).fldComment.getText());
                }
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            plSqlRunnerPanel.m_txtBlock.dispose();
            throw throwable;
        }
        plSqlRunnerPanel.m_txtBlock.dispose();
        return textBuffer;
    }

    private void _updateOK(boolean bl) {
        this.m_dlg.setOKButtonEnabled(bl);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(Math.min(dimension.width, 600), dimension.height);
    }

    public void setNode(RunnableSourceNode runnableSourceNode) {
        this.m_node = runnableSourceNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void init() {
        Connection connection;
        DefaultListModel<Procedure> defaultListModel = new DefaultListModel<Procedure>();
        String string = (String)this.m_node.getProperty("TYPE");
        OracleDatabase oracleDatabase = (OracleDatabase)PlSqlRunnerPanel.getDatabase(this.m_node);
        Connection connection2 = connection = oracleDatabase.getConnection();
        synchronized (connection2) {
            block27: {
                Exception exception2222;
                ResultSet resultSet;
                Statement statement;
                block25: {
                    statement = null;
                    resultSet = null;
                    ArrayList arrayList = new ArrayList();
                    ArrayList arrayList2 = new ArrayList();
                    TextBuffer textBuffer = this.m_node.acquireTextBuffer();
                    PlsqlRoot plsqlRoot = PlsqlParser.parsePlsql((ReadTextBuffer)textBuffer);
                    URL uRL = this.m_node.getURL();
                    String string2 = DBURLFormatHelper.getSchema(uRL);
                    String string3 = DBURLFormatHelper.getName(uRL);
                    if ("PACKAGE".equals(string) || "PACKAGE BODY".equals(string)) {
                        statement = connection.prepareStatement(PACKAGE_QUERY);
                        statement.setString(1, string2);
                        statement.setString(2, string3);
                        resultSet = statement.executeQuery();
                        boolean bl = false;
                        while (resultSet.next()) {
                            String string4 = resultSet.getString(1);
                            int n = resultSet.getInt(2);
                            int n2 = resultSet.getInt(3);
                            defaultListModel.addElement(new Procedure(string2, string3, string4, n2, n, oracleDatabase, plsqlRoot));
                        }
                    } else {
                        statement = connection.prepareStatement(PROC_QUERY);
                        statement.setString(1, string2);
                        statement.setString(2, string3);
                        resultSet = statement.executeQuery();
                        if (resultSet.next()) {
                            int n = resultSet.getInt(1);
                            defaultListModel.addElement(new Procedure(string2, string3, n, oracleDatabase, plsqlRoot));
                        }
                    }
                    this._updateOK(true);
                    Object var20_21 = null;
                    if (resultSet == null) break block25;
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception2222) {
                        // empty catch block
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception2222) {
                        // empty catch block
                    }
                }
                this.m_node.releaseTextBuffer();
                {
                    break block27;
                    catch (SQLException sQLException) {
                        Exception exception32222;
                        SQLErrorDialog.showErrorDialog((Component)this, (String)RunnerArb.getString(11), (SQLException)sQLException);
                        this._updateOK(false);
                        Object var20_22 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Exception exception32222) {
                                // empty catch block
                            }
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Exception exception32222) {
                                // empty catch block
                            }
                        }
                        this.m_node.releaseTextBuffer();
                    }
                }
                catch (Throwable throwable) {
                    Exception exception42222;
                    Object var20_23 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Exception exception42222) {
                            // empty catch block
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception42222) {
                            // empty catch block
                        }
                    }
                    this.m_node.releaseTextBuffer();
                    throw throwable;
                }
            }
        }
        this.m_lstTarget.setModel(defaultListModel);
        if (defaultListModel.size() > 0) {
            this.m_lstTarget.setSelectedIndex(0);
        }
        this.m_splContent.invalidate();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.m_layMain);
        this.m_layButtons.setAxis(0);
        this.m_pnlButtons.setLayout((LayoutManager)this.m_layButtons);
        this.m_splContent.setOrientation(0);
        this.m_pnlTarget.setLayout(this.m_layTarget);
        this.m_pnlParams.setLayout(this.m_layParams);
        this.m_pnlBlock.setLayout(this.m_layBlock);
        ResourceUtils.resLabel((JLabel)this.m_lblTarget, (Component)this.m_lstTarget, (String)RunnerArb.getString(7));
        this.m_scrTarget.setMinimumSize(new Dimension(150, 100));
        this.m_lstTarget.setSelectionModel(this.m_selModel);
        this.m_lstTarget.setVisibleRowCount(5);
        ResourceUtils.resLabel((JLabel)this.m_lblParams, (Component)this.m_tblParams, (String)RunnerArb.getString(8));
        this.m_txtBlock.installPlugin((EditorPlugin)this.m_sqlHighlite);
        this.m_scrBlock.setHorizontalScrollBarPolicy(32);
        this.m_scrBlock.setVerticalScrollBarPolicy(22);
        this.m_tblParams.setAutoCreateColumnsFromModel(false);
        this.m_colName.setModelIndex(0);
        this.m_colName.setPreferredWidth(220);
        this.m_colName.setHeaderValue(RunnerArb.getString(0));
        this.m_colMdl.addColumn(this.m_colName);
        this.m_colType.setModelIndex(1);
        this.m_colType.setPreferredWidth(110);
        this.m_colType.setHeaderValue(RunnerArb.getString(1));
        this.m_colMdl.addColumn(this.m_colType);
        this.m_colMode.setModelIndex(2);
        this.m_colMode.setPreferredWidth(50);
        this.m_colMode.setHeaderValue(RunnerArb.getString(2));
        this.m_colMdl.addColumn(this.m_colMode);
        this.m_tblParams.setColumnModel(this.m_colMdl);
        ResourceUtils.resLabel((JLabel)this.m_lblBlock, (Component)this.m_txtBlock, (String)RunnerArb.getString(9));
        this.m_selModel.setSelectionMode(0);
        this.m_selModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    PlSqlRunnerPanel.this._targetChanged();
                }
            }
        });
        ResourceUtils.resButton((AbstractButton)this.m_btnReset, (String)RunnerArb.getString(14));
        ResourceUtils.resButton((AbstractButton)this.m_btnFromFile, (String)RunnerArb.getString(15));
        this.m_btnReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlSqlRunnerPanel.this._resetDocument();
            }
        });
        this.m_btnFromFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlSqlRunnerPanel.this._loadFromFile();
            }
        });
        ResourceUtils.resButton((AbstractButton)this.m_btnToFile, (String)RunnerArb.getString(19));
        this.m_btnToFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlSqlRunnerPanel.this._saveToFile();
            }
        });
        this.m_pnlButtons.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && PlSqlRunnerPanel.this.isShowing()) {
                    PlSqlRunnerPanel.this.m_splContent.setDividerLocation(0.33);
                    PlSqlRunnerPanel.this.m_splTop.setDividerLocation(0.4);
                    PlSqlRunnerPanel.this.removeHierarchyListener(this);
                }
            }
        });
        this.m_pnlTarget.add((Component)this.m_lblTarget, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_scrTarget.getViewport().add((Component)this.m_lstTarget, null);
        this.m_pnlTarget.add((Component)this.m_scrTarget, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_splTop.add((Component)this.m_pnlTarget, "left");
        this.m_pnlParams.add((Component)this.m_lblParams, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_scrParams.getViewport().add((Component)this.m_tblParams, null);
        this.m_pnlParams.add((Component)this.m_scrParams, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_splTop.add((Component)this.m_pnlParams, "right");
        this.m_splContent.add((Component)this.m_splTop, "top");
        this.m_scrBlock.getViewport().add((Component)this.m_txtBlock, null);
        this.m_pnlBlock.add((Component)this.m_lblBlock, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlBlock.add((Component)this.m_scrBlock, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_splContent.add((Component)this.m_pnlBlock, "bottom");
        this.add((Component)this.m_splContent, "Center");
        this.m_pnlButtons.add(this.m_glue);
        this.m_pnlButtons.add(this.m_btnToFile);
        this.m_pnlButtons.add(this.m_btnFromFile);
        this.m_pnlButtons.add(this.m_btnReset);
        this.add((Component)this.m_pnlButtons, "South");
    }

    protected void _saveToFile() {
        URL[] uRLArray;
        URLChooser uRLChooser = DialogUtil.newURLChooser();
        uRLChooser.setSelectionScope(0);
        uRLChooser.setSelectionMode(0);
        int n = uRLChooser.showOpenDialog((Component)this, RunnerArb.getString(20));
        if (n == 0 && (uRLArray = uRLChooser.getSelectedURLs()) != null && uRLArray[0] != null) {
            URL uRL = uRLArray[0];
            try {
                String string = this.m_txtBlock.getText();
                String string2 = Ide.getEnvironOptions().getEncoding();
                byte[] byArray = string2 != null ? string.getBytes(string2) : string.getBytes();
                FileUtilities.writeFile((URL)uRL, (byte[])byArray);
            }
            catch (IOException iOException) {
                ExceptionHandler.handleException((Exception)iOException);
            }
        }
    }

    private void _loadFromFile() {
        URL uRL = null;
        try {
            URL[] uRLArray;
            URLChooser uRLChooser = DialogUtil.newURLChooser();
            uRLChooser.setSelectionScope(2);
            uRLChooser.setSelectionMode(0);
            int n = uRLChooser.showOpenDialog((Component)this, DirOptionsArb.getString((int)20));
            if (n == 0 && (uRLArray = uRLChooser.getSelectedURLs()) != null && uRLArray[0] != null) {
                uRL = uRLArray[0];
                byte[] byArray = FileUtilities.readFile((URL)uRL);
                String string = Ide.getEnvironOptions().getEncoding();
                String string2 = string != null ? new String(byArray, string) : new String(byArray);
                this.m_txtBlock.setText(string2);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)(RunnerArb.getString(18) + URLFileSystem.getPlatformPathName(uRL)), (String)RunnerArb.getString(16), null);
        }
        catch (Exception exception) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)exception.getMessage(), (String)RunnerArb.getString(16), null);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    private void _resetDocument() {
        Procedure procedure = (Procedure)this.m_lstTarget.getSelectedValue();
        if (procedure != null) {
            procedure.resetDocument();
            this._targetChanged();
        }
    }

    private void _targetChanged() {
        Document document = this.m_txtBlock.getDocument();
        ParamTableModel paramTableModel = null;
        BasicDocument basicDocument = null;
        Procedure procedure = (Procedure)this.m_lstTarget.getSelectedValue();
        if (procedure != null) {
            try {
                paramTableModel = procedure.getTableModel();
                basicDocument = procedure.getDocument();
                this._updateOK(true);
            }
            catch (SQLException sQLException) {
                SQLErrorDialog.showErrorDialog((Component)this, (String)RunnerArb.getString(11), (SQLException)sQLException);
            }
        }
        if (paramTableModel == null || basicDocument == null) {
            paramTableModel = new ParamTableModel();
            basicDocument = new BasicDocument("foo.plsql");
            this._updateOK(false);
        }
        boolean bl = paramTableModel.getRowCount() > 0;
        this.m_tblParams.setEnabled(bl);
        this.m_lblParams.setEnabled(bl);
        if (document != basicDocument) {
            if (this.m_sqlGutter != null) {
                this.m_txtBlock.deinstallPlugin((EditorPlugin)this.m_sqlGutter);
            }
            this.m_tblParams.setModel(paramTableModel);
            this.m_txtBlock.setDocument((Document)basicDocument);
            this.m_sqlGutter = new LineGutterPlugin();
            this.m_txtBlock.installPlugin((EditorPlugin)this.m_sqlGutter);
            this.m_scrBlock.setRowHeaderView((Component)this.m_sqlGutter);
            this.m_txtBlock.scrollRectToVisible(new Rectangle(0, 0, 0, 0));
        }
    }

    private boolean _commit() {
        boolean bl = false;
        BasicDocument basicDocument = (BasicDocument)this.m_txtBlock.getDocument();
        TextBuffer textBuffer = basicDocument.getTextBuffer();
        Database database = PlSqlRunnerPanel.getDatabase(this.m_node);
        try {
            PlSqlRunnerPanel.checkPlSql(database, textBuffer);
            Procedure procedure = (Procedure)this.m_lstTarget.getSelectedValue();
            if (procedure != null) {
                procedure.saveDocument();
            }
            bl = true;
        }
        catch (SQLException sQLException) {
            SQLErrorDialog.showErrorDialog((Component)this, (String)RunnerArb.getString(11), (SQLException)sQLException);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkPlSql(Database database, TextBuffer textBuffer) throws SQLException {
        Connection connection;
        String string = textBuffer.getString(0, textBuffer.getLength());
        Connection connection2 = connection = database.getConnection();
        synchronized (connection2) {
            OracleCallableStatement oracleCallableStatement;
            block11: {
                oracleCallableStatement = null;
                CLOB cLOB = null;
                try {
                    QueryXMLSupport queryXMLSupport = QueryXMLSupport.getQueryXMLSupport((String)"/oracle/dbtools/raptor/runner/source.xml");
                    Query query = queryXMLSupport.getQuery("runnerBlock", database.getConnection());
                    HashMap<String, CLOB> hashMap = new HashMap<String, CLOB>();
                    cLOB = CLOB.createTemporary((Connection)database.getConnection(), (boolean)false, (int)10);
                    cLOB.setString(1L, string);
                    hashMap.put("SRC", cLOB);
                    oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(query.getSql());
                    DBUtil.getInstance().bind((PreparedStatement)oracleCallableStatement, hashMap);
                    oracleCallableStatement.execute();
                    Object var11_10 = null;
                    if (cLOB == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (cLOB != null) {
                        cLOB.freeTemporary();
                    }
                    if (oracleCallableStatement != null) {
                        try {
                            oracleCallableStatement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                cLOB.freeTemporary();
            }
            if (oracleCallableStatement != null) {
                try {
                    oracleCallableStatement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static Database getDatabase(RunnableSourceNode runnableSourceNode) {
        Database database = null;
        try {
            URL uRL = runnableSourceNode.getURL();
            String string = DBURLFormatHelper.getConnectionName(uRL);
            database = Connections.getInstance().getDatabase(string, true);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return database;
    }

    private static class PlSqlProfilerPanel
    extends PlSqlRunnerPanel {
        private JPanel pnlComment = new JPanel();
        protected JLabel lblComment = new JLabel();
        private JTextField fldComment = new JTextField(30);

        public PlSqlProfilerPanel() {
            this.pnlComment.add(this.lblComment);
            this.pnlComment.add(this.fldComment);
            ResourceUtils.resLabel((JLabel)this.lblComment, (Component)this.fldComment, (String)RunnerArb.getString(10));
            this.add((Component)this.pnlComment, "North");
        }
    }
}

