/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.runner;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.nls.DefaultNLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.runner.PlSqlRunnerPanel;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.log.StyledMessage;
import oracle.ide.model.DefaultDisplayable;
import oracle.ide.model.Displayable;
import oracle.ide.model.Node;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Starter;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.icons.OracleIcons;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdeveloper.db.ConnectionException;
import oracle.jdeveloper.db.ConnectionsEvent;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;
import oracle.jdeveloper.db.DisconnectListener;
import oracle.jdeveloper.runner.DatabaseRunHelper;
import oracle.jdeveloper.runner.JRunProcess;
import oracle.jdeveloper.runner.JStarter;
import oracle.jdeveloper.runner.JStarterFactory;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.debug.DebuggingProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBStarterFactory
extends AbstractStarterFactory
implements JStarterFactory {
    private static final Map<String, Integer> s_activeConns = new HashMap<String, Integer>();
    private Logger logger = Logger.getLogger(DBStarterFactory.class.getName());

    public static synchronized boolean isDebugSessionActive(String string) {
        return DBStarterFactory.getCount(string) > 0;
    }

    private static synchronized Integer getCount(String string) {
        Integer n = s_activeConns.get(string);
        return n != null ? n : 0;
    }

    private void populateNlsFromConfig(HashMap<String, String> hashMap) {
        if (hashMap != null) {
            Set<String> set = DBConfig.getInstance().getPropertyKeys();
            for (String string : set) {
                hashMap.put(string, DBConfig.getInstance().getString(string));
            }
        }
    }

    private static synchronized void putCount(String string, Integer n) {
        if (n > 0) {
            s_activeConns.put(string, n);
        } else {
            s_activeConns.remove(string);
        }
    }

    private static synchronized void incrementDebugSessionCount(String string) {
        DBStarterFactory.putCount(string, DBStarterFactory.getCount(string) + 1);
    }

    private static synchronized void decrementDebugSessionCount(String string) {
        DBStarterFactory.putCount(string, DBStarterFactory.getCount(string) - 1);
    }

    public String getName() {
        return null;
    }

    public Object canStart(RunProcess runProcess, Node node, List list) {
        Object object;
        if (runProcess instanceof JRunProcess && node instanceof RunnableSourceNode && (object = DBStarterFactory.findBaseTarget(node, list)) != null) {
            try {
                Database database = DBStarterFactory.getDatabase(node);
                if (runProcess.canRun("Database", (Object)database, node, list)) {
                    return object;
                }
            }
            catch (DBException dBException) {
                list.add(dBException.getLocalizedMessage());
            }
        }
        return null;
    }

    public Starter createStarter(RunProcess runProcess, Node node, Object object) {
        RunnableSourceNode runnableSourceNode = (RunnableSourceNode)object;
        return new PlSqlStarter((JRunProcess)runProcess, runnableSourceNode);
    }

    public boolean enableRunDebugActions(Context context) {
        Node node = RunProcess.getContextNodeForRun((Context)context);
        return node instanceof RunnableSourceNode && Boolean.parseBoolean((String)((RunnableSourceNode)node).getProperty("RUNNABLE"));
    }

    public Displayable getDisplayable(RunProcess runProcess, Context context, Node node, Object object) {
        return new DefaultDisplayable(){

            public String getShortLabel() {
                return RunMgrArb.getString((int)79);
            }

            public String getLongLabel() {
                return RunMgrArb.getString((int)79);
            }

            public Icon getIcon() {
                return OracleIcons.getIcon((String)"plsql_proc.png");
            }
        };
    }

    private static Object findBaseTarget(Node node, List list) {
        URL uRL = node.getURL();
        if (DBURLFormatHelper.isDBURL(uRL)) {
            if (node instanceof RunnableSourceNode) {
                RunnableSourceNode runnableSourceNode = ((RunnableSourceNode)node).getRunTarget();
                if (runnableSourceNode != null) {
                    return runnableSourceNode;
                }
                list.add("Source does not have a runnable target.");
            } else {
                list.add("Not a runnable DB source");
            }
        } else {
            String string = RunMgrArb.format((int)17, (Object)node.getShortLabel());
            list.add(string);
        }
        return null;
    }

    private static Database getDatabase(Node node) throws DBException {
        URL uRL = node.getURL();
        String string = DBURLFormatHelper.getConnectionName(uRL);
        return Connections.getInstance().getDatabase(string, true);
    }

    static /* synthetic */ Logger access$900(DBStarterFactory dBStarterFactory) {
        return dBStarterFactory.logger;
    }

    class PlSqlStarter
    extends JStarter
    implements DisconnectListener {
        private TextBuffer buf;
        private RunnableSourceNode target;
        private Database database;
        private Connection executionConnection;
        private String connName;
        private boolean connectHappened;
        private boolean dbSupportsCall;
        private static final String DBMS_OUTPUT_GET_LINE = "DBMS_OUTPUT.GET_LINE( ?, ? )";

        PlSqlStarter(JRunProcess jRunProcess, RunnableSourceNode runnableSourceNode) {
            super(jRunProcess, null);
            this.jrunProcess = jRunProcess;
            this.target = runnableSourceNode;
            URL uRL = runnableSourceNode.getURL();
            this.connName = DBURLFormatHelper.getConnectionName(uRL);
        }

        private Database getDatabase() {
            if (this.database == null && !this.connectHappened && this.connName != null) {
                try {
                    this.jrunProcess.getLogPage().log((Object)RunMgrArb.format((int)25, (Object)Connections.getDisplayName(this.connName)));
                    DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore(Connections.getStoreName(this.connName));
                    databaseConnections.addDisconnectListener((DisconnectListener)this);
                    this.executionConnection = databaseConnections.getUniqueConnection(Connections.getConnectionName(this.connName));
                    Object object = null;
                    object = this.executionConnection instanceof OracleConnection ? new OracleNLSProvider(this.executionConnection) : new DefaultNLSProvider(this.executionConnection);
                    HashMap hashMap = new HashMap();
                    DBStarterFactory.this.populateNlsFromConfig(hashMap);
                    object.updateDefaults(hashMap);
                    object.initConnection();
                    this.executionConnection = object.getConnection();
                    DBStarterFactory.incrementDebugSessionCount(this.connName);
                    this.database = Connections.getInstance().getDatabase(this.connName);
                    this.connectHappened = true;
                    int n = this.database instanceof OracleDatabase ? ((OracleDatabase)this.database).getOracleDatabaseType() : 0;
                    this.dbSupportsCall = 0 != n && 1 != n;
                }
                catch (DBException dBException) {
                    this.logError((Exception)((Object)dBException));
                }
                catch (ConnectionException connectionException) {
                    this.logError((Exception)((Object)connectionException));
                }
            }
            return this.database;
        }

        private void disconnect() {
            if (this.database != null) {
                this.jrunProcess.getLogPage().log((Object)RunMgrArb.format((int)35, (Object)this.database.getConnectionName()));
                try {
                    this.executionConnection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                DatabaseConnections databaseConnections = DatabaseConnectionStores.getInstance().getStore(Connections.getStoreName(this.connName));
                databaseConnections.removeDisconnectListener((DisconnectListener)this);
                DBStarterFactory.decrementDebugSessionCount(this.connName);
                this.database = null;
            }
        }

        public File getStartDirectory() {
            return null;
        }

        public String[] getStartCommand() {
            return null;
        }

        public boolean canStart(List list) {
            return true;
        }

        public boolean start() {
            if (this.getDatabase() != null) {
                boolean bl = this.jrunProcess instanceof DebuggingProcess;
                this.buf = PlSqlRunnerPanel.runDialog(this.target, bl, false);
                this.jrunProcess.setLabelOverride(this.getDatabase().getConnectionName());
                if (this.buf == null) {
                    this.disconnect();
                    return false;
                }
                final DatabaseRunHelper databaseRunHelper = (DatabaseRunHelper)this.jrunProcess.getValue("Database", (Object)this.database, "DatabaseRunHelper");
                final String[][] stringArray = databaseRunHelper != null ? databaseRunHelper.getDatabaseCommands((Object)this.database) : (String[][])null;
                Thread thread = new Thread("PL/SQL Starter Thread"){

                    public void run() {
                        int n;
                        int n2;
                        int n3;
                        PlSqlStarter.this.enableDbmsOutput();
                        boolean bl = false;
                        if (stringArray != null && stringArray.length >= 1 && stringArray[0] != null) {
                            n3 = stringArray[0].length;
                            for (n2 = 0; n2 < n3; ++n2) {
                                n = PlSqlStarter.this.executeSQL(stringArray[0][n2], true);
                                if (n == 0) continue;
                                if (databaseRunHelper != null) {
                                    databaseRunHelper.handleDatabaseError(stringArray, 0, n2, n);
                                }
                                bl = true;
                                break;
                            }
                        }
                        if (!bl && (databaseRunHelper == null || databaseRunHelper.waitForDatabase())) {
                            n3 = PlSqlStarter.this.executePlSqlNode();
                            int n4 = n2 = PlSqlStarter.this.database instanceof OracleDatabase && (n3 == 6543 || n3 == 30687) ? 1 : 0;
                            if (stringArray != null && stringArray.length >= 2 && stringArray[1] != null) {
                                n = stringArray[1].length;
                                for (int i = 0; i < n; ++i) {
                                    int n5 = PlSqlStarter.this.executeSQL(stringArray[1][i], true);
                                    if (n5 == 0 || databaseRunHelper == null) continue;
                                    databaseRunHelper.handleDatabaseError(stringArray, 1, i, n5);
                                }
                            }
                            if (n2 == 0) {
                                PlSqlStarter.this.logDbmsOutput();
                            }
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                PlSqlStarter.this.jrunProcess.finished();
                                PlSqlStarter.this.finished();
                            }
                        });
                    }
                };
                thread.start();
                return true;
            }
            this.disconnect();
            return false;
        }

        private void logMsg(String string) {
            this.logMsg(string, null);
        }

        private void logMsg(String string, AttributeSet attributeSet) {
            if (string != null) {
                if (!string.endsWith("\n")) {
                    string = string + "\n";
                }
                if (attributeSet != null) {
                    this.jrunProcess.log((Object)new StyledMessage(attributeSet, string));
                } else {
                    this.jrunProcess.log((Object)string);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private int executeSQL(String string, boolean bl) {
            int n;
            block12: {
                n = 0;
                if (bl) {
                    boolean bl2 = true;
                    StringBuffer stringBuffer = new StringBuffer(RunMgrArb.getString((int)58));
                    String string2 = stringBuffer.toString();
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        this.logMsg(string2 + string3 + "\n");
                        if (!bl2) continue;
                        for (int i = stringBuffer.length() - 1; i >= 0; --i) {
                            stringBuffer.setCharAt(i, ' ');
                        }
                        string2 = stringBuffer.toString();
                        bl2 = false;
                    }
                }
                Statement statement = null;
                statement = this.executionConnection.createStatement();
                statement.execute(string);
                Object var11_12 = null;
                if (statement == null) break block12;
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                statement = null;
                {
                    break block12;
                    catch (SQLException sQLException) {
                        n = this.handleError(sQLException, bl);
                        Object var11_13 = null;
                        if (statement == null) break block12;
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        statement = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        statement = null;
                    }
                    throw throwable;
                }
            }
            return n;
        }

        private void logError(Exception exception) {
            Throwable throwable;
            while ((exception instanceof ConnectionException || exception instanceof DBException) && (throwable = exception.getCause()) instanceof Exception) {
                exception = (Exception)throwable;
            }
            this.logMsg(exception.getMessage(), RunProcess.getSystemErrAttributeSet());
        }

        private int handleError(SQLException sQLException, boolean bl) {
            int n = sQLException.getErrorCode();
            String string = sQLException.getMessage();
            if (bl) {
                this.logMsg(string, RunProcess.getSystemErrAttributeSet());
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int executePlSqlNode() {
            int n = 0;
            if (this.buf == null) return n;
            String string = this.buf.getString(0, this.buf.getLength());
            Statement statement = null;
            statement = this.executionConnection.createStatement();
            statement.setEscapeProcessing(false);
            statement.execute(string);
            Object var6_4 = null;
            if (statement == null) return n;
            try {
                statement.close();
                return n;
            }
            catch (Exception exception) {}
            return n;
            {
                catch (SQLException sQLException) {
                    n = this.handleError(sQLException, true);
                    Object var6_5 = null;
                    if (statement == null) return n;
                    try {
                        statement.close();
                        return n;
                    }
                    catch (Exception exception) {}
                    return n;
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (statement == null) throw throwable;
                try {
                    statement.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }

        private String getSQL(String string, boolean bl) {
            return this.getSQL(string, this.dbSupportsCall, bl);
        }

        private String getSQL(String string, boolean bl, boolean bl2) {
            StringBuffer stringBuffer = new StringBuffer(100);
            if (bl) {
                stringBuffer.append("{ CALL ");
            } else {
                stringBuffer.append("BEGIN ");
            }
            stringBuffer.append(string);
            if (bl) {
                if (bl2) {
                    stringBuffer.append("()");
                }
                stringBuffer.append("}");
            } else {
                stringBuffer.append("; END;");
            }
            return stringBuffer.toString();
        }

        private void enableDbmsOutput() {
            this.executeSQL(this.getSQL("DBMS_OUTPUT.DISABLE", true), false);
            this.executeSQL(this.getSQL("DBMS_OUTPUT.ENABLE", true), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void logDbmsOutput() {
            while (true) {
                block10: {
                    var1_1 = null;
                    try {
                        try {
                            var2_2 = this.getSQL("DBMS_OUTPUT.GET_LINE( ?, ? )", false);
                            var1_1 = this.executionConnection.prepareCall(var2_2);
                            var1_1.registerOutParameter(1, 12);
                            var1_1.registerOutParameter(2, 4);
                            var1_1.execute();
                            var3_4 = var1_1.getString(1);
                            var4_5 = var1_1.getInt(2);
                            this.logMsg(var3_4, RunProcess.getSystemOutAttributeSet());
                            if (var4_5 <= 0) break block10;
                            var6_6 = null;
                            if (var1_1 == null) return;
                        }
                        catch (Exception var2_3) {
                            DBStarterFactory.access$900(DBStarterFactory.this).log(Level.SEVERE, "logDbmsOutput", var2_3);
                            var6_6 = null;
                            if (var1_1 == null) return;
                            try {
                                var1_1.close();
                                return;
                            }
                            catch (Exception var7_7) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                    catch (Throwable var5_8) {
                        var6_6 = null;
                        if (var1_1 == null) throw var5_8;
                        ** try [egrp 2[TRYBLOCK] [5 : 120->131)] { 
lbl35:
                        // 1 sources

                        var1_1.close();
                        var1_1 = null;
                        throw var5_8;
lbl38:
                        // 1 sources

                        catch (Exception var7_7) {
                            // empty catch block
                        }
                        throw var5_8;
                    }
                    ** try [egrp 2[TRYBLOCK] [5 : 120->131)] { 
lbl43:
                    // 1 sources

                    var1_1.close();
                    return;
lbl45:
                    // 1 sources

                    catch (Exception var7_7) {
                        // empty catch block
                    }
                    return;
                }
                var6_6 = null;
                if (var1_1 == null) continue;
                try {}
                catch (Exception var7_7) {}
                var1_1.close();
                var1_1 = null;
            }
        }

        public boolean canTerminate() {
            return false;
        }

        public void terminate() {
        }

        public void finished() {
            this.disconnect();
            super.finished();
        }

        public boolean canDisconnect(ConnectionsEvent connectionsEvent) {
            return this.executionConnection == null;
        }

        public void connectionDisconnected(ConnectionsEvent connectionsEvent) {
        }
    }
}

